/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.QueryFrame;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleRaiseNull
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean raisedNode = true;
        while (raisedNode) {
            raisedNode = false;
            List nodes = NodeEditor.findAllNodes(plan, 31);
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                PlanNode newRoot;
                PlanNode nullNode = (PlanNode)iter.next();
                if (nullNode.getParent() == null || nullNode.getParent().getParent() == null || (newRoot = this.raiseNullNode(plan, nullNode, metadata, capFinder)) == null) continue;
                raisedNode = true;
                plan = newRoot;
            }
        }
        return plan;
    }

    PlanNode raiseNullNode(PlanNode rootNode, PlanNode nullNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode parentNode = nullNode.getParent();
        if (parentNode == null) {
            return null;
        }
        switch (parentNode.getType()) {
            case 7: {
                JoinType jt = (JoinType)parentNode.getProperty(NodeConstants.Info.JOIN_TYPE);
                if (jt == JoinType.JOIN_CROSS || jt == JoinType.JOIN_INNER) {
                    FrameUtil.replaceWithNullNode(parentNode);
                    return rootNode;
                }
                if (jt == JoinType.JOIN_LEFT_OUTER) {
                    if (nullNode == parentNode.getFirstChild()) {
                        FrameUtil.replaceWithNullNode(parentNode);
                    } else {
                        RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getLastChild());
                    }
                    return rootNode;
                }
                if (jt == JoinType.JOIN_RIGHT_OUTER) {
                    if (nullNode == parentNode.getLastChild()) {
                        FrameUtil.replaceWithNullNode(parentNode);
                    } else {
                        RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getFirstChild());
                    }
                    return rootNode;
                }
                if (jt != JoinType.JOIN_FULL_OUTER) break;
                if (nullNode == parentNode.getLastChild()) {
                    RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getLastChild());
                } else {
                    RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getFirstChild());
                }
                return rootNode;
            }
            case 11: {
                PlanNode upperProject;
                if (parentNode.getParent() == null || parentNode.getParent().getType() != 19 && parentNode.getParent().getType() != 3) break;
                for (upperProject = parentNode.getParent(); upperProject != null && upperProject.getType() != 11; upperProject = upperProject.getParent()) {
                }
                if (upperProject != null && upperProject.getProperty(NodeConstants.Info.INTO_GROUP) != null) break;
                FrameUtil.replaceWithNullNode(parentNode);
                return rootNode;
            }
            case 29: {
                break;
            }
            case 23: {
                break;
            }
            default: {
                FrameUtil.replaceWithNullNode(parentNode);
                return rootNode;
            }
        }
        return null;
    }

    static void raiseNullThroughJoin(QueryMetadataInterface metadata, PlanNode joinNode, PlanNode nullNode) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Assertion.assertTrue((joinNode.getType() == 7 ? 1 : 0) != 0);
        Assertion.assertTrue((nullNode.getType() == 31 ? 1 : 0) != 0);
        Assertion.assertTrue((nullNode.getParent() == joinNode ? 1 : 0) != 0);
        NodeEditor.removeChildNode(joinNode, nullNode);
        NodeEditor.removeChildNode(joinNode.getParent(), joinNode);
        QueryFrame frame = FrameUtil.findQueryFrame(joinNode);
        Set groups = nullNode.getGroups();
        Iterator groupIter = groups.iterator();
        while (groupIter.hasNext()) {
            GroupSymbol group = (GroupSymbol)groupIter.next();
            Map nullSymbolMap = FrameUtil.buildSymbolMap(group, null, metadata);
            FrameUtil.convertFrame(frame, nullNode, group, null, nullSymbolMap, metadata);
        }
    }

    public String toString() {
        return "RaiseNull";
    }
}

