/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.QueryFrame;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.AtomicCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.symbol.AbstractCaseExpression;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FrameUtil {
    private static final String RECONTEXT_STRING = "__";

    static void findQueryFrames(PlanNode node, QueryFrame parentFrame, List frames) throws QueryPlannerException {
        List childNodes = node.getChildren();
        Iterator childIter = childNodes.iterator();
        if (node.getType() == 29) {
            while (childIter.hasNext()) {
                FrameUtil.findQueryFrames((PlanNode)childIter.next(), parentFrame, frames);
            }
            return;
        }
        ArrayList bottomNodes = new ArrayList();
        while (childIter.hasNext()) {
            FrameUtil.findBottomNodes((PlanNode)childIter.next(), bottomNodes);
        }
        QueryFrame frame = new QueryFrame(parentFrame, node, bottomNodes);
        FrameUtil.setJoinFlag(frame);
        if (bottomNodes.size() > 0) {
            Iterator nodeIter = bottomNodes.iterator();
            while (nodeIter.hasNext()) {
                PlanNode bottomNode = (PlanNode)nodeIter.next();
                if (bottomNode.getChildCount() <= 0) continue;
                FrameUtil.findQueryFrames(bottomNode, frame, frames);
            }
        }
        frames.add(frame);
    }

    static void findBottomNodes(PlanNode node, List foundNodes) {
        block5: {
            block6: {
                block4: {
                    if (node.getType() != 29) break block4;
                    Iterator children = node.getChildren().iterator();
                    while (children.hasNext()) {
                        PlanNode child = (PlanNode)children.next();
                        if (child.getType() == 29) {
                            FrameUtil.findBottomNodes(child, foundNodes);
                            continue;
                        }
                        while (child.getType() != 11) {
                            child = child.getFirstChild();
                        }
                        foundNodes.add(child);
                    }
                    break block5;
                }
                if (node.getType() != 19) break block6;
                foundNodes.add(node);
                break block5;
            }
            if (node.getChildCount() <= 0) break block5;
            List children = node.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                FrameUtil.findBottomNodes((PlanNode)iter.next(), foundNodes);
            }
        }
    }

    static void setJoinFlag(QueryFrame frame) {
        LinkedList nodes = new LinkedList();
        nodes.addAll(frame.getTopNode().getChildren());
        List bottomNodes = frame.getBottomNodes();
        while (!nodes.isEmpty()) {
            PlanNode node = (PlanNode)nodes.removeFirst();
            if (node.getType() == 7) {
                frame.setJoinNode(node);
                break;
            }
            if (bottomNodes.contains(node)) continue;
            nodes.addAll(node.getChildren());
        }
    }

    static List getOverlappingGroups(GroupSymbol groupToIgnore, Set lowerGroups, Set upperGroups) {
        ArrayList<GroupSymbol> overlapGroups = null;
        Iterator upperGroupIter = upperGroups.iterator();
        while (upperGroupIter.hasNext()) {
            GroupSymbol upperGroup = (GroupSymbol)upperGroupIter.next();
            if (upperGroup.equals((Object)groupToIgnore) || !lowerGroups.contains(upperGroup)) continue;
            if (overlapGroups == null) {
                overlapGroups = new ArrayList<GroupSymbol>();
            }
            overlapGroups.add(upperGroup);
        }
        return overlapGroups;
    }

    static void convertFrame(QueryFrame frame, PlanNode startNode, GroupSymbol oldGroup, GroupSymbol newGroup, Map symbolMap, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Map parentSymbolMap;
        PlanNode topNode = frame.getTopNode();
        PlanNode current = startNode;
        PlanNode endNode = null;
        if (topNode.getType() == 19) {
            endNode = topNode;
        } else {
            for (endNode = topNode.getParent(); endNode != null && endNode.getType() != 19; endNode = endNode.getParent()) {
            }
        }
        while (current != endNode) {
            FrameUtil.convertNode(current, oldGroup, newGroup, symbolMap, metadata);
            current = current.getParent();
        }
        if (endNode != null && (parentSymbolMap = (Map)endNode.getProperty(NodeConstants.Info.SYMBOL_MAP)) != null) {
            Iterator symbolIter = parentSymbolMap.keySet().iterator();
            while (symbolIter.hasNext()) {
                Expression convertedParentValue;
                Object parentKey = symbolIter.next();
                Expression parentValue = (Expression)parentSymbolMap.get(parentKey);
                if (symbolMap.containsKey(parentValue)) {
                    convertedParentValue = FrameUtil.convertSingleElementSymbol((SingleElementSymbol)parentValue, symbolMap, false, metadata);
                    if (convertedParentValue instanceof ExpressionSymbol) {
                        convertedParentValue = ((ExpressionSymbol)convertedParentValue).getExpression();
                    }
                    parentSymbolMap.put(parentKey, convertedParentValue);
                    continue;
                }
                convertedParentValue = FrameUtil.convertExpression(parentValue, symbolMap);
                parentSymbolMap.put(parentKey, convertedParentValue);
            }
        }
    }

    static void convertNode(PlanNode node, GroupSymbol oldGroup, GroupSymbol newGroup, Map symbolMap, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List groupCols;
        SingleElementSymbol mappedSymbol;
        SingleElementSymbol symbol;
        Iterator elementIter;
        ArrayList<SingleElementSymbol> newElements;
        List elements;
        Set groups = node.getGroups();
        List refs = (List)node.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
        if (refs != null) {
            Iterator refIter = refs.iterator();
            while (refIter.hasNext()) {
                Reference ref = (Reference)refIter.next();
                Expression expr = ref.getExpression();
                Expression convertedExpr = FrameUtil.convertExpression(expr, symbolMap);
                ref.setExpression(convertedExpr);
            }
        }
        if (groups.size() == 0 && node.getType() == 13) {
            return;
        }
        boolean hasOld = groups.contains(oldGroup);
        if (hasOld) {
            groups.remove(oldGroup);
        } else if (node.getType() == 13) {
            return;
        }
        if (newGroup != null && (node.getType() != 19 || hasOld)) {
            groups.add(newGroup);
        }
        ArrayList newElementSymbols = new ArrayList();
        int type = node.getType();
        if (type == 13) {
            Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
            FrameUtil.convertCriteria(crit, symbolMap);
            ElementCollectorVisitor.getElements((LanguageObject)crit, newElementSymbols);
        } else if (type == 11) {
            elements = (List)node.getProperty(NodeConstants.Info.PROJECT_COLS);
            newElements = new ArrayList<SingleElementSymbol>(elements.size());
            elementIter = elements.iterator();
            while (elementIter.hasNext()) {
                symbol = (SingleElementSymbol)elementIter.next();
                mappedSymbol = FrameUtil.convertSingleElementSymbol(symbol, symbolMap, true, metadata);
                newElements.add(mappedSymbol);
                ElementCollectorVisitor.getElements((LanguageObject)mappedSymbol, newElementSymbols);
            }
            node.setProperty(NodeConstants.Info.PROJECT_COLS, newElements);
        } else if (type == 7) {
            List joinCrits;
            From from = (From)node.getProperty(NodeConstants.Info.FROM_CLAUSE);
            if (from != null) {
                Iterator clauseIter = from.getClauses().iterator();
                while (clauseIter.hasNext()) {
                    UnaryFromClause ufc;
                    FromClause clause = (FromClause)clauseIter.next();
                    if (clause instanceof JoinPredicate) {
                        LinkedList<FromClause> predicates = new LinkedList<FromClause>();
                        predicates.add(clause);
                        while (predicates.size() > 0) {
                            UnaryFromClause ufc2;
                            JoinPredicate predicate = (JoinPredicate)predicates.removeFirst();
                            List jcrit = predicate.getJoinCriteria();
                            if (jcrit != null) {
                                Iterator critIter = jcrit.iterator();
                                while (critIter.hasNext()) {
                                    FrameUtil.convertCriteria((Criteria)critIter.next(), symbolMap);
                                }
                            }
                            if (predicate.getLeftClause() instanceof JoinPredicate) {
                                predicates.add(predicate.getLeftClause());
                            } else if (predicate.getLeftClause() instanceof UnaryFromClause && newGroup != null && (ufc2 = (UnaryFromClause)predicate.getLeftClause()).getGroup().equals((Object)oldGroup)) {
                                ufc2.setGroup(newGroup);
                            }
                            if (predicate.getRightClause() instanceof JoinPredicate) {
                                predicates.add(predicate.getRightClause());
                                continue;
                            }
                            if (!(predicate.getRightClause() instanceof UnaryFromClause) || newGroup == null || !(ufc2 = (UnaryFromClause)predicate.getRightClause()).getGroup().equals((Object)oldGroup)) continue;
                            ufc2.setGroup(newGroup);
                        }
                        continue;
                    }
                    if (newGroup == null || !(ufc = (UnaryFromClause)clause).getGroup().equals((Object)oldGroup)) continue;
                    ufc.setGroup(newGroup);
                }
            }
            if ((joinCrits = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA)) != null && joinCrits.size() > 0) {
                Iterator critIter = joinCrits.iterator();
                while (critIter.hasNext()) {
                    Criteria crit = (Criteria)critIter.next();
                    FrameUtil.convertCriteria(crit, symbolMap);
                    ElementCollectorVisitor.getElements((LanguageObject)crit, newElementSymbols);
                }
            }
        } else if (type == 17) {
            elements = (List)node.getProperty(NodeConstants.Info.SORT_ORDER);
            newElements = new ArrayList(elements.size());
            elementIter = elements.iterator();
            while (elementIter.hasNext()) {
                symbol = (SingleElementSymbol)elementIter.next();
                mappedSymbol = FrameUtil.convertSingleElementSymbol(symbol, symbolMap, true, metadata);
                newElements.add(mappedSymbol);
                ElementCollectorVisitor.getElements((LanguageObject)mappedSymbol, newElementSymbols);
            }
            node.setProperty(NodeConstants.Info.SORT_ORDER, newElements);
        } else if (type == 23 && (groupCols = (List)node.getProperty(NodeConstants.Info.GROUP_COLS)) != null) {
            ArrayList<SingleElementSymbol> newGroupCols = new ArrayList<SingleElementSymbol>(groupCols.size());
            HashMap<SingleElementSymbol, SingleElementSymbol> newMappedCols = new HashMap<SingleElementSymbol, SingleElementSymbol>();
            Iterator groupIter = groupCols.iterator();
            while (groupIter.hasNext()) {
                SingleElementSymbol groupCol = (SingleElementSymbol)groupIter.next();
                SingleElementSymbol mappedCol = FrameUtil.convertSingleElementSymbol(groupCol, symbolMap, false, metadata);
                newMappedCols.put(groupCol, mappedCol);
                newGroupCols.add(mappedCol);
                ElementCollectorVisitor.getElements((LanguageObject)mappedCol, newElementSymbols);
            }
            node.setProperty(NodeConstants.Info.GROUP_COLS, newGroupCols);
            symbolMap.putAll(newMappedCols);
        }
        if (newElementSymbols.size() > 0) {
            Iterator elemIter = newElementSymbols.iterator();
            while (elemIter.hasNext()) {
                ElementSymbol elem = (ElementSymbol)elemIter.next();
                groups.add(elem.getGroupSymbol());
            }
        }
    }

    static SingleElementSymbol convertSingleElementSymbol(SingleElementSymbol symbol, Map symbolMap, boolean shouldAlias, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String alias = metadata.getShortElementName(symbol.getName());
        boolean hasAlias = false;
        if (symbol instanceof AliasSymbol) {
            symbol = ((AliasSymbol)symbol).getSymbol();
            hasAlias = true;
        }
        Object mappedSymbol = null;
        if (symbol instanceof ElementSymbol) {
            Expression mappedExpression = FrameUtil.convertExpression((Expression)symbol, symbolMap);
            mappedSymbol = mappedExpression instanceof ElementSymbol ? (SingleElementSymbol)mappedExpression : new ExpressionSymbol(alias, mappedExpression);
        } else {
            ExpressionSymbol esymbol = (ExpressionSymbol)symbol;
            esymbol.setExpression(FrameUtil.convertExpression(esymbol.getExpression(), symbolMap));
            mappedSymbol = esymbol;
        }
        if (shouldAlias && hasAlias) {
            mappedSymbol = new AliasSymbol(alias, mappedSymbol);
        }
        return mappedSymbol;
    }

    static Expression convertExpression(Expression expression, Map symbolMap) throws QueryPlannerException {
        if (expression instanceof ElementSymbol) {
            if (symbolMap.containsKey(expression)) {
                Expression mappedSymbol = (Expression)symbolMap.get(expression);
                return mappedSymbol;
            }
            return expression;
        }
        if (expression instanceof AggregateSymbol) {
            AggregateSymbol aggSymbol = (AggregateSymbol)expression;
            SingleElementSymbol replacement = (SingleElementSymbol)symbolMap.get(aggSymbol);
            if (replacement != null) {
                return replacement;
            }
            if (aggSymbol.getExpression() != null) {
                aggSymbol.setExpression(FrameUtil.convertExpression(aggSymbol.getExpression(), symbolMap));
            }
            return aggSymbol;
        }
        if (expression instanceof Function) {
            Expression[] args = ((Function)expression).getArgs();
            for (int i = 0; i < args.length; ++i) {
                args[i] = FrameUtil.convertExpression(args[i], symbolMap);
            }
            return expression;
        }
        if (expression instanceof AbstractCaseExpression) {
            AbstractCaseExpression ace = (AbstractCaseExpression)expression;
            int whenCount = ace.getWhenCount();
            ArrayList<Expression> newThens = new ArrayList<Expression>(whenCount);
            for (int i = 0; i < whenCount; ++i) {
                newThens.add(FrameUtil.convertExpression(ace.getThenExpression(i), symbolMap));
            }
            Expression newElseExpression = FrameUtil.convertExpression(ace.getElseExpression(), symbolMap);
            SearchedCaseExpression returnExpr = null;
            if (expression instanceof CaseExpression) {
                CaseExpression ce = (CaseExpression)ace;
                ArrayList<Expression> newWhens = new ArrayList<Expression>(whenCount);
                for (int i = 0; i < whenCount; ++i) {
                    newWhens.add(FrameUtil.convertExpression(ce.getWhenExpression(i), symbolMap));
                }
                Expression newExpression = FrameUtil.convertExpression(ce.getExpression(), symbolMap);
                CaseExpression newCe = new CaseExpression(newExpression, newWhens, newThens);
                newCe.setElseExpression(newElseExpression);
                newCe.setType(ce.getType());
                returnExpr = newCe;
            } else {
                SearchedCaseExpression sce = (SearchedCaseExpression)ace;
                for (int i = 0; i < whenCount; ++i) {
                    FrameUtil.convertCriteria(sce.getWhenCriteria(i), symbolMap);
                }
                SearchedCaseExpression newSce = new SearchedCaseExpression(sce.getWhen(), newThens);
                newSce.setElseExpression(newElseExpression);
                newSce.setType(sce.getType());
                returnExpr = newSce;
            }
            return returnExpr;
        }
        if (expression instanceof ExpressionSymbol) {
            ExpressionSymbol eSymbol = (ExpressionSymbol)expression;
            eSymbol.setExpression(FrameUtil.convertExpression(eSymbol.getExpression(), symbolMap));
            return eSymbol;
        }
        return expression;
    }

    static Criteria convertCriteria(Criteria criteria, Map symbolMap) throws QueryPlannerException {
        SetCriteria scrit;
        CompoundCriteria ccrit;
        if (criteria instanceof CompoundCriteria) {
            ccrit = (CompoundCriteria)criteria;
            List crits = ccrit.getCriteria();
            Iterator critIter = crits.iterator();
            while (critIter.hasNext()) {
                FrameUtil.convertCriteria((Criteria)critIter.next(), symbolMap);
            }
        } else if (criteria instanceof AtomicCriteria) {
            FrameUtil.convertCriteria(((AtomicCriteria)criteria).getCriteria(), symbolMap);
        } else if (criteria instanceof CompareCriteria) {
            ccrit = (CompareCriteria)criteria;
            ccrit.setLeftExpression(FrameUtil.convertExpression(ccrit.getLeftExpression(), symbolMap));
            ccrit.setRightExpression(FrameUtil.convertExpression(ccrit.getRightExpression(), symbolMap));
        } else if (criteria instanceof SubqueryCompareCriteria) {
            ccrit = (SubqueryCompareCriteria)criteria;
            ccrit.setLeftExpression(FrameUtil.convertExpression(ccrit.getLeftExpression(), symbolMap));
        } else if (criteria instanceof MatchCriteria) {
            MatchCriteria mcrit = (MatchCriteria)criteria;
            mcrit.setLeftExpression(FrameUtil.convertExpression(mcrit.getLeftExpression(), symbolMap));
            mcrit.setRightExpression(FrameUtil.convertExpression(mcrit.getRightExpression(), symbolMap));
        } else if (criteria instanceof SetCriteria) {
            scrit = (SetCriteria)criteria;
            scrit.setExpression(FrameUtil.convertExpression(scrit.getExpression(), symbolMap));
            ArrayList<Expression> newVals = new ArrayList<Expression>(scrit.getValues().size());
            Iterator valIter = scrit.getValues().iterator();
            while (valIter.hasNext()) {
                Expression val = (Expression)valIter.next();
                newVals.add(FrameUtil.convertExpression(val, symbolMap));
            }
            scrit.setValues(newVals);
        } else if (criteria instanceof SubquerySetCriteria) {
            scrit = (SubquerySetCriteria)criteria;
            scrit.setExpression(FrameUtil.convertExpression(scrit.getExpression(), symbolMap));
        } else if (criteria instanceof IsNullCriteria) {
            IsNullCriteria icrit = (IsNullCriteria)criteria;
            icrit.setExpression(FrameUtil.convertExpression(icrit.getExpression(), symbolMap));
        } else if (criteria instanceof DependentSetCriteria) {
            DependentSetCriteria dscrit = (DependentSetCriteria)criteria;
            dscrit.setExpression(FrameUtil.convertExpression(dscrit.getExpression(), symbolMap));
        } else {
            if (criteria instanceof ExistsCriteria) {
                return criteria;
            }
            throw new QueryPlannerException(QueryExecPlugin.Util.getString("ERR.015.004.0019", (Object)criteria.getClass().getName()));
        }
        try {
            return QueryRewriter.rewriteCriteria(criteria, null, null);
        }
        catch (QueryValidatorException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0023", (Object)criteria));
        }
    }

    static Set getNamesFromSymbols(Collection symbols) {
        HashSet<String> names = new HashSet<String>();
        Iterator iter = symbols.iterator();
        while (iter.hasNext()) {
            GroupSymbol symbol = (GroupSymbol)iter.next();
            names.add(symbol.getName());
        }
        return names;
    }

    static GroupSymbol recontextSymbol(GroupSymbol oldSymbol, Set allGroupNames) {
        String tryName;
        String oldName = oldSymbol.getName();
        int dotIndex = oldName.lastIndexOf(".");
        if (dotIndex >= 0) {
            oldName = oldName.substring(dotIndex + 1);
        }
        int recontextNumber = 1;
        int recontextIndex = oldName.lastIndexOf(RECONTEXT_STRING);
        if (recontextIndex >= 0) {
            try {
                recontextNumber = Integer.parseInt(oldName.substring(recontextIndex + RECONTEXT_STRING.length())) + 1;
                oldName = oldName.substring(0, recontextIndex);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        HashSet<String> allUpperNames = new HashSet<String>();
        Iterator iter = allGroupNames.iterator();
        while (iter.hasNext()) {
            String upperName = ((String)iter.next()).toUpperCase();
            allUpperNames.add(upperName);
        }
        String newName = null;
        while (true) {
            if (!allUpperNames.contains((tryName = oldName + RECONTEXT_STRING + recontextNumber).toUpperCase())) break;
            ++recontextNumber;
        }
        newName = tryName;
        String newDefinition = null;
        newDefinition = oldSymbol.getDefinition() == null ? oldSymbol.getName() : oldSymbol.getDefinition();
        GroupSymbol newSymbol = new GroupSymbol(newName, newDefinition);
        newSymbol.setVirtualDatabaseName(oldSymbol.getVirtualDatabaseName());
        newSymbol.setMetadataID(oldSymbol.getMetadataID());
        return newSymbol;
    }

    static Map buildSymbolMap(GroupSymbol oldGroup, GroupSymbol newGroup, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        String newGroupName = null;
        if (newGroup != null) {
            newGroupName = newGroup.getName();
        }
        HashMap<ElementSymbol, Constant> map = new HashMap<ElementSymbol, Constant>();
        List elements = null;
        try {
            elements = ResolverUtil.resolveElementsInGroup((GroupSymbol)oldGroup, (QueryMetadataInterface)metadata);
        }
        catch (QueryComponentException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            ElementSymbol oldElementSymbol = (ElementSymbol)iter.next();
            Constant symbol = null;
            if (newGroup != null) {
                String newFullName = metadata.getFullElementName(newGroupName, oldElementSymbol.getShortName());
                ElementSymbol newElementSymbol = new ElementSymbol(newFullName);
                newElementSymbol.setGroupSymbol(newGroup);
                newElementSymbol.setMetadataID(oldElementSymbol.getMetadataID());
                String elementType = metadata.getElementType(newElementSymbol.getMetadataID());
                newElementSymbol.setType(DataTypeManager.getDataTypeClass((String)elementType));
                symbol = newElementSymbol;
            } else {
                symbol = new Constant(null, oldElementSymbol.getType());
            }
            map.put(oldElementSymbol, symbol);
        }
        return map;
    }

    static boolean hasSubquery(PlanNode critNode) {
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Collection subCrits = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)crit);
        return subCrits.size() > 0;
    }

    static PlanNode findOriginatingNode(PlanNode root, Set groups) {
        return FrameUtil.findOriginatingNode(root, groups, false);
    }

    static PlanNode findJoinSourceNode(PlanNode root, Set groups) {
        return FrameUtil.findOriginatingNode(root, groups, true);
    }

    private static PlanNode findOriginatingNode(PlanNode root, Set groups, boolean firstJoin) {
        boolean containsGroups = false;
        if (root.getType() == 31 || root.getType() == 23 || root.getType() == 19 || root.getType() == 7 || root.getType() == 29) {
            if (groups.isEmpty()) {
                return root;
            }
            containsGroups = root.getGroups().containsAll(groups);
            if (containsGroups && (root.getType() != 7 || firstJoin || root.getGroups().size() == groups.size())) {
                return root;
            }
            if (root.getType() != 7 || firstJoin || !containsGroups) {
                return null;
            }
        }
        List children = root.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            PlanNode child = (PlanNode)childIter.next();
            PlanNode found = FrameUtil.findOriginatingNode(child, groups, firstJoin);
            if (found == null) continue;
            return found;
        }
        if (root.getType() == 7 && containsGroups) {
            return root;
        }
        return null;
    }

    static Set getGroups(Criteria crit) {
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol elementID = (ElementSymbol)elementIter.next();
            groups.add(elementID.getGroupSymbol());
        }
        return groups;
    }

    static QueryFrame findQueryFrame(PlanNode node) throws QueryPlannerException {
        PlanNode currentNode = node;
        while (currentNode.getParent() != null && currentNode.getParent().getType() != 19) {
            currentNode = currentNode.getParent();
        }
        ArrayList frames = new ArrayList();
        FrameUtil.findQueryFrames(currentNode, null, frames);
        QueryFrame frame = null;
        Iterator i = frames.iterator();
        while (i.hasNext() && !(frame = (QueryFrame)i.next()).containsNode(node)) {
        }
        Assertion.isNotNull(frame);
        return frame;
    }

    static void replaceWithNullNode(PlanNode node) {
        PlanNode nullNode = NodeFactory.getNewNode((int)31);
        PlanNode source = FrameUtil.findJoinSourceNode(node, node.getGroups());
        if (source != null) {
            nullNode.addGroups(source.getGroups());
        }
        node.getChildren().clear();
        NodeEditor.replaceNode(node, nullNode);
        nullNode.setParent(node.getParent());
    }
}

