/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.registry;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.event.AsynchEventBroker;
import com.metamatrix.core.event.EventBroker;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.event.EventSourceException;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.registry.HostRegistryBinding;
import com.metamatrix.platform.registry.MetaMatrixRegistry;
import com.metamatrix.platform.registry.ResourcePoolMgrBinding;
import com.metamatrix.platform.registry.ResourcePoolMgrID;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.registry.VMPollingThread;
import com.metamatrix.platform.registry.VMRegistryBinding;
import com.metamatrix.platform.registry.event.RegistryChangedEvent;
import com.metamatrix.platform.registry.event.RegistryEvent;
import com.metamatrix.platform.registry.exception.RegistryCommunicationException;
import com.metamatrix.platform.registry.exception.RegistryException;
import com.metamatrix.platform.registry.exception.ResourcePoolMgrNotBoundException;
import com.metamatrix.platform.registry.exception.ServiceNotBoundException;
import com.metamatrix.platform.registry.exception.VMControllerNotBoundException;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.ServiceInterface;
import com.metamatrix.platform.service.proxy.ProxyManager;
import com.metamatrix.platform.service.proxy.ServiceProxy;
import com.metamatrix.platform.vm.api.controller.VMControllerInterface;
import com.metamatrix.platform.vm.controller.VMControllerID;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MetaMatrixRegistryImpl
implements MetaMatrixRegistry {
    private ProxyManager proxyMgr;
    private Map hostBindings;
    private VMControllerID vmControllerID;
    private String hostName;
    private EventBroker localEventBroker;
    protected MessageBus messageBus;
    private VMPollingThread pollingThread;
    private boolean closed = false;

    public MetaMatrixRegistryImpl(MessageBus messageBus) throws RegistryException {
        this.messageBus = messageBus;
        this.init();
    }

    private void init() throws RegistryException {
        this.hostBindings = new HashMap(4);
        this.localEventBroker = new AsynchEventBroker();
        this.hostName = VMNaming.getLogicalHostName();
        if (this.hostName == null || this.hostName.length() == 0) {
            String msg = PlatformPlugin.Util.getString("ERR.014.006.0006");
            LogManager.logCritical("REGISTRY", msg);
            throw new RegistryException("ERR.014.006.0006", msg);
        }
        RegistryEvent event = new RegistryEvent((Object)this, 0, null);
        try {
            this.messageBus.addListener(Class.forName("com.metamatrix.platform.registry.event.RegistryEvent"), (EventObjectListener)this);
            this.messageBus.processEvent((EventObject)event);
        }
        catch (Exception e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.006.0007");
            LogManager.logCritical("REGISTRY", (Throwable)e, msg);
            throw new RegistryException((Throwable)e, "ERR.014.006.0007", msg);
        }
        try {
            this.proxyMgr = new ProxyManager((MetaMatrixRegistry)this);
        }
        catch (Exception e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.006.0008");
            LogManager.logCritical("REGISTRY", (Throwable)e, msg);
            throw new RegistryException((Throwable)e, "ERR.014.006.0008", msg);
        }
        this.startVMPollingThread();
    }

    protected void startVMPollingThread() {
        this.pollingThread = new VMPollingThread(this);
        this.pollingThread.setName("VMPollingThread");
        this.pollingThread.start();
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.pollingThread.stopThread();
            this.pollingThread = null;
            this.proxyMgr = null;
            this.hostBindings = new HashMap();
            this.vmControllerID = null;
            this.hostName = null;
            this.localEventBroker = null;
            try {
                this.messageBus.removeListener((EventObjectListener)this);
            }
            catch (Exception e) {
                LogManager.logError("REGISTRY", (Throwable)e, PlatformPlugin.Util.getString("ERR.014.006.0009"));
            }
            this.messageBus = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getHostRegistryBindings() {
        Map map = this.hostBindings;
        synchronized (map) {
            return new ArrayList(this.hostBindings.values());
        }
    }

    public ResourcePoolMgrBinding getResourcePoolMgrBinding(ResourcePoolMgrID resourcePoolMgrID) throws ResourcePoolMgrNotBoundException {
        HostRegistryBinding hostBinding = (HostRegistryBinding)this.hostBindings.get(resourcePoolMgrID.getHostName());
        if (hostBinding == null) {
            throw new ResourcePoolMgrNotBoundException("ERR.014.006.0010", PlatformPlugin.Util.getString("ERR.014.006.0010", (Object)resourcePoolMgrID));
        }
        VMRegistryBinding vmBinding = hostBinding.getVMRegistryBinding(resourcePoolMgrID.getVMControllerID());
        if (vmBinding == null) {
            throw new ResourcePoolMgrNotBoundException("ERR.014.006.0010", PlatformPlugin.Util.getString("ERR.014.006.0010", (Object)resourcePoolMgrID));
        }
        return vmBinding.getResourcePoolMgrBinding(resourcePoolMgrID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllResourcePoolMgrBindings() {
        ArrayList pools = new ArrayList();
        ArrayList hBindings = null;
        Map map = this.hostBindings;
        synchronized (map) {
            hBindings = new ArrayList(this.hostBindings.values());
        }
        Iterator iter = hBindings.iterator();
        while (iter.hasNext()) {
            HostRegistryBinding hostBinding = (HostRegistryBinding)iter.next();
            Iterator vmIter = hostBinding.getVMRegistryBindings().iterator();
            while (vmIter.hasNext()) {
                VMRegistryBinding vmBinding = (VMRegistryBinding)vmIter.next();
                pools.addAll(vmBinding.getAllResourcePoolMgrBindings());
            }
        }
        return pools;
    }

    public List getLocalServices(String serviceType) {
        try {
            VMRegistryBinding vmBinding = this.getLocalVMRegistryBinding();
            return vmBinding.getServices(serviceType);
        }
        catch (VMControllerNotBoundException e) {
            return new ArrayList();
        }
    }

    public List getLocalActiveServices(String serviceType) {
        try {
            VMRegistryBinding vmBinding = this.getLocalVMRegistryBinding();
            return vmBinding.getActiveServices(serviceType);
        }
        catch (VMControllerNotBoundException e) {
            return new ArrayList();
        }
    }

    public ServiceInterface getService(ServiceID serviceID) throws ServiceNotBoundException {
        HostRegistryBinding hostBinding = (HostRegistryBinding)this.hostBindings.get(serviceID.getHostName().toUpperCase());
        if (hostBinding == null) {
            throw new ServiceNotBoundException("ERR.014.006.0011", PlatformPlugin.Util.getString("ERR.014.006.0011", (Object)serviceID));
        }
        VMRegistryBinding vmBinding = hostBinding.getVMRegistryBinding(serviceID.getVMControllerID());
        if (vmBinding == null) {
            throw new ServiceNotBoundException("ERR.014.006.0011", PlatformPlugin.Util.getString("ERR.014.006.0011", (Object)serviceID));
        }
        return vmBinding.getService(serviceID);
    }

    public ServiceRegistryBinding getServiceBinding(ServiceID serviceID) throws ServiceNotBoundException {
        HostRegistryBinding hostBinding = (HostRegistryBinding)this.hostBindings.get(serviceID.getHostName());
        if (hostBinding == null) {
            throw new ServiceNotBoundException("ERR.014.006.0011", PlatformPlugin.Util.getString("ERR.014.006.0011", (Object)serviceID));
        }
        VMRegistryBinding vmBinding = hostBinding.getVMRegistryBinding(serviceID.getVMControllerID());
        if (vmBinding == null) {
            throw new ServiceNotBoundException("ERR.014.006.0011", PlatformPlugin.Util.getString("ERR.014.006.0011", (Object)serviceID));
        }
        return vmBinding.getServiceRegistryBinding(serviceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getServices(String serviceType) {
        ArrayList services = new ArrayList();
        ArrayList hBindings = null;
        Map map = this.hostBindings;
        synchronized (map) {
            hBindings = new ArrayList(this.hostBindings.values());
        }
        Iterator iter = hBindings.iterator();
        while (iter.hasNext()) {
            HostRegistryBinding hostBinding = (HostRegistryBinding)iter.next();
            Iterator vmIter = hostBinding.getVMRegistryBindings().iterator();
            while (vmIter.hasNext()) {
                VMRegistryBinding vmBinding = (VMRegistryBinding)vmIter.next();
                services.addAll(vmBinding.getServices(serviceType));
            }
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActiveServices(String serviceType) {
        ArrayList services = new ArrayList();
        if (this.hostBindings == null) {
            return services;
        }
        ArrayList hBindings = null;
        Map map = this.hostBindings;
        synchronized (map) {
            hBindings = new ArrayList(this.hostBindings.values());
        }
        Iterator iter = hBindings.iterator();
        while (iter.hasNext()) {
            HostRegistryBinding hostBinding = (HostRegistryBinding)iter.next();
            Iterator vmIter = hostBinding.getVMRegistryBindings().iterator();
            while (vmIter.hasNext()) {
                VMRegistryBinding vmBinding = (VMRegistryBinding)vmIter.next();
                services.addAll(vmBinding.getActiveServices(serviceType));
            }
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMControllerInterface getVMController(VMControllerID vmControllerID) throws VMControllerNotBoundException {
        HostRegistryBinding hostBinding = null;
        Map map = this.hostBindings;
        synchronized (map) {
            hostBinding = (HostRegistryBinding)this.hostBindings.get(vmControllerID.getHostName());
        }
        if (hostBinding == null) {
            throw new VMControllerNotBoundException("ERR.014.006.0012", PlatformPlugin.Util.getString("ERR.014.006.0012", (Object)vmControllerID));
        }
        VMRegistryBinding vmBinding = hostBinding.getVMRegistryBinding(vmControllerID);
        if (vmBinding == null) {
            throw new VMControllerNotBoundException("ERR.014.006.0012", PlatformPlugin.Util.getString("ERR.014.006.0012", (Object)vmControllerID));
        }
        try {
            return vmBinding.getVMController();
        }
        catch (RegistryCommunicationException e) {
            throw new VMControllerNotBoundException((Throwable)e, "ERR.014.006.0013", PlatformPlugin.Util.getString("ERR.014.006.0013"));
        }
    }

    public void markServiceAsBad(ServiceID serviceID) {
        if (serviceID.getVMControllerID().equals((Object)this.vmControllerID)) {
            this.doMarkServiceAsBad(serviceID);
        } else {
            this.notifyOfBadService(serviceID);
        }
    }

    protected void doMarkServiceAsBad(ServiceID serviceID) {
    }

    private void notifyOfBadService(ServiceID serviceID) {
        if (this.closed) {
            return;
        }
        LogManager.logDetail("REGISTRY", "[MetaMatrixRegistryImpl.notifyOfBadService] bad serviceId: " + serviceID);
        RegistryEvent event = new RegistryEvent((Object)this, 2, this.vmControllerID, (Object)serviceID);
        try {
            if (this.messageBus != null) {
                this.messageBus.processEvent((EventObject)event);
            }
        }
        catch (MessagingException e) {
            LogManager.logError("REGISTRY", (Throwable)e, PlatformPlugin.Util.getString("ERR.014.006.0014", new Object[]{serviceID}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject message) {
        if (this.closed || message.getSource() == this) {
            return;
        }
        RegistryEvent event = (RegistryEvent)message;
        switch (event.getEventType()) {
            case 0: {
                LogManager.logDetail("REGISTRY", "Received REGISTRY_ALIVE_EVENT");
                try {
                    this.broadcastLocalState();
                }
                catch (Exception e) {
                    LogManager.logError("REGISTRY", (Throwable)e, PlatformPlugin.Util.getString("ERR.014.006.0015"));
                }
                break;
            }
            case 2: {
                ServiceID serviceID = (ServiceID)event.getEventObject();
                LogManager.logDetail("REGISTRY", "Received REGISTRY_SERVICE_FAILED_EVENT for " + serviceID);
                if (!serviceID.getVMControllerID().equals((Object)this.vmControllerID)) break;
                this.doMarkServiceAsBad(serviceID);
                break;
            }
            case 1: {
                LogManager.logDetail("REGISTRY", "Received REGISTRY_STATE_EVENT");
                this.updateVMState((VMRegistryBinding)event.getEventObject());
                break;
            }
            case 3: {
                LogManager.logDetail("REGISTRY", "Received REGISTRY_VMCONTROLLER_REMOVED_EVENT");
                VMControllerID vmID = null;
                try {
                    vmID = event.getID();
                    Map map = this.hostBindings;
                    synchronized (map) {
                        HostRegistryBinding hostBinding = this.getHostRegistryBinding(vmID.getHostName());
                        if (hostBinding != null) {
                            hostBinding.removeVMController(vmID);
                            if (hostBinding.getVMRegistryBindings().isEmpty()) {
                                this.hostBindings.remove(vmID.getHostName());
                            }
                        }
                    }
                    this.sendRegistryChangedEvent();
                }
                catch (Exception e) {
                    LogManager.logError("REGISTRY", (Throwable)e, PlatformPlugin.Util.getString("ERR.014.006.0016", new Object[]{vmID}));
                }
                break;
            }
            default: {
                LogManager.logDetail("REGISTRY", "Received Unknown event");
            }
        }
    }

    protected void broadcastLocalState() throws RegistryCommunicationException, RegistryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HostRegistryBinding getLocalHostRegistryBinding() {
        Map map = this.hostBindings;
        synchronized (map) {
            HostRegistryBinding hostBinding = this.getHostRegistryBinding(this.hostName.toUpperCase());
            if (hostBinding == null) {
                hostBinding = new HostRegistryBinding(this.hostName.toUpperCase());
                this.hostBindings.put(this.hostName.toUpperCase(), hostBinding);
            }
            return hostBinding;
        }
    }

    protected VMRegistryBinding getLocalVMRegistryBinding() throws VMControllerNotBoundException {
        if (this.vmControllerID == null) {
            throw new VMControllerNotBoundException("ERR.014.006.0017", PlatformPlugin.Util.getString("ERR.014.006.0017"));
        }
        return this.getVMRegistryBinding(this.vmControllerID);
    }

    public List getAllLocalServices() {
        try {
            VMRegistryBinding vmBinding = this.getLocalVMRegistryBinding();
            List list = vmBinding.getServiceRegistryBindings();
            Iterator iter = list.iterator();
            ArrayList<ServiceRegistryBinding> services = new ArrayList<ServiceRegistryBinding>();
            while (iter.hasNext()) {
                ServiceRegistryBinding binding = (ServiceRegistryBinding)iter.next();
                services.add(binding);
            }
            return services;
        }
        catch (VMControllerNotBoundException e) {
            return new ArrayList();
        }
    }

    private HostRegistryBinding getHostRegistryBinding(String hostName) {
        return (HostRegistryBinding)this.hostBindings.get(hostName.toUpperCase());
    }

    private VMRegistryBinding getVMRegistryBinding(VMControllerID vmID) throws VMControllerNotBoundException {
        HostRegistryBinding hostBinding = this.getHostRegistryBinding(vmID.getHostName());
        if (hostBinding == null) {
            throw new VMControllerNotBoundException("ERR.014.006.0018", PlatformPlugin.Util.getString("ERR.014.006.0018", (Object)vmID));
        }
        VMRegistryBinding vmBinding = hostBinding.getVMRegistryBinding(vmID);
        if (vmBinding == null) {
            throw new VMControllerNotBoundException("ERR.014.006.0018", PlatformPlugin.Util.getString("ERR.014.006.0018", (Object)vmID));
        }
        return vmBinding;
    }

    protected void setVMControllerID(VMControllerID id) {
        this.vmControllerID = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVMState(VMRegistryBinding vmRegistryBinding) {
        if (this.closed) {
            return;
        }
        Map map = this.hostBindings;
        synchronized (map) {
            HostRegistryBinding hostBinding = this.getHostRegistryBinding(vmRegistryBinding.getHostName());
            if (hostBinding == null) {
                hostBinding = new HostRegistryBinding(vmRegistryBinding.getHostName());
                this.hostBindings.put(vmRegistryBinding.getHostName().toUpperCase(), hostBinding);
            }
            hostBinding.updateVMRegistryBinding(vmRegistryBinding);
        }
        this.sendRegistryChangedEvent();
    }

    protected void sendRegistryChangedEvent() {
        LogManager.logTrace("REGISTRY", "Send RegistryChangeEvent.");
        this.localEventBroker.processEvent((EventObject)new RegistryChangedEvent((Object)this));
    }

    public List getVMControllerBindings() {
        ArrayList list = new ArrayList(2);
        Iterator iter = this.getHostRegistryBindings().iterator();
        while (iter.hasNext()) {
            HostRegistryBinding binding = (HostRegistryBinding)iter.next();
            list.addAll(binding.getVMRegistryBindings());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeVMController(VMControllerID id) {
        Map map = this.hostBindings;
        synchronized (map) {
            HostRegistryBinding hostBinding = this.getHostRegistryBinding(id.getHostName());
            hostBinding.removeVMController(id);
            if (hostBinding.getVMRegistryBindings().isEmpty()) {
                this.hostBindings.remove(id.getHostName().toUpperCase());
            }
        }
        this.sendRegistryChangedEvent();
        LogManager.logTrace("REGISTRY", "Removing VMController: " + id);
    }

    public ServiceProxy getProxy(String type, Properties props) {
        return this.proxyMgr.findOrCreateProxy(type, props);
    }

    public void addListener(Class eventClass, EventObjectListener listener) throws EventSourceException {
        this.localEventBroker.addListener(eventClass, listener);
    }

    public void addListener(EventObjectListener listener) throws EventSourceException {
        this.localEventBroker.addListener(listener);
    }

    public void removeListener(Class eventClass, EventObjectListener listener) throws EventSourceException {
        this.localEventBroker.removeListener(eventClass, listener);
    }

    public void removeListener(EventObjectListener listener) throws EventSourceException {
        this.localEventBroker.removeListener(listener);
    }

    public void removeAllListeners() throws EventSourceException {
        this.localEventBroker.removeAllListeners();
    }

    public List getListeners(Class eventClass) {
        return this.localEventBroker.getListeners(eventClass);
    }

    public String toString() {
        StringBuffer b = new StringBuffer("Registry for ");
        b.append(this.vmControllerID);
        try {
            List hosts = this.getHostRegistryBindings();
            Iterator iter = hosts.iterator();
            while (iter.hasNext()) {
                HostRegistryBinding hostBinding = (HostRegistryBinding)iter.next();
                b.append("\n\t");
                b.append(hostBinding);
                Iterator vms = hostBinding.getVMRegistryBindings().iterator();
                while (vms.hasNext()) {
                    VMRegistryBinding vmBinding = (VMRegistryBinding)vms.next();
                    b.append("\n\t\t");
                    b.append(vmBinding);
                    Iterator services = vmBinding.getServiceRegistryBindings().iterator();
                    while (services.hasNext()) {
                        b.append("\n\t\t\t");
                        b.append(services.next());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error printing toString.";
        }
        return b.toString();
    }
}

