/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.navigator.DeepPreOrderNavigator;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.ScalarSubquery;

public class EvaluatableVisitor
extends LanguageVisitor {
    protected boolean evaluationPossible = true;
    private boolean duringPlanning = false;
    private boolean fullyEvaluatable = false;

    public EvaluatableVisitor(boolean duringPlanning, boolean duringExecution) {
        this.duringPlanning = duringPlanning;
        this.fullyEvaluatable = duringExecution;
    }

    public void visit(Function obj) {
        if (obj.getFunctionDescriptor().getPushdown() == 2) {
            this.evaluationPossible = false;
        } else if (this.duringPlanning && EvaluatableVisitor.isDelayedEvaluationFunction(obj)) {
            this.evaluationPossible = false;
        }
        if (!this.evaluationPossible) {
            this.setAbort(true);
        }
    }

    public static boolean isDelayedEvaluationFunction(Function obj) {
        return obj.getName().equalsIgnoreCase("lookup") || obj.getName().equalsIgnoreCase("env") || obj.getName().equalsIgnoreCase("commandpayload");
    }

    public void visit(ElementSymbol obj) {
        if (!this.duringPlanning && !this.fullyEvaluatable && "VARIABLES".equalsIgnoreCase(obj.getGroupSymbol().getCanonicalName())) {
            return;
        }
        this.evaluationPossible = false;
        this.setAbort(true);
    }

    public void visit(ExpressionSymbol obj) {
        this.evaluationPossible = false;
        this.setAbort(true);
    }

    public void visit(AggregateSymbol obj) {
        this.evaluationPossible = false;
        this.setAbort(true);
    }

    public void visit(Reference obj) {
        if (this.duringPlanning) {
            this.evaluationPossible = false;
            this.setAbort(true);
        } else if (this.fullyEvaluatable) {
            if (obj.getExpression() instanceof ElementSymbol) {
                if (obj.getTuple() == null) {
                    this.evaluationPossible = false;
                    this.setAbort(true);
                }
            } else if (obj.getExpression() != null) {
                obj.getExpression().acceptVisitor((LanguageVisitor)this);
            }
        } else if (obj.isCorrelated()) {
            this.evaluationPossible = false;
            this.setAbort(true);
        }
    }

    public void visit(StoredProcedure proc) {
        this.evaluationPossible = false;
        this.setAbort(true);
    }

    public void visit(ScalarSubquery obj) {
        this.evaluationPossible = false;
        this.setAbort(true);
    }

    public void visit(DependentSetCriteria obj) {
        this.evaluationPossible = false;
        this.setAbort(true);
    }

    public void visit(ExistsCriteria obj) {
        this.evaluationPossible = false;
        this.setAbort(true);
    }

    public void visit(SubquerySetCriteria obj) {
        this.evaluationPossible = false;
        this.setAbort(true);
    }

    public void visit(SubqueryCompareCriteria obj) {
        this.evaluationPossible = false;
        this.setAbort(true);
    }

    public boolean isEvaluationPossible() {
        return this.evaluationPossible;
    }

    static final boolean isEvaluatable(LanguageObject obj, boolean deep, boolean duringPlanning, boolean duringExecution) {
        EvaluatableVisitor visitor = new EvaluatableVisitor(duringPlanning, duringExecution);
        if (deep) {
            DeepPreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        } else {
            PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        }
        return visitor.isEvaluationPossible();
    }
}

