/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.eval.CriteriaEvaluator;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RuleCleanCriteria
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, MetaMatrixComponentException {
        List criteria = NodeEditor.findAllNodes(plan, 13);
        Iterator critIter = criteria.iterator();
        while (critIter.hasNext()) {
            Criteria crit;
            PlanNode critNode = (PlanNode)critIter.next();
            if (critNode.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM)) {
                NodeEditor.removeChildNode(critNode.getParent(), critNode);
                continue;
            }
            if (critNode.hasBooleanProperty(NodeConstants.Info.IS_HAVING) || critNode.getGroups().size() != 0 || !EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)(crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA)), true)) continue;
            try {
                boolean eval = CriteriaEvaluator.evaluate((Criteria)crit, (Map)Collections.EMPTY_MAP, (List)Collections.EMPTY_LIST);
                if (eval) {
                    NodeEditor.removeChildNode(critNode.getParent(), critNode);
                    continue;
                }
                FrameUtil.replaceWithNullNode(critNode);
            }
            catch (BlockedException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
            catch (CriteriaEvaluationException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
            catch (MetaMatrixComponentException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
        }
        return plan;
    }

    public String toString() {
        return "CleanCriteria";
    }
}

