/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.JoinUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleBreakCriteria;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.util.CommandContext;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class RulePushNonJoinCriteria
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List nodes = NodeEditor.findAllNodes(plan, 7);
        boolean treeChanged = false;
        boolean removeCopiedFlag = false;
        boolean pushRuleRaiseNull = false;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            PlanNode node = (PlanNode)i.next();
            List criteria = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            JoinType joinType = (JoinType)node.getProperty(NodeConstants.Info.JOIN_TYPE);
            if (joinType == JoinType.JOIN_FULL_OUTER || joinType == JoinType.JOIN_CROSS) continue;
            Iterator crits = criteria.iterator();
            while (crits.hasNext()) {
                Criteria crit = (Criteria)crits.next();
                if (crit.equals(QueryRewriter.FALSE_CRITERIA)) {
                    if (joinType == JoinType.JOIN_INNER) {
                        FrameUtil.replaceWithNullNode(node);
                    } else {
                        FrameUtil.replaceWithNullNode(JoinUtil.getInnerSideJoinNodes(node)[0]);
                        removeCopiedFlag = true;
                    }
                    pushRuleRaiseNull = true;
                    treeChanged = true;
                    break;
                }
                if (crit.equals(QueryRewriter.TRUE_CRITERIA)) {
                    crits.remove();
                    break;
                }
                if (!this.pushCriteria(node, crit)) continue;
                treeChanged = true;
                crits.remove();
            }
            if (criteria.isEmpty() && joinType == JoinType.JOIN_INNER) {
                node.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_CROSS);
                treeChanged = true;
            }
            if (!removeCopiedFlag) continue;
            for (PlanNode parent = node.getParent(); parent != null && parent.getType() == 13; parent = parent.getParent()) {
                parent.setProperty(NodeConstants.Info.COPIED, Boolean.FALSE);
            }
        }
        if (treeChanged) {
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        if (pushRuleRaiseNull) {
            rules.push(RuleConstants.RAISE_NULL);
        }
        return plan;
    }

    private boolean pushCriteria(PlanNode joinNode, Criteria tgtCrit) {
        PlanNode newCritNode = RuleBreakCriteria.createSelectNode(tgtCrit);
        Set groups = newCritNode.getGroups();
        PlanNode[] innerJoinNodes = JoinUtil.getInnerSideJoinNodes(joinNode);
        boolean pushed = false;
        for (int i = 0; i < innerJoinNodes.length; ++i) {
            if (FrameUtil.findOriginatingNode(innerJoinNodes[i], groups) == null) continue;
            if (pushed) {
                newCritNode = RuleBreakCriteria.createSelectNode(tgtCrit);
            }
            NodeEditor.insertNode(joinNode, innerJoinNodes[i], newCritNode);
            pushed = true;
        }
        return pushed;
    }

    public String toString() {
        return "PushNonJoinCriteria";
    }
}

