/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.data.visitor.util;

import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IFromItem;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.IInlineView;
import com.metamatrix.data.language.IJoin;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.IOrderByItem;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.IScalarSubquery;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.language.ISubqueryCompareCriteria;
import com.metamatrix.data.language.ISubqueryInCriteria;
import com.metamatrix.data.language.IUnion;
import com.metamatrix.data.visitor.framework.HierarchyVisitor;
import com.metamatrix.data.visitor.framework.LanguageObjectVisitor;
import com.metamatrix.data.visitor.util.NamingCorrectionVisitor;
import com.metamatrix.data.visitor.util.SQLStringVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NamingCorrectionVisitor
extends HierarchyVisitor {
    private final SQLStringVisitor visitor;
    private SQLNamingContext namingContext = new SQLNamingContext(null);

    public NamingCorrectionVisitor(SQLStringVisitor visitor) {
        this.visitor = visitor;
    }

    public void visit(IElement obj) {
        IGroup group = obj.getGroup();
        if (group != null && group.getDefinition() == null && group.getMetadataID() != null) {
            return;
        }
        String elemShortName = this.getActualShortName(obj);
        if (elemShortName != null) {
            obj.setName(elemShortName);
        }
    }

    private String getActualShortName(IElement obj) {
        IGroup group = obj.getGroup();
        String elemShortName = this.visitor.getElementShortName(obj);
        if (group != null) {
            String groupName = group.getContext();
            String groupAlias = this.namingContext.getGroupName(groupName.toUpperCase());
            if (groupAlias != null) {
                if (group.getDefinition() == null) {
                    group.setDefinition(group.getContext());
                }
                group.setContext(groupAlias);
            }
            elemShortName = this.namingContext.getElementName(groupName.toUpperCase(), elemShortName.toUpperCase());
        } else {
            elemShortName = this.namingContext.getElementName(elemShortName.toUpperCase());
        }
        return elemShortName;
    }

    public void visit(IUnion obj) {
        Iterator i2 = obj.getUnionQueries().iterator();
        while (i2.hasNext()) {
            IQuery query = (IQuery)i2.next();
            this.createChildNamingContext();
            this.visitNode((ILanguageObject)query);
            this.removeChildNamingContext();
        }
        this.visit((IQuery)obj);
        this.visitNode((ILanguageObject)obj.getUnionOrderBy());
    }

    public void visit(ISelect obj) {
        List selectSymbols = obj.getSelectSymbols();
        Iterator selectSymbolIterator = selectSymbols.iterator();
        while (selectSymbolIterator.hasNext()) {
            ISelectSymbol temp = (ISelectSymbol)selectSymbolIterator.next();
            if (!temp.hasAlias() && temp.getExpression() instanceof IElement) {
                IElement element = (IElement)temp.getExpression();
                String outputName = this.visitor.getShortName(element.getName());
                String actualName = null;
                actualName = element.getGroup() instanceof IInlineView ? this.getActualShortName(element) : this.visitor.getElementShortName(element);
                this.namingContext.currentSymbolNames.put(outputName.toUpperCase(), actualName);
                continue;
            }
            if (!temp.hasAlias()) continue;
            this.namingContext.currentSymbolNames.put(temp.getOutputName().toUpperCase(), temp.getOutputName());
        }
        int maxSelectAliasLength = this.visitor.getMaxSelectAliasLength();
        if (maxSelectAliasLength != 0) {
            HashSet<String> newAliases = new HashSet<String>();
            selectSymbolIterator = selectSymbols.iterator();
            while (selectSymbolIterator.hasNext()) {
                ISelectSymbol temp = (ISelectSymbol)selectSymbolIterator.next();
                if (!temp.hasAlias()) continue;
                String outputName = this.visitor.getShortName(temp.getOutputName());
                int aliasIndex = 0;
                String newAlias = outputName;
                if (outputName.length() > maxSelectAliasLength) {
                    newAlias = this.truncateAlias(outputName, maxSelectAliasLength);
                    while (this.namingContext.getElementName(newAlias.toUpperCase()) != null || newAliases.contains(newAlias.toUpperCase())) {
                        newAlias = newAlias + aliasIndex++;
                    }
                    newAliases.add(newAlias.toUpperCase());
                }
                this.namingContext.currentSymbolNames.put(outputName.toUpperCase(), newAlias);
                temp.setOutputName(newAlias);
            }
        }
        super.visit(obj);
    }

    public void visit(IQuery obj) {
        this.visitNode((ILanguageObject)obj.getFrom());
        this.visitNode((ILanguageObject)obj.getWhere());
        this.visitNode((ILanguageObject)obj.getGroupBy());
        this.visitNode((ILanguageObject)obj.getHaving());
        this.visitNode((ILanguageObject)obj.getSelect());
        this.visitNode((ILanguageObject)obj.getOrderBy());
    }

    private String truncateAlias(String aliasName, int maxAliasLength) {
        return aliasName.substring(0, maxAliasLength - 2);
    }

    public void visit(IInlineView obj) {
        this.createChildNamingContext();
        obj.getQuery().acceptVisitor((LanguageObjectVisitor)this);
        this.namingContext.updateElementMap(obj.getName().toUpperCase());
        this.removeChildNamingContext();
        this.visitGroup((IGroup)obj);
    }

    public void visit(IScalarSubquery obj) {
        this.createChildNamingContext();
        super.visit(obj);
        this.removeChildNamingContext();
    }

    public void visit(ISubqueryCompareCriteria obj) {
        this.createChildNamingContext();
        super.visit(obj);
        this.removeChildNamingContext();
    }

    public void visit(ISubqueryInCriteria obj) {
        this.createChildNamingContext();
        super.visit(obj);
        this.removeChildNamingContext();
    }

    public void createChildNamingContext() {
        this.namingContext = new SQLNamingContext(this.namingContext);
    }

    public void removeChildNamingContext() {
        this.namingContext = this.namingContext.parent;
    }

    private void extractGroupNames(IFromItem item) {
        if (item instanceof IGroup) {
            IGroup group = (IGroup)item;
            this.namingContext.currentGroupNames.put(group.getContext().toUpperCase(), group.getContext());
        } else if (item instanceof IJoin) {
            IJoin join = (IJoin)item;
            this.extractGroupNames(join.getLeftItem());
            this.extractGroupNames(join.getRightItem());
        }
    }

    public void visit(IFrom obj) {
        Iterator items = obj.getItems().iterator();
        while (items.hasNext()) {
            IFromItem item = (IFromItem)items.next();
            this.extractGroupNames(item);
        }
        super.visit(obj);
        this.namingContext.currentGroupNames.clear();
    }

    public void visit(IGroup obj) {
        super.visit(obj);
        this.visitGroup(obj);
    }

    private void visitGroup(IGroup obj) {
        String outputName;
        String newAlias = outputName = obj.getContext();
        if (obj.getDefinition() != null || obj.getMetadataID() == null) {
            newAlias = outputName.replace('.', '_');
            int aliasIndex = 0;
            int maxTableAliasLength = this.visitor.getMaxTableAliasLength();
            if (maxTableAliasLength != 0 && outputName.length() > maxTableAliasLength) {
                newAlias = this.truncateAlias(newAlias, maxTableAliasLength);
                while (this.namingContext.currentGroupNames.get(newAlias.toUpperCase()) != null || this.namingContext.getGroupName(newAlias.toUpperCase()) != null) {
                    newAlias = newAlias + aliasIndex++;
                }
            }
            obj.setContext(newAlias);
        }
        this.namingContext.groupNames.put(outputName.toUpperCase(), newAlias);
    }

    public void visit(IOrderByItem obj) {
        if (obj.getElement() == null) {
            String name = obj.getName();
            String actualName = this.namingContext.getElementName(name.toUpperCase());
            if (actualName != null) {
                obj.setName(actualName);
            }
        } else {
            this.visit(obj.getElement());
        }
    }
}

