/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.internal.ui.sqleditor.component;

import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNodeFactory;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNodeUtils;
import com.metamatrix.query.internal.ui.sqleditor.component.OptionDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.WhereDisplayNode;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeleteDisplayNode
extends DisplayNode {
    public DeleteDisplayNode(DisplayNode parentNode, Delete delete) {
        this.parentNode = parentNode;
        this.languageObject = delete;
        this.createChildNodes();
    }

    public boolean supportsGroup() {
        return true;
    }

    public boolean supportsCriteria() {
        return true;
    }

    public DisplayNode getClauseDisplayNode(int clauseType) {
        if (clauseType < 6 || clauseType > 13) {
            return null;
        }
        Iterator iter = this.childNodeList.iterator();
        while (iter.hasNext()) {
            DisplayNode node = (DisplayNode)iter.next();
            switch (clauseType) {
                case 9: {
                    if (!(node instanceof WhereDisplayNode)) break;
                    return node;
                }
                case 13: {
                    if (!(node instanceof OptionDisplayNode)) break;
                    return node;
                }
            }
        }
        return null;
    }

    public DisplayNode getClauseAtIndex(int index) {
        List nodes = DisplayNodeUtils.getDisplayNodesAtIndex((List)this.displayNodeList, (int)index);
        int nNodes = nodes.size();
        if (nNodes == 0) {
            return null;
        }
        if (nNodes == 1) {
            return DisplayNodeUtils.getClauseForNode((DisplayNode)((DisplayNode)nodes.get(0)));
        }
        if (nNodes == 2) {
            DisplayNode clause1 = DisplayNodeUtils.getClauseForNode((DisplayNode)((DisplayNode)nodes.get(0)));
            DisplayNode clause2 = DisplayNodeUtils.getClauseForNode((DisplayNode)((DisplayNode)nodes.get(1)));
            if (clause2 != null) {
                return clause2;
            }
            return clause1;
        }
        return null;
    }

    private void createChildNodes() {
        Option option;
        Criteria criteria;
        this.childNodeList = new ArrayList();
        Delete delete = (Delete)this.getLanguageObject();
        GroupSymbol group = delete.getGroup();
        if (group != null) {
            this.childNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)group));
        }
        if ((criteria = delete.getCriteria()) != null) {
            this.childNodeList.add(DisplayNodeFactory.createWhereDisplayNode((DisplayNode)this, (Criteria)criteria));
        }
        if ((option = delete.getOption()) != null) {
            this.childNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)option));
        }
        this.createDisplayNodeList();
    }

    private void createDisplayNodeList() {
        this.displayNodeList = new ArrayList();
        int indent = this.getIndentLevel();
        ++indent;
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"DELETE"));
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"FROM"));
        this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
        Iterator iter = this.getChildren().iterator();
        if (iter.hasNext()) {
            DisplayNode groupChild = (DisplayNode)iter.next();
            if (groupChild.hasDisplayNodes()) {
                this.displayNodeList.addAll(groupChild.getDisplayNodeList());
            } else {
                this.displayNodeList.add(groupChild);
            }
            if (iter.hasNext()) {
                this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)" "));
                if (DisplayNodeUtils.isClauseCROn() && !DisplayNodeUtils.isWithinNoClauseIndentNode((DisplayNode)this)) {
                    this.displayNodeList.add(DisplayNodeFactory.createDisplayNode((DisplayNode)this, (Object)"\n"));
                    if (DisplayNodeUtils.isClauseIndentOn() && !DisplayNodeUtils.isWithinNoClauseIndentNode((DisplayNode)this)) {
                        this.displayNodeList.addAll(DisplayNodeUtils.getIndentNodes((DisplayNode)this, (int)indent));
                    }
                }
            }
        }
        while (iter.hasNext()) {
            DisplayNode childNode = (DisplayNode)iter.next();
            if (childNode.hasDisplayNodes()) {
                this.displayNodeList.addAll(childNode.getDisplayNodeList());
                continue;
            }
            this.displayNodeList.add(childNode);
        }
    }
}

