/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Association;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.LiteralBoolean;
import org.eclipse.uml2.LiteralInteger;
import org.eclipse.uml2.LiteralString;
import org.eclipse.uml2.LiteralUnlimitedNatural;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.RedefinableElement;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.ValueSpecification;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class PropertyOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    private PropertyOperations() {
    }

    public static boolean validateOppositeIsOtherEnd(Property property, DiagnosticChain diagnostics, Map context) {
        Property otherEnd;
        boolean result = true;
        Property opposite = null;
        if (property.getOwningAssociation() == null && (otherEnd = PropertyOperations.getOtherEnd(property)) != null && otherEnd.getOwningAssociation() == null) {
            opposite = otherEnd;
        }
        if (!PropertyOperations.safeEquals(property.getOpposite(), opposite)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 13, UML2Plugin.INSTANCE.getString("_UI_Property_OppositeIsOtherEnd_diagnostic", PropertyOperations.getMessageSubstitutions(context, property)), new Object[]{property, opposite}));
            }
        }
        return result;
    }

    public static Property opposite(Property property) {
        Property otherEnd;
        if (property.getOwningAssociation() == null && (otherEnd = PropertyOperations.getOtherEnd(property)) != null && otherEnd.getOwningAssociation() == null) {
            return otherEnd;
        }
        return null;
    }

    public static boolean validateMultiplicityOfComposite(Property property, DiagnosticChain diagnostics, Map context) {
        int upperBound;
        Property otherEnd;
        boolean result = true;
        if (property.isComposite() && (otherEnd = PropertyOperations.getOtherEnd(property)) != null && (-1 == (upperBound = otherEnd.upperBound()) || 1 < upperBound)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 14, UML2Plugin.INSTANCE.getString("_UI_Property_MultiplicityOfComposite_diagnostic", PropertyOperations.getMessageSubstitutions(context, property)), new Object[]{property, new Integer(upperBound)}));
            }
        }
        return result;
    }

    public static boolean validateSubsettingContext(Property property, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator sp = property.getSubsettedProperties().iterator();
        block0: while (sp.hasNext()) {
            Property subsettedProperty = (Property)sp.next();
            Iterator sc = property.subsettingContext().iterator();
            while (sc.hasNext()) {
                Classifier subsettingContext = (Classifier)sc.next();
                Iterator c = subsettedProperty.subsettingContext().iterator();
                while (c.hasNext()) {
                    if (subsettingContext.conformsTo((Classifier)c.next())) continue block0;
                }
            }
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 15, UML2Plugin.INSTANCE.getString("_UI_Property_SubsettingContext_diagnostic", PropertyOperations.getMessageSubstitutions(context, property, subsettedProperty)), new Object[]{property, subsettedProperty}));
        }
        return result;
    }

    public static boolean validateNavigablePropertyRedefinition(Property property, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator subsettedProperties = property.getSubsettedProperties().iterator();
        while (subsettedProperties.hasNext()) {
            Property subsettedProperty = (Property)subsettedProperties.next();
            if (!subsettedProperty.isNavigable() || property.isNavigable()) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 16, UML2Plugin.INSTANCE.getString("_UI_Property_NavigablePropertyRedefinition_diagnostic", PropertyOperations.getMessageSubstitutions(context, property, subsettedProperty)), new Object[]{property, subsettedProperty}));
        }
        Iterator redefinedProperties = property.getRedefinedProperties().iterator();
        while (redefinedProperties.hasNext()) {
            Property redefinedProperty = (Property)redefinedProperties.next();
            if (!redefinedProperty.isNavigable() || property.isNavigable()) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 16, UML2Plugin.INSTANCE.getString("_UI_Property_NavigablePropertyRedefinition_diagnostic", PropertyOperations.getMessageSubstitutions(context, property, redefinedProperty)), new Object[]{property, redefinedProperty}));
        }
        return result;
    }

    public static boolean validateSubsettingRules(Property property, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Type type = property.getType();
        int upperBound = property.upperBound();
        Iterator subsettedProperties = property.getSubsettedProperties().iterator();
        while (subsettedProperties.hasNext()) {
            Property subsettedProperty = (Property)subsettedProperties.next();
            int subsettedUpperBound = subsettedProperty.upperBound();
            if (type.conformsTo(subsettedProperty.getType()) && (-1 == subsettedUpperBound || upperBound != -1 && upperBound <= subsettedUpperBound)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 17, UML2Plugin.INSTANCE.getString("_UI_Property_SubsettingRules_diagnostic", PropertyOperations.getMessageSubstitutions(context, property, subsettedProperty)), new Object[]{property, subsettedProperty}));
        }
        return result;
    }

    public static boolean validateNavigableReadonly(Property property, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (property.isReadOnly() && property.getAssociation() != null && !property.isNavigable()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 18, UML2Plugin.INSTANCE.getString("_UI_Property_NavigableReadOnly_diagnostic", PropertyOperations.getMessageSubstitutions(context, property)), new Object[]{property}));
            }
        }
        return result;
    }

    public static boolean validateDerivedUnionIsDerived(Property property, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (property.isDerivedUnion() && !property.isDerived()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 19, UML2Plugin.INSTANCE.getString("_UI_Property_DerivedUnionIsDerived_diagnostic", PropertyOperations.getMessageSubstitutions(context, property)), new Object[]{property}));
            }
        }
        return result;
    }

    public static Set subsettingContext(Property property) {
        HashSet<EObject> subsettingContext = new HashSet<EObject>();
        Association association = property.getAssociation();
        if (association == null) {
            EObject eContainer = property.eContainer();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.uml2.Classifier");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isInstance(eContainer)) {
                subsettingContext.add(eContainer);
            }
        } else {
            subsettingContext.addAll((Collection<EObject>)association.getEndTypes());
        }
        return Collections.unmodifiableSet(subsettingContext);
    }

    public static boolean isConsistentWith(Property property, RedefinableElement redefinee) {
        if (redefinee.isRedefinitionContextValid(property)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.uml2.Property");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isInstance(redefinee)) {
                Property prop = (Property)redefinee;
                Type type = property.getType();
                int upperBound = property.upperBound();
                Type propType = prop.getType();
                int propUpperBound = prop.upperBound();
                return (type == null ? propType == null : propType.conformsTo(type)) && prop.lowerBound() >= property.lowerBound() && (-1 == upperBound || propUpperBound != -1 && propUpperBound <= upperBound) && (!property.isDerived() || prop.isDerived());
            }
        }
        return false;
    }

    protected static Property getOtherEnd(Property property) {
        Association association = property.getAssociation();
        if (association != null && association.isBinary()) {
            EList memberEnds = association.getMemberEnds();
            return (Property)memberEnds.get(Math.abs(memberEnds.indexOf(property) - 1));
        }
        return null;
    }

    public static boolean isNavigable(Property property) {
        if (property == null) {
            return false;
        }
        return property.getAssociation() != null && property.getOwningAssociation() == null;
    }

    public static void setNavigable(Property property, boolean navigable) {
        if (property == null) {
            throw new IllegalArgumentException(String.valueOf(property));
        }
        Association association = property.getAssociation();
        if (association == null || !association.isBinary()) {
            throw new IllegalArgumentException(String.valueOf(property));
        }
        if (navigable != PropertyOperations.isNavigable(property)) {
            if (navigable) {
                List ownedAttributes = PropertyOperations.getOwnedAttributes(PropertyOperations.getOtherEnd(property).getType());
                if (ownedAttributes == null) {
                    throw new IllegalArgumentException(String.valueOf(navigable));
                }
                ownedAttributes.add(property);
            } else {
                association.getOwnedEnds().add((Object)property);
            }
        }
    }

    public static void setBooleanDefault(Property property, boolean value) {
        if (property == null) {
            throw new IllegalArgumentException(String.valueOf(property));
        }
        ValueSpecification defaultValue = property.getDefaultValue();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.uml2.LiteralBoolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((LiteralBoolean)(clazz.isInstance(defaultValue) ? defaultValue : property.createDefaultValue(UML2Package.eINSTANCE.getLiteralBoolean()))).setValue(value);
    }

    public static void setIntegerDefault(Property property, int value) {
        if (property == null) {
            throw new IllegalArgumentException(String.valueOf(property));
        }
        ValueSpecification defaultValue = property.getDefaultValue();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.uml2.LiteralInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((LiteralInteger)(clazz.isInstance(defaultValue) ? defaultValue : property.createDefaultValue(UML2Package.eINSTANCE.getLiteralInteger()))).setValue(value);
    }

    public static void setStringDefault(Property property, String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.valueOf(property));
        }
        ValueSpecification defaultValue = property.getDefaultValue();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.uml2.LiteralString");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((LiteralString)(clazz.isInstance(defaultValue) ? defaultValue : property.createDefaultValue(UML2Package.eINSTANCE.getLiteralString()))).setValue(value);
    }

    public static void setUnlimitedNaturalDefault(Property property, int value) {
        if (property == null) {
            throw new IllegalArgumentException(String.valueOf(property));
        }
        ValueSpecification defaultValue = property.getDefaultValue();
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.uml2.LiteralUnlimitedNatural");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((LiteralUnlimitedNatural)(clazz.isInstance(defaultValue) ? defaultValue : property.createDefaultValue(UML2Package.eINSTANCE.getLiteralUnlimitedNatural()))).setValue(value);
    }

    public static String getDefault(Property property) {
        ValueSpecification defaultValue = property.getDefaultValue();
        return defaultValue == null ? "" : defaultValue.stringValue();
    }
}

