/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Dependency;
import org.eclipse.uml2.Generalization;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.VisibilityKind;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class ClassifierOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private ClassifierOperations() {
    }

    public static Set allFeatures(Classifier classifier) {
        HashSet<NamedElement> allFeatures = new HashSet<NamedElement>();
        Iterator members = classifier.getMembers().iterator();
        while (members.hasNext()) {
            NamedElement member = (NamedElement)members.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.uml2.Feature");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(member)) continue;
            allFeatures.add(member);
        }
        return Collections.unmodifiableSet(allFeatures);
    }

    public static boolean validateNoCyclesInGeneralization(Classifier classifier, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (classifier.allParents().contains(classifier)) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 23, UML2Plugin.INSTANCE.getString("_UI_Classifier_NoCyclesInGeneralization_diagnostic", ClassifierOperations.getMessageSubstitutions(context, classifier)), new Object[]{classifier}));
            }
        }
        return result;
    }

    public static boolean validateSpecializeType(Classifier classifier, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator parents = classifier.parents().iterator();
        while (parents.hasNext()) {
            Classifier parent = (Classifier)parents.next();
            if (classifier.maySpecializeType(parent)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 24, UML2Plugin.INSTANCE.getString("_UI_Classifier_SpecializeType_diagnostic", ClassifierOperations.getMessageSubstitutions(context, classifier, parent)), new Object[]{classifier, parent}));
        }
        return result;
    }

    public static boolean validateInheritedMember(Classifier classifier, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        HashSet inheritedMember = new HashSet();
        Iterator parents = classifier.parents().iterator();
        while (parents.hasNext()) {
            inheritedMember.addAll(((Classifier)parents.next()).inheritableMembers(classifier));
        }
        if (!classifier.inheritedMember().containsAll(classifier.inherit(inheritedMember))) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 25, UML2Plugin.INSTANCE.getString("_UI_Classifier_InheritedMember_diagnostic", ClassifierOperations.getMessageSubstitutions(context, classifier)), new Object[]{classifier}));
            }
        }
        return result;
    }

    public static Set inheritedMember(Classifier classifier) {
        HashSet inheritedMember = new HashSet();
        Iterator parents = classifier.parents().iterator();
        while (parents.hasNext()) {
            inheritedMember.addAll(((Classifier)parents.next()).inheritableMembers(classifier));
        }
        return classifier.inherit(inheritedMember);
    }

    public static Set parents(Classifier classifier) {
        HashSet<Classifier> parents = new HashSet<Classifier>();
        Iterator generalizations = classifier.getGeneralizations().iterator();
        while (generalizations.hasNext()) {
            Classifier general = ((Generalization)generalizations.next()).getGeneral();
            if (general == null) continue;
            parents.add(general);
        }
        return Collections.unmodifiableSet(parents);
    }

    public static Set allParents(Classifier classifier) {
        HashSet allParents = new HashSet();
        ClassifierOperations.allParentsHelper(classifier, allParents);
        return Collections.unmodifiableSet(allParents);
    }

    public static Set inheritableMembers(Classifier classifier, Classifier c) {
        HashSet<NamedElement> inheritableMembers = new HashSet<NamedElement>();
        if (classifier == c || !c.allParents().contains(classifier) || classifier.allParents().contains(c)) {
            return inheritableMembers;
        }
        Iterator members = classifier.getMembers().iterator();
        while (members.hasNext()) {
            NamedElement member = (NamedElement)members.next();
            if (!c.hasVisibilityOf(member)) continue;
            inheritableMembers.add(member);
        }
        return Collections.unmodifiableSet(inheritableMembers);
    }

    public static boolean hasVisibilityOf(Classifier classifier, NamedElement n) {
        Iterator allParents = classifier.allParents().iterator();
        while (allParents.hasNext()) {
            if (!((Classifier)allParents.next()).getMembers().contains((Object)n)) continue;
            return VisibilityKind.PRIVATE_LITERAL != n.getVisibility();
        }
        return false;
    }

    public static Set inherit(Classifier classifier, Set inhs) {
        return Collections.unmodifiableSet(inhs);
    }

    public static boolean maySpecializeType(Classifier classifier, Classifier c) {
        return c.eClass().isSuperTypeOf(classifier.eClass());
    }

    public static Set general(Classifier classifier) {
        return classifier.parents();
    }

    public static boolean validateGeneralEqualsParents(Classifier classifier, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (!classifier.general().equals(classifier.parents())) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 26, UML2Plugin.INSTANCE.getString("_UI_Classifier_GeneralEqualsParents_diagnostic", ClassifierOperations.getMessageSubstitutions(context, classifier)), new Object[]{classifier}));
            }
        }
        return result;
    }

    public static boolean conformsTo(Classifier classifier, Classifier other) {
        return classifier == other || classifier.allParents().contains(other);
    }

    protected static void allParentsHelper(Classifier classifier, Set allParents) {
        Iterator parents = classifier.parents().iterator();
        while (parents.hasNext()) {
            Classifier parent = (Classifier)parents.next();
            if (allParents.contains(parent)) continue;
            allParents.add(parent);
            ClassifierOperations.allParentsHelper(parent, allParents);
        }
    }

    public static Generalization createGeneralization(Classifier classifier, Classifier generalClassifier) {
        if (classifier == null) {
            throw new IllegalArgumentException(String.valueOf(classifier));
        }
        if (generalClassifier == null || classifier.allParents().contains(generalClassifier) || generalClassifier.allParents().contains(classifier)) {
            throw new IllegalArgumentException(String.valueOf(generalClassifier));
        }
        Generalization generalization = classifier.createGeneralization();
        generalization.setGeneral(generalClassifier);
        return generalization;
    }

    public static Set getUsedInterfaces(Classifier classifier) {
        HashSet<NamedElement> usedInterfaces = new HashSet<NamedElement>();
        if (classifier != null) {
            Iterator clientDependencies = classifier.getClientDependencies().iterator();
            while (clientDependencies.hasNext()) {
                Dependency clientDependency = (Dependency)clientDependencies.next();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.uml2.Usage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isInstance(clientDependency)) continue;
                Iterator suppliers = clientDependency.getSuppliers().iterator();
                while (suppliers.hasNext()) {
                    NamedElement supplier = (NamedElement)suppliers.next();
                    Class<?> clazz2 = class$2;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("org.eclipse.uml2.Interface");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz2.isInstance(supplier)) continue;
                    usedInterfaces.add(supplier);
                }
            }
        }
        return usedInterfaces;
    }
}

