/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.vdb;

import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.common.vdb.api.VDBInfo;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.RuntimeMgmtManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.notification.AddedDataEntitlementNotification;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.WorkspaceController;
import com.metamatrix.console.ui.util.BasicWizardSubpanelContainer;
import com.metamatrix.console.ui.util.WizardInterface;
import com.metamatrix.console.ui.util.WizardInterfaceImpl;
import com.metamatrix.console.ui.views.vdb.AllMaterializationFilesDisplayInfo;
import com.metamatrix.console.ui.views.vdb.BindingNameAndExistingUUID;
import com.metamatrix.console.ui.views.vdb.BindingsAlreadyExistDlg;
import com.metamatrix.console.ui.views.vdb.CreateVDBPanelParent;
import com.metamatrix.console.ui.views.vdb.ImportFileSelectionPanel;
import com.metamatrix.console.ui.views.vdb.ModelVisibilityInfo;
import com.metamatrix.console.ui.views.vdb.SingleMaterializationFileDisplayInfo;
import com.metamatrix.console.ui.views.vdb.VDBWizardModelVisibilityPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardConfirmPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardDTCPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardEditConnBindPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardEntitlementsPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardEntitlementsSelectPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardIdPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardSaveMaterializationFilesPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardUserAndPasswordPanel;
import com.metamatrix.console.ui.views.vdb.VdbWizardWrittenMaterializationFilesPanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseDoesNotExistException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.vdb.defn.VDBDefnFactory;
import com.metamatrix.modeler.core.metadata.runtime.MetadataConstants;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.server.admin.api.MaterializationLoadScripts;
import com.metamatrix.server.admin.api.RuntimeMetadataAdminAPI;
import com.metamatrix.server.admin.apiimpl.rmc.RMCException;
import com.metamatrix.server.admin.apiimpl.rmc.RMCVersionEntry;
import com.metamatrix.toolbox.preference.UserPreferences;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.vdb.edit.loader.VDBReader;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBDefn;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;

public class CreateVDBPanel
extends WizardInterfaceImpl {
    private static final String CONNECTION_PROPERTIES_FILE_DESC = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.connectionPropertiesFile");
    private static final String CREATE_SCRIPT_FILE_DESC = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.createScriptFile");
    private static final String LOAD_SCRIPT_FILE_DESC = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.loadScriptFile");
    private static final String SWAP_SCRIPT_FILE_DESC = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.swapScriptFile");
    private static final String TRUNCATE_SCRIPT_FILE_DESC = ConsolePlugin.Util.getString("VdbWizardSaveMaterializationFilesPanel.truncateScriptFile");
    private static final int NUM_MATERIALIZATION_FILES = 5;
    private static final int ID_STEP_NUM = 2;
    static final String[] VDB_IMPORT_EXTENSIONS = new String[]{"def", "vdb"};
    static final String VDB_TYPE_FILE_DESC = "VDB Import Types (*.def, *.vdb)";
    private static final int IMPORT_INITIALIZED_NONE = -1;
    private static final int IMPORT_INITIALIZED_NEW_VDB = -2;
    private static final int IMPORT_INITIALIZED_NEW_VERSION = -3;
    ImportFileSelectionPanel selectorPanel;
    VdbWizardEditConnBindPanel pnlEditConnBind = null;
    VdbWizardConfirmPanel pnlConfirm = null;
    VdbWizardIdPanel pnlID = null;
    VdbWizardEntitlementsPanel pnlEntitlements = null;
    VdbWizardEntitlementsSelectPanel pnlEntitlementsSelect = null;
    VDBWizardModelVisibilityPanel visPanel = null;
    VdbWizardDTCPanel pnlDTC;
    private VdbWizardUserAndPasswordPanel upPanel = null;
    private VdbWizardSaveMaterializationFilesPanel savePanel = null;
    private VdbWizardWrittenMaterializationFilesPanel matFilesPanel = null;
    private boolean importing;
    private boolean creatingNewVDBVersion = false;
    private TreeView dtcTreeView;
    private VirtualDatabase sourceVirtualDatabase;
    private MaterializationLoadScripts scripts = null;
    private int importInitializedType = -1;
    String sVdbName = "";
    String sDescription = "";
    ModelVisibilityInfo[] visInfo = null;
    RMCVersionEntry rmcVDBVersion = null;
    Map mapConnBind = null;
    Map existingBindingsOnImport = null;
    CreateVDBPanelParent dlgParent = null;
    VirtualDatabase newVirtualDatabase = null;
    VDBDefn newVDBDefn = null;
    boolean nextFlag = true;
    short siStatus = 0;
    private EntitlementMigrationReport emrEntitlementReport = null;
    private ModelInfo materializationTableModel;
    private ConnectorBinding materializationConnectorBinding;
    private boolean attemptedCreatingVDB = false;
    private ConnectionInfo connection = null;
    private boolean vdbSelectionChanged = true;
    private String oldVDBPath = "";

    public static Map modelVisibilityMap(ModelVisibilityInfo[] visInf) {
        HashMap<String, Short> map = new HashMap<String, Short>();
        if (visInf != null) {
            for (int i = 0; i < visInf.length; ++i) {
                String modelName = visInf[i].getModelName();
                short visibilityType = visInf[i].isVisible() ? (short)0 : 1;
                map.put(modelName, new Short(visibilityType));
            }
        }
        return map;
    }

    public static Map modelMultiSourceMap(ModelVisibilityInfo[] visInf) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (visInf != null) {
            for (int i = 0; i < visInf.length; ++i) {
                String modelName = visInf[i].getModelName();
                Boolean sourceEnabled = new Boolean(visInf[i].isMultipleSourcesSelected());
                map.put(modelName, sourceEnabled);
            }
        }
        return map;
    }

    public CreateVDBPanel(CreateVDBPanelParent dlgParent, TreeView dtcTreeView, VirtualDatabase vdbSourceVdb, ConnectionInfo connection) {
        this.dlgParent = dlgParent;
        this.dtcTreeView = dtcTreeView;
        this.sourceVirtualDatabase = vdbSourceVdb;
        boolean bl = this.importing = this.dtcTreeView == null;
        if (!this.importing) {
            this.creatingNewVDBVersion = this.sourceVirtualDatabase != null;
        }
        this.connection = connection;
        this.init();
    }

    private RuntimeMetadataAdminAPI getRuntimeMetadataAdminAPI() {
        return ModelManager.getRuntimeMetadataAPI((ConnectionInfo)this.connection);
    }

    private VdbManager getVdbManager() {
        return ModelManager.getVdbManager((ConnectionInfo)this.connection);
    }

    private ConnectorManager getConnectorManager() {
        return ModelManager.getConnectorManager((ConnectionInfo)this.connection);
    }

    private ConfigurationManager getConfigurationManager() {
        return ModelManager.getConfigurationManager((ConnectionInfo)this.connection);
    }

    private RuntimeMgmtManager getRuntimeMgmtManager() {
        return ModelManager.getRuntimeMgmtManager((ConnectionInfo)this.connection);
    }

    private void init() {
        int iPages = this.getPageCount();
        for (int x = 0; x < iPages; ++x) {
            this.removePage(x);
        }
        if (this.importing) {
            String initialDirectory = (String)UserPreferences.getInstance().getValue("metamatrix.console.directory");
            this.selectorPanel = new ImportFileSelectionPanel((WizardInterface)this, initialDirectory, 1);
            this.addPage((Component)((Object)this.selectorPanel));
            this.pnlID = new VdbWizardIdPanel(1, (WizardInterface)this);
            this.addPage((Component)this.pnlID);
            VdbWizardIdPanel extra = new VdbWizardIdPanel(1, (WizardInterface)this);
            this.addPage((Component)extra);
            this.renumberPages();
            this.setListeners();
        } else {
            this.pnlDTC = new VdbWizardDTCPanel(1, (WizardInterface)this, this.dtcTreeView, this.connection);
            this.pnlID = this.sourceVirtualDatabase == null ? new VdbWizardIdPanel(1, (WizardInterface)this) : new VdbWizardIdPanel(1, this.sourceVirtualDatabase, (WizardInterface)this);
            this.visPanel = new VDBWizardModelVisibilityPanel(1, (WizardInterface)this);
            this.pnlEditConnBind = new VdbWizardEditConnBindPanel(1, this.sourceVirtualDatabase, (WizardInterface)this, this.connection);
            if (this.creatingNewVDBVersion) {
                this.pnlEntitlementsSelect = new VdbWizardEntitlementsSelectPanel(this.sourceVirtualDatabase, (WizardInterface)this, 1);
            }
            if (this.sourceVirtualDatabase == null) {
                this.pnlConfirm = new VdbWizardConfirmPanel((WizardInterface)this, 1);
            } else {
                this.pnlConfirm = new VdbWizardConfirmPanel(this.sourceVirtualDatabase, (WizardInterface)this, 1);
                this.pnlEntitlements = new VdbWizardEntitlementsPanel(this.sourceVirtualDatabase, (WizardInterface)this, this.connection, 1);
            }
            this.addPage((Component)this.pnlDTC);
            this.addPage((Component)this.pnlID);
            this.addPage((Component)this.visPanel);
            this.addPage((Component)this.pnlEditConnBind);
            if (this.creatingNewVDBVersion) {
                this.addPage((Component)this.pnlEntitlementsSelect);
            }
            this.addPage((Component)this.pnlConfirm);
            this.renumberPages();
            this.setListeners();
            this.pnlID.postRealize();
            this.getNextButton().setEnabled(false);
        }
    }

    private void initImportNewVersion() {
        if (this.importInitializedType != -3) {
            int iPages;
            for (int x = iPages = this.getPageCount(); x > 2; --x) {
                this.removePage(x - 1);
            }
            this.visPanel = new VDBWizardModelVisibilityPanel(1, (WizardInterface)this);
            this.pnlEditConnBind = new VdbWizardEditConnBindPanel(1, this.sourceVirtualDatabase, (WizardInterface)this, this.connection);
            this.pnlEntitlementsSelect = new VdbWizardEntitlementsSelectPanel(this.sourceVirtualDatabase, (WizardInterface)this, 1);
            this.pnlConfirm = new VdbWizardConfirmPanel(this.sourceVirtualDatabase, (WizardInterface)this, 1);
            this.pnlEntitlements = new VdbWizardEntitlementsPanel(this.sourceVirtualDatabase, (WizardInterface)this, this.connection, 1);
            this.addPage((Component)this.visPanel);
            this.addPage((Component)this.pnlEditConnBind);
            this.addPage((Component)this.pnlEntitlementsSelect);
            this.addPage((Component)this.pnlConfirm);
            this.pnlEntitlementsSelect.getViewEntitlementsReportCbx().addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.renumberPages();
            this.getNextButton().setEnabled(false);
        }
        this.initImportCommon();
        this.importInitializedType = -3;
    }

    private void initImportNewVDB() {
        if (this.importInitializedType != -2) {
            int iPages;
            for (int x = iPages = this.getPageCount(); x > 2; --x) {
                this.removePage(x - 1);
            }
            this.visPanel = new VDBWizardModelVisibilityPanel(1, (WizardInterface)this);
            this.addPage((Component)this.visPanel);
            this.pnlEditConnBind = new VdbWizardEditConnBindPanel(1, (WizardInterface)this, this.connection);
            this.addPage((Component)this.pnlEditConnBind);
            this.pnlConfirm = new VdbWizardConfirmPanel((WizardInterface)this, 1);
            this.addPage((Component)this.pnlConfirm);
            this.renumberPages();
            this.getNextButton().setEnabled(false);
        }
        this.initImportCommon();
        this.importInitializedType = -2;
    }

    private void initImportCommon() {
        ModelVisibilityInfo[] vInfo = this.convertModelTableRowsToModelVisibilityInfo((VDBInfo)this.rmcVDBVersion);
        if (this.vdbSelectionChanged) {
            this.visPanel.populateTable(vInfo);
            Collection mdls = this.rmcVDBVersion.getModels();
            this.pnlEditConnBind.setDtcInfo(this.rmcVDBVersion);
            this.pnlEditConnBind.setModels(mdls);
            this.pnlEditConnBind.loadAdditionalBindings();
            this.mapConnBind = null;
        }
    }

    private void setListeners() {
        this.getCancelButton().addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getFinishButton().addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.pnlEntitlementsSelect != null) {
            this.pnlEntitlementsSelect.getViewEntitlementsReportCbx().addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void renumberPages() {
        Component[] thePages = this.getPages();
        for (int i = 0; i < thePages.length; ++i) {
            if (!(thePages[i] instanceof BasicWizardSubpanelContainer)) continue;
            BasicWizardSubpanelContainer bwsc = (BasicWizardSubpanelContainer)thePages[i];
            bwsc.replaceStepNum(i + 1);
        }
    }

    private void processViewEntitlementControl() {
        if (this.pnlEntitlementsSelect.isSelectedViewEntitlementsReport()) {
            this.addPage((Component)this.pnlEntitlements);
        } else {
            this.removePage((Component)this.pnlEntitlements);
        }
        this.renumberPages();
    }

    private void processCancelButton() {
        this.dlgParent.processCancelButton();
    }

    private void processFinishButton() {
        if (!this.attemptedCreatingVDB) {
            try {
                this.createVDB();
            }
            catch (Exception e) {
                LogManager.logError("VIRTUAL_DATABASE", (Throwable)e, "VDB creation failed");
                ExceptionUtility.showMessage((String)"ERROR!  Failed while creating a VDB", (Throwable)e);
            }
        }
        this.dlgParent.processFinishButton();
    }

    public AbstractButton getWizardNextButton() {
        return this.getNextButton();
    }

    public void enableNextButton(boolean b) {
        ButtonWidget btnNext = null;
        btnNext = this.getNextButton();
        if (btnNext != null) {
            btnNext.setEnabled(b);
        } else {
            btnNext = this.getFinishButton();
            if (btnNext != null) {
                btnNext.setEnabled(b);
            }
        }
    }

    public VirtualDatabase getNewVdb() {
        return this.newVirtualDatabase;
    }

    private EntitlementMigrationReport getMigrationReport() {
        return this.emrEntitlementReport;
    }

    private List getNewConnectorBindings() {
        HashMap bindings = new HashMap(this.newVDBDefn.getConnectorBindings());
        Iterator iter = this.existingBindingsOnImport.values().iterator();
        while (iter.hasNext()) {
            BindingNameAndExistingUUID bnaeu = (BindingNameAndExistingUUID)iter.next();
            String name = bnaeu.getBindingName();
            bindings.remove(name);
        }
        return new ArrayList(bindings.values());
    }

    private void createMaterializationFiles() {
        try {
            this.validateConnBindForMaterialization();
        }
        catch (Exception ex) {
            // empty catch block
        }
        boolean proceeding = true;
        Exception error = null;
        String connectionPropsFileName = null;
        String createScriptFileName = null;
        String loadScriptFileName = null;
        String swapScriptFileName = null;
        String truncateScriptFileName = null;
        String directory = null;
        try {
            String host = this.getVdbManager().getConnection().getHost();
            String port = this.getVdbManager().getConnection().getPort();
            String loginUserName = this.upPanel.getLoginUserName();
            String loginPassword = this.upPanel.getLoginPassword();
            String dataBaseUserName = this.upPanel.getDataBaseUserName();
            String dataBasePassword = this.upPanel.getDataBasePassword();
            if (this.newVirtualDatabase != null) {
                VirtualDatabaseID id = (VirtualDatabaseID)this.newVirtualDatabase.getID();
                String versStr = id.getVersion();
                this.rmcVDBVersion.setVersion(versStr);
            }
            this.scripts = this.getVdbManager().getMaterializationScripts(this.materializationConnectorBinding, this.rmcVDBVersion, host, port, dataBaseUserName, dataBasePassword, loginUserName, loginPassword);
        }
        catch (Exception ex) {
            String msg = "Error obtaining materialization information";
            LogManager.logError("VIRTUAL_DATABASE", (Throwable)ex, msg);
            error = ex;
            proceeding = false;
        }
        if (proceeding) {
            directory = this.savePanel.getDirectoryName();
            char lastChar = directory.charAt(directory.length() - 1);
            if (lastChar != '\\') {
                directory = directory + "\\";
            }
            connectionPropsFileName = directory + this.scripts.getConnectionPropsFileName();
            InputStream connectionPropsInputStream = this.scripts.getConnectionPropsFileContents();
            File target = new File(connectionPropsFileName);
            proceeding = true;
            if (target.exists()) {
                proceeding = true;
            } else {
                try {
                    target.createNewFile();
                }
                catch (IOException ex) {
                    error = ex;
                    proceeding = false;
                }
            }
            if (proceeding) {
                boolean exported = false;
                if (!target.canWrite()) {
                    StaticUtilities.displayModalDialogWithOK((String)"Cannot write to target file", (String)("Unable to write to target file " + connectionPropsFileName + "."));
                    proceeding = false;
                }
                if (proceeding) {
                    try {
                        FileUtils.write((InputStream)connectionPropsInputStream, (File)target);
                        exported = true;
                    }
                    catch (Exception ex) {
                        LogManager.logError("VIRTUAL_DATABASE", (Throwable)ex, "Error writing connection properties file.");
                        error = ex;
                        proceeding = false;
                    }
                }
                if (exported) {
                    String directoryForModule = this.savePanel.getDirectoryName();
                    UserPreferences.getInstance().setValue("metamatrix.console.materializationdirectory", (Object)directoryForModule);
                    UserPreferences.getInstance().saveChanges();
                }
            }
            if (proceeding) {
                createScriptFileName = directory + this.scripts.getCreateScriptFileName();
                InputStream createScriptInputStream = this.scripts.getCreateScriptFile();
                target = new File(createScriptFileName);
                if (target.exists()) {
                    proceeding = true;
                } else {
                    try {
                        target.createNewFile();
                    }
                    catch (IOException ex) {
                        error = ex;
                        proceeding = false;
                    }
                }
                if (proceeding) {
                    if (!target.canWrite()) {
                        StaticUtilities.displayModalDialogWithOK((String)"Cannot write to target file", (String)("Unable to write to target file " + createScriptFileName + "."));
                        proceeding = false;
                    }
                    if (proceeding) {
                        try {
                            FileUtils.write((InputStream)createScriptInputStream, (File)target);
                        }
                        catch (Exception ex) {
                            LogManager.logError("VIRTUAL_DATABASE", (Throwable)ex, "Error writing DDL Script file.");
                            error = ex;
                            proceeding = false;
                        }
                    }
                }
                if (proceeding) {
                    loadScriptFileName = directory + this.scripts.getLoadScriptFileName();
                    InputStream loadScriptInputStream = this.scripts.getLoadScriptFile();
                    target = new File(loadScriptFileName);
                    if (!target.exists()) {
                        try {
                            target.createNewFile();
                        }
                        catch (IOException ex) {
                            error = ex;
                            proceeding = false;
                        }
                    }
                    if (proceeding) {
                        if (!target.canWrite()) {
                            StaticUtilities.displayModalDialogWithOK((String)"Cannot write to target file", (String)("Unable to write to target file " + loadScriptFileName + "."));
                            proceeding = false;
                        }
                        if (proceeding) {
                            try {
                                FileUtils.write((InputStream)loadScriptInputStream, (File)target);
                            }
                            catch (Exception ex) {
                                LogManager.logError("VIRTUAL_DATABASE", (Throwable)ex, "Error writing Load Script file.");
                                error = ex;
                                proceeding = false;
                            }
                        }
                    }
                    if (proceeding) {
                        swapScriptFileName = directory + this.scripts.getSwapScriptFileName();
                        InputStream swapScriptInputStream = this.scripts.getSwapScriptFile();
                        target = new File(swapScriptFileName);
                        if (target.exists()) {
                            proceeding = true;
                        } else {
                            try {
                                target.createNewFile();
                            }
                            catch (IOException ex) {
                                StaticUtilities.displayModalDialogWithOK((String)"Cannot create target file", (String)("Unable to create target file " + swapScriptFileName + ".  Must select another file name or cancel."));
                                proceeding = false;
                            }
                        }
                        if (proceeding) {
                            if (!target.canWrite()) {
                                StaticUtilities.displayModalDialogWithOK((String)"Cannot write to target file", (String)("Unable to write to target file " + swapScriptFileName + "."));
                                proceeding = false;
                            }
                            if (proceeding) {
                                try {
                                    FileUtils.write((InputStream)swapScriptInputStream, (File)target);
                                }
                                catch (Exception ex) {
                                    LogManager.logError("VIRTUAL_DATABASE", (Throwable)ex, "Error writing Load Script file.");
                                    error = ex;
                                    proceeding = false;
                                }
                            }
                        }
                        if (proceeding) {
                            truncateScriptFileName = directory + this.scripts.getTruncateScriptFileName();
                            InputStream truncateScriptInputStream = this.scripts.getTruncateScriptFile();
                            target = new File(truncateScriptFileName);
                            if (target.exists()) {
                                proceeding = true;
                            } else {
                                try {
                                    target.createNewFile();
                                }
                                catch (IOException ex) {
                                    StaticUtilities.displayModalDialogWithOK((String)"Cannot create target file", (String)("Unable to create target file " + truncateScriptFileName + ".  Must select another file name or cancel."));
                                    proceeding = false;
                                }
                            }
                            if (proceeding) {
                                if (!target.canWrite()) {
                                    StaticUtilities.displayModalDialogWithOK((String)"Cannot write to target file", (String)("Unable to write to target file " + truncateScriptFileName + "."));
                                    proceeding = false;
                                }
                                if (proceeding) {
                                    try {
                                        FileUtils.write((InputStream)truncateScriptInputStream, (File)target);
                                    }
                                    catch (Exception ex) {
                                        LogManager.logError("VIRTUAL_DATABASE", (Throwable)ex, "Error writing Truncate Script file.");
                                        error = ex;
                                        proceeding = false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Exception materializationFileCreationResult = null;
        if (error != null) {
            materializationFileCreationResult = error;
        } else {
            SingleMaterializationFileDisplayInfo[] files = new SingleMaterializationFileDisplayInfo[]{new SingleMaterializationFileDisplayInfo(CONNECTION_PROPERTIES_FILE_DESC, this.scripts.getConnectionPropsFileName()), new SingleMaterializationFileDisplayInfo(CREATE_SCRIPT_FILE_DESC, this.scripts.getCreateScriptFileName()), new SingleMaterializationFileDisplayInfo(LOAD_SCRIPT_FILE_DESC, this.scripts.getLoadScriptFileName()), new SingleMaterializationFileDisplayInfo(SWAP_SCRIPT_FILE_DESC, this.scripts.getSwapScriptFileName()), new SingleMaterializationFileDisplayInfo(TRUNCATE_SCRIPT_FILE_DESC, this.scripts.getTruncateScriptFileName())};
            AllMaterializationFilesDisplayInfo allFiles = new AllMaterializationFilesDisplayInfo(directory, files);
            materializationFileCreationResult = allFiles;
        }
        this.matFilesPanel.setResults((Object)materializationFileCreationResult);
    }

    private void createVDB() throws Exception {
        this.attemptedCreatingVDB = true;
        if (this.sVdbName == null || this.sVdbName.equals("")) {
            ExceptionUtility.showMessage((String)"ERROR!  could not create vdb because name is missing", (Throwable)new Exception("VDB Name Must Be Specified"));
        } else {
            VDBDefnFactory factory = new VDBDefnFactory();
            Map visMap = CreateVDBPanel.modelVisibilityMap(this.visInfo);
            Map multiSourceMap = CreateVDBPanel.modelMultiSourceMap(this.visInfo);
            try {
                this.newVDBDefn = factory.create((BasicVDBDefn)this.rmcVDBVersion, this.sVdbName, visMap, this.reviseMapForExistingUUIDSubstitution(this.mapConnBind, this.existingBindingsOnImport), multiSourceMap, this.pnlConfirm.getStatus(), this.getConnectorManager().getAllConnectorBindings());
                this.newVirtualDatabase = this.getVdbManager().importVDB(this.newVDBDefn);
                boolean decryptable = true;
                List bindings = this.getNewConnectorBindings();
                decryptable = this.getConfigurationManager().checkDecryptable(bindings);
                try {
                    if (decryptable && this.pnlConfirm.isSyncActive()) {
                        this.getRuntimeMgmtManager().synchronizeServer();
                    }
                }
                catch (Exception e) {
                    LogManager.logError("VIRTUAL_DATABASE", (Throwable)e, "Synchronize failed");
                    ExceptionUtility.showMessage((String)"ERROR!  Synchronize Failed", (Throwable)e);
                }
                if (this.creatingNewVDBVersion) {
                    try {
                        if (this.pnlEntitlementsSelect.isSelectedMigrateEntitlements()) {
                            this.emrEntitlementReport = this.getVdbManager().migrateEntitlements(this.sourceVirtualDatabase, this.newVirtualDatabase);
                            WorkspaceController.getInstance().handleUpdateNotification(this.getVdbManager().getConnection(), (RuntimeUpdateNotification)new AddedDataEntitlementNotification());
                        }
                    }
                    catch (Exception e) {
                        LogManager.logError("VIRTUAL_DATABASE", (Throwable)e, "Migrating entitlements failed");
                        ExceptionUtility.showMessage((String)"ERROR!  Migrate Entitlements Failed", (Throwable)e);
                    }
                    this.newVirtualDatabase = this.getVdbManager().getVirtualDatabase((VirtualDatabaseID)this.newVirtualDatabase.getID());
                }
                this.getConfigurationManager().refresh();
            }
            catch (Exception e) {
                ExceptionUtility.showMessage((String)"ERROR!  VDB Not created", (String)e.getMessage(), (Throwable)e);
            }
            if (this.materializationTableModel != null) {
                this.createMaterializationFiles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showNextPage() {
        try {
            StaticUtilities.startWait((Component)this.dlgParent.getContentPane());
            JPanel pnlCurrPage = (JPanel)this.getCurrentPage();
            boolean proceeding = true;
            if (pnlCurrPage.equals((Object)this.selectorPanel)) {
                proceeding = this.navigateFromSelectorPanel();
            } else if (pnlCurrPage.equals(this.pnlDTC)) {
                proceeding = this.navigateFromDTCPanel();
            } else if (pnlCurrPage.equals(this.pnlID)) {
                proceeding = this.navigateFromIDPanel();
            } else if (pnlCurrPage.equals(this.visPanel)) {
                proceeding = this.navigateFromVisibilityPanel();
            } else if (pnlCurrPage.equals(this.pnlEditConnBind)) {
                proceeding = this.navigateFromEditConnectorBindingsPanel();
            } else if (pnlCurrPage.equals(this.upPanel)) {
                proceeding = this.navigateFromUserPasswordPanel();
            } else if (pnlCurrPage.equals(this.savePanel)) {
                proceeding = this.navigateFromSavePanel();
            } else if (pnlCurrPage.equals(this.pnlEntitlementsSelect)) {
                proceeding = this.navigateFromEntitlementsSelectPanel();
            } else if (pnlCurrPage.equals(this.pnlConfirm)) {
                proceeding = this.navigateFromConfirmPanel();
            }
            if (!proceeding) {
                return;
            }
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"ERROR!  failed navigating the wizard", (Throwable)e);
        }
        finally {
            StaticUtilities.endWait((Component)this.dlgParent.getContentPane());
        }
        super.showNextPage();
    }

    private boolean navigateFromSelectorPanel() throws Exception {
        boolean result = this.checkSelectorPanelResults();
        if (!result) {
            return false;
        }
        this.pnlID.setVdbName(this.rmcVDBVersion.getName());
        this.pnlID.setDescription(this.rmcVDBVersion.getDescription());
        this.pnlID.putDataIntoPanel();
        boolean proceeding = true;
        proceeding = this.findExistingBindings(true);
        if (!proceeding) {
            this.processCancelButton();
        }
        return true;
    }

    private boolean navigateFromDTCPanel() {
        this.rmcVDBVersion = this.pnlDTC.getDTCInfo();
        TreePath selectedTreePath = this.pnlDTC.getSelectedTreePath();
        String pathString = selectedTreePath == null ? "" : selectedTreePath.toString();
        this.vdbSelectionChanged = !this.oldVDBPath.equals(pathString);
        this.oldVDBPath = pathString;
        if (this.rmcVDBVersion != null) {
            this.pnlID.setVdbName(this.rmcVDBVersion.getName());
            this.pnlID.setDescription(this.rmcVDBVersion.getDescription());
            this.pnlID.putDataIntoPanel();
        }
        this.findExistingBindings(false);
        return true;
    }

    private boolean findExistingBindings(boolean promptWhenDuplicates) {
        this.existingBindingsOnImport = null;
        try {
            this.existingBindingsOnImport = this.getExistingBindingUUIDsForVDB(this.rmcVDBVersion);
        }
        catch (Exception ex) {
            String msg = "Error retrieving existing connector bindings.";
            LogManager.logError("VIRTUAL_DATABASE", (Throwable)ex, msg);
            ExceptionUtility.showMessage((String)msg, (Throwable)ex);
        }
        if (this.existingBindingsOnImport != null && this.existingBindingsOnImport.size() > 0) {
            String[] bindingNames = new String[this.existingBindingsOnImport.size()];
            Iterator ib = this.existingBindingsOnImport.entrySet().iterator();
            int i = 0;
            while (ib.hasNext()) {
                Map.Entry me = ib.next();
                BindingNameAndExistingUUID item = (BindingNameAndExistingUUID)me.getValue();
                bindingNames[i] = item.getBindingName();
                ++i;
            }
            if (promptWhenDuplicates) {
                BindingsAlreadyExistDlg dlg = new BindingsAlreadyExistDlg((Frame)ConsoleMainFrame.getInstance(), bindingNames);
                dlg.show();
                return dlg.proceeding();
            }
        }
        return true;
    }

    private boolean navigateFromIDPanel() {
        this.pnlID.getDataFromPanel();
        this.sVdbName = this.pnlID.getVdbName();
        this.sDescription = this.pnlID.getDescription();
        this.rmcVDBVersion.setDescription(this.sDescription);
        if (this.importing) {
            this.sourceVirtualDatabase = this.getLatestVDB(this.sVdbName);
            boolean bl = this.creatingNewVDBVersion = this.sourceVirtualDatabase != null;
            if (this.creatingNewVDBVersion) {
                this.initImportNewVersion();
            } else {
                this.initImportNewVDB();
            }
        } else {
            this.initImportCommon();
        }
        return true;
    }

    private boolean navigateFromVisibilityPanel() {
        this.visInfo = this.visPanel.getUpdatedVisibilityInfo();
        this.pnlEditConnBind.updateMultiSource(CreateVDBPanel.modelMultiSourceMap(this.visInfo));
        this.pnlEditConnBind.updateSelectionForModelsTable();
        return true;
    }

    private boolean navigateFromEditConnectorBindingsPanel() {
        String modelName;
        boolean proceeding = true;
        this.materializationTableModel = this.getVdbManager().getMaterializationTableModel(this.rmcVDBVersion);
        if (this.materializationTableModel != null && !this.pnlEditConnBind.hasBindingAssigned(modelName = this.materializationTableModel.getName())) {
            proceeding = false;
            String hdr = "Materialization model connector binding needed";
            String msg = "Must assign connector binding to materialization model " + modelName + " before proceeding.";
            StaticUtilities.displayModalDialogWithOK((String)hdr, (String)msg, (int)2);
        }
        if (proceeding) {
            this.mapConnBind = this.pnlEditConnBind.getModelsToConnBindsMap();
            this.siStatus = this.determinePotentialVdbsStatus(this.mapConnBind);
            this.pnlConfirm.setVdbName(this.sVdbName);
            this.pnlConfirm.setStatus(this.siStatus);
            if (this.pnlEntitlementsSelect != null) {
                this.pnlEntitlementsSelect.setVdbName(this.sVdbName);
                this.pnlEntitlementsSelect.putDataIntoPanel();
                this.pnlConfirm.setMigrateEntitlementsRequested(this.pnlEntitlementsSelect.isSelectedMigrateEntitlements());
            } else {
                this.pnlConfirm.setMigrateEntitlementsRequested(false);
            }
            this.pnlConfirm.putDataIntoPanel();
            if (this.materializationTableModel != null) {
                try {
                    this.validateConnBindForMaterialization();
                }
                catch (Exception ex) {
                    LogManager.logError("VIRTUAL_DATABASE", (Throwable)ex, "Error validating materialization connector binding.");
                    ExceptionUtility.showMessage((String)"Error validating materialization connector binding", (Throwable)ex);
                    return false;
                }
                if (this.upPanel == null) {
                    this.upPanel = new VdbWizardUserAndPasswordPanel((WizardInterface)this, 1);
                }
                if (this.savePanel == null) {
                    String initialDirectory = (String)UserPreferences.getInstance().getValue("metamatrix.console.materializationdirectory");
                    this.savePanel = new VdbWizardSaveMaterializationFilesPanel((WizardInterface)this, 1, initialDirectory);
                }
                if (this.matFilesPanel == null) {
                    this.matFilesPanel = new VdbWizardWrittenMaterializationFilesPanel((WizardInterface)this, 1, true);
                }
                this.removePage((Component)this.upPanel);
                this.removePage((Component)this.savePanel);
                if (this.pnlEntitlementsSelect != null) {
                    this.removePage((Component)this.pnlEntitlementsSelect);
                }
                this.removePage((Component)this.pnlConfirm);
                this.removePage((Component)this.matFilesPanel);
                this.addPage((Component)this.upPanel);
                this.addPage((Component)this.savePanel);
                if (this.pnlEntitlementsSelect != null) {
                    this.addPage((Component)this.pnlEntitlementsSelect);
                }
                this.addPage((Component)this.pnlConfirm);
                this.addPage((Component)this.matFilesPanel);
                this.renumberPages();
                this.getForwardButton().setEnabled(false);
            } else {
                if (this.upPanel != null) {
                    this.removePage((Component)this.upPanel);
                }
                if (this.savePanel != null) {
                    this.removePage((Component)this.savePanel);
                }
                if (this.matFilesPanel != null) {
                    this.removePage((Component)this.matFilesPanel);
                }
                this.renumberPages();
            }
        }
        return proceeding;
    }

    private boolean navigateFromUserPasswordPanel() {
        return true;
    }

    private boolean navigateFromSavePanel() {
        this.getForwardButton().setEnabled(false);
        return true;
    }

    private boolean navigateFromEntitlementsSelectPanel() {
        this.pnlConfirm.setVdbName(this.sVdbName);
        this.pnlConfirm.setStatus(this.siStatus);
        this.pnlConfirm.setMigrateEntitlementsRequested(this.pnlEntitlementsSelect.isSelectedMigrateEntitlements());
        this.pnlConfirm.putDataIntoPanel();
        return true;
    }

    private boolean navigateFromConfirmPanel() {
        try {
            this.createVDB();
        }
        catch (Exception e) {
            LogManager.logError("VIRTUAL_DATABASE", (Throwable)e, "VDB creation failed");
            ExceptionUtility.showMessage((String)"ERROR!  Failed while creating a VDB", (Throwable)e);
        }
        if (this.pnlEntitlements != null) {
            this.pnlEntitlements.setNewVdb(this.getNewVdb());
            this.pnlEntitlements.setEntitlementMigrationReport(this.getMigrationReport());
        }
        this.getBackButton().setVisible(false);
        this.getCancelButton().setVisible(false);
        return true;
    }

    public void showPreviousPage() {
        super.showPreviousPage();
        this.enableNextButton(true);
    }

    private Map getExistingBindingUUIDsForVDB(RMCVersionEntry rve) throws Exception {
        HashMap<String, BindingNameAndExistingUUID> existingBindingsInVDB = new HashMap<String, BindingNameAndExistingUUID>();
        Iterator it = rve.getConnectorBindings().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String bindingName = (String)me.getKey();
            ConnectorBinding cb = this.getConnectorManager().getConnectorBindingByName(bindingName);
            if (cb == null) continue;
            String uuid = cb.getRoutingUUID();
            ConnectorBinding cbFromImport = (ConnectorBinding)me.getValue();
            String uuidOnImport = cbFromImport.getRoutingUUID();
            BindingNameAndExistingUUID item = new BindingNameAndExistingUUID(bindingName, uuid);
            existingBindingsInVDB.put(uuidOnImport, item);
        }
        return existingBindingsInVDB;
    }

    private Map reviseMapForExistingUUIDSubstitution(Map fromImport, Map existing) {
        HashMap outputMap;
        if (existing == null || existing.size() == 0) {
            outputMap = fromImport;
        } else {
            outputMap = new HashMap();
            Iterator it = fromImport.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String modelName = (String)me.getKey();
                List bindingUUIDsOnImport = (List)me.getValue();
                ArrayList<String> newList = new ArrayList<String>(bindingUUIDsOnImport.size());
                Iterator it2 = bindingUUIDsOnImport.iterator();
                while (it2.hasNext()) {
                    String uuidFromImport = (String)it2.next();
                    String uuidToUse = null;
                    BindingNameAndExistingUUID replacement = (BindingNameAndExistingUUID)existing.get(uuidFromImport);
                    uuidToUse = replacement == null ? uuidFromImport : replacement.getExistingUUID();
                    newList.add(uuidToUse);
                }
                outputMap.put(modelName, newList);
            }
        }
        return outputMap;
    }

    public boolean checkSelectorPanelResults() {
        boolean goingToNextPage = true;
        String fileName = this.selectorPanel.getSelectedFileFullName();
        this.vdbSelectionChanged = !fileName.equals(this.oldVDBPath);
        this.oldVDBPath = fileName;
        File file = new File(fileName);
        if (!file.exists()) {
            StaticUtilities.displayModalDialogWithOK((String)"Unable to open file", (String)("Unable to open file " + fileName + ".  Must select " + "a different file or cancel."));
            goingToNextPage = false;
        } else if (!file.canRead()) {
            StaticUtilities.displayModalDialogWithOK((String)"Unable to read file", (String)("Unable to open file " + fileName + ".  Must select " + "a different file or cancel."));
            goingToNextPage = false;
        } else {
            try {
                String vdbDirectoryName = this.selectorPanel.getDirectoryName();
                String vdbFileName = this.selectorPanel.getSelectedFileName();
                UserPreferences.getInstance().setValue("metamatrix.console.directory", (Object)vdbDirectoryName);
                UserPreferences.getInstance().saveChanges();
                String vdbF = vdbFileName.toLowerCase();
                if (vdbF.endsWith(VDB_IMPORT_EXTENSIONS[1])) {
                    goingToNextPage = this.importVDB(file, vdbFileName);
                } else if (vdbF.endsWith(VDB_IMPORT_EXTENSIONS[0])) {
                    goingToNextPage = this.importDefinition(vdbFileName, vdbDirectoryName);
                } else {
                    StaticUtilities.displayModalDialogWithOK((String)"Selection Error", (String)"File selected must be of VDB Import Types (*.def, *.vdb)");
                    goingToNextPage = false;
                }
            }
            catch (VirtualDatabaseException vex) {
                StaticUtilities.displayModalDialogWithOK((String)"VDB Exceptions", (String)vex.getMessage());
                if (vex instanceof RMCException) {
                    String title = "Unable to import VDB";
                    String msg = null;
                    msg = vex.getCode().equals("1") ? "No models exist in the vdb definition file.  The vdb requires rebuilding." : (vex.getCode().equals("3") ? "Unable to deploy a vdb that contains errors." : (vex.getCode().equals("2") ? "Unable to deploy a vdb that contains error(s) in a model." : vex.getMessage()));
                    StaticUtilities.displayModalDialogWithOK((String)title, (String)msg);
                    goingToNextPage = false;
                } else {
                    String msg1 = "Unable to import VDB.";
                    String msg2 = "File " + fileName + " may not contain a VDB in the correct format, " + "or VDB definition file may be missing.  See details.";
                    ExceptionUtility.showMessage((String)msg1, (String)msg2, (Throwable)vex);
                    goingToNextPage = false;
                }
            }
            catch (Exception ex) {
                String msg1 = "Unable to complete VDB Creation.";
                String msg2 = "File " + fileName + " may not contain a VDB in the correct format, " + "or VDB definition file may be missing.  See details.";
                ExceptionUtility.showMessage((String)msg1, (String)msg2, (Throwable)ex);
                goingToNextPage = false;
            }
        }
        return goingToNextPage;
    }

    private boolean validateConnBindForMaterialization() throws Exception {
        String modelName = this.materializationTableModel.getName();
        Map map = this.pnlEditConnBind.getModelsToConnBindsMap();
        this.materializationConnectorBinding = null;
        List uuids = (List)map.get(modelName);
        if (uuids != null && uuids.size() > 0) {
            String uuid = (String)uuids.get(0);
            String connBindingName = (String)this.getConnectorManager().getUUIDConnectorBindingsMap(false).get(uuid);
            this.materializationConnectorBinding = this.getConnectorManager().getConnectorBindingByName(connBindingName);
        }
        return this.getRuntimeMetadataAdminAPI().validateConnectorBindingForMaterialization(this.materializationConnectorBinding);
    }

    private VirtualDatabase getLatestVDB(String vdbName) {
        try {
            VirtualDatabase vdb = this.getVdbManager().getLatestVDBVersion(vdbName);
            return vdb;
        }
        catch (VirtualDatabaseDoesNotExistException dne) {
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = "An error occurred retrieving VDB version information";
            LogManager.logError("Information Retrieval Error", (Throwable)ex, msg);
            ExceptionUtility.showMessage((String)msg, (Throwable)ex);
            return null;
        }
    }

    protected boolean importVDB(File file, String vdbArchiveFileName) throws Exception {
        VDBDefn vdbDefn = null;
        byte[] archiveFile = new FileUtil(file.getAbsolutePath()).readBytesSafe();
        vdbDefn = VDBReader.loadVDBDefn(vdbArchiveFileName, archiveFile, null);
        this.rmcVDBVersion = new RMCVersionEntry(vdbDefn);
        if (vdbDefn.doesVDBHaveValidityError()) {
            StaticUtilities.displayModalDialogWithOK((String)"VDB.DEF Processing Error", (String)("VDB " + vdbDefn.getName() + " is at a nondeployable severity state of " + MetadataConstants.getVDBStatusName((short)vdbDefn.getStatus())));
            return false;
        }
        return true;
    }

    protected boolean importDefinition(String fileName, String directory) throws Exception {
        if (fileName == null || directory == null) {
            StaticUtilities.displayModalDialogWithOK((String)"VDB.DEF Processing Error", (String)"VDB File name or the directory was not able to be obtained from selected file.");
            return false;
        }
        VDBDefn vdbDefn = VDBReader.loadVDBDefn(fileName, directory);
        this.rmcVDBVersion = new RMCVersionEntry(vdbDefn);
        if (vdbDefn.doesVDBHaveValidityError()) {
            StaticUtilities.displayModalDialogWithOK((String)"VDB.DEF Processing Error", (String)("VDB " + vdbDefn.getName() + " is at a nondeployable severity state of " + MetadataConstants.getVDBStatusName((short)vdbDefn.getStatus())));
            return false;
        }
        return true;
    }

    private ModelVisibilityInfo[] convertModelTableRowsToModelVisibilityInfo(VDBInfo info) {
        ModelVisibilityInfo[] visInfo = null;
        Collection mdls = info.getModels();
        int numRows = mdls.size();
        visInfo = new ModelVisibilityInfo[numRows];
        int i = 0;
        Iterator it = mdls.iterator();
        while (it.hasNext()) {
            ModelInfo me = (ModelInfo)it.next();
            int v = Integer.parseInt(me.getVersion());
            int numBindings = me.getConnectorBindingNames().size();
            boolean multipleSourceEditable = me.supportsMultiSourceBindings() && numBindings <= 1;
            visInfo[i] = new ModelVisibilityInfo(me.getName(), v, me.getModelTypeName(), me.isVisible(), me.supportsMultiSourceBindings(), multipleSourceEditable, me.isMultiSourceBindingEnabled());
            ++i;
        }
        return visInfo;
    }

    private short determinePotentialVdbsStatus(Map mapConnBind) {
        short siStatus = 0;
        boolean bHasMissingValues = false;
        boolean bHasNoBindings = false;
        boolean requiresBindings = false;
        Iterator mit = this.rmcVDBVersion.getModels().iterator();
        while (mit.hasNext()) {
            ModelInfo mi = (ModelInfo)mit.next();
            if (!mi.requiresConnectorBinding()) continue;
            requiresBindings = true;
            break;
        }
        if (!requiresBindings) {
            return 2;
        }
        int connBind = 0;
        Iterator it = mapConnBind.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            if (list == null || list.size() == 0) {
                bHasMissingValues = true;
                continue;
            }
            connBind += list.size();
        }
        if (connBind == 0) {
            bHasNoBindings = true;
        }
        siStatus = bHasNoBindings || bHasMissingValues ? (short)1 : 2;
        return siStatus;
    }

    static /* synthetic */ void access$000(CreateVDBPanel x0) {
        x0.processViewEntitlementControl();
    }

    static /* synthetic */ void access$100(CreateVDBPanel x0) {
        x0.processCancelButton();
    }

    static /* synthetic */ void access$200(CreateVDBPanel x0) {
        x0.processFinishButton();
    }
}

