/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.QueryFrame;
import com.metamatrix.query.processor.relational.AccessNode;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.RelationalPlan;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleAttachSubqueryPlans
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List accessNodes = NodeEditor.findAllNodes(plan, 3);
        Iterator i = accessNodes.iterator();
        while (i.hasNext()) {
            PlanNode accessNode = (PlanNode)i.next();
            List selectNodes = NodeEditor.findAllNodes(accessNode, 13);
            Iterator selectIter = selectNodes.iterator();
            while (selectIter.hasNext()) {
                PlanNode selectNode = (PlanNode)selectIter.next();
                this.replaceWithPlannedQuery(selectNode);
                this.recontextCorrelatedReferenceGroups(selectNode, metadata);
            }
        }
        return plan;
    }

    void replaceWithPlannedQuery(PlanNode critNode) {
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Iterator valueIteratorProviders = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)crit).iterator();
        if (valueIteratorProviders.hasNext()) {
            SubqueryContainer container = (SubqueryContainer)valueIteratorProviders.next();
            RelationalPlan subqueryPlan = (RelationalPlan)((Collection)critNode.getProperty(NodeConstants.Info.SUBQUERY_PLANS)).iterator().next();
            RelationalNode root = subqueryPlan.getRootNode();
            AccessNode child = (AccessNode)root.getChildren()[0];
            container.setCommand(child.getCommand());
        }
    }

    void recontextCorrelatedReferenceGroups(PlanNode critNode, QueryMetadataInterface metadata) throws QueryMetadataException, QueryPlannerException, MetaMatrixComponentException {
        List overlapGroups;
        List refs = (List)critNode.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
        if (refs == null || refs.size() == 0) {
            return;
        }
        ArrayList refGroups = new ArrayList(refs.size());
        Iterator refIter = refs.iterator();
        while (refIter.hasNext()) {
            Reference ref = (Reference)refIter.next();
            Expression expr = ref.getExpression();
            GroupsUsedByElementsVisitor.getGroups((LanguageObject)expr, refGroups);
        }
        QueryFrame frame = FrameUtil.findQueryFrame(critNode);
        Collection subqueryGroups = null;
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Iterator valueIteratorProviders = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)crit).iterator();
        if (valueIteratorProviders.hasNext()) {
            SubqueryContainer container = (SubqueryContainer)valueIteratorProviders.next();
            subqueryGroups = GroupCollectorVisitor.getGroups((LanguageObject)container.getCommand(), (boolean)true);
        }
        if ((overlapGroups = FrameUtil.getOverlappingGroups(null, new HashSet(refGroups), new HashSet(subqueryGroups))) != null && overlapGroups.size() > 0) {
            HashSet allGroups = new HashSet();
            allGroups.addAll(refGroups);
            allGroups.addAll(subqueryGroups);
            allGroups.addAll(frame.getSourceGroups());
            Set allNames = FrameUtil.getNamesFromSymbols(allGroups);
            Iterator overlapIter = overlapGroups.iterator();
            while (overlapIter.hasNext()) {
                GroupSymbol overlapGroup = (GroupSymbol)overlapIter.next();
                GroupSymbol newSymbol = FrameUtil.recontextSymbol(overlapGroup, allNames);
                Map symbolMap = FrameUtil.buildSymbolMap(overlapGroup, newSymbol, metadata);
                PlanNode startNode = null;
                List bottomNodes = frame.getBottomNodes();
                Iterator iter = bottomNodes.iterator();
                while (iter.hasNext()) {
                    PlanNode sourceNode = (PlanNode)iter.next();
                    if (!overlapGroup.equals(sourceNode.getGroups().iterator().next())) continue;
                    startNode = sourceNode;
                }
                FrameUtil.convertFrame(frame, startNode, overlapGroup, newSymbol, symbolMap, metadata);
                refIter = refs.iterator();
                while (refIter.hasNext()) {
                    Reference ref = (Reference)refIter.next();
                    Expression expr = ref.getExpression();
                    ref.setExpression(FrameUtil.convertExpression(expr, symbolMap));
                }
            }
        }
    }

    public String toString() {
        return "AttachSubqueryPlans";
    }
}

