/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.installer.transformation.etl.tasks.vdb;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.installer.transformation.etl.apiimpl.TransformBaseTask;
import com.metamatrix.installer.transformation.etl.jdbc.api.Connector;
import java.io.File;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Copy;

public class CreateVDBDefnTask
extends TransformBaseTask {
    public static final String PROP_VDBDEFN_OUTPUT_FILENAME = "metamatrix.vdbdefn.name";
    private String toFileName = null;
    private static final String ORACLE8i = "oracle8i";
    private static final String ORACLE9i = "oracle9i";
    private static final String DB2 = "db2";
    private static final String MSSQLSERVER = "msSQLServer";
    private static final String MMSECURE = "mmSecure";
    private static final String DERBY = "derby";
    private static final String SYBASE = "sybase";
    private String vdbDefnName = "";
    Map dbVDBDefns = null;

    public void process() throws MetaMatrixException {
        try {
            this.toFileName = this.getProperties().getProperty(PROP_VDBDEFN_OUTPUT_FILENAME);
            Map obj = (Map)this.getActionPropertyMapping();
            if (obj == null || obj.size() <= 0) {
                throw new MetaMatrixException("Error determining Database Type no database mapping properties");
            }
            this.dbVDBDefns = (Map)obj.values().iterator().next();
            this.determineDefnName();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaMatrixException((Throwable)e, "Error determining Database Type");
        }
        try {
            this.copyVDBDefn();
        }
        catch (Exception e) {
            throw new MetaMatrixException("Error copying .DEF file " + this.vdbDefnName + ": " + e.getMessage());
        }
    }

    protected void determineDefnName() throws Exception {
        Connector c = this.getTargetConnector();
        if (c.isSecure()) {
            this.vdbDefnName = (String)this.dbVDBDefns.get(MMSECURE);
        } else if (c.isDB2()) {
            this.vdbDefnName = (String)this.dbVDBDefns.get(DB2);
        } else if (c.isDerby()) {
            this.vdbDefnName = (String)this.dbVDBDefns.get(DERBY);
        } else if (c.isOracle8i()) {
            this.vdbDefnName = (String)this.dbVDBDefns.get(ORACLE8i);
        } else if (c.isOracle()) {
            this.vdbDefnName = (String)this.dbVDBDefns.get(ORACLE9i);
        } else if (c.isMSSQL()) {
            this.vdbDefnName = (String)this.dbVDBDefns.get(MSSQLSERVER);
        } else if (c.getPlatform().isSybase()) {
            this.vdbDefnName = (String)this.dbVDBDefns.get(SYBASE);
        } else {
            throw new MetaMatrixException("Unknown database type " + c.getConnection().getMetaData().getDriverName());
        }
        if (this.vdbDefnName == null || this.vdbDefnName.length() == 0) {
            throw new MetaMatrixException("No database type mapping defined for " + c.getConnection().getMetaData().getDriverName());
        }
    }

    protected void copyVDBDefn() throws Exception {
        this.performCopy(this.toFileName, this.vdbDefnName);
    }

    protected void performCopy(String toFileName, String fromFileName) throws MetaMatrixException {
        File fromFile = new File(fromFileName);
        if (!fromFile.exists()) {
            this.logError(fromFileName + " does not exist to copy");
            throw new MetaMatrixException(fromFileName + " does not exist to copy");
        }
        final class CopyThis
        extends Copy {
            public CopyThis() {
                Project proj = new Project();
                this.setProject(proj);
                proj.init();
                this.setTaskType("copy");
                this.setTaskName("copy");
                this.setOwningTarget(new Target());
            }
        }
        CopyThis copy = new CopyThis();
        copy.setTofile(new File(toFileName));
        copy.setFile(fromFile);
        copy.execute();
        this.logInfo("Copy from " + fromFileName + " to " + toFileName);
    }
}

