/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.JoinUtil;
import com.metamatrix.query.optimizer.relational.rules.QueryFrame;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleMergeVirtual
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        LinkedList frames = new LinkedList();
        FrameUtil.findQueryFrames(plan, null, frames);
        while (frames.size() > 1) {
            QueryFrame frame = (QueryFrame)frames.removeFirst();
            if (!this.canMerge(frame, metadata, capFinder)) continue;
            this.doMerge(frame, metadata, capFinder);
        }
        return plan;
    }

    boolean canMerge(QueryFrame frame, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Command command;
        PlanNode procSourceNode;
        PlanNode accessNode;
        PlanNode projectNode;
        List sourceNodes;
        QueryFrame parentFrame = frame.getParentFrame();
        if (parentFrame == null) {
            return false;
        }
        PlanNode aNode = frame.getTopNode();
        if (aNode.getType() == 19) {
            aNode = aNode.getFirstChild();
        }
        if ((sourceNodes = NodeEditor.findAllNodes(aNode, 19)).size() == 0) {
            return false;
        }
        LinkedList nodes = new LinkedList();
        nodes.addAll(frame.getTopNode().getChildren());
        while (!nodes.isEmpty()) {
            PlanNode node = (PlanNode)nodes.removeFirst();
            int type = node.getType();
            if (type == 23) {
                return false;
            }
            if (type == 13) {
                Boolean isHaving = (Boolean)node.getProperty(NodeConstants.Info.IS_HAVING);
                if (isHaving != null && isHaving.equals(Boolean.TRUE)) {
                    return false;
                }
                if (parentFrame.hasJoin()) {
                    PlanNode critRoot;
                    for (critRoot = node; critRoot != null && critRoot.getParent() != parentFrame.getJoinNode(); critRoot = critRoot.getParent()) {
                    }
                    JoinType jt = JoinUtil.getJoinTypePreventingCriteriaOptimization(parentFrame.getJoinNode(), critRoot);
                    if (jt != null && (jt == JoinType.JOIN_FULL_OUTER || node.getGroups().size() == 0)) {
                        return false;
                    }
                }
            } else if (type == 11) {
                List selectSymbols = (List)node.getProperty(NodeConstants.Info.PROJECT_COLS);
                Iterator selectIter = selectSymbols.iterator();
                while (selectIter.hasNext()) {
                    SingleElementSymbol symbol = (SingleElementSymbol)selectIter.next();
                    if (symbol instanceof AggregateSymbol) {
                        return false;
                    }
                    Collection scalarSubqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)symbol);
                    if (scalarSubqueries.isEmpty()) continue;
                    for (PlanNode selectNode = frame.getTopNode().getParent(); selectNode != null && selectNode.getType() != 19; selectNode = selectNode.getParent()) {
                        if (selectNode.getType() != 13) continue;
                        Criteria crit = (Criteria)selectNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                        boolean REMOVE_DUPLICATES = true;
                        Iterator critElements = ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true).iterator();
                        while (critElements.hasNext()) {
                            ElementSymbol element = (ElementSymbol)critElements.next();
                            if (!element.getShortName().equalsIgnoreCase(symbol.getName())) continue;
                            return false;
                        }
                    }
                    for (PlanNode projectNode2 = frame.getTopNode().getParent(); projectNode2 != null && projectNode2.getType() != 19; projectNode2 = projectNode2.getParent()) {
                        if (projectNode2.getType() != 11) continue;
                        List projColumns = (List)projectNode2.getProperty(NodeConstants.Info.PROJECT_COLS);
                        Iterator projColumnsIter = projColumns.iterator();
                        while (projColumnsIter.hasNext()) {
                            SingleElementSymbol singleElement = (SingleElementSymbol)projColumnsIter.next();
                            boolean REMOVE_DUPLICATES = true;
                            Iterator critElements = ElementCollectorVisitor.getElements((LanguageObject)singleElement, (boolean)true).iterator();
                            while (critElements.hasNext()) {
                                ElementSymbol element = (ElementSymbol)critElements.next();
                                if (!element.getShortName().equalsIgnoreCase(symbol.getName())) continue;
                                return false;
                            }
                        }
                    }
                }
            }
            if (type == 19) continue;
            nodes.addAll(node.getChildren());
        }
        if (frame.getTopNode().getLastChild().getType() != 11) {
            return false;
        }
        if (frame.hasJoin() && parentFrame.hasJoin()) {
            PlanNode currentNode = frame.getJoinNode().getParent();
            while (currentNode.getType() == 13) {
                currentNode = currentNode.getParent();
            }
            if (currentNode.getType() != 11) {
                return false;
            }
            if ((currentNode = currentNode.getParent()).getType() != 19) {
                return false;
            }
            currentNode = currentNode.getParent();
            while (currentNode.getType() == 13) {
                currentNode = currentNode.getParent();
            }
            if (currentNode != parentFrame.getJoinNode()) {
                return false;
            }
        }
        if ((projectNode = frame.getTopNode().getFirstChild()).getType() == 11 && projectNode.getChildCount() > 0 && (accessNode = projectNode.getFirstChild()).getType() == 3 && accessNode.getChildCount() > 0 && (procSourceNode = accessNode.getFirstChild()).getType() == 19 && (command = (Command)procSourceNode.getProperty(NodeConstants.Info.VIRTUAL_COMMAND)) instanceof StoredProcedure) {
            return false;
        }
        PlanNode parentProject = parentFrame.getTopNode();
        return parentProject.getType() != 11 || parentProject.getProperty(NodeConstants.Info.INTO_GROUP) == null;
    }

    Set getFrameGroups(QueryFrame frame) {
        HashSet groups = new HashSet();
        List bottomNodes = frame.getBottomNodes();
        Iterator bottomIter = bottomNodes.iterator();
        while (bottomIter.hasNext()) {
            PlanNode node = (PlanNode)bottomIter.next();
            groups.addAll(node.getGroups());
        }
        return groups;
    }

    void doMerge(QueryFrame frame, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode topNode = frame.getTopNode();
        GroupSymbol oldGroup = (GroupSymbol)topNode.getGroups().iterator().next();
        QueryFrame parentFrame = frame.getParentFrame();
        Map symbolMap = (Map)topNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        this.handleOverlappingGroups(frame, metadata);
        FrameUtil.convertFrame(parentFrame, topNode, oldGroup, null, symbolMap, metadata);
        PlanNode projectNode = topNode.getLastChild();
        PlanNode parentBottom = topNode.getParent();
        RuleMergeVirtual.copyProjectSubqueryProps(projectNode, parentBottom);
        NodeEditor.removeChildNode(parentBottom, topNode);
        NodeEditor.removeChildNode(parentBottom, projectNode);
        if (parentFrame.hasJoin()) {
            if (frame.hasJoin()) {
                this.mergeJoinNodes(parentFrame.getJoinNode(), frame.getJoinNode(), oldGroup);
            } else {
                PlanNode upperJoin = parentFrame.getJoinNode();
                From upperFrom = (From)upperJoin.getProperty(NodeConstants.Info.FROM_CLAUSE);
                List fromClauses = upperFrom.getClauses();
                List bottomNodes = frame.getBottomNodes();
                PlanNode onlyBottomNode = (PlanNode)bottomNodes.get(0);
                GroupSymbol replacementGroup = (GroupSymbol)onlyBottomNode.getGroups().iterator().next();
                Iterator fromIter = fromClauses.iterator();
                while (fromIter.hasNext()) {
                    FromClause clause = (FromClause)fromIter.next();
                    this.fixFromClause(clause, oldGroup, replacementGroup);
                }
                upperJoin.getGroups().clear();
                upperJoin.addGroups(upperFrom.getGroups());
            }
        }
        List parentBottomNodes = parentFrame.getBottomNodes();
        parentBottomNodes.remove(frame.getTopNode());
        parentBottomNodes.addAll(frame.getBottomNodes());
        if (!parentFrame.hasJoin()) {
            parentFrame.setJoinNode(frame.getJoinNode());
        }
    }

    private static void copyProjectSubqueryProps(PlanNode projectNode, PlanNode parentProject) {
        List correlatedReferences;
        List subqueryPlans = (List)projectNode.getProperty(NodeConstants.Info.SUBQUERY_PLANS);
        if (subqueryPlans != null) {
            List subqueryValueProviders = (List)projectNode.getProperty(NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS);
            while (parentProject.getType() != 11) {
                parentProject = parentProject.getParent();
                Assertion.isNotNull((Object)parentProject);
            }
            RuleMergeVirtual.addListValuesToNode(subqueryPlans, parentProject, NodeConstants.Info.SUBQUERY_PLANS);
            RuleMergeVirtual.addListValuesToNode(subqueryValueProviders, parentProject, NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS);
        }
        if ((correlatedReferences = (List)projectNode.getProperty(NodeConstants.Info.CORRELATED_REFERENCES)) != null) {
            RuleMergeVirtual.addListValuesToNode(correlatedReferences, parentProject, NodeConstants.Info.CORRELATED_REFERENCES);
        }
    }

    private static void addListValuesToNode(List values, PlanNode node, Integer propKey) {
        if (values != null) {
            List nodeValues = (List)node.getProperty(propKey);
            if (nodeValues == null) {
                node.setProperty(propKey, values);
            } else {
                nodeValues.addAll(values);
            }
        }
    }

    void handleOverlappingGroups(QueryFrame frame, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        QueryFrame parentFrame = frame.getParentFrame();
        List overlappingGroups = this.getOverlappingGroups(frame);
        if (overlappingGroups != null) {
            Set bothFrameGroups = this.getFrameGroups(parentFrame);
            bothFrameGroups.addAll(this.getFrameGroups(frame));
            HashSet<String> allGroupNames = new HashSet<String>();
            Iterator frameGroupIter = bothFrameGroups.iterator();
            while (frameGroupIter.hasNext()) {
                GroupSymbol frameGroup = (GroupSymbol)frameGroupIter.next();
                allGroupNames.add(frameGroup.getName());
            }
            Iterator overlapIter = overlappingGroups.iterator();
            while (overlapIter.hasNext()) {
                GroupSymbol overlapGroup = (GroupSymbol)overlapIter.next();
                GroupSymbol renamedSymbol = FrameUtil.recontextSymbol(overlapGroup, allGroupNames);
                allGroupNames.add(renamedSymbol.getName());
                Map tempSymbolMap = FrameUtil.buildSymbolMap(overlapGroup, renamedSymbol, metadata);
                PlanNode siblingNode = null;
                Iterator bottomIter = parentFrame.getBottomNodes().iterator();
                while (bottomIter.hasNext()) {
                    PlanNode bottomNode = (PlanNode)bottomIter.next();
                    if (!bottomNode.getGroups().contains(overlapGroup)) continue;
                    siblingNode = bottomNode;
                    break;
                }
                FrameUtil.convertFrame(parentFrame, siblingNode, overlapGroup, renamedSymbol, tempSymbolMap, metadata);
                Map siblingSymbolMap = (Map)siblingNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
                if (siblingSymbolMap == null) continue;
                HashMap convertedMap = new HashMap();
                Iterator symbolIter = siblingSymbolMap.keySet().iterator();
                while (symbolIter.hasNext()) {
                    Object key = symbolIter.next();
                    Object value = siblingSymbolMap.get(key);
                    Object newKey = tempSymbolMap.get(key);
                    if (newKey == null) {
                        convertedMap.put(key, value);
                        continue;
                    }
                    convertedMap.put(newKey, value);
                }
                siblingNode.setProperty(NodeConstants.Info.SYMBOL_MAP, convertedMap);
            }
        }
    }

    List getOverlappingGroups(QueryFrame frame) {
        GroupSymbol frameSymbol = (GroupSymbol)frame.getTopNode().getGroups().iterator().next();
        Set lowerGroups = this.getFrameGroups(frame);
        Set upperGroups = this.getFrameGroups(frame.getParentFrame());
        return FrameUtil.getOverlappingGroups(frameSymbol, lowerGroups, upperGroups);
    }

    boolean fixFromClause(FromClause clause, GroupSymbol oldGroup, GroupSymbol replacementGroup) {
        if (clause instanceof UnaryFromClause) {
            UnaryFromClause unary = (UnaryFromClause)clause;
            if (unary.getGroup().equals((Object)oldGroup)) {
                unary.setGroup(replacementGroup);
                return true;
            }
            return false;
        }
        JoinPredicate jp = (JoinPredicate)clause;
        boolean fixed = this.fixFromClause(jp.getLeftClause(), oldGroup, replacementGroup);
        if (fixed) {
            return fixed;
        }
        fixed = this.fixFromClause(jp.getRightClause(), oldGroup, replacementGroup);
        return fixed;
    }

    boolean mergeJoinNodes(PlanNode upperJoin, PlanNode lowerJoin, GroupSymbol oldGroup) {
        boolean removeSelectNodes = false;
        From upperFrom = (From)upperJoin.getProperty(NodeConstants.Info.FROM_CLAUSE);
        From lowerFrom = (From)lowerJoin.getProperty(NodeConstants.Info.FROM_CLAUSE);
        List upperClauses = upperFrom.getClauses();
        List clausePath = this.findClausePath(upperClauses, oldGroup);
        if (clausePath.size() == 1) {
            upperClauses.remove(clausePath.get(0));
            upperClauses.addAll(lowerFrom.getClauses());
        } else {
            FromClause replacementClause = null;
            List lowerClauses = lowerFrom.getClauses();
            if (lowerClauses.size() == 1) {
                replacementClause = (FromClause)lowerClauses.get(0);
            } else {
                List lowerCriteria = (List)lowerJoin.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                Iterator lowerClauseIter = lowerClauses.iterator();
                replacementClause = (FromClause)lowerClauseIter.next();
                HashSet collectedGroups = new HashSet();
                collectedGroups.addAll(GroupCollectorVisitor.getGroups((LanguageObject)replacementClause, (boolean)true));
                while (lowerClauseIter.hasNext()) {
                    FromClause rightClause = (FromClause)lowerClauseIter.next();
                    collectedGroups.addAll(GroupCollectorVisitor.getGroups((LanguageObject)rightClause, (boolean)true));
                    ArrayList<Criteria> predCrits = new ArrayList<Criteria>();
                    if (lowerCriteria != null) {
                        Iterator lowerCritIter = lowerCriteria.iterator();
                        while (lowerCritIter.hasNext()) {
                            Criteria crit = (Criteria)lowerCritIter.next();
                            Collection critGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit);
                            if (!collectedGroups.containsAll(critGroups)) continue;
                            predCrits.add(crit);
                            lowerCritIter.remove();
                        }
                    }
                    replacementClause = predCrits.size() == 0 ? new JoinPredicate(replacementClause, rightClause, JoinType.JOIN_CROSS) : new JoinPredicate(replacementClause, rightClause, JoinType.JOIN_INNER, predCrits);
                    ((JoinPredicate)replacementClause).setOptional(((UnaryFromClause)clausePath.get(0)).isOptional());
                }
            }
            UnaryFromClause oldClause = (UnaryFromClause)clausePath.get(0);
            JoinPredicate oldParent = (JoinPredicate)clausePath.get(1);
            if (oldParent.getLeftClause() == oldClause) {
                oldParent.setLeftClause(replacementClause);
            } else {
                oldParent.setRightClause(replacementClause);
            }
        }
        Set upperGroups = upperJoin.getGroups();
        upperGroups.clear();
        upperGroups.addAll(upperFrom.getGroups());
        ArrayList upperCrits = (ArrayList)upperJoin.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        List lowerCrits = (List)lowerJoin.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        if (upperCrits == null) {
            upperCrits = new ArrayList();
            upperJoin.setProperty(NodeConstants.Info.JOIN_CRITERIA, upperCrits);
        }
        if (lowerCrits != null) {
            upperCrits.addAll(lowerCrits);
        }
        if (lowerJoin.getParent() != upperJoin) {
            PlanNode selectBottom = lowerJoin.getParent();
            while (selectBottom != upperJoin) {
                NodeEditor.removeChildNode(selectBottom.getParent(), selectBottom);
                NodeEditor.insertNode(upperJoin.getParent(), upperJoin, selectBottom);
                selectBottom = lowerJoin.getParent();
            }
        }
        NodeEditor.removeChildNode(lowerJoin.getParent(), lowerJoin);
        return removeSelectNodes;
    }

    List findClausePath(List upperClauses, GroupSymbol oldGroup) {
        ArrayList path = new ArrayList();
        Iterator upperClauseIter = upperClauses.iterator();
        while (upperClauseIter.hasNext()) {
            FromClause clause = (FromClause)upperClauseIter.next();
            this.buildClausePath(clause, oldGroup, path);
            if (path.size() <= 0) continue;
            return path;
        }
        Assertion.failed((String)QueryExecPlugin.Util.getString("ERR.015.004.0060", (Object)oldGroup));
        return path;
    }

    void buildClausePath(FromClause clause, GroupSymbol group, List path) {
        if (clause instanceof UnaryFromClause) {
            if (((UnaryFromClause)clause).getGroup().equals((Object)group)) {
                path.add(clause);
            }
        } else {
            JoinPredicate jp = (JoinPredicate)clause;
            this.buildClausePath(jp.getLeftClause(), group, path);
            if (path.size() > 0) {
                path.add(clause);
                return;
            }
            this.buildClausePath(jp.getRightClause(), group, path);
            if (path.size() > 0) {
                path.add(clause);
            }
        }
    }

    public String toString() {
        return "MergeVirtual";
    }
}

