/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.util.Permutation;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleBreakMultiJoin;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RuleBreakMultiJoin
implements OptimizerRule {
    public static final int EXHAUSTIVE_REGION_SEARCH_THRESHOLD = 7;
    public static final int NON_EXHAUSTIVE_SEARCH_COUNT = 5040;

    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode joinNode = this.findMultiJoin(plan);
        if (joinNode == null) {
            return plan;
        }
        From from = (From)joinNode.getProperty(NodeConstants.Info.FROM_CLAUSE);
        HashSet optionalGroups = new HashSet();
        this.collectOptionalGroups((LanguageObject)from, optionalGroups);
        ArrayList joinCrit = (ArrayList)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        if (joinNode.getChildCount() == 2) {
            JoinType jtype = null;
            List clauses = from.getClauses();
            if (clauses.size() == 2) {
                jtype = joinCrit != null && joinCrit.size() > 0 ? JoinType.JOIN_INNER : JoinType.JOIN_CROSS;
            } else {
                JoinPredicate jp = (JoinPredicate)clauses.get(0);
                jtype = jp.getJoinType();
                if (jp.getJoinCriteria().size() > 0) {
                    if (joinCrit == null) {
                        joinCrit = new ArrayList();
                        joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCrit);
                    }
                    joinCrit.addAll(jp.getJoinCriteria());
                }
            }
            joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, jtype);
            joinNode.removeProperty(NodeConstants.Info.FROM_CLAUSE);
        } else {
            Map sourceMap = this.getSourceMap(joinNode);
            int childCount = joinNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                PlanNode child = joinNode.getFirstChild();
                joinNode.removeChild(child);
            }
            PlanNode parent = joinNode.getParent();
            NodeEditor.removeChildNode(parent, joinNode);
            this.mergeClauseTrees(from, joinCrit);
            if (from.getClauses().size() == 1) {
                FromClause clause = (FromClause)from.getClauses().get(0);
                if (joinCrit != null && joinCrit.size() > 0) {
                    this.distributeJoinCriteria(clause, joinCrit);
                }
                this.buildTree(clause, parent, sourceMap);
            } else {
                JoinGraph joinGraph = new JoinGraph();
                this.extractJoinInfo(from, joinCrit, joinGraph);
                List regions = this.sortIntoRegions(joinGraph, metadata, capFinder);
                Iterator regionIter = regions.iterator();
                while (regionIter.hasNext()) {
                    this.planRegion((Region)regionIter.next(), joinGraph, from);
                }
                if (regions.size() == 1) {
                    Region region = (Region)regions.get(0);
                    this.buildTree(region.getJoinStructure(), parent, sourceMap);
                } else if (regions.size() == 2) {
                    this.replaceJoinNode(parent, regions, joinGraph, sourceMap);
                } else {
                    this.planRegions(regions, parent, joinGraph, sourceMap, metadata, capFinder);
                }
            }
        }
        rules.push((OptimizerRule)this);
        if (!optionalGroups.isEmpty()) {
            this.markOptionalNodes(plan, optionalGroups);
        }
        return plan;
    }

    PlanNode findMultiJoin(PlanNode root) throws QueryPlannerException, MetaMatrixComponentException {
        if (root.getType() == 7 && (root.getChildren().size() > 2 || root.getProperty(NodeConstants.Info.FROM_CLAUSE) != null)) {
            return root;
        }
        if (root.getChildCount() > 0) {
            List children = root.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                PlanNode found = this.findMultiJoin(child);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    Map getSourceMap(PlanNode joinNode) {
        HashMap map = new HashMap();
        List children = joinNode.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            PlanNode node = (PlanNode)childIter.next();
            Iterator groupIter = node.getGroups().iterator();
            Object group = groupIter.next();
            map.put(group, node);
        }
        return map;
    }

    void distributeJoinCriteria(FromClause clause, List joinCrit) {
        this.distributeJoinCriteriaRecursive(clause, new LinkedList(joinCrit), new HashMap());
    }

    void distributeJoinCriteriaRecursive(FromClause clause, LinkedList joinCrit, Map clauseGroups) {
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        if (clause instanceof UnaryFromClause) {
            groups.add(((UnaryFromClause)clause).getGroup());
            clauseGroups.put(clause, groups);
            return;
        }
        if (clause instanceof SubqueryFromClause) {
            groups.add(((SubqueryFromClause)clause).getGroupSymbol());
            clauseGroups.put(clause, groups);
            return;
        }
        if (clause instanceof JoinPredicate) {
            JoinPredicate jp = (JoinPredicate)clause;
            this.distributeJoinCriteriaRecursive(jp.getLeftClause(), joinCrit, clauseGroups);
            this.distributeJoinCriteriaRecursive(jp.getRightClause(), joinCrit, clauseGroups);
            groups.addAll((Set)clauseGroups.get(jp.getLeftClause()));
            groups.addAll((Set)clauseGroups.get(jp.getRightClause()));
            clauseGroups.put(clause, groups);
            ArrayList<Criteria> jpCrit = jp.getJoinCriteria();
            if (jpCrit == null) {
                jpCrit = new ArrayList<Criteria>();
                jp.setJoinCriteria(jpCrit);
            }
            Iterator critIter = joinCrit.iterator();
            while (critIter.hasNext()) {
                Criteria crit = (Criteria)critIter.next();
                Collection critGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit);
                Iterator critGroupIter = critGroups.iterator();
                boolean matched = true;
                while (critGroupIter.hasNext()) {
                    GroupSymbol critGroup = (GroupSymbol)critGroupIter.next();
                    if (groups.contains(critGroup)) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                critIter.remove();
                jpCrit.add(crit);
            }
        }
    }

    private void mergeClauseTrees(From from, List joinCrit) {
        List clauses = from.getClauses();
        if (joinCrit == null || clauses.size() < 2) {
            return;
        }
        boolean hasPredicate = false;
        ArrayList<Collection> clauseGroups = new ArrayList<Collection>();
        Iterator clauseIter = clauses.iterator();
        while (clauseIter.hasNext()) {
            FromClause clause = (FromClause)clauseIter.next();
            clauseGroups.add(GroupCollectorVisitor.getGroups((LanguageObject)clause, (boolean)false));
            if (!(clause instanceof JoinPredicate)) continue;
            hasPredicate = true;
        }
        if (!hasPredicate) {
            return;
        }
        LinkedList workingCrits = new LinkedList(joinCrit);
        while (workingCrits.size() > 0) {
            Criteria crit = (Criteria)workingCrits.removeFirst();
            HashSet critGroups = new HashSet(GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit));
            int index1 = -1;
            int index2 = -1;
            for (int i = 0; i < clauseGroups.size(); ++i) {
                Collection groups = (Collection)clauseGroups.get(i);
                Iterator findIter = critGroups.iterator();
                while (findIter.hasNext()) {
                    if (!groups.contains(findIter.next())) continue;
                    if (index1 < 0) {
                        index1 = i;
                        break;
                    }
                    index2 = i;
                    break;
                }
                if (index2 >= 0) break;
            }
            if (index2 < 0) {
                ArrayList<Criteria> distCrits = new ArrayList<Criteria>();
                distCrits.add(crit);
                this.distributeJoinCriteria((FromClause)clauses.get(index1), distCrits);
                continue;
            }
            FromClause c2 = (FromClause)clauses.remove(index2);
            FromClause c1 = (FromClause)clauses.remove(index1);
            Collection combinedGroups = (Collection)clauseGroups.remove(index2);
            combinedGroups.addAll((Collection)clauseGroups.remove(index1));
            ArrayList<Criteria> newCrits = new ArrayList<Criteria>();
            newCrits.add(crit);
            Iterator otherCritIter = workingCrits.iterator();
            while (otherCritIter.hasNext()) {
                Criteria otherCrit = (Criteria)otherCritIter.next();
                HashSet otherCritGroups = new HashSet(GroupsUsedByElementsVisitor.getGroups((LanguageObject)otherCrit));
                if (!combinedGroups.containsAll(otherCritGroups)) continue;
                otherCritIter.remove();
                newCrits.add(otherCrit);
            }
            JoinPredicate jp = new JoinPredicate(c1, c2, JoinType.JOIN_INNER, newCrits);
            clauses.add(0, jp);
            clauseGroups.add(0, combinedGroups);
        }
        joinCrit.clear();
    }

    void buildTree(FromClause clause, PlanNode parent, Map sourceMap) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        if (clause instanceof UnaryFromClause) {
            PlanNode node = (PlanNode)sourceMap.get(((UnaryFromClause)clause).getGroup());
            parent.addLastChild(node);
            node.setParent(parent);
        } else {
            JoinPredicate jp = (JoinPredicate)clause;
            PlanNode joinNode = NodeFactory.getNewNode((int)7);
            joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, jp.getJoinType());
            joinNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, JoinStrategyType.NESTED_LOOP);
            joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, jp.getJoinCriteria());
            this.setOptionalProperty(clause, joinNode);
            parent.addLastChild(joinNode);
            joinNode.setParent(parent);
            FromClause[] clauses = new FromClause[]{jp.getLeftClause(), jp.getRightClause()};
            for (int i = 0; i < 2; ++i) {
                if (clauses[i] instanceof UnaryFromClause) {
                    GroupSymbol group = ((UnaryFromClause)clauses[i]).getGroup();
                    PlanNode sourceNode = (PlanNode)sourceMap.get(group);
                    Assertion.isNotNull((Object)sourceNode);
                    joinNode.addLastChild(sourceNode);
                    sourceNode.setParent(joinNode);
                } else {
                    this.buildTree(clauses[i], joinNode, sourceMap);
                }
                Iterator iter = joinNode.getChildren().iterator();
                while (iter.hasNext()) {
                    PlanNode child = (PlanNode)iter.next();
                    joinNode.addGroups(child.getGroups());
                }
            }
        }
    }

    void extractJoinInfo(From from, List joinCrit, JoinGraph joinGraph) throws QueryPlannerException {
        joinGraph.addGroups((Collection)from.getGroups());
        if (joinCrit != null) {
            Iterator critIter = joinCrit.iterator();
            while (critIter.hasNext()) {
                Criteria crit = (Criteria)critIter.next();
                GroupSymbol[] groups = this.getGroups(crit);
                if (groups == null) continue;
                joinGraph.addCriteria(groups[0], groups[1], crit, null);
            }
        }
        Iterator clauseIter = from.getClauses().iterator();
        while (clauseIter.hasNext()) {
            FromClause clause = (FromClause)clauseIter.next();
            if (!(clause instanceof JoinPredicate)) continue;
            this.extractJoinInfo((JoinPredicate)clause, joinGraph);
        }
    }

    void extractJoinInfo(JoinPredicate predicate, JoinGraph joinGraph) throws QueryPlannerException {
        List crits = predicate.getJoinCriteria();
        if (crits != null) {
            Iterator critIter = crits.iterator();
            while (critIter.hasNext()) {
                Criteria crit = (Criteria)critIter.next();
                GroupSymbol[] groups = this.getGroups(crit);
                if (groups == null) continue;
                joinGraph.addCriteria(groups[0], groups[1], crit, predicate.getJoinType());
            }
        }
        if (predicate.getLeftClause() instanceof JoinPredicate) {
            this.extractJoinInfo((JoinPredicate)predicate.getLeftClause(), joinGraph);
        }
        if (predicate.getRightClause() instanceof JoinPredicate) {
            this.extractJoinInfo((JoinPredicate)predicate.getRightClause(), joinGraph);
        }
    }

    List sortIntoRegions(JoinGraph joinGraph, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        Region region;
        GroupSymbol group;
        LinkedList workGroups = new LinkedList(joinGraph.getGroups());
        ArrayList<Region> regions = new ArrayList<Region>();
        Iterator firstPassIter = workGroups.iterator();
        while (firstPassIter.hasNext()) {
            group = (GroupSymbol)firstPassIter.next();
            if (group.getMetadataID() instanceof TempMetadataID || metadata.isVirtualGroup(group.getMetadataID())) {
                region = new Region();
                region.addGroup(group);
                regions.add(region);
                firstPassIter.remove();
                continue;
            }
            Object modelID = metadata.getModelID(group.getMetadataID());
            if (CapabilitiesUtil.supportsJoins(modelID, metadata, capFinder) && !metadata.modelSupports(modelID, 10) && !metadata.modelSupports(modelID, 11)) continue;
            Region region2 = new Region();
            region2.addGroup(group);
            region2.setModelID(modelID);
            regions.add(region2);
            firstPassIter.remove();
        }
        while (workGroups.size() > 0) {
            int numGroupsInRegion;
            group = (GroupSymbol)workGroups.removeFirst();
            region = new Region();
            region.addGroup(group);
            regions.add(region);
            Object modelID = metadata.getModelID(group.getMetadataID());
            region.setModelID(modelID);
            do {
                numGroupsInRegion = region.getGroups().size();
                Iterator workGroupIter = workGroups.iterator();
                while (workGroupIter.hasNext()) {
                    GroupSymbol possibleGroup = (GroupSymbol)workGroupIter.next();
                    Object possibleModelID = metadata.getModelID(possibleGroup.getMetadataID());
                    if (!possibleModelID.equals(modelID) || this.isSelfJoin(region.getGroups(), possibleGroup) && !CapabilitiesUtil.supportsSelfJoins(modelID, metadata, capFinder)) continue;
                    boolean cantJoin = false;
                    boolean foundConnection = false;
                    Iterator regionGroupIter = region.getGroups().iterator();
                    while (regionGroupIter.hasNext()) {
                        ArrayList joinCriteria;
                        GroupSymbol regionGroup = (GroupSymbol)regionGroupIter.next();
                        JoinType type = joinGraph.getJoinInfo(regionGroup, possibleGroup, joinCriteria = new ArrayList(2));
                        if (type.equals((Object)JoinType.JOIN_CROSS) || joinCriteria == null || joinCriteria.size() == 0) continue;
                        if (!type.equals((Object)JoinType.JOIN_INNER) && !CapabilitiesUtil.supportsOuterJoin(modelID, type, metadata, capFinder)) {
                            cantJoin = true;
                            break;
                        }
                        boolean hasExpression = false;
                        Iterator critIter = joinCriteria.iterator();
                        while (critIter.hasNext()) {
                            Criteria ccrit = (Criteria)critIter.next();
                            if (FunctionCollectorVisitor.getFunctions((LanguageObject)ccrit, (boolean)false).size() <= 0) continue;
                            hasExpression = true;
                            break;
                        }
                        if (hasExpression && !CapabilitiesUtil.supportsJoinExpression(modelID, joinCriteria, metadata, capFinder)) {
                            cantJoin = true;
                            break;
                        }
                        foundConnection = true;
                    }
                    if (!foundConnection || cantJoin) continue;
                    region.addGroup(possibleGroup);
                    workGroupIter.remove();
                }
            } while (region.getGroups().size() != numGroupsInRegion);
        }
        return regions;
    }

    boolean isSelfJoin(Set groups, GroupSymbol possibleSelfGroup) {
        Iterator groupIter = groups.iterator();
        while (groupIter.hasNext()) {
            GroupSymbol group = (GroupSymbol)groupIter.next();
            if (!group.getMetadataID().equals(possibleSelfGroup.getMetadataID())) continue;
            return true;
        }
        return false;
    }

    GroupSymbol[] getGroups(Criteria crit) {
        GroupSymbol[] groups = new GroupSymbol[2];
        Collection critGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit);
        Iterator groupIter = critGroups.iterator();
        if (groupIter.hasNext()) {
            groups[0] = (GroupSymbol)groupIter.next();
            if (!groupIter.hasNext()) {
                return null;
            }
        } else {
            return null;
        }
        groups[1] = (GroupSymbol)groupIter.next();
        return groups;
    }

    void planRegion(Region region, JoinGraph joinGraph, From from) throws QueryPlannerException {
        int numGroups = region.getGroups().size();
        boolean failed = true;
        for (int groupIndex = 0; groupIndex < region.getGroups().size(); ++groupIndex) {
            region.resetJoinStructure();
            ArrayList groups = new ArrayList(region.getGroups());
            GroupSymbol firstGroup = (GroupSymbol)groups.get(groupIndex);
            region.joinGroup(firstGroup, null, null);
            try {
                HashSet<GroupSymbol> seenGroups = new HashSet<GroupSymbol>();
                seenGroups.add(firstGroup);
                int innerGroup = (groupIndex + 1) % numGroups;
                while (innerGroup != groupIndex) {
                    GroupSymbol group = (GroupSymbol)groups.get(innerGroup);
                    HashSet<GroupSymbol> singleGroup = new HashSet<GroupSymbol>();
                    ArrayList crits = new ArrayList();
                    singleGroup.add(group);
                    JoinType type = joinGraph.getJoinInfo(seenGroups, singleGroup, crits);
                    region.joinGroup(group, type, crits);
                    seenGroups.add(group);
                    innerGroup = (innerGroup + 1) % numGroups;
                }
                failed = false;
                break;
            }
            catch (QueryPlannerException e) {
                continue;
            }
        }
        if (failed && (failed = this.planRegionUsingFromClause(region, joinGraph, from))) {
            throw new QueryPlannerException(QueryExecPlugin.Util.getString("RuleBreakMultiJoin.Unable_find_join_plan"));
        }
    }

    boolean planRegionUsingFromClause(Region region, JoinGraph joinGraph, From from) {
        boolean failed = false;
        From copyFrom = (From)from.clone();
        List clauses = copyFrom.getClauses();
        ArrayList<FromClause> regionClauses = new ArrayList<FromClause>(clauses.size());
        Iterator clauseIter = clauses.iterator();
        while (clauseIter.hasNext()) {
            FromClause clause = (FromClause)clauseIter.next();
            if (!this.containsAny(clause, region.getGroups())) continue;
            regionClauses.add(clause);
        }
        ListIterator<FromClause> regionClauseIter = regionClauses.listIterator();
        while (regionClauseIter.hasNext()) {
            FromClause clause = (FromClause)regionClauseIter.next();
            FromClause prunedClause = this.pruneClause(clause, region.getGroups());
            if (prunedClause == null) {
                regionClauseIter.remove();
                continue;
            }
            regionClauseIter.set(prunedClause);
        }
        FromClause regionTree = null;
        if (regionClauses.size() > 0) {
            Iterator combineIter = regionClauses.iterator();
            regionTree = (FromClause)combineIter.next();
            HashSet seenGroups = new HashSet();
            regionTree.collectGroups(seenGroups);
            try {
                while (combineIter.hasNext()) {
                    FromClause clause = (FromClause)combineIter.next();
                    HashSet clauseGroups = new HashSet();
                    clause.collectGroups(clauseGroups);
                    ArrayList crits = new ArrayList();
                    JoinType type = joinGraph.getJoinInfo(seenGroups, clauseGroups, crits);
                    regionTree = new JoinPredicate(regionTree, clause, type, crits);
                    seenGroups.addAll(clauseGroups);
                }
            }
            catch (QueryPlannerException e) {
                failed = true;
            }
        } else {
            failed = true;
        }
        if (!failed) {
            region.setJoinStructure(regionTree);
        }
        return failed;
    }

    boolean containsAny(FromClause clause, Collection regionGroups) {
        HashSet clauseGroups = new HashSet();
        clause.collectGroups(clauseGroups);
        clauseGroups.retainAll(regionGroups);
        return clauseGroups.size() > 0;
    }

    FromClause pruneClause(FromClause clause, Set regionGroups) {
        if (clause instanceof UnaryFromClause) {
            GroupSymbol group = ((UnaryFromClause)clause).getGroup();
            if (!regionGroups.contains(group)) {
                return null;
            }
            return clause;
        }
        if (clause instanceof SubqueryFromClause) {
            GroupSymbol group = ((SubqueryFromClause)clause).getGroupSymbol();
            if (!regionGroups.contains(group)) {
                return null;
            }
            return clause;
        }
        JoinPredicate jp = (JoinPredicate)clause;
        FromClause left = this.pruneClause(jp.getLeftClause(), regionGroups);
        FromClause right = this.pruneClause(jp.getRightClause(), regionGroups);
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        jp.setLeftClause(left);
        jp.setRightClause(right);
        return jp;
    }

    void replaceJoinNode(PlanNode parent, List regions, JoinGraph joinGraph, Map sourceMap) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Iterator regionIter = regions.iterator();
        PlanNode lastNode = null;
        while (regionIter.hasNext()) {
            FromClause js;
            Region region;
            PlanNode currentNode = NodeFactory.getNewNode((int)7);
            if (lastNode == null) {
                region = (Region)regionIter.next();
                js = region.getJoinStructure();
                this.buildTree(js, currentNode, sourceMap);
            } else {
                currentNode.addLastChild(lastNode);
                lastNode.setParent(currentNode);
            }
            region = (Region)regionIter.next();
            js = region.getJoinStructure();
            this.buildTree(js, currentNode, sourceMap);
            Set leftGroups = currentNode.getFirstChild().getGroups();
            Set rightGroups = currentNode.getLastChild().getGroups();
            currentNode.addGroups(leftGroups);
            currentNode.addGroups(rightGroups);
            ArrayList joinCriteria = new ArrayList();
            JoinType joinType = joinGraph.getJoinInfo(leftGroups, rightGroups, joinCriteria);
            if (joinCriteria.size() == 0) {
                currentNode.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_CROSS);
            } else {
                currentNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
                currentNode.setProperty(NodeConstants.Info.JOIN_TYPE, joinType);
            }
            currentNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, JoinStrategyType.NESTED_LOOP);
            lastNode = currentNode;
        }
        parent.addLastChild(lastNode);
        lastNode.setParent(parent);
    }

    void planRegions(List regions, PlanNode parent, JoinGraph joinGraph, Map sourceMap, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        if (RuleBreakMultiJoin.anyRegionsSupportLeafJoin(regions, metadata)) {
            PlanNode dummy = new PlanNode();
            dummy.setParent(parent);
            Set atomicProjectedGroups = RuleRaiseAccess.getProjectedGroups(dummy, metadata, capFinder);
            regions = RuleBreakMultiJoin.mergeRegions(regions, atomicProjectedGroups, parent, joinGraph, metadata);
            if (regions.size() == 1) {
                Region region = (Region)regions.get(0);
                this.buildTree(region.getJoinStructure(), parent, sourceMap);
                return;
            }
            if (regions.size() == 2) {
                this.replaceJoinNode(parent, regions, joinGraph, sourceMap);
                return;
            }
        }
        Map scoreMap = this.calculateSourceStats(sourceMap);
        Map regionMap = this.calculateRegionStats(regions, scoreMap);
        Object[] bestOrder = null;
        bestOrder = regions.size() > 7 ? this.compareRandomOrders(regions, joinGraph, regionMap) : this.compareAllOrders(regions, joinGraph, regionMap);
        if (bestOrder == null) {
            throw new QueryPlannerException(QueryExecPlugin.Util.getString("ERR.015.004.0014"));
        }
        this.replaceJoinNode(parent, Arrays.asList(bestOrder), joinGraph, sourceMap);
    }

    static boolean anyRegionsSupportLeafJoin(List regions, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Iterator regionIter = regions.iterator();
        while (regionIter.hasNext()) {
            Object modelID;
            Region region = (Region)regionIter.next();
            if (region.isVirtual() || !metadata.modelSupports(modelID = region.getModelID(), 11)) continue;
            return true;
        }
        return false;
    }

    static List mergeRegions(List regions, Collection projectedGroups, PlanNode parent, JoinGraph joinGraph, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        ArrayList result = new ArrayList(regions.size());
        DirectedJoinGraph directedGraph = new DirectedJoinGraph(regions, projectedGroups, joinGraph, parent, metadata);
        RuleBreakMultiJoin.stabilizeDirectedJoinGraph(directedGraph, result);
        return result;
    }

    static void stabilizeDirectedJoinGraph(DirectedJoinGraph directedGraph, List newRegions) {
        directedGraph.removeIrrelevantVertices(newRegions);
        Iterator invalidEdges = DirectedJoinGraph.access$000((DirectedJoinGraph)directedGraph).iterator();
        while (invalidEdges.hasNext()) {
            Edge edge = (Edge)invalidEdges.next();
            edge.getHead().removeEdge(edge);
            edge.getTail().removeEdge(edge);
            directedGraph.removeEdge(edge, true);
        }
        block1: while (true) {
            Iterator vertices = DirectedJoinGraph.access$100((DirectedJoinGraph)directedGraph).iterator();
            while (vertices.hasNext()) {
                Vertice vertice = (Vertice)vertices.next();
                if (!Vertice.access$200((Vertice)vertice) || Vertice.access$300((Vertice)vertice).isEmpty()) continue;
                while (true) {
                    if (Vertice.access$300((Vertice)vertice).isEmpty()) continue block1;
                    Edge goingEdge = (Edge)Vertice.access$300((Vertice)vertice).iterator().next();
                    goingEdge.getHead().removeEdge(goingEdge);
                    goingEdge.getTail().removeEdge(goingEdge);
                    directedGraph.removeEdge(goingEdge, true);
                }
            }
            Iterator pathIter = DirectedJoinGraph.access$400((DirectedJoinGraph)directedGraph).iterator();
            if (!pathIter.hasNext()) break;
            Stack path = (Stack)pathIter.next();
            pathIter.remove();
            path.pop();
            Edge edge = (Edge)path.pop();
            edge.getHead().removeEdge(edge);
            edge.getTail().removeEdge(edge);
            directedGraph.removeEdge(edge, false);
        }
        directedGraph.mergeRegions(newRegions);
    }

    Object[] compareAllOrders(List regions, JoinGraph joinGraph, Map regionMap) {
        int bestScore = -1;
        int bestCrossJoinScore = -1;
        Object[] bestOrder = null;
        Object[] bestCrossJoinOrder = null;
        JoinPlanState state = new JoinPlanState();
        Permutation perms = new Permutation(regions.toArray());
        Iterator permIter = perms.generate();
        while (permIter.hasNext()) {
            Object[] order = (Object[])permIter.next();
            int score = this.computeOrderScore(order, regionMap, joinGraph, state);
            if (score == -1) continue;
            if (state.foundCrossJoin) {
                if (score <= bestCrossJoinScore) continue;
                bestCrossJoinOrder = order;
                bestCrossJoinScore = score;
                continue;
            }
            if (score <= bestScore) continue;
            bestOrder = order;
            bestScore = score;
        }
        Object[] returnOrder = null;
        returnOrder = bestOrder != null ? bestOrder : bestCrossJoinOrder;
        return returnOrder;
    }

    Object[] compareRandomOrders(List regions, JoinGraph joinGraph, Map regionMap) {
        Random random = new Random(((Object)joinGraph.getGroups()).hashCode());
        int regionCount = regions.size();
        HashSet<Integer> seeds = new HashSet<Integer>(regionCount);
        for (int i = 0; i < regionCount; ++i) {
            seeds.add(new Integer(i));
        }
        Object[] bestOrder = null;
        int bestScore = -1;
        Object[] bestCrossJoinOrder = null;
        int bestCrossJoinScore = -1;
        JoinPlanState state = new JoinPlanState();
        for (int count = 0; count < 5040; ++count) {
            ArrayList newOrder = new ArrayList(regionCount);
            LinkedList regionsLeft = new LinkedList(seeds);
            while (regionsLeft.size() > 0) {
                int index = random.nextInt(regionsLeft.size());
                Integer regionIndex = (Integer)regionsLeft.get(index);
                newOrder.add(regions.get(regionIndex));
                regionsLeft.remove(index);
            }
            Object[] order = newOrder.toArray();
            int score = this.computeOrderScore(order, regionMap, joinGraph, state);
            if (score == -1) continue;
            if (state.foundCrossJoin) {
                if (score <= bestCrossJoinScore) continue;
                bestCrossJoinOrder = order;
                bestCrossJoinScore = score;
                continue;
            }
            if (score <= bestScore) continue;
            bestOrder = order;
            bestScore = score;
        }
        Object[] returnOrder = null;
        returnOrder = bestOrder != null ? bestOrder : bestCrossJoinOrder;
        return returnOrder;
    }

    int computeOrderScore(Object[] order, Map regionMap, JoinGraph joinGraph, JoinPlanState state) {
        boolean invalidOrder = false;
        state.foundCrossJoin = false;
        int score = 0;
        HashSet seenGroups = new HashSet();
        for (int i = 0; i < order.length; ++i) {
            int depth = order.length - i;
            Region region = (Region)order[i];
            SourceStats stats = (SourceStats)regionMap.get(region);
            int regionScore = this.getRegionScore(stats, depth);
            score += regionScore;
            if (i > 0) {
                try {
                    int joinScore = this.getJoinScore(region, seenGroups, joinGraph, depth, state);
                    if (!state.acceptCrossJoinPlan && state.foundCrossJoin) {
                        return -1;
                    }
                    score += joinScore;
                }
                catch (QueryPlannerException e) {
                    invalidOrder = true;
                    break;
                }
            }
            seenGroups.addAll(region.getGroups());
        }
        if (state.acceptCrossJoinPlan && !state.foundCrossJoin) {
            state.acceptCrossJoinPlan = false;
        }
        if (invalidOrder) {
            return -1;
        }
        return score;
    }

    Map calculateSourceStats(Map sourceMap) {
        HashMap scoreMap = new HashMap();
        Iterator sourceIter = sourceMap.keySet().iterator();
        while (sourceIter.hasNext()) {
            Object src = sourceIter.next();
            PlanNode node = (PlanNode)sourceMap.get(src);
            SourceStats stats = new SourceStats();
            this.getStats(node, stats);
            scoreMap.put(src, stats);
        }
        return scoreMap;
    }

    void getStats(PlanNode node, SourceStats stats) {
        switch (node.getType()) {
            case 13: {
                Criteria crit = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                if (crit instanceof PredicateCriteria) {
                    ++stats.numCriteria;
                    break;
                }
                if (!(crit instanceof CompoundCriteria)) break;
                CompoundCriteria compCrit = (CompoundCriteria)crit;
                if (compCrit.getOperator() == 0) {
                    stats.numCriteria += compCrit.getCriteria().size();
                    break;
                }
                ++stats.numCriteria;
                break;
            }
            case 7: {
                List jcrits = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                if (jcrits == null) break;
                stats.numJoinCriteria += jcrits.size();
                break;
            }
            case 19: {
                ++stats.numGroups;
            }
        }
        List children = node.getChildren();
        if (children.size() > 0) {
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                this.getStats((PlanNode)childIter.next(), stats);
            }
        }
    }

    Map calculateRegionStats(List regions, Map scoreMap) {
        HashMap<Region, SourceStats> regionMap = new HashMap<Region, SourceStats>();
        Iterator regionIter = regions.iterator();
        while (regionIter.hasNext()) {
            Region region = (Region)regionIter.next();
            SourceStats stats = new SourceStats();
            Iterator iter = region.getGroups().iterator();
            while (iter.hasNext()) {
                Object group = iter.next();
                SourceStats groupStats = (SourceStats)scoreMap.get(group);
                stats.add(groupStats);
            }
            regionMap.put(region, stats);
        }
        return regionMap;
    }

    int getRegionScore(SourceStats stats, int depth) {
        return depth * stats.numCriteria + depth * stats.numJoinCriteria;
    }

    int getJoinScore(Region region, Set oldGroups, JoinGraph joinGraph, int depth, JoinPlanState state) throws QueryPlannerException {
        Set newGroups = region.getGroups();
        ArrayList crits = new ArrayList();
        JoinType type = joinGraph.getJoinInfo(oldGroups, newGroups, crits);
        int score = depth * crits.size();
        if (!type.equals((Object)JoinType.JOIN_INNER) && !type.equals((Object)JoinType.JOIN_CROSS)) {
            score += depth;
        }
        if (type.equals((Object)JoinType.JOIN_CROSS)) {
            state.foundCrossJoin = true;
        }
        return score;
    }

    public String toString() {
        return "BreakMultiJoin";
    }

    private void setOptionalProperty(FromClause clause, PlanNode node) {
        if (clause.isOptional()) {
            node.setProperty(NodeConstants.Info.IS_OPTIONAL, Boolean.TRUE);
        }
    }

    private void collectOptionalGroups(LanguageObject from, Set optionalGroups) {
        1 visitor = new /* Unavailable Anonymous Inner Class!! */;
        PreOrderNavigator.doVisit((LanguageObject)from, (LanguageVisitor)visitor);
    }

    private void markOptionalNodes(PlanNode node, Set optionalGroups) {
        if (node.getType() == 7) {
            PlanNode rightChild;
            PlanNode leftChild = this.findChildAccessOrJoinNode(node.getFirstChild());
            if (optionalGroups.containsAll(leftChild.getGroups())) {
                node.setProperty(NodeConstants.Info.IS_LEFT_OPTIONAL, Boolean.TRUE);
            }
            if (optionalGroups.containsAll((rightChild = this.findChildAccessOrJoinNode(node.getLastChild())).getGroups())) {
                node.setProperty(NodeConstants.Info.IS_RIGHT_OPTIONAL, Boolean.TRUE);
            }
        }
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            this.markOptionalNodes((PlanNode)iter.next(), optionalGroups);
        }
    }

    private PlanNode findChildAccessOrJoinNode(PlanNode node) {
        if (node.getType() == 7 || node.getType() == 3) {
            return node;
        }
        return this.findChildAccessOrJoinNode(node.getFirstChild());
    }
}

