/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.admin.objects.MMConnectorBinding;
import com.metamatrix.admin.objects.MMModel;
import com.metamatrix.admin.objects.MMPropertyDefinition;
import com.metamatrix.admin.objects.MMVDB;
import com.metamatrix.admin.server.AdminServerPlugin;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.admin.util.AdminExceptionConverter;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.common.util.crypto.NullCryptor;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.metabase.platform.DirectoryServiceProxy;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import com.metamatrix.platform.admin.apiimpl.RuntimeStateAdminAPIHelper;
import com.metamatrix.platform.config.api.service.IConfigurationServiceProxy;
import com.metamatrix.platform.registry.MetaMatrixRegistry;
import com.metamatrix.platform.registry.exception.RegistryException;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.PasswordCredentials;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.IAuthorizationServiceProxy;
import com.metamatrix.platform.security.api.service.IMembershipServiceProxy;
import com.metamatrix.platform.security.api.service.ISessionServiceProxy;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.vm.api.controller.VMControllerInterface;
import com.metamatrix.platform.vm.controller.VMControllerID;
import com.metamatrix.server.query.service.IQueryServiceProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AbstractAdminImpl {
    private static final String DOUBLE_ESCAPED_DELIMITER = "\\" + AdminObject.ESCAPED_DELIMITER;
    protected ServerAdminImpl parent = null;
    private static String regexpAnyCharZeroOrMore = ".*";

    public AbstractAdminImpl(ServerAdminImpl parent) {
        this.parent = parent;
    }

    protected String getParent(String identifier) {
        return MMAdminObject.getParentName((String)identifier);
    }

    protected String getName(String identifier) {
        return MMAdminObject.getNameFromIdentifier((String)identifier);
    }

    protected String getUserName() {
        return this.parent.getSecurityContext().getUserName();
    }

    protected MetaMatrixSessionID getSessionID() {
        return this.parent.getSessionID();
    }

    protected SessionToken validateSession() throws AdminComponentException {
        SessionToken sessionToken = null;
        try {
            sessionToken = this.getSessionServiceProxy().validateSession(this.getSessionID());
        }
        catch (InvalidSessionException err) {
            AbstractAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (SessionServiceException err) {
            AbstractAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (ServiceException err) {
            AbstractAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (ComponentNotFoundException err) {
            AbstractAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        if (sessionToken == null) {
            this.logAndThrowSystemException(AdminServerPlugin.Util.getString("AbstractAdminImpl.Unable_to_validate_session"));
        }
        return sessionToken;
    }

    public static void logAndConvertSystemException(Exception e) throws AdminComponentException {
        String msg = AdminServerPlugin.Util.getString("AbstractAdminImpl.System_Exception");
        LogManager.logError((String)"ADMIN", (Throwable)e, (String)msg);
        throw AdminExceptionConverter.convertToComponentException((Throwable)e, (String)msg);
    }

    public static void logAndConvertSystemException(Exception e, String appendMsg) throws AdminComponentException {
        String msg = AdminServerPlugin.Util.getString("AbstractAdminImpl.System_Exception");
        if (appendMsg != null && appendMsg.length() > 0) {
            msg = msg + appendMsg;
        }
        LogManager.logError((String)"ADMIN", (Throwable)e, (String)msg);
        throw AdminExceptionConverter.convertToComponentException((Throwable)e, (String)msg);
    }

    public static void logAndConvertProcessingException(Exception e) throws AdminProcessingException {
        String msg = AdminServerPlugin.Util.getString("AbstractAdminImpl.System_Exception");
        LogManager.logError((String)"ADMIN", (Throwable)e, (String)msg);
        throw AdminExceptionConverter.convertToProcessingException((Throwable)e, (String)msg);
    }

    protected void throwProcessingException(String key) throws AdminException {
        String msg = AdminServerPlugin.Util.getString(key);
        LogManager.logError((String)"ADMIN", (String)msg);
        throw new AdminProcessingException(msg);
    }

    protected void throwProcessingException(String key, Object[] objects) throws AdminException {
        String msg = AdminServerPlugin.Util.getString(key, objects);
        LogManager.logError((String)"ADMIN", (String)msg);
        throw new AdminProcessingException(msg);
    }

    protected void logAndThrowSystemException(String key) throws AdminComponentException {
        String msg = AdminServerPlugin.Util.getString(key);
        AdminComponentException e = new AdminComponentException(msg);
        LogManager.logError((String)"ADMIN", (Throwable)e, (String)msg);
        throw e;
    }

    protected void logAndThrowSystemException(String key, Object[] objects) throws AdminComponentException {
        String msg = AdminServerPlugin.Util.getString(key, objects);
        AdminComponentException e = new AdminComponentException(msg);
        LogManager.logError((String)"ADMIN", (Throwable)e, (String)msg);
        throw e;
    }

    protected void logDetail(String key, Object[] params) {
        String msg = AdminServerPlugin.Util.getString(key, params);
        LogManager.logDetail((String)"ADMIN", (String)msg);
    }

    protected void logDetail(String key, Object param) {
        this.logDetail(key, new Object[]{param});
    }

    protected void logException(Throwable e) {
        LogManager.logError((String)"ADMIN", (Throwable)e, (String)e.getMessage());
    }

    protected synchronized ISessionServiceProxy getSessionServiceProxy() throws ServiceException {
        return this.parent.getSessionServiceProxy();
    }

    protected synchronized IMembershipServiceProxy getMembershipServiceProxy() throws ServiceException {
        return this.parent.getMembershipServiceProxy();
    }

    protected synchronized IAuthorizationServiceProxy getAuthorizationServiceProxy() throws ServiceException {
        return this.parent.getAuthorizationServiceProxy();
    }

    protected synchronized IConfigurationServiceProxy getConfigurationServiceProxy() throws ServiceException {
        return this.parent.getConfigurationServiceProxy();
    }

    protected synchronized DirectoryServiceProxy getDirectoryServiceProxy() throws ServiceException {
        return this.parent.getDirectoryServiceProxy();
    }

    protected synchronized IQueryServiceProxy getQueryServiceProxy() throws ServiceException {
        return this.parent.getQueryServiceProxy();
    }

    protected ExtensionModuleManager getExtensionSourceManager() {
        return this.parent.getExtensionSourceManager();
    }

    protected RuntimeStateAdminAPIHelper getRuntimeStateAdminAPIHelper() throws ServiceException {
        return this.parent.getRuntimeStateAdminAPIHelper();
    }

    protected MetaMatrixRegistry getMetaMatrixRegistry() throws ServiceException, RegistryException {
        return this.parent.getMetaMatrixRegistry();
    }

    public static boolean identifierMatches(String query, String[] identifierPartsArray) {
        String identifier = MMAdminObject.buildIdentifier((String[])identifierPartsArray);
        return AbstractAdminImpl.identifierMatches(query, identifier);
    }

    protected static boolean identifierMatches(String query, String identifier) {
        if ("*".equals(query)) {
            return true;
        }
        query = query.toUpperCase();
        identifier = identifier.toUpperCase();
        int firstWildcardIndex = query.indexOf("*");
        boolean matches = false;
        if (firstWildcardIndex >= 0) {
            String regExQuery = query.replaceAll(AdminObject.ESCAPED_DELIMITER, DOUBLE_ESCAPED_DELIMITER);
            regExQuery = regExQuery.replaceAll("\\*", regexpAnyCharZeroOrMore);
            matches = identifier.matches(regExQuery);
        } else {
            matches = identifier.equals(query);
        }
        return matches;
    }

    protected Credentials createEncryptedCredentials(char[] password) throws AdminException {
        char[] encryptedPassword = null;
        try {
            encryptedPassword = CryptoUtil.stringEncrypt((Encryptor)this.parent.getEncryptor(), (char[])password);
        }
        catch (CryptoException err) {
            AbstractAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        return new PasswordCredentials(encryptedPassword, !(this.parent.getEncryptor() instanceof NullCryptor));
    }

    protected VDB convertToAdminVDB(VirtualDatabase virtualDatabase) throws AdminException {
        MMVDB vdb = null;
        String vdbName = virtualDatabase.getName();
        String vdbVersion = virtualDatabase.getVirtualDatabaseID().getVersion();
        String[] identifierParts = new String[]{vdbName, vdbVersion};
        try {
            ConfigurationModelContainer cmc = this.getConfigurationModel();
            vdb = new MMVDB(identifierParts);
            vdb.setCreated(virtualDatabase.getCreationDate());
            vdb.setCreatedBy(virtualDatabase.getCreatedBy());
            vdb.setLastUpdated(virtualDatabase.getUpdateDate());
            vdb.setLastUpdatedBy(virtualDatabase.getUpdatedBy());
            vdb.setProperties(virtualDatabase.getProperties());
            vdb.setStatus(virtualDatabase.getStatus());
            vdb.setUID(((BasicVirtualDatabaseID)virtualDatabase.getVirtualDatabaseID()).getUID());
            vdb.setVersionedBy(virtualDatabase.getVersionBy());
            vdb.setVersionedDate(virtualDatabase.getVersionDate());
            Collection modelObjects = RuntimeMetadataCatalog.getModels(virtualDatabase.getVirtualDatabaseID());
            Iterator iter2 = modelObjects.iterator();
            while (iter2.hasNext()) {
                Model modelObject = (Model)iter2.next();
                String modelName = modelObject.getName();
                String[] modelIdentifierParts = new String[]{vdbName, modelName};
                MMModel model = new MMModel(modelIdentifierParts);
                model.setConnectorBindingNames(this.getConnectorBindingNamesFromUUIDs(modelObject.getConnectorBindingNames(), cmc));
                model.setMaterialization(modelObject.isMaterialization());
                if (modelObject.isMaterialization()) {
                    vdb.setMaterializedViews(true);
                }
                model.setModelType(modelObject.getModelTypeName());
                model.setModelURI(modelObject.getModelURI());
                model.setPhysical(modelObject.isPhysical());
                model.setProperties(modelObject.getProperties());
                model.setSupportsMultiSourceBindings(modelObject.supportsMultiSourceBindings());
                model.setVisible(modelObject.isVisible());
                vdb.addModel(model);
            }
        }
        catch (Exception err) {
            AbstractAdminImpl.logAndConvertSystemException(err);
        }
        return vdb;
    }

    protected List getVDBs(String identifier, Collection virtualDatabases) throws AdminException {
        ArrayList<VDB> results = new ArrayList<VDB>(virtualDatabases.size());
        if (identifier.indexOf(124) < 0 && identifier.indexOf("*") < 0) {
            identifier = identifier.concat("|*");
        }
        Iterator iter = virtualDatabases.iterator();
        while (iter.hasNext()) {
            String vdbVersion;
            VirtualDatabase virtualDatabase = (VirtualDatabase)iter.next();
            String vdbName = virtualDatabase.getName();
            String[] identifierParts = new String[]{vdbName, vdbVersion = virtualDatabase.getVirtualDatabaseID().getVersion()};
            if (!AbstractAdminImpl.identifierMatches(identifier, identifierParts)) continue;
            VDB vdb = this.convertToAdminVDB(virtualDatabase);
            results.add(vdb);
        }
        Collections.sort(results);
        return results;
    }

    protected String getConnectorBindingNameFromUUID(String uuid) throws ConfigurationException, ServiceException {
        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
        ConnectorBinding cb = config.getConnectorBindingByRoutingID(uuid);
        if (cb != null) {
            return cb.getName();
        }
        return null;
    }

    protected List getConnectorBindingNamesFromUUIDs(List uuids, ConfigurationModelContainer configModel) throws ConfigurationException, ServiceException {
        ArrayList<String> results = new ArrayList<String>(uuids.size());
        Iterator iter = uuids.iterator();
        while (iter.hasNext()) {
            String uuid = (String)iter.next();
            ConnectorBinding cb = configModel.getConfiguration().getConnectorBindingByRoutingID(uuid);
            if (cb == null) continue;
            results.add(cb.getName());
        }
        return results;
    }

    protected List getConnectorBindingNamesFromUUIDs(List uuids) throws ConfigurationException, ServiceException {
        ConfigurationModelContainer cmc = this.getConfigurationModel();
        return this.getConnectorBindingNamesFromUUIDs(uuids, cmc);
    }

    protected Map getConnectorBindingNamesMapFromUUIDs(Collection uuids) throws ConfigurationException, ServiceException {
        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
        HashMap<String, String> uuidMap = new HashMap<String, String>(uuids.size());
        Iterator iter = uuids.iterator();
        while (iter.hasNext()) {
            String uuid = (String)iter.next();
            ConnectorBinding cb = config.getConnectorBindingByRoutingID(uuid);
            if (cb == null) continue;
            uuidMap.put(uuid, cb.getName());
        }
        return uuidMap;
    }

    protected void shutDownConnectorBinding(MMConnectorBinding binding, boolean stopNow) throws AdminException {
        VMControllerID vmControllerID = new VMControllerID(binding.getProcessID(), binding.getHostName());
        ServiceID serviceID = new ServiceID(binding.getServiceID(), vmControllerID);
        try {
            VMControllerInterface vmController = this.getMetaMatrixRegistry().getVMController(serviceID.getVMControllerID());
            if (stopNow) {
                vmController.shutdownServiceNow(serviceID);
            } else {
                vmController.shutdownService(serviceID);
            }
        }
        catch (Exception err) {
            AbstractAdminImpl.logAndConvertSystemException(err);
        }
    }

    protected Collection convertPropertyDefinitions(ComponentObject component) throws Exception {
        ComponentType ctype = this.getConfigurationServiceProxy().getComponentType(component.getComponentTypeID());
        Properties properties = component.getProperties();
        return this.convertPropertyDefinitions(ctype, properties);
    }

    protected Collection convertPropertyDefinitions(ComponentObject component, Properties properties) throws Exception {
        ComponentType ctype = this.getConfigurationServiceProxy().getComponentType(component.getComponentTypeID());
        return this.convertPropertyDefinitions(ctype, properties);
    }

    protected Collection convertPropertyDefinitions(ComponentType ctype, Properties properties) throws Exception {
        ArrayList<MMPropertyDefinition> results = new ArrayList<MMPropertyDefinition>();
        Iterator iter = ctype.getComponentTypeDefinitions().iterator();
        while (iter.hasNext()) {
            ComponentTypeDefn cdefn = (ComponentTypeDefn)iter.next();
            PropertyDefinition pdefn = cdefn.getPropertyDefinition();
            MMPropertyDefinition result = new MMPropertyDefinition(new String[]{pdefn.getName()});
            result.setAllowedValues((Collection)pdefn.getAllowedValues());
            result.setConstrainedToAllowedValues(pdefn.isConstrainedToAllowedValues());
            result.setDefaultValue(pdefn.getDefaultValue());
            result.setDescription(pdefn.getShortDescription());
            result.setDisplayName(pdefn.getDisplayName());
            result.setExpert(pdefn.isExpert());
            result.setHidden(pdefn.isHidden());
            result.setMasked(pdefn.isMasked());
            result.setMinimumMultiplicity(pdefn.getMultiplicity().getMinimum());
            result.setMaximumMultiplicity(pdefn.getMultiplicity().getMaximum());
            result.setModifiable(pdefn.isModifiable());
            result.setPreferred(pdefn.isPreferred());
            result.setPropertyType(pdefn.getPropertyType().getDisplayName());
            result.setPropertyTypeClassName(pdefn.getPropertyType().getClassName());
            result.setRequired(pdefn.isRequired());
            result.setRequiresRestart(pdefn.getRequiresRestart());
            result.setValueDelimiter(pdefn.getValueDelimiter());
            String value = properties.getProperty(pdefn.getName());
            result.setValue(value);
            results.add(result);
        }
        return results;
    }

    protected Collection getAdminObjects(String identifier, String className) throws AdminException {
        int code = MMAdminObject.getObjectType((String)className);
        ArrayList<Object> list = null;
        switch (code) {
            case 0: {
                return this.parent.getCaches(identifier);
            }
            case 1: {
                return this.parent.getConnectionPools(identifier);
            }
            case 2: {
                return this.parent.getConnectorBindings(identifier);
            }
            case 3: {
                return this.parent.getConnectorTypes(identifier);
            }
            case 4: {
                return this.parent.getDQPs(identifier);
            }
            case 6: {
                return this.parent.getExtensionModules(identifier);
            }
            case 7: {
                return this.parent.getGroups(identifier);
            }
            case 8: {
                return this.parent.getHosts(identifier);
            }
            case 9: {
                list = new ArrayList<Object>();
                list.add(this.parent.getLogConfiguration());
                return list;
            }
            case 11: {
                return this.parent.getProcesses(identifier);
            }
            case 13: {
                return this.parent.getQueueWorkerPools(identifier);
            }
            case 14: {
                return this.parent.getRequests(identifier);
            }
            case 15: {
                return this.parent.getResources(identifier);
            }
            case 17: {
                return this.parent.getSessions(identifier);
            }
            case 18: {
                return this.parent.getSourceRequests(identifier);
            }
            case 19: {
                list = new ArrayList();
                list.add(this.parent.getSystem());
                return list;
            }
            case 20: {
                return this.parent.getUsers(identifier);
            }
            case 21: {
                return this.parent.getVDBs(identifier);
            }
        }
        this.throwProcessingException("AbstractAdminImpl.Unsupported_Admin_Object", new Object[]{className});
        return Collections.EMPTY_LIST;
    }

    protected void checkSourceLicense(int numberOfSources) throws AdminException {
        boolean licensed = LicenseChecker.hasValidProductLicense((String)"Sources", (String)"5.0", (int)numberOfSources);
        if (!licensed) {
            Object[] params = new Object[]{new Integer(numberOfSources)};
            this.throwProcessingException("AbstractAdminImpl.Failed_license_check", params);
        }
    }

    protected ConfigurationModelContainer getConfigurationModel() throws ConfigurationException, ServiceException {
        return this.getConfigurationServiceProxy().getConfigurationModel("Next Startup");
    }
}

