/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational;

import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.relational.PlanHints;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class GenerateCanonical {
    public static PlanNode generatePlan(Command command, PlanHints hints, QueryMetadataInterface metadata) throws QueryPlannerException {
        if (command.getType() == 1) {
            return GenerateCanonical.createQueryPlan(command, hints, metadata);
        }
        if (command.getType() == 2 || command.getType() == 3 || command.getType() == 4) {
            hints.isUpdate = true;
            return GenerateCanonical.createUpdatePlan(command, hints);
        }
        if (command.getType() == 6) {
            return GenerateCanonical.createStoredProcedurePlan(command, hints);
        }
        throw new QueryPlannerException(QueryExecPlugin.Util.getString("ERR.015.004.0005", (Object)command.getClass().getName()));
    }

    private GenerateCanonical() {
    }

    static PlanNode createUpdatePlan(Command command, PlanHints hints) throws QueryPlannerException {
        PlanNode projectNode = NodeFactory.getNewNode((int)11);
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)false);
        projectNode.addGroups(groups);
        List cols = command.getProjectedSymbols();
        projectNode.setProperty(NodeConstants.Info.TOP_COLS, cols);
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, cols);
        PlanNode sourceNode = NodeFactory.getNewNode((int)19);
        sourceNode.setProperty(NodeConstants.Info.ATOMIC_REQUEST, command);
        sourceNode.setProperty(NodeConstants.Info.VIRTUAL_COMMAND, command);
        sourceNode.addGroups(groups);
        NodeEditor.attachLast(projectNode, sourceNode);
        return projectNode;
    }

    static PlanNode createStoredProcedurePlan(Command command, PlanHints hints) throws QueryPlannerException {
        StoredProcedure storedProc = (StoredProcedure)command;
        PlanNode projectNode = NodeFactory.getNewNode((int)11);
        List cols = storedProc.getProjectedSymbols();
        projectNode.setProperty(NodeConstants.Info.TOP_COLS, cols);
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, cols);
        PlanNode sourceNode = NodeFactory.getNewNode((int)19);
        sourceNode.setProperty(NodeConstants.Info.VIRTUAL_COMMAND, storedProc);
        sourceNode.addGroup(storedProc.getGroup());
        NodeEditor.attachLast(projectNode, sourceNode);
        return projectNode;
    }

    static PlanNode createQueryPlan(Command command, PlanHints hints, QueryMetadataInterface metadata) throws QueryPlannerException {
        QueryCommand qcommand = (QueryCommand)command;
        Option option = qcommand.getOption();
        if (option != null) {
            hints.addMakeDepGroups(option.getDependentGroups());
            hints.addMakeNotDepGroups(option.getNotDependentGroups());
        }
        PlanNode node = null;
        node = command instanceof Query ? GenerateCanonical.createQueryPlan((Query)command, hints, metadata) : GenerateCanonical.createQueryPlan((SetQuery)command, hints, metadata);
        List projectCols = command.getProjectedSymbols();
        ArrayList<Object> topCols = new ArrayList<Object>(projectCols.size());
        Iterator projectIter = projectCols.iterator();
        while (projectIter.hasNext()) {
            SingleElementSymbol symbol = (SingleElementSymbol)projectIter.next();
            topCols.add(symbol.clone());
        }
        node.setProperty(NodeConstants.Info.TOP_COLS, topCols);
        return node;
    }

    private static PlanNode createQueryPlan(SetQuery query, PlanHints hints, QueryMetadataInterface metadata) throws QueryPlannerException {
        hints.hasUnion = true;
        Iterator queryIter = query.getQueries().iterator();
        Iterator flagIter = query.getUseAllFlags().iterator();
        PlanNode plan = null;
        while (queryIter.hasNext()) {
            QueryCommand command = (QueryCommand)queryIter.next();
            Boolean useAll = (Boolean)flagIter.next();
            if (plan == null) {
                plan = GenerateCanonical.createQueryPlan((Command)command, hints, metadata);
                continue;
            }
            PlanNode leftChild = plan;
            PlanNode rightChild = GenerateCanonical.createQueryPlan((Command)command, hints, metadata);
            plan = NodeFactory.getNewNode((int)29);
            plan.setProperty(NodeConstants.Info.SET_OPERATION, new Integer(query.getOperation()));
            plan.setProperty(NodeConstants.Info.USE_ALL, useAll);
            plan.addLastChild(leftChild);
            plan.addLastChild(rightChild);
            leftChild.setParent(plan);
            rightChild.setParent(plan);
            plan.addGroups(leftChild.getGroups());
            plan.addGroups(rightChild.getGroups());
        }
        if (query.getOrderBy() != null) {
            plan = GenerateCanonical.attachSorting(plan, query.getOrderBy());
            hints.hasSort = true;
        }
        if (query.getLimit() != null) {
            plan = GenerateCanonical.attachTupleLimit(plan, query.getLimit());
        }
        return plan;
    }

    private static PlanNode createQueryPlan(Query query, PlanHints hints, QueryMetadataInterface metadata) throws QueryPlannerException {
        PlanNode plan = null;
        if (query.getFrom() != null) {
            List sourceNodes = GenerateCanonical.createSourceNodes(query.getFrom());
            if (sourceNodes.size() > 1) {
                plan = GenerateCanonical.joinSources(sourceNodes, query.getFrom());
                hints.hasJoin = true;
            } else {
                plan = (PlanNode)sourceNodes.get(0);
            }
            if (query.getCriteria() != null) {
                plan = GenerateCanonical.attachCriteria(plan, query.getCriteria());
                hints.hasCriteria = true;
            }
            Iterator i = plan.getGroups().iterator();
            while (i.hasNext()) {
                GroupSymbol group = (GroupSymbol)i.next();
                try {
                    if (metadata.isVirtualGroup(group.getMetadataID())) continue;
                    Object modelID = metadata.getModelID(group.getMetadataID());
                    boolean bl = hints.needsWhereAllValidation = !metadata.modelSupports(modelID, 3);
                    if (!hints.needsWhereAllValidation) continue;
                    break;
                }
                catch (Exception e) {
                    throw new QueryPlannerException((Throwable)e, "");
                }
            }
            if (query.getGroupBy() != null || GenerateCanonical.containsAggregates(query.getSelect())) {
                plan = GenerateCanonical.attachGrouping(plan, query, hints);
            }
            if (query.getHaving() != null) {
                plan = GenerateCanonical.attachCriteria(plan, query.getHaving());
                plan.setProperty(NodeConstants.Info.IS_HAVING, Boolean.TRUE);
            }
            Iterator iter = query.getFrom().getClauses().iterator();
            while (iter.hasNext()) {
                GenerateCanonical.setOptionalJoinHint((FromClause)iter.next(), hints);
            }
        }
        plan = GenerateCanonical.attachProject(plan, query.getSelect());
        if (query.getSelect().isDistinct()) {
            plan = GenerateCanonical.attachDupRemoval(plan);
        }
        if (query.getOrderBy() != null) {
            plan = GenerateCanonical.attachSorting(plan, query.getOrderBy());
            hints.hasSort = true;
        }
        if (query.getLimit() != null) {
            plan = GenerateCanonical.attachTupleLimit(plan, query.getLimit());
        }
        if (query.getInto() != null) {
            PlanNode originalProject = plan;
            while (originalProject.getType() != 11) {
                originalProject = originalProject.getFirstChild();
            }
            originalProject.setProperty(NodeConstants.Info.TOP_COLS, originalProject.getProperty(NodeConstants.Info.PROJECT_COLS));
            List groups = null;
            PlanNode sourceNode = NodeFactory.getNewNode((int)19);
            List cols = query.getSelect().getProjectedSymbols();
            HashMap<SingleElementSymbol, SingleElementSymbol> symbolMap = new HashMap<SingleElementSymbol, SingleElementSymbol>();
            for (int i = 0; i < cols.size(); ++i) {
                SingleElementSymbol symbol = (SingleElementSymbol)cols.get(i);
                symbolMap.put(symbol, symbol);
            }
            sourceNode.setProperty(NodeConstants.Info.SYMBOL_MAP, symbolMap);
            NodeEditor.attachLast(sourceNode, plan);
            plan = sourceNode;
            if (query.getFrom() != null) {
                groups = query.getFrom().getGroups();
                sourceNode.addGroups(groups);
            }
            PlanNode projectNode = NodeFactory.getNewNode((int)11);
            List selectCols = query.getProjectedSymbols();
            projectNode.setProperty(NodeConstants.Info.TOP_COLS, selectCols);
            projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, selectCols);
            projectNode.setProperty(NodeConstants.Info.INTO_GROUP, query.getInto().getGroup());
            if (groups != null) {
                projectNode.addGroups(groups);
            }
            NodeEditor.attachLast(projectNode, plan);
            plan = projectNode;
        }
        return plan;
    }

    private static List createSourceNodes(From from) {
        LinkedList<PlanNode> nodes = new LinkedList<PlanNode>();
        Iterator groupIter = from.getGroups().iterator();
        while (groupIter.hasNext()) {
            GroupSymbol group = (GroupSymbol)groupIter.next();
            PlanNode sourceNode = NodeFactory.getNewNode((int)19);
            sourceNode.addGroup(group);
            nodes.add(sourceNode);
        }
        return nodes;
    }

    private static PlanNode joinSources(List sourceNodes, From from) {
        PlanNode joinNode = NodeFactory.getNewNode((int)7);
        joinNode.setProperty(NodeConstants.Info.FROM_CLAUSE, from);
        joinNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, JoinStrategyType.NESTED_LOOP);
        Iterator iter = sourceNodes.iterator();
        while (iter.hasNext()) {
            PlanNode sourceNode = (PlanNode)iter.next();
            sourceNode.setParent(joinNode);
        }
        joinNode.addChildren(sourceNodes);
        joinNode.addGroups(from.getGroups());
        return joinNode;
    }

    private static PlanNode attachCriteria(PlanNode plan, Criteria criteria) throws QueryPlannerException {
        PlanNode critNode = NodeFactory.getNewNode((int)13);
        critNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, criteria);
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)criteria, (boolean)true);
        critNode.addGroups(GenerateCanonical.getGroups(elements));
        NodeEditor.attachLast(critNode, plan);
        return critNode;
    }

    private static boolean containsAggregates(Select select) {
        return AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)select, (boolean)true).size() > 0;
    }

    private static PlanNode attachGrouping(PlanNode plan, Query query, PlanHints hints) {
        PlanNode groupNode = NodeFactory.getNewNode((int)23);
        GroupBy groupBy = query.getGroupBy();
        if (groupBy != null) {
            groupNode.setProperty(NodeConstants.Info.GROUP_COLS, groupBy.getSymbols());
        }
        groupNode.addGroups(plan.getGroups());
        NodeEditor.attachLast(groupNode, plan);
        hints.hasAggregates = true;
        return groupNode;
    }

    private static PlanNode attachSorting(PlanNode plan, OrderBy orderBy) {
        PlanNode sortNode = NodeFactory.getNewNode((int)17);
        List orderElements = orderBy.getVariables();
        Assertion.isNotNull((Object)orderElements);
        ArrayList<Object> unaliasedElements = new ArrayList<Object>(orderElements.size());
        Iterator orderIter = orderElements.iterator();
        while (orderIter.hasNext()) {
            Object orderElement = orderIter.next();
            if (orderElement instanceof AliasSymbol) {
                unaliasedElements.add(((AliasSymbol)orderElement).getSymbol());
                continue;
            }
            unaliasedElements.add(orderElement);
        }
        sortNode.setProperty(NodeConstants.Info.SORT_ORDER, orderElements);
        sortNode.setProperty(NodeConstants.Info.ORDER_TYPES, orderBy.getTypes());
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)orderBy, (boolean)false);
        sortNode.addGroups(GenerateCanonical.getGroups(elements));
        NodeEditor.attachLast(sortNode, plan);
        return sortNode;
    }

    private static PlanNode attachTupleLimit(PlanNode plan, Limit limit) {
        PlanNode offsetNode = null;
        if (limit.getOffset() != null) {
            Expression offsetExpr = limit.getOffset();
            Integer offset = null;
            if (offsetExpr instanceof Reference) {
                Constant offsetConstant = (Constant)((Reference)offsetExpr).getExpression();
                offset = (Integer)offsetConstant.getValue();
            } else {
                offset = (Integer)((Constant)offsetExpr).getValue();
            }
            if (offset > 0) {
                offsetNode = NodeFactory.getNewNode((int)37);
                offsetNode.setProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT, offsetExpr);
                offsetNode.addGroups(plan.getGroups());
                NodeEditor.attachLast(offsetNode, plan);
                plan = offsetNode;
            }
        }
        Expression limitExpr = limit.getRowLimit();
        Integer rowLimit = null;
        if (limitExpr instanceof Reference) {
            Constant limitConstant = (Constant)((Reference)limitExpr).getExpression();
            rowLimit = (Integer)limitConstant.getValue();
        } else {
            rowLimit = (Integer)((Constant)limitExpr).getValue();
        }
        if (rowLimit > 0) {
            PlanNode limitNode = NodeFactory.getNewNode((int)41);
            limitNode.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, limitExpr);
            limitNode.addGroups(plan.getGroups());
            NodeEditor.attachLast(limitNode, plan);
            return limitNode;
        }
        return plan;
    }

    private static PlanNode attachDupRemoval(PlanNode plan) {
        PlanNode dupNode = NodeFactory.getNewNode((int)5);
        NodeEditor.attachLast(dupNode, plan);
        return dupNode;
    }

    private static PlanNode attachProject(PlanNode plan, Select select) {
        PlanNode projectNode = NodeFactory.getNewNode((int)11);
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, select.getProjectedSymbols());
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)select, (boolean)true);
        projectNode.addGroups(GenerateCanonical.getGroups(elements));
        NodeEditor.attachLast(projectNode, plan);
        return projectNode;
    }

    private static Set getGroups(Collection elements) {
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol element = (ElementSymbol)elementIter.next();
            groups.add(element.getGroupSymbol());
        }
        return groups;
    }

    private static void setOptionalJoinHint(FromClause clause, PlanHints hints) {
        if (clause.isOptional()) {
            hints.hasOptionalNodes = true;
            return;
        }
        if (clause instanceof JoinPredicate) {
            JoinPredicate joinPredicate = (JoinPredicate)clause;
            GenerateCanonical.setOptionalJoinHint(joinPredicate.getLeftClause(), hints);
            GenerateCanonical.setOptionalJoinHint(joinPredicate.getRightClause(), hints);
        }
    }
}

