/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.vdb.defn;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.vdb.edit.loader.VDBReader;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBDefn;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBModelDefn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VDBDefnFactory {
    public VDBDefn create(BasicVDBDefn entry, String newName, Map visibilities, Map modelsToBindings, Map multiSourceEnabled, short status, Collection configbindings) throws Exception {
        Assertion.isNotNull((Object)((Object)entry), (String)"RMCVersionEntry must not be null");
        Assertion.isNotNull((Object)newName, (String)"Name for the new VDB must not be null");
        Assertion.isNotNull((Object)visibilities, (String)"Visibilities for models in new VDB must not be null");
        HashMap<String, ConnectorBinding> uuidsToConfigBindings = new HashMap<String, ConnectorBinding>(configbindings.size());
        Iterator bit = configbindings.iterator();
        while (bit.hasNext()) {
            ConnectorBinding cb = (ConnectorBinding)bit.next();
            uuidsToConfigBindings.put(cb.getRoutingUUID(), cb);
        }
        Collection models = entry.getModels();
        Iterator it = models.iterator();
        while (it.hasNext()) {
            Object s;
            BasicVDBModelDefn mdefn = (BasicVDBModelDefn)it.next();
            Object o = visibilities.get(mdefn.getName());
            if (o instanceof Short) {
                s = (Short)o;
                mdefn.setVisibility(((Short)s).shortValue());
            } else {
                s = (String)o;
                if (((String)s).equalsIgnoreCase("Public")) {
                    mdefn.setIsVisible(true);
                } else {
                    mdefn.setIsVisible(false);
                }
            }
            if (modelsToBindings != null && modelsToBindings.containsKey(mdefn.getName())) {
                List bindings = (List)modelsToBindings.get(mdefn.getName());
                ArrayList<String> names = new ArrayList<String>(bindings.size());
                Iterator iter = bindings.iterator();
                while (iter.hasNext()) {
                    String uuid = (String)iter.next();
                    ConnectorBinding cb = (ConnectorBinding)uuidsToConfigBindings.get(uuid);
                    if (cb == null) {
                        cb = entry.getConnectorBindingByRouting(uuid);
                    }
                    if (cb == null) continue;
                    names.add(cb.getFullName());
                }
                mdefn.setConnectorBindingNames(names);
            }
            if (multiSourceEnabled == null || !multiSourceEnabled.containsKey(mdefn.getName())) continue;
            Boolean enabled = (Boolean)multiSourceEnabled.get(mdefn.getName());
            mdefn.enableMutliSourceBindings(enabled.booleanValue());
        }
        entry.removeUnmappedBindings();
        entry.setModelInfos(models);
        entry.setStatus(status);
        entry.setName(newName);
        return entry;
    }

    public void copyDeploymentInformation(BasicVDBDefn targetDefn, VirtualDatabase sourceVirtualDatabase, Collection sourceModels, Map modelsToBindings, Collection configBindings) throws Exception {
        Assertion.isNotNull((Object)((Object)targetDefn), (String)"targetDefn must not be null");
        Assertion.isNotNull((Object)sourceVirtualDatabase, (String)"sourceDefn must not be null");
        Assertion.isNotNull((Object)sourceModels, (String)"Models in new VDB must not be null");
        HashMap<String, Model> sourceModelMap = new HashMap<String, Model>();
        Iterator it = sourceModels.iterator();
        while (it.hasNext()) {
            Model sourceModel = (Model)it.next();
            sourceModelMap.put(sourceModel.getName(), sourceModel);
        }
        HashMap<String, ConnectorBinding> uuidsToConfigBindings = new HashMap<String, ConnectorBinding>(configBindings.size());
        Iterator bit = configBindings.iterator();
        while (bit.hasNext()) {
            ConnectorBinding cb = (ConnectorBinding)bit.next();
            uuidsToConfigBindings.put(cb.getRoutingUUID(), cb);
        }
        Collection targetModelDefns = targetDefn.getModels();
        Iterator iter1 = targetModelDefns.iterator();
        while (iter1.hasNext()) {
            BasicVDBModelDefn targetModelDefn = (BasicVDBModelDefn)iter1.next();
            Model sourceModel = (Model)sourceModelMap.get(targetModelDefn.getName());
            if (sourceModel == null) {
                String msg = RuntimeMetadataPlugin.Util.getString("VDBDefnFactory.Model_not_found", (Object)targetModelDefn.getName());
                throw new Exception(msg);
            }
            targetModelDefn.setVisibility(sourceModel.getVisibility());
            targetModelDefn.enableMutliSourceBindings(sourceModel.isMultiSourceBindingEnabled());
            Collection bindingUUIDs = (Collection)modelsToBindings.get(targetModelDefn.getName());
            ArrayList<String> bindingNames = new ArrayList<String>(bindingUUIDs.size());
            Iterator iter2 = bindingUUIDs.iterator();
            while (iter2.hasNext()) {
                String routing = (String)iter2.next();
                ConnectorBinding cb = (ConnectorBinding)uuidsToConfigBindings.get(routing);
                if (cb == null) continue;
                bindingNames.add(cb.getFullName());
            }
            targetModelDefn.setConnectorBindingNames(bindingNames);
        }
        targetDefn.removeUnmappedBindings();
        targetDefn.setStatus(sourceVirtualDatabase.getStatus());
        targetDefn.setName(sourceVirtualDatabase.getName());
        targetDefn.setDescription(sourceVirtualDatabase.getDescription());
    }

    public VDBDefn create(VirtualDatabase vdb, byte[] archive) throws Exception {
        BasicVDBDefn vdbDefn = new BasicVDBDefn(vdb.getName());
        vdbDefn.setUUID(vdb.getGUID());
        vdbDefn.setDescription(vdb.getDescription() == null ? "" : vdb.getDescription());
        vdbDefn.setFileName(vdb.getFileName());
        vdbDefn.setVDBJar(archive);
        vdbDefn.setCreatedBy(vdb.getVersionBy());
        vdbDefn.setDateCreated(vdb.getVersionDate());
        vdbDefn.setStatus(vdb.getStatus());
        vdbDefn.setVersion(vdb.getVirtualDatabaseID().getVersion());
        return vdbDefn;
    }

    public VDBDefn create(String vdbName, String vdbVersion) throws Exception {
        VirtualDatabaseID vdbID;
        if (vdbName == null) {
            Assertion.isNotNull((Object)vdbName, (String)RuntimeMetadataPlugin.Util.getString("VDBCreation.Invalid_VDB_name"));
        }
        if ((vdbID = this.getVirtualDatabaseID(vdbName, vdbVersion)) == null) {
            String msg = RuntimeMetadataPlugin.Util.getString("VDBDefnFactory.VDB_version_not_found", new Object[]{vdbName, vdbVersion});
            throw new MetaMatrixException(msg);
        }
        VirtualDatabase vdb = this.getVirtualDatabase(vdbID);
        byte[] archive = this.getVDBArchive(vdbID);
        Collection models = this.getModels(vdbID);
        VDBDefn defn = this.create(vdb, archive);
        System.out.println(RuntimeMetadataPlugin.Util.getString("VDBDefnFactory.Load_vdb_models", (Object)vdbName));
        this.loadRuntimeModelFiles(models, (BasicVDBDefn)defn);
        boolean transferBindingsFromDefn = true;
        defn = VDBReader.loadVDBDefn(defn, archive, transferBindingsFromDefn);
        return defn;
    }

    protected VirtualDatabaseID getVirtualDatabaseID(String vdbName, String vdbVersion) throws Exception {
        return RuntimeMetadataCatalog.getVirtualDatabaseID(vdbName, vdbVersion);
    }

    protected VirtualDatabase getVirtualDatabase(VirtualDatabaseID vdbID) throws Exception {
        return RuntimeMetadataCatalog.getVirtualDatabase(vdbID);
    }

    protected byte[] getVDBArchive(VirtualDatabaseID vdbID) throws Exception {
        return RuntimeMetadataCatalog.getVDBArchive(vdbID);
    }

    protected Collection getModels(VirtualDatabaseID vdbID) throws Exception {
        return RuntimeMetadataCatalog.getModels(vdbID);
    }

    protected void loadRuntimeModelFiles(Collection models, BasicVDBDefn defn) throws Exception {
        if (models != null) {
            Iterator it = models.iterator();
            while (it.hasNext()) {
                Model m = (Model)it.next();
                BasicVDBModelDefn modelDef = this.create(m);
                defn.addModelInfo((ModelInfo)modelDef);
                List bindings = m.getConnectorBindingNames();
                Iterator bit = bindings.iterator();
                while (bit.hasNext()) {
                    String name = (String)bit.next();
                    ConnectorBinding cb = this.getConnectorBinding(name);
                    Assertion.isNotNull((Object)cb, (String)RuntimeMetadataPlugin.Util.getString("VDBDefnFactory.No_connector_binding_found", (Object)name));
                    ComponentType type = this.getComponentType(cb.getComponentTypeID());
                    defn.addConnectorType(type);
                    defn.addConnectorBinding(modelDef.getName(), cb);
                }
            }
        }
    }

    private BasicVDBModelDefn create(Model model) {
        BasicVDBModelDefn md = new BasicVDBModelDefn(model.getName());
        md.setModelType(model.getModelType());
        md.setModelURI(model.getModelURI());
        md.setVersion(model.getVersion());
        md.setUuid(model.getGUID());
        md.setIsVisible(model.isVisible());
        md.enableMutliSourceBindings(model.isMultiSourceBindingEnabled());
        md.setVersionDate(model.getDateVersioned());
        md.setVersionedBy(model.getVersionedBy());
        md.setDescription(model.getDescription());
        return md;
    }

    private ConnectorBinding getConnectorBinding(String routing) throws Exception {
        ConnectorBinding cb = CurrentConfiguration.getConfiguration().getConnectorBindingByRoutingID(routing);
        if (cb == null) {
            Collection b = CurrentConfiguration.getConfiguration().getConnectorBindings();
            Iterator it = b.iterator();
            while (it.hasNext()) {
                ConnectorBinding cb2 = (ConnectorBinding)it.next();
                if (!cb2.getRoutingUUID().equals(routing)) continue;
                return cb2;
            }
        }
        return cb;
    }

    private ComponentType getComponentType(ComponentTypeID typeID) throws Exception {
        return CurrentConfiguration.getConfigurationModel().getComponentType(typeID.getFullName());
    }

    public static ModelInfo createModelInfo(ModelReference modelRef) {
        return new BasicVDBModelDefn(modelRef);
    }
}

