/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.xml.DocumentInProgress;
import com.metamatrix.query.processor.xml.NodeDescriptor;
import com.metamatrix.query.processor.xml.ProcessorEnvironment;
import com.metamatrix.query.processor.xml.ProcessorInstruction;
import com.metamatrix.query.processor.xml.XMLValueTranslator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AddNodeInstruction
extends ProcessorInstruction {
    public static final boolean ELEMENT = true;
    public static final boolean ATTRIBUTE = false;
    private NodeDescriptor descriptor;
    private String resultSetName;
    private int resultSetColumn;
    private NodeDescriptor nillableDescriptor;

    public AddNodeInstruction(NodeDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public AddNodeInstruction(NodeDescriptor descriptor, String resultSetName, int resultSetColumn) {
        this.descriptor = descriptor;
        this.resultSetName = resultSetName;
        this.resultSetColumn = resultSetColumn;
    }

    public void process(ProcessorEnvironment env) throws BlockedException, MetaMatrixComponentException {
        DocumentInProgress doc = env.getDocumentInProgress();
        boolean success = true;
        boolean isElement = this.descriptor.isElement();
        String defaultValue = this.descriptor.getDefaultValue();
        if (this.resultSetName == null) {
            if (defaultValue != null) {
                if (isElement) {
                    success = doc.addElement(this.descriptor, defaultValue);
                    LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"TAG elem", this.descriptor.getName(), "fixed value", defaultValue});
                } else {
                    success = doc.addAttribute(this.descriptor, defaultValue);
                    LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"TAG attr", this.descriptor.getName(), "fixed value", defaultValue});
                }
            } else if (isElement) {
                success = doc.addElement(this.descriptor, this.nillableDescriptor);
                LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"TAG elem", this.descriptor.getName()});
            }
        } else {
            List row = env.getCurrentRow(this.resultSetName);
            Object value = row.get(this.resultSetColumn);
            String valueStr = XMLValueTranslator.translateToXMLValue(value, (Class)this.descriptor.getRuntimeType(), (String)this.descriptor.getDocBuiltInType());
            if (valueStr != null) {
                if (isElement) {
                    success = doc.addElement(this.descriptor, valueStr);
                    LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"TAG elem", this.descriptor.getName(), "value", valueStr});
                } else {
                    success = doc.addAttribute(this.descriptor, valueStr);
                    LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"TAG attr", this.descriptor.getName(), "value", valueStr});
                }
            } else if (defaultValue != null) {
                if (isElement) {
                    success = doc.addElement(this.descriptor, defaultValue);
                    LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"TAG elem", this.descriptor.getName(), "default value", defaultValue});
                } else {
                    success = doc.addAttribute(this.descriptor, defaultValue);
                    LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"TAG attr", this.descriptor.getName(), "default value", defaultValue});
                }
            } else if (isElement) {
                success = doc.addElement(this.descriptor, this.nillableDescriptor);
                LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"TAG elem", this.descriptor.getName(), "no value"});
            }
        }
        if (!success) {
            String elem = isElement ? QueryExecPlugin.Util.getString("AddNodeInstruction.element__1") : QueryExecPlugin.Util.getString("AddNodeInstruction.attribute__2");
            Object[] params = new Object[]{elem, this.descriptor.getQName(), this.descriptor.getNamespaceURI(), this.descriptor.getNamespaceURIs()};
            String msg = QueryExecPlugin.Util.getString("AddNodeInstruction.Unable_to_add_xml_{0}_{1},_namespace_{2},_namespace_declarations_{3}_3", params);
            throw new MetaMatrixComponentException(msg);
        }
        env.incrementCurrentProgramCounter();
    }

    public String toString() {
        Properties namespaceDeclarations;
        StringBuffer str = new StringBuffer();
        if (this.descriptor.isElement()) {
            str.append("ELEM ");
        } else {
            str.append("ATTR ");
        }
        str.append(this.descriptor.getQName());
        if (this.resultSetName != null) {
            str.append(" ");
            str.append(this.resultSetName);
            str.append(" ");
            str.append(this.resultSetColumn);
        }
        if (this.descriptor.getDefaultValue() != null) {
            str.append(" (default " + this.descriptor.getDefaultValue() + ")");
        }
        if ((namespaceDeclarations = this.descriptor.getNamespaceURIs()) != null) {
            str.append(" (namespaces ");
            Enumeration<?> e = namespaceDeclarations.propertyNames();
            while (e.hasMoreElements()) {
                String prefix = (String)e.nextElement();
                str.append(prefix);
                str.append("=>");
                str.append(namespaceDeclarations.getProperty(prefix));
                if (!e.hasMoreElements()) continue;
                str.append(", ");
            }
            str.append(")");
        }
        return str.toString();
    }

    public Map getDescriptionProperties() {
        Properties namespaceDeclarations;
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.descriptor.isElement()) {
            props.put("type", "ADD ELEMENT");
        } else {
            props.put("type", "ADD ATTRIBUTE");
        }
        props.put("tag", this.descriptor.getName());
        if (this.descriptor.isOptional()) {
            props.put("optional", "" + this.descriptor.isOptional());
        }
        if (this.resultSetName != null) {
            props.put("dataCol", this.resultSetName + "." + this.resultSetColumn);
        }
        if (this.descriptor.getNamespacePrefix() != null) {
            props.put("namespace", this.descriptor.getNamespacePrefix());
        }
        if ((namespaceDeclarations = this.descriptor.getNamespaceURIs()) != null) {
            ArrayList<String> nsDecl = new ArrayList<String>(namespaceDeclarations.size());
            Enumeration<?> e = namespaceDeclarations.propertyNames();
            while (e.hasMoreElements()) {
                String prefix = (String)e.nextElement();
                String ns = namespaceDeclarations.getProperty(prefix);
                nsDecl.add(prefix + "=\"" + ns + "\"");
            }
            props.put("namespaceDeclarations", nsDecl);
        }
        if (this.descriptor.getDefaultValue() != null) {
            props.put("default", this.descriptor.getDefaultValue());
        }
        return props;
    }

    String getResultSetName() {
        return this.resultSetName;
    }

    void setResultSetName(String resultSetName) {
        this.resultSetName = resultSetName;
    }

    public void setNillableDescriptor(NodeDescriptor nillableDescriptor) {
        this.nillableDescriptor = nillableDescriptor;
    }
}

