/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.navigator.AggregateStopNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.sql.visitor.RemoveGroupAliasMappingVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleAssignOutputElements
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode projectNode = RuleAssignOutputElements.findFirstProject(plan);
        if (projectNode == null) {
            return plan;
        }
        if (projectNode.getChildren() == null || projectNode.getChildren().isEmpty()) {
            boolean foundUnion = false;
            for (PlanNode searchNode = projectNode.getParent(); searchNode != null; searchNode = searchNode.getParent()) {
                if (searchNode.getType() != 29) continue;
                foundUnion = true;
                break;
            }
            if (!foundUnion) {
                projectNode.setProperty(NodeConstants.Info.OUTPUT_COLS, projectNode.getProperty(NodeConstants.Info.PROJECT_COLS));
                return plan;
            }
        }
        List projectCols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
        this.assignOutputElements(plan, projectCols, metadata, capFinder);
        return plan;
    }

    static PlanNode findFirstProject(PlanNode node) {
        if (node.getType() == 11) {
            return node;
        }
        List children = node.getChildren();
        if (children != null && children.size() > 0) {
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                PlanNode childNode = (PlanNode)childIter.next();
                PlanNode foundNode = RuleAssignOutputElements.findFirstProject(childNode);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    static void findAllProjects(PlanNode node, List projects) {
        if (node.getType() == 11) {
            projects.add(node);
        } else {
            List children = node.getChildren();
            if (children != null && children.size() > 0) {
                Iterator childIter = children.iterator();
                while (childIter.hasNext()) {
                    PlanNode childNode = (PlanNode)childIter.next();
                    RuleAssignOutputElements.findAllProjects(childNode, projects);
                }
            }
        }
    }

    void assignOutputElements(PlanNode root, List outputElements, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        block15: {
            int nodeType;
            block17: {
                block16: {
                    block14: {
                        root.setProperty(NodeConstants.Info.OUTPUT_COLS, outputElements);
                        nodeType = root.getType();
                        if (nodeType != 3) break block14;
                        Command command = (Command)root.getProperty(NodeConstants.Info.ATOMIC_REQUEST);
                        RuleAssignOutputElements.assignOutputElementsToCommand(root, outputElements, metadata, capFinder, command);
                        if (root.getChildCount() == 0) {
                            return;
                        }
                        this.assignOutputElements(root.getLastChild(), outputElements, metadata, capFinder);
                        break block15;
                    }
                    if (nodeType != 19) break block16;
                    if (root.getChildCount() == 0) {
                        return;
                    }
                    PlanNode virtualRoot = root.getLastChild();
                    boolean overAccess = false;
                    if (virtualRoot.getType() == 3 && virtualRoot.getChildCount() == 1) {
                        virtualRoot = virtualRoot.getFirstChild();
                        overAccess = true;
                    }
                    if (this.hasDupRemoval(virtualRoot)) {
                        Map symbolMap = (Map)root.getProperty(NodeConstants.Info.SYMBOL_MAP);
                        ArrayList removedSymbols = new ArrayList();
                        this.removeOptionalNodeColumns(root, symbolMap, (List)root.getProperty(NodeConstants.Info.OUTPUT_COLS), removedSymbols);
                        List newOutputElements = this.createOrderedOutputElements(symbolMap.keySet(), this.findTopCols(virtualRoot, NodeConstants.Info.TOP_COLS));
                        root.setProperty(NodeConstants.Info.OUTPUT_COLS, newOutputElements);
                        if (!removedSymbols.isEmpty()) {
                            this.removeUnusedColumnsInVirtualRoot(root, removedSymbols, NodeConstants.Info.TOP_COLS);
                            this.removeUnusedColumnsInVirtualRoot(root, removedSymbols, NodeConstants.Info.OUTPUT_COLS);
                            this.removeUnusedColumnsInVirtualRoot(root, removedSymbols, NodeConstants.Info.PROJECT_COLS);
                        }
                    }
                    if (overAccess) {
                        virtualRoot = virtualRoot.getParent();
                    }
                    this.assignOutputElements(virtualRoot, this.filterVirtualElements(root, metadata), metadata, capFinder);
                    break block15;
                }
                if (nodeType != 29) break block17;
                Iterator childIter = root.getChildren().iterator();
                boolean first = true;
                while (childIter.hasNext()) {
                    PlanNode childNode = (PlanNode)childIter.next();
                    PlanNode projectNode = RuleAssignOutputElements.findFirstProject(childNode);
                    ArrayList<SingleElementSymbol> projectCols = (ArrayList<SingleElementSymbol>)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
                    if (!first) {
                        ArrayList<SingleElementSymbol> unaliasedOutputCols = new ArrayList<SingleElementSymbol>();
                        Iterator projectIter = projectCols.iterator();
                        while (projectIter.hasNext()) {
                            SingleElementSymbol symbol = (SingleElementSymbol)projectIter.next();
                            if (symbol instanceof AliasSymbol) {
                                unaliasedOutputCols.add(((AliasSymbol)symbol).getSymbol());
                                continue;
                            }
                            unaliasedOutputCols.add(symbol);
                        }
                        projectCols = unaliasedOutputCols;
                    }
                    this.assignOutputElements(childNode, projectCols, metadata, capFinder);
                    first = false;
                }
                break block15;
            }
            if (nodeType == 31) break block15;
            ArrayList requiredInput = new ArrayList();
            HashSet created = new HashSet();
            this.collectRequiredInputSymbols(root, requiredInput, created);
            Iterator currentIter = outputElements.iterator();
            while (currentIter.hasNext()) {
                Object currentOutputSymbol = currentIter.next();
                if (created.contains(currentOutputSymbol) || requiredInput.contains(currentOutputSymbol)) continue;
                requiredInput.add(currentOutputSymbol);
            }
            if (root.getChildCount() == 1) {
                this.assignOutputElements(root.getLastChild(), requiredInput, metadata, capFinder);
            } else {
                Iterator childIter = root.getChildren().iterator();
                while (childIter.hasNext()) {
                    PlanNode childNode = (PlanNode)childIter.next();
                    ArrayList filteredElements = new ArrayList();
                    this.collectFilteredElements(requiredInput, filteredElements, this.getSourceGroups(childNode));
                    this.assignOutputElements(childNode, filteredElements, metadata, capFinder);
                }
            }
        }
    }

    private List createOrderedOutputElements(Set virtualCols, List topCols) {
        if (topCols == null) {
            return new ArrayList(virtualCols);
        }
        HashSet remainingVirtual = new HashSet(virtualCols);
        ArrayList<SingleElementSymbol> newCols = new ArrayList<SingleElementSymbol>();
        Iterator topIter = topCols.iterator();
        block0: while (topIter.hasNext()) {
            SingleElementSymbol topSymbol = (SingleElementSymbol)topIter.next();
            String shortName = topSymbol.getShortCanonicalName();
            Iterator virtualIter = remainingVirtual.iterator();
            while (virtualIter.hasNext()) {
                SingleElementSymbol virtualSymbol = (SingleElementSymbol)virtualIter.next();
                if (!virtualSymbol.getShortCanonicalName().equals(shortName)) continue;
                newCols.add(virtualSymbol);
                virtualIter.remove();
                continue block0;
            }
        }
        return newCols;
    }

    static void assignOutputElementsToCommand(PlanNode root, List outputElements, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Command command) throws QueryMetadataException, MetaMatrixComponentException {
        if (command instanceof Query) {
            Select select = ((Query)command).getSelect();
            select.clearSymbols();
            select.addSymbols((Collection)outputElements);
            RuleAssignOutputElements.removeGroupAliases(root, metadata, capFinder, select);
            OrderBy orderBy = ((Query)command).getOrderBy();
            if (orderBy != null) {
                Iterator orderIter = orderBy.getVariables().iterator();
                while (orderIter.hasNext()) {
                    SingleElementSymbol symbol = (SingleElementSymbol)orderIter.next();
                    if (select.containsSymbol((SelectSymbol)symbol)) continue;
                    select.addSymbol((SelectSymbol)symbol);
                    outputElements.add(symbol);
                }
            }
        }
    }

    private void removeUnusedColumnsInVirtualRoot(PlanNode sourceNode, List removedSymbols, Integer nodeProperty) {
        PlanNode virtualRoot = sourceNode.getLastChild();
        List cols = this.findTopCols(virtualRoot, nodeProperty);
        if (cols == null) {
            return;
        }
        block0: for (int i = 0; i < removedSymbols.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)removedSymbols.get(i);
            String shortName = symbol.getShortName();
            Iterator iter = new ArrayList(cols).iterator();
            while (iter.hasNext()) {
                SingleElementSymbol topCol = (SingleElementSymbol)iter.next();
                if (!shortName.equalsIgnoreCase(topCol.getShortName())) continue;
                cols.remove(topCol);
                continue block0;
            }
        }
    }

    static void removeGroupAliases(PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Select select) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = accessNode.getProperty(NodeConstants.Info.MODEL_ID);
        if (modelID != null && !CapabilitiesUtil.supportsGroupAliases(modelID, metadata, capFinder)) {
            Map symbolMap = RemoveGroupAliasMappingVisitor.removeAliases((LanguageObject)select);
            accessNode.setProperty(NodeConstants.Info.SYMBOL_MAP, symbolMap);
        } else if (modelID == null) {
            Iterator groups = accessNode.getGroups().iterator();
            while (groups.hasNext()) {
                GroupSymbol group = (GroupSymbol)groups.next();
                if (!group.hasAlias() || !group.isTempGroupSymbol()) continue;
                Map symbolMap = RemoveGroupAliasMappingVisitor.removeAliases((LanguageObject)select);
                accessNode.setProperty(NodeConstants.Info.SYMBOL_MAP, symbolMap);
            }
        }
    }

    Collection getSourceGroups(PlanNode node) {
        HashSet groups = new HashSet();
        this.recurseGetSourceGroups(node, groups);
        return groups;
    }

    void recurseGetSourceGroups(PlanNode node, Collection groups) {
        int nodeType = node.getType();
        if (nodeType == 3 || nodeType == 19) {
            groups.addAll(node.getGroups());
        } else if (node.getChildCount() > 0) {
            Iterator iter = node.getChildren().iterator();
            while (iter.hasNext()) {
                PlanNode childNode = (PlanNode)iter.next();
                this.recurseGetSourceGroups(childNode, groups);
            }
        }
    }

    List filterVirtualElements(PlanNode sourceNode, QueryMetadataInterface metadata) throws QueryPlannerException {
        int i;
        PlanNode virtualRoot = sourceNode.getLastChild();
        List outputColumns = (List)sourceNode.getProperty(NodeConstants.Info.OUTPUT_COLS);
        ArrayList allProjects = new ArrayList();
        RuleAssignOutputElements.findAllProjects(virtualRoot, allProjects);
        int[] unfilteredIndices = null;
        if (outputColumns == null || outputColumns.size() == 0) {
            unfilteredIndices = new int[]{0};
        } else {
            List topCols = this.findTopCols(virtualRoot, NodeConstants.Info.TOP_COLS);
            unfilteredIndices = new int[outputColumns.size()];
            if (topCols == null) {
                for (i = 0; i < outputColumns.size(); ++i) {
                    unfilteredIndices[i] = i;
                }
            } else {
                for (i = 0; i < outputColumns.size(); ++i) {
                    unfilteredIndices[i] = -1;
                    SingleElementSymbol symbol = (SingleElementSymbol)outputColumns.get(i);
                    String shortName = symbol.getShortName();
                    for (int j = 0; j < topCols.size(); ++j) {
                        SingleElementSymbol topCol = (SingleElementSymbol)topCols.get(j);
                        if (!shortName.equalsIgnoreCase(topCol.getShortName())) continue;
                        unfilteredIndices[i] = j;
                        break;
                    }
                    if (unfilteredIndices[i] != -1) continue;
                    Assertion.failed((String)QueryExecPlugin.Util.getString("ERR.015.004.0058", (Object)shortName));
                }
            }
        }
        ArrayList firstProjColumns = null;
        for (i = 0; i < allProjects.size(); ++i) {
            PlanNode projectNode = (PlanNode)allProjects.get(i);
            List projectCols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
            ArrayList newCols = new ArrayList();
            for (int j = 0; j < unfilteredIndices.length; ++j) {
                newCols.add(projectCols.get(unfilteredIndices[j]));
            }
            projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, newCols);
            if (i != 0) continue;
            firstProjColumns = newCols;
        }
        if (Boolean.TRUE.equals(sourceNode.getProperty(NodeConstants.Info.INLINE_VIEW))) {
            firstProjColumns.clear();
            Map symbolMap = (Map)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
            Iterator i2 = outputColumns.iterator();
            while (i2.hasNext()) {
                SingleElementSymbol outputColumn;
                SingleElementSymbol column = (SingleElementSymbol)i2.next();
                Expression expression = (Expression)symbolMap.get(column);
                if (!(expression instanceof SingleElementSymbol)) {
                    expression = new ExpressionSymbol(column.getShortName(), expression);
                }
                if (!(expression instanceof AliasSymbol || !((outputColumn = (SingleElementSymbol)expression) instanceof ExpressionSymbol) && outputColumn.getShortCanonicalName().equals(column.getShortCanonicalName()))) {
                    expression = new AliasSymbol(column.getShortName(), outputColumn);
                }
                firstProjColumns.add(expression);
            }
        }
        return firstProjColumns;
    }

    boolean hasDupRemoval(PlanNode node) {
        int nodeType = node.getType();
        if (nodeType == 3 || nodeType == 19 || nodeType == 7) {
            return false;
        }
        if (nodeType == 5 || nodeType == 17 && node.getFirstChild() != null && node.getFirstChild().getType() == 5) {
            return true;
        }
        if (nodeType == 29 && node.getProperty(NodeConstants.Info.SET_OPERATION).equals(new Integer(0)) && node.getProperty(NodeConstants.Info.USE_ALL).equals(Boolean.FALSE)) {
            return true;
        }
        if (node.getChildCount() > 0) {
            Iterator iter = node.getChildren().iterator();
            while (iter.hasNext()) {
                PlanNode childNode = (PlanNode)iter.next();
                boolean childHasNoAll = this.hasDupRemoval(childNode);
                if (!childHasNoAll) continue;
                return true;
            }
        }
        return false;
    }

    List findTopCols(PlanNode node, Integer nodeProperty) {
        List topCols = null;
        for (PlanNode tempNode = node; tempNode != null && (topCols = (List)tempNode.getProperty(nodeProperty)) == null && tempNode.getChildCount() > 0; tempNode = tempNode.getFirstChild()) {
        }
        return topCols;
    }

    void collectRequiredInputSymbols(PlanNode node, Collection requiredSymbols, Set createdSymbols) {
        List<Expression> requiredSymbolsList = new ArrayList<SingleElementSymbol>();
        switch (node.getType()) {
            case 11: {
                GroupSymbol intoGroup = (GroupSymbol)node.getProperty(NodeConstants.Info.INTO_GROUP);
                if (intoGroup == null) {
                    List projectCols = (List)node.getProperty(NodeConstants.Info.PROJECT_COLS);
                    Iterator projectIter = projectCols.iterator();
                    while (projectIter.hasNext()) {
                        SingleElementSymbol ss = (SingleElementSymbol)projectIter.next();
                        if (this.symbolCreatedHere(node, ss)) {
                            createdSymbols.add(ss);
                            if (ss instanceof AliasSymbol) {
                                ss = ((AliasSymbol)ss).getSymbol();
                            }
                            if (this.symbolCreatedHere(node, ss)) {
                                createdSymbols.add(ss);
                                Expression expression = ((ExpressionSymbol)ss).getExpression();
                                AggregateSymbolCollectorVisitor visitor = new AggregateSymbolCollectorVisitor(requiredSymbolsList, requiredSymbolsList);
                                AggregateStopNavigator nav = new AggregateStopNavigator((LanguageVisitor)visitor);
                                expression.acceptVisitor((LanguageVisitor)nav);
                                continue;
                            }
                            requiredSymbolsList.add((Expression)ss);
                            continue;
                        }
                        requiredSymbolsList.add((Expression)ss);
                    }
                    break;
                }
                PlanNode childNode = node.getLastChild();
                Map symbolMap = (Map)childNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
                PlanNode childProject = childNode.getLastChild();
                while (childProject.getType() != 11) {
                    childProject = childProject.getLastChild();
                }
                List projCols = (List)childProject.getProperty(NodeConstants.Info.PROJECT_COLS);
                requiredSymbolsList = RuleAssignOutputElements.reverseSymbolLookup(projCols, symbolMap);
                createdSymbols.addAll((List)node.getProperty(NodeConstants.Info.PROJECT_COLS));
                break;
            }
            case 13: {
                Criteria selectCriteria = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                Boolean isHaving = (Boolean)node.getProperty(NodeConstants.Info.IS_HAVING);
                if (isHaving != null && isHaving.equals(Boolean.TRUE)) {
                    AggregateSymbolCollectorVisitor visitor = new AggregateSymbolCollectorVisitor(requiredSymbolsList, requiredSymbolsList);
                    AggregateStopNavigator nav = new AggregateStopNavigator((LanguageVisitor)visitor);
                    selectCriteria.acceptVisitor((LanguageVisitor)nav);
                    break;
                }
                ElementCollectorVisitor.getElements((LanguageObject)selectCriteria, requiredSymbolsList);
                break;
            }
            case 7: {
                List crits = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                if (crits == null) break;
                Iterator critIter = crits.iterator();
                while (critIter.hasNext()) {
                    Criteria joinCriteria = (Criteria)critIter.next();
                    ElementCollectorVisitor.getElements((LanguageObject)joinCriteria, requiredSymbolsList);
                }
                break;
            }
            case 5: 
            case 17: {
                requiredSymbolsList.addAll((List)node.getProperty(NodeConstants.Info.OUTPUT_COLS));
                break;
            }
            case 23: {
                List groupCols = (List)node.getProperty(NodeConstants.Info.GROUP_COLS);
                if (groupCols != null) {
                    Iterator iter = groupCols.iterator();
                    while (iter.hasNext()) {
                        SingleElementSymbol symbol = (SingleElementSymbol)iter.next();
                        if (symbol instanceof ElementSymbol) {
                            requiredSymbolsList.add((Expression)symbol);
                            continue;
                        }
                        ExpressionSymbol exprSymbol = (ExpressionSymbol)symbol;
                        Expression expr = exprSymbol.getExpression();
                        ElementCollectorVisitor.getElements((LanguageObject)expr, requiredSymbolsList);
                        createdSymbols.add(exprSymbol);
                    }
                }
                ArrayList aggregateCols = (ArrayList)node.getProperty(NodeConstants.Info.AGGREGATES);
                List outputCols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
                Iterator outputIter = outputCols.iterator();
                while (outputIter.hasNext()) {
                    Object outputSymbol = outputIter.next();
                    if (!(outputSymbol instanceof AggregateSymbol)) continue;
                    if (aggregateCols == null) {
                        aggregateCols = new ArrayList();
                        node.setProperty(NodeConstants.Info.AGGREGATES, aggregateCols);
                    }
                    aggregateCols.add(outputSymbol);
                }
                if (aggregateCols == null) break;
                createdSymbols.addAll(aggregateCols);
                Iterator aggIter = aggregateCols.iterator();
                while (aggIter.hasNext()) {
                    AggregateSymbol agg = (AggregateSymbol)aggIter.next();
                    Expression aggExpr = agg.getExpression();
                    if (aggExpr == null) continue;
                    if (aggExpr instanceof AggregateSymbol) {
                        requiredSymbolsList.add(aggExpr);
                        continue;
                    }
                    ElementCollectorVisitor.getElements((LanguageObject)aggExpr, requiredSymbolsList);
                }
                break;
            }
        }
        List refs = (List)node.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
        if (refs != null) {
            Iterator refIter = refs.iterator();
            while (refIter.hasNext()) {
                Reference ref = (Reference)refIter.next();
                Expression expr = ref.getExpression();
                ElementCollectorVisitor.getElements((LanguageObject)expr, requiredSymbolsList);
            }
        }
        if (node.getType() == 5 || node.getType() == 17) {
            requiredSymbols.addAll(requiredSymbolsList);
        } else {
            Iterator elementIter = requiredSymbolsList.iterator();
            while (elementIter.hasNext()) {
                Object symbol = elementIter.next();
                if (requiredSymbols.contains(symbol)) continue;
                requiredSymbols.add(symbol);
            }
        }
    }

    private void removeOptionalNodeColumns(PlanNode node, Map symbolMap, List outColumns, List removedSymbols) {
        if (node.getType() == 7) {
            if (Boolean.TRUE.equals(node.getProperty(NodeConstants.Info.IS_RIGHT_OPTIONAL)) && Boolean.TRUE.equals(node.getProperty(NodeConstants.Info.IS_LEFT_OPTIONAL))) {
                return;
            }
            HashSet groupsInOptionalNode = null;
            if (Boolean.TRUE.equals(node.getProperty(NodeConstants.Info.IS_LEFT_OPTIONAL))) {
                groupsInOptionalNode = ((PlanNode)node.getChildren().get(0)).getGroups();
            }
            if (Boolean.TRUE.equals(node.getProperty(NodeConstants.Info.IS_RIGHT_OPTIONAL))) {
                groupsInOptionalNode = ((PlanNode)node.getChildren().get(1)).getGroups();
            }
            if (groupsInOptionalNode != null) {
                groupsInOptionalNode = new HashSet(groupsInOptionalNode);
                Iterator<Object> iter = outColumns.iterator();
                while (iter.hasNext()) {
                    Object element = symbolMap.get(iter.next());
                    if (element == null || !(element instanceof ElementSymbol)) continue;
                    groupsInOptionalNode.remove(((ElementSymbol)element).getGroupSymbol());
                }
                if (!groupsInOptionalNode.isEmpty()) {
                    iter = new HashSet(symbolMap.entrySet()).iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        Object element = entry.getValue();
                        if (!(element instanceof ElementSymbol) || !groupsInOptionalNode.contains(((ElementSymbol)element).getGroupSymbol())) continue;
                        symbolMap.remove(entry.getKey());
                        removedSymbols.add(entry.getKey());
                    }
                }
            }
        }
        if (node.getChildCount() == 0) {
            return;
        }
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            PlanNode child = (PlanNode)iter.next();
            if (child.getType() == 19) continue;
            this.removeOptionalNodeColumns(child, symbolMap, outColumns, removedSymbols);
        }
    }

    public static List reverseSymbolLookup(List inputList, Map symbolMap) {
        ArrayList result = new ArrayList(inputList.size());
        HashMap reverseMap = new HashMap(symbolMap.size());
        Iterator mapIter = symbolMap.entrySet().iterator();
        while (mapIter.hasNext()) {
            Map.Entry entry = mapIter.next();
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        Iterator projIter = inputList.iterator();
        while (projIter.hasNext()) {
            Expression projCol = (Expression)projIter.next();
            Object value = reverseMap.get(projCol);
            if (value == null && projCol instanceof ExpressionSymbol) {
                projCol = ((ExpressionSymbol)projCol).getExpression();
            }
            value = reverseMap.get(projCol);
            Assertion.isNotNull(value);
            result.add(value);
        }
        return result;
    }

    boolean symbolCreatedHere(PlanNode node, SingleElementSymbol symbol) {
        if (symbol instanceof ElementSymbol || symbol instanceof AggregateSymbol) {
            return false;
        }
        if (node.getChildCount() == 0) {
            return true;
        }
        node = node.getFirstChild();
        while (true) {
            switch (node.getType()) {
                case 3: {
                    Collection exprCreated = (Collection)node.getProperty(NodeConstants.Info.EXPRESSIONS_CREATED);
                    if (exprCreated != null) {
                        return !exprCreated.contains(symbol);
                    }
                    return true;
                }
                case 23: {
                    List groupElements = (List)node.getProperty(NodeConstants.Info.GROUP_COLS);
                    if (groupElements != null) {
                        return !groupElements.contains(symbol);
                    }
                    return true;
                }
                case 5: 
                case 13: 
                case 17: {
                    break;
                }
                default: {
                    return true;
                }
            }
            node = node.getFirstChild();
        }
    }

    void collectFilteredElements(Collection sourceElements, Collection targetElements, Collection filterGroups) {
        if (sourceElements != null) {
            Iterator sourceIter = sourceElements.iterator();
            while (sourceIter.hasNext()) {
                Expression expr;
                SingleElementSymbol element = (SingleElementSymbol)sourceIter.next();
                if (element instanceof ElementSymbol) {
                    if (!filterGroups.contains(((ElementSymbol)element).getGroupSymbol())) continue;
                    targetElements.add(element);
                    continue;
                }
                if (element instanceof AggregateSymbol) {
                    expr = ((AggregateSymbol)element).getExpression();
                    if (expr != null) {
                        Collection aggElem = ElementCollectorVisitor.getElements((LanguageObject)expr, (boolean)true);
                        Iterator iter = aggElem.iterator();
                        while (iter.hasNext()) {
                            ElementSymbol elem = (ElementSymbol)iter.next();
                            if (!filterGroups.contains(elem.getGroupSymbol())) continue;
                            targetElements.add(element);
                        }
                        continue;
                    }
                    targetElements.add(element);
                    continue;
                }
                if (!(element instanceof ExpressionSymbol) || !filterGroups.containsAll(GroupsUsedByElementsVisitor.getGroups((LanguageObject)(expr = ((ExpressionSymbol)element).getExpression())))) continue;
                targetElements.add(element);
            }
        }
    }

    public String toString() {
        return "AssignOutputElements";
    }
}

