/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class JoinUtil {
    private JoinUtil() {
    }

    static boolean doesJoinPreventCriteriaOptimization(PlanNode joinNode, PlanNode critNode) {
        return JoinUtil.getJoinTypePreventingCriteriaOptimization(joinNode, critNode) != null;
    }

    static JoinType getJoinTypePreventingCriteriaOptimization(PlanNode joinNode, PlanNode critNode) {
        Set groups = critNode.getGroups();
        if (groups.size() == 0) {
            if ((critNode = FrameUtil.findOriginatingNode(critNode, groups)) == null) {
                return null;
            }
            groups = critNode.getGroups();
        }
        if (joinNode.getProperty(NodeConstants.Info.JOIN_TYPE) != null) {
            return JoinUtil.getJoinTypePreventingOptimization(joinNode, (Collection)groups);
        }
        From from = (From)joinNode.getProperty(NodeConstants.Info.FROM_CLAUSE);
        return JoinUtil.getJoinTypePreventingOptimization(from, (Collection)groups);
    }

    private static JoinType getJoinTypePreventingOptimization(PlanNode joinNode, Collection groups) {
        Iterator groupIter = groups.iterator();
        JoinType joinType = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (!joinType.isOuter()) {
            return null;
        }
        if (joinType.equals((Object)JoinType.JOIN_FULL_OUTER)) {
            return joinType;
        }
        Set innerGroups = JoinUtil.getInnerSideJoinNodes(joinNode)[0].getGroups();
        while (groupIter.hasNext()) {
            GroupSymbol group = (GroupSymbol)groupIter.next();
            if (!innerGroups.contains(group)) continue;
            return joinType;
        }
        return null;
    }

    private static JoinType getJoinTypePreventingOptimization(From from, Collection groups) {
        Iterator clauses = from.getClauses().iterator();
        while (clauses.hasNext()) {
            Iterator groupIter = groups.iterator();
            FromClause clause = (FromClause)clauses.next();
            while (groupIter.hasNext()) {
                GroupSymbol groupSymbol = (GroupSymbol)groupIter.next();
                JoinPredicate result = JoinUtil.getJoinPredicatePreventingOptimization(clause, groupSymbol);
                if (result == null) continue;
                return result.getJoinType();
            }
        }
        return null;
    }

    private static JoinPredicate getJoinPredicatePreventingOptimization(FromClause clause, GroupSymbol groupSymbol) {
        if (clause instanceof JoinPredicate) {
            JoinPredicate result;
            JoinPredicate predicate = (JoinPredicate)clause;
            JoinType jtype = predicate.getJoinType();
            if (jtype.isOuter()) {
                if (jtype.equals((Object)JoinType.JOIN_LEFT_OUTER)) {
                    if (GroupCollectorVisitor.getGroups((LanguageObject)predicate.getRightClause(), (boolean)true).contains(groupSymbol)) {
                        return predicate;
                    }
                } else if (jtype.equals((Object)JoinType.JOIN_RIGHT_OUTER)) {
                    if (GroupCollectorVisitor.getGroups((LanguageObject)predicate.getLeftClause(), (boolean)true).contains(groupSymbol)) {
                        return predicate;
                    }
                } else {
                    return predicate;
                }
            }
            if ((result = JoinUtil.getJoinPredicatePreventingOptimization(predicate.getLeftClause(), groupSymbol)) != null) {
                return result;
            }
            result = JoinUtil.getJoinPredicatePreventingOptimization(predicate.getRightClause(), groupSymbol);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    static PlanNode[] getInnerSideJoinNodes(PlanNode joinNode) {
        Assertion.assertTrue((joinNode.getType() == 7 ? 1 : 0) != 0);
        JoinType jt = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jt == JoinType.JOIN_INNER || jt == JoinType.JOIN_CROSS) {
            return new PlanNode[]{joinNode.getFirstChild(), joinNode.getLastChild()};
        }
        if (jt == JoinType.JOIN_RIGHT_OUTER) {
            return new PlanNode[]{joinNode.getFirstChild()};
        }
        if (jt == JoinType.JOIN_LEFT_OUTER) {
            return new PlanNode[]{joinNode.getLastChild()};
        }
        return new PlanNode[0];
    }
}

