/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.component;

import com.metamatrix.common.application.basic.BasicApplication;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.messaging.VMMessageBus;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.interceptor.Interceptor;
import com.metamatrix.core.interceptor.InterceptorStack;
import com.metamatrix.core.interceptor.InterceptorStackImpl;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.metabase.platform.DirectoryServiceFactory;
import com.metamatrix.metabase.platform.DirectoryServiceProxy;
import com.metamatrix.metabase.repository.RepositoryParameters;
import com.metamatrix.metabase.repository.api.BufferedInputStreamWrapper;
import com.metamatrix.metabase.repository.internal.message.MessageFactory;
import com.metamatrix.metabase.repository.internal.message.MessageUtil;
import com.metamatrix.metabase.repository.internal.message.RequestMessage;
import com.metamatrix.metabase.repository.internal.message.ResponseMessage;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.MetabaseRepositoryShredderConfigSource;
import com.metamatrix.metamodels.db.model.component.ModelShreddingInterceptor;
import com.metamatrix.metamodels.db.model.component.ShredderRequestContainer;
import com.metamatrix.metamodels.db.model.component.ShredderRequestKey;
import com.metamatrix.metamodels.db.model.component.StartupQueueingThread;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequestImpl;
import com.metamatrix.metamodels.db.model.component.request.RequestFailedMessageImpl;
import com.metamatrix.metamodels.db.model.component.request.StatusListener;
import com.metamatrix.metamodels.db.model.exception.IDException;
import com.metamatrix.metamodels.db.model.exception.ProcessingException;
import com.metamatrix.metamodels.db.model.exception.ResourceException;
import com.metamatrix.metamodels.db.model.pool.ConnectionPool;
import com.metamatrix.metamodels.db.model.processing.ModelProcessorFactory;
import com.metamatrix.metamodels.db.model.processing.command.Command;
import com.metamatrix.metamodels.db.model.processing.command.CommandFactory;
import com.metamatrix.metamodels.db.model.processing.event.ShreddingEvent;
import com.metamatrix.metamodels.db.model.processing.helper.DBIDHelper;
import com.metamatrix.metamodels.db.model.processing.helper.IDHelper;
import com.metamatrix.metamodels.db.model.processing.status.StateChangeEvent;
import com.metamatrix.metamodels.db.model.service.message.BasicIndexingServiceModelActionRequest;
import com.metamatrix.metamodels.db.model.service.message.BasicLazyLoadModelInputStreamWrapper;
import com.metamatrix.metamodels.db.model.statement.StatementProcessorFactory;
import com.metamatrix.metamodels.db.model.statement.StatementTargetFactory;
import com.metamatrix.metamodels.db.model.statement.StatementTargetFactoryImpl;
import com.metamatrix.metamodels.db.platform.api.IndexingServiceModelActionRequest;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.jdom.Document;
import org.jdom.Element;

public class MetabaseRepositoryShredderComponent
extends BasicApplication
implements StatusListener {
    static final String METADATESHREDDING_USER = "MetaDataShredding";
    public static final String TURNOFF_QUEUE_CHECKING = "turnoff.queue.checking";
    public static final int TRANS_SUCCESS_CODE = 1;
    public static final int TRANS_ERROR_CODE = 2;
    private Collection clientConnections = new HashSet();
    private MetabaseRepositoryShredderConfigSource configSource;
    private ConnectionPool jdbcConnectionPool;
    private InterceptorStack interceptors;
    private WorkerPool modelsWorkerPool;
    private WorkerPool statementWorkerPool;
    private IDHelper idHelper;
    private StatementTargetFactoryImpl targetFactory;
    private boolean initialized;
    private CommandFactory commandFactory;
    private VMMessageBus messageBus;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$jdbc$commands$GetItemPathByIdCommand;

    public MetabaseRepositoryShredderComponent(MetabaseRepositoryShredderConfigSource configSource, ConnectionPool jdbcConnectionPool, VMMessageBus vmMessageBus) {
        if (configSource == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.The_configuration_source_for_the_MetabaseRepositoryShredderComponent_was_null._1"));
        }
        if (jdbcConnectionPool == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.The_connection_pool_for_the_MetabaseRepositoryShredderComponent_was_null_2"));
        }
        this.configSource = configSource;
        this.jdbcConnectionPool = jdbcConnectionPool;
        this.messageBus = vmMessageBus;
    }

    public void start() throws ApplicationLifecycleException {
    }

    public void stop() throws ApplicationLifecycleException {
        this.modelsWorkerPool.shutdown();
        this.statementWorkerPool.shutdown();
    }

    public boolean hasWork() {
        return this.modelsWorkerPool.hasWork() || this.statementWorkerPool.hasWork();
    }

    public void connectionAdded(ClientConnection connection) {
        this.clientConnections.add(connection);
    }

    public void connectionRemoved(ClientConnection connection) {
        if (this.clientConnections.contains(connection)) {
            this.clientConnections.remove(connection);
        }
    }

    public Message receive(ClientConnection connection, Message message) {
        Object[] params = new String[]{};
        DBModelPlugin.Util.log(4, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.The_synchronous___receive()___method_is_not_supported_by_the_MetabaseRepositoryShredderComponent_Application.__The_request_could_not_be_processed._1", params));
        return null;
    }

    public void receive(ClientConnection connection, Message message, String messageKey) {
        if (!this.initialized) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_process_a_request_using_this_component.__It_was_not_initialize()ed_prior_to_a_call_to_the_receive_method._1"));
        }
        if (connection == null) {
            DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.The_client_connection_passed_to_the_asynchronous_receive_method__1"));
        } else {
            Object[] params = new Object[]{messageKey};
            if (message == null) {
                try {
                    connection.send(this.createErrorMessage(message, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.The_MetabaseRepositoryShredderComponent_was_unable_2", params), null), messageKey);
                }
                catch (CommunicationException e) {
                    DBModelPlugin.Util.log(4, (Throwable)e, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_send_the_error_message_indicating_that_3", params));
                }
                return;
            }
        }
        if (message instanceof IndexingServiceModelActionRequest) {
            IndexingServiceModelActionRequest requestMsg = (IndexingServiceModelActionRequest)message;
            ShredderRequestContainer shredrequest = this.addCommandToQueue(connection, requestMsg, messageKey);
            this.processCommand(shredrequest);
        }
    }

    private void processCommand(ShredderRequestContainer shredrequest) {
        if (shredrequest == null || !shredrequest.getShredderRequestKey().isToShredNow()) {
            DBModelPlugin.Util.log(1, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Command_queued_for_processing", (Object)shredrequest.getShredderRequestKey()));
            return;
        }
        MetabaseRepositoryShredderComponentRequest trans = shredrequest.getRequestMsg();
        trans.setClientRequestID((Object)shredrequest.getObjectID());
        ClientConnection connection = shredrequest.getConnection();
        try {
            this.idHelper.createTransaction(trans.getUserName(), trans.getCommandTypeString(), System.currentTimeMillis(), shredrequest.getShredderRequestKey().getTransactionID());
        }
        catch (IDException e) {
            String errorMessage = DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_get_a_proper_RequestID_from_the_database._3");
            DBModelPlugin.Util.log(4, (Throwable)e, errorMessage);
            trans.addErrorStatus(errorMessage, (Throwable)e);
            if (connection != null) {
                try {
                    connection.send((Message)trans, shredrequest.getObjectID());
                }
                catch (CommunicationException e1) {
                    DBModelPlugin.Util.log(4, (Throwable)e, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_send_the_error_message_4"));
                }
            }
            this.removeCommandFromQueue(shredrequest.getShredderRequestKey());
            return;
        }
        trans.setTransactionID(shredrequest.getShredderRequestKey().getTransactionID());
        trans.setClientConnection(connection);
        trans.addStatusListener((StatusListener)this);
        Command command = this.commandFactory.createCommand(trans);
        try {
            this.getInterceptorStack().getFirstInterceptor().invoke((Object)command);
        }
        catch (Throwable t) {
            DBModelPlugin.Util.log(4, t, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_invoke_the_interceptor_stack_using_the_submitted_message._4"));
            if (connection != null) {
                try {
                    connection.send(this.createErrorMessage((Message)trans, "Failed while processing the message with key: {0}", t), shredrequest.getObjectID());
                }
                catch (CommunicationException e1) {
                    DBModelPlugin.Util.log(4, (Throwable)e1, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_send_the_error_message_4"));
                }
            }
            return;
        }
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
        this.createWorkerPools();
        this.getInterceptorStack();
        super.initialize(props);
        this.initializeComponentResources();
        this.idHelper.isShreddingQueueAvailable(METADATESHREDDING_USER);
        if (props.getProperty(TURNOFF_QUEUE_CHECKING) == null) {
            StartupQueueingThread sqt = new StartupQueueingThread(this);
            sqt.start();
        }
        this.initialized = true;
    }

    public InterceptorStack getInterceptorStack() {
        if (this.interceptors == null) {
            ModelShreddingInterceptor firstInterceptor = new ModelShreddingInterceptor(this.configSource, this.modelsWorkerPool, this.statementWorkerPool);
            this.interceptors = new InterceptorStackImpl((Interceptor)firstInterceptor);
        }
        return this.interceptors;
    }

    public void setInterceptorStack(InterceptorStack interceptors) {
        this.interceptors = interceptors;
    }

    protected void createWorkerPools() {
        this.statementWorkerPool = new WorkerPool("SQLStatementWorkerPool", (QueueWorkerFactory)new StatementProcessorFactory(this.jdbcConnectionPool), this.configSource.getStatementWorkerPoolMaxSize(), (long)this.configSource.getStatementWorkerPoolKeepAlive());
        int batchingSize = this.configSource.getStatementBatchingSize();
        this.targetFactory = new StatementTargetFactoryImpl(this.statementWorkerPool, batchingSize, this.jdbcConnectionPool);
        this.modelsWorkerPool = new WorkerPool("ModelProcessorWorkerPool", (QueueWorkerFactory)new ModelProcessorFactory(), this.configSource.getModelWorkerPoolMaxSize(), (long)this.configSource.getModelWorkerPoolKeepAlive());
    }

    protected void initializeComponentResources() throws ApplicationInitializationException {
        this.idHelper = new DBIDHelper(this.jdbcConnectionPool);
        this.commandFactory = new CommandFactory(this.jdbcConnectionPool, this.configSource, this.idHelper, (StatementTargetFactory)this.targetFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void requestProcessingEvent(Status status, Message message) {
        if (status == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.The_status_instance_passed_to_the_requestProcessingEvent_1"));
        }
        if (message == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.The_message_passed_to_the_requestProcessingEvent_method_was_null._2"));
        }
        if (!(message instanceof MetabaseRepositoryShredderComponentRequest)) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_process_the_status_message_1", message.getClass()));
        }
        MetabaseRepositoryShredderComponentRequest response = (MetabaseRepositoryShredderComponentRequest)message;
        if (status instanceof StateChangeEvent && (status.getCode() == 4 || status.getCode() == 5)) {
            Object[] params;
            block22: {
                if (response.getClientConnection() != null) {
                    try {
                        response.getClientConnection().send(message, response.getClientRequestID().toString());
                    }
                    catch (CommunicationException e) {
                        params = new String[]{response.getModelName()};
                        DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_deliver_the_asynchronous_completion_response_for_shredded_file__{0}_2", params));
                    }
                } else {
                    Object[] params2 = new String[]{response.getModelName()};
                    DBModelPlugin.Util.log(0, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_deliver_the_asynchronous_completion_response_for_shredded_file__{0}_3", params2));
                }
                if (status.getCode() == 4) {
                    try {
                        this.updateTransCompletionStatus(response, 1);
                    }
                    catch (Exception e1) {
                        params = new String[]{response.getTransactionID() + ""};
                        String errorMessage = DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_update_the_transaction_status_of_Transaction_with_id__{0}._1", params);
                        DBModelPlugin.Util.log(4, (Throwable)e1, errorMessage);
                    }
                    break block22;
                }
                if (status.getCode() != 5) break block22;
                this.updateTransCompletionStatus(response, 2);
            }
            Object var8_11 = null;
            try {
                this.processCompleted(response.getShredderRequestKey());
            }
            finally {
                this.fireEvent(response.getShredderRequestKey());
            }
            {
                catch (Exception e1) {
                    params = new String[]{response.getTransactionID() + ""};
                    String errorMessage = DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_update_the_transaction_status_of_Transaction_with_id__{0}._1", params);
                    DBModelPlugin.Util.log(4, (Throwable)e1, errorMessage);
                    Object var8_12 = null;
                    try {
                        this.processCompleted(response.getShredderRequestKey());
                    }
                    finally {
                        this.fireEvent(response.getShredderRequestKey());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                try {
                    this.processCompleted(response.getShredderRequestKey());
                }
                finally {
                    this.fireEvent(response.getShredderRequestKey());
                }
                throw throwable;
            }
        }
    }

    private void fireEvent(ShredderRequestKey key) {
        if (this.messageBus != null) {
            Object[] params = new Object[]{new Integer(key.getAction()), key.getModelName()};
            try {
                this.messageBus.processEvent((EventObject)new ShreddingEvent(key));
            }
            catch (Exception e) {
                String errorMessage = DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_fire_model_schredding_event", params);
                DBModelPlugin.Util.log(4, (Throwable)e, errorMessage);
            }
        }
    }

    private void processCompleted(ShredderRequestKey key) {
        this.removeCommandFromQueue(key);
        try {
            ShredderRequestKey sk = this.idHelper.getNextFromShreddingQueue(key);
            if (sk == null) {
                return;
            }
            this.processNextRequest(sk);
        }
        catch (IDException e) {
            String errorMessage = DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_get_next_shredder_key_from_the_database");
            DBModelPlugin.Util.log(4, (Throwable)e, errorMessage);
            return;
        }
    }

    private void removeCommandFromQueue(ShredderRequestKey key) {
        try {
            this.idHelper.removeFromShreddingQueue(key);
        }
        catch (IDException e) {
            String errorMessage = DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Error_removing_request_from_queue");
            DBModelPlugin.Util.log(4, (Throwable)e, errorMessage);
        }
    }

    private ShredderRequestContainer addCommandToQueue(ClientConnection connection, IndexingServiceModelActionRequest requestMsg, String messageKey) {
        MetabaseRepositoryShredderComponentRequestImpl trans = null;
        ShredderRequestKey key = null;
        ShredderRequestContainer reqContainer = null;
        try {
            key = this.idHelper.addToShreddingQueue(requestMsg, requestMsg.getUserName());
            trans = new MetabaseRepositoryShredderComponentRequestImpl(requestMsg, key);
            reqContainer = new ShredderRequestContainer(connection, (MetabaseRepositoryShredderComponentRequest)trans, key);
        }
        catch (IDException e) {
            String errorMessage = DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_add_request_to_shredding_queue");
            DBModelPlugin.Util.log(4, (Throwable)e, errorMessage);
            if (trans == null) {
                trans = new MetabaseRepositoryShredderComponentRequestImpl(requestMsg, null);
            }
            trans.addErrorStatus(errorMessage, (Throwable)e);
            if (connection != null) {
                try {
                    connection.send((Message)trans, messageKey);
                }
                catch (CommunicationException e1) {
                    DBModelPlugin.Util.log(4, (Throwable)e, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_send_the_error_message_4"));
                }
            }
            return null;
        }
        return reqContainer;
    }

    protected void processNextRequest(ShredderRequestKey key) throws IDException {
        MetabaseRepositoryShredderComponentRequest request = this.createRequest(key);
        ShredderRequestContainer cont = new ShredderRequestContainer(null, request, key);
        this.processCommand(cont);
    }

    protected Message createErrorMessage(Message request, String message, Throwable e) {
        return new RequestFailedMessageImpl(request, message, e);
    }

    /*
     * Loose catch block
     */
    protected void updateTransCompletionStatus(MetabaseRepositoryShredderComponentRequest message, int statusCode) throws ResourceException, ProcessingException {
        Connection connection;
        block14: {
            String errorMessage2;
            Object[] params2;
            PreparedStatement statement;
            block13: {
                String endTransTime = DateUtil.getCurrentDateAsString();
                connection = this.jdbcConnectionPool.getConnection(message.getUserName());
                statement = null;
                statement = connection.prepareStatement("UPDATE DD_TXN_LOG SET END_TXN = ?, TXN_STATE = ? WHERE ID = ?");
                statement.setLong(3, message.getTransactionID());
                statement.setLong(2, statusCode);
                statement.setString(1, endTransTime);
                statement.execute();
                Object var8_6 = null;
                if (statement == null) break block13;
                try {
                    statement.close();
                }
                catch (SQLException e1) {
                    params2 = new String[]{};
                    errorMessage2 = DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_close_the_statement_used_to_update_the_Transaction_state_in_the_database._2", params2);
                    DBModelPlugin.Util.log(2, (Throwable)e1, errorMessage2);
                }
            }
            if (connection != null) {
                try {
                    connection.commit();
                    break block14;
                }
                catch (SQLException e2) {
                    params2 = new String[]{};
                    errorMessage2 = DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_commit_a_transaction_on_the_Connection_used_to_update_the_DD_TXN_LOG_table_1", params2);
                    DBModelPlugin.Util.log(2, (Throwable)e2, errorMessage2);
                }
                {
                }
            }
            break block14;
            {
                catch (SQLException e) {
                    throw new ProcessingException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                String errorMessage2;
                Object[] params2;
                Object var8_7 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e1) {
                        params2 = new String[]{};
                        errorMessage2 = DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_close_the_statement_used_to_update_the_Transaction_state_in_the_database._2", params2);
                        DBModelPlugin.Util.log(2, (Throwable)e1, errorMessage2);
                    }
                }
                if (connection != null) {
                    try {
                        connection.commit();
                    }
                    catch (SQLException e2) {
                        params2 = new String[]{};
                        errorMessage2 = DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Unable_to_commit_a_transaction_on_the_Connection_used_to_update_the_DD_TXN_LOG_table_1", params2);
                        DBModelPlugin.Util.log(2, (Throwable)e2, errorMessage2);
                    }
                }
                this.jdbcConnectionPool.returnConnection(connection);
                throw throwable;
            }
        }
        this.jdbcConnectionPool.returnConnection(connection);
    }

    protected void requeueModels() throws Exception {
        List keys = this.idHelper.getKeysToRequeue(METADATESHREDDING_USER);
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            ShredderRequestKey key = (ShredderRequestKey)it.next();
            key = this.idHelper.addModelToReQueue(METADATESHREDDING_USER, key);
            this.processNextRequest(key);
        }
    }

    public void statementAdded(Message message) {
    }

    public void statementProcessed(Message message) {
    }

    private MetabaseRepositoryShredderComponentRequest createRequest(ShredderRequestKey key) throws IDException {
        try {
            SessionToken token = new SessionToken(new MetaMatrixSessionID(-1L, key.getUserName()));
            if (key.getPath() == null || key.getPath().trim().length() == 0) {
                String path = this.getModelPath(key.getUserName(), key.getObjectID(), key.getUUID(), key.getVersion(), token);
                key.setPath(path);
            }
            BasicLazyLoadModelInputStreamWrapper streamWrapper = new BasicLazyLoadModelInputStreamWrapper(token, key.getObjectID(), key.getPath(), key.getVersion());
            BasicIndexingServiceModelActionRequest request = new BasicIndexingServiceModelActionRequest((BufferedInputStreamWrapper)streamWrapper, key);
            MetabaseRepositoryShredderComponentRequestImpl trans = new MetabaseRepositoryShredderComponentRequestImpl((IndexingServiceModelActionRequest)request, key);
            return trans;
        }
        catch (Exception e) {
            throw new IDException((Throwable)e);
        }
    }

    private String getModelPath(String userName, ObjectID uuid, String objectID, String version, SessionToken token) throws Exception {
        String msg = "CREATE GETPATH REQUEST-command " + (class$com$metamatrix$metabase$repository$jdbc$commands$GetItemPathByIdCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetItemPathByIdCommand = MetabaseRepositoryShredderComponent.class$("com.metamatrix.metabase.repository.jdbc.commands.GetItemPathByIdCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetItemPathByIdCommand).getName() + " For model " + objectID;
        DBModelPlugin.Util.log(1, msg);
        RepositoryParameters parameters = new RepositoryParameters();
        Path entryPath = new Path("");
        parameters.setId(uuid);
        parameters.setUserName(userName);
        parameters.setPath((IPath)entryPath);
        parameters.setVersion(version);
        RequestMessage mr = MessageFactory.createRequest((String)(class$com$metamatrix$metabase$repository$jdbc$commands$GetItemPathByIdCommand == null ? (class$com$metamatrix$metabase$repository$jdbc$commands$GetItemPathByIdCommand = MetabaseRepositoryShredderComponent.class$("com.metamatrix.metabase.repository.jdbc.commands.GetItemPathByIdCommand")) : class$com$metamatrix$metabase$repository$jdbc$commands$GetItemPathByIdCommand).getName(), (RepositoryParameters)parameters);
        ResponseMessage response = (ResponseMessage)this.submit(userName, mr, token);
        return this.getPath(response.getXmlMessageString());
    }

    private String getPath(String xmlString) throws Exception {
        Element e;
        List children;
        Document doc = MessageUtil.createDocumentFromString((String)xmlString);
        Element root = doc.getRootElement();
        List entries = root.getChildren("responseEntry");
        String p = null;
        if (entries != null && entries.size() > 0 && (children = (e = (Element)entries.get(0)).getChildren()) != null && children.size() > 0) {
            Iterator cit = children.iterator();
            while (cit.hasNext()) {
                Element c = (Element)cit.next();
                if (!c.getName().equals("entryPath")) continue;
                p = c.getText();
                break;
            }
        }
        return p;
    }

    protected Object submit(String userName, RequestMessage message, SessionToken token) throws Exception {
        return this.getProxy().submitRequest(token.getSessionID(), userName, message);
    }

    protected DirectoryServiceProxy getProxy() throws Exception {
        DirectoryServiceProxy dsProxy = DirectoryServiceFactory.getDirectoryServiceProxy();
        return dsProxy;
    }

    protected IDHelper getIDHelper() {
        return this.idHelper;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

