/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.lob.ValueID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.util.Intervals;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.exception.PartialResultsException;
import com.metamatrix.dqp.exception.SourceFailureDetails;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.process.ConnectorRequestInfo;
import com.metamatrix.dqp.internal.process.RequestHolder;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.internal.process.WorkQueue;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.sql.lang.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RequestManager {
    private Map requests = new HashMap();
    private Map requestsByClients = new HashMap();
    private Object warningsLock = new Object();
    private WorkQueue queue;
    private static int iSeqNo;
    private static Thread responseThread;
    final long WAIT = 300000L;

    public RequestManager() {
        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
            LogManager.logDetail((String)"DQP", (String)"Launching History Report Thread");
            this.launchHistoryReportThread();
        }
    }

    private void launchHistoryReportThread() {
        responseThread = new Thread(){

            public void run() {
                RequestManager.this.reportHistory();
            }
        };
        responseThread.start();
    }

    private void reportHistory() {
        ++iSeqNo;
        try {
            while (true) {
                Iterator it = this.requests.keySet().iterator();
                while (it.hasNext()) {
                    RequestID rid = (RequestID)it.next();
                    RequestHolder rh = (RequestHolder)this.requests.get(rid);
                    LogManager.logDetail((String)"DQP", (String)("[RequestManager #" + iSeqNo + " - show history] " + Thread.currentThread().getName() + " - " + rid + " - " + rh.getHistoryString()));
                }
                Thread.sleep(300000L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void setWorkQueue(WorkQueue queue) {
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(RequestMessage requestMsg, Command originalCommand, QueryProcessor processor, TupleSourceID resultsID, AnalysisRecord analysisRecord) {
        RequestID requestID = requestMsg.getRequestID();
        RequestHolder holder = new RequestHolder(this.queue, requestMsg, originalCommand, processor, resultsID, analysisRecord);
        if (!requestMsg.isSynchronousRequest()) {
            holder.range = new int[]{1, requestMsg.getFetchSize()};
        }
        ClientConnection token = requestMsg.getClientConnection();
        Map map = this.requests;
        synchronized (map) {
            this.requests.put(requestID, holder);
        }
        map = this.requestsByClients;
        synchronized (map) {
            Object bySession = this.requestsByClients.get(token);
            if (bySession == null) {
                this.requestsByClients.put(token, requestID);
            } else if (bySession instanceof RequestID) {
                LinkedList<Object> sessionReqs = new LinkedList<Object>();
                sessionReqs.add(bySession);
                sessionReqs.add(requestID);
                this.requestsByClients.put(token, sessionReqs);
            } else {
                ((List)bySession).add(requestID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequestStateHistory(RequestID requestID) {
        RequestHolder holder = null;
        Map map = this.requests;
        synchronized (map) {
            holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return holder.getStateString() + ", " + holder.getHistoryString();
            }
            return "NOT FOUND";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestMessage getRequest(RequestID requestID) {
        RequestHolder holder = null;
        Map map = this.requests;
        synchronized (map) {
            holder = (RequestHolder)this.requests.get(requestID);
        }
        if (holder != null) {
            return holder.requestMsg;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(RequestID requestID) {
        RequestHolder holder = null;
        Map map = this.requests;
        synchronized (map) {
            holder = (RequestHolder)this.requests.remove(requestID);
        }
        if (holder != null) {
            map = this.requestsByClients;
            synchronized (map) {
                ClientConnection token = holder.requestMsg.getClientConnection();
                Object byClient = this.requestsByClients.get(token);
                if (byClient != null) {
                    if (byClient instanceof RequestID) {
                        this.requestsByClients.remove(token);
                    } else {
                        List sessionReqs = (List)byClient;
                        if (sessionReqs.size() < 2) {
                            this.requestsByClients.remove(token);
                        } else {
                            sessionReqs.remove(requestID);
                        }
                    }
                }
            }
            if (holder.processor != null) {
                try {
                    holder.processor.getProcessorPlan().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection getRequests(ClientConnection token) {
        ArrayList<RequestMessage> reqs = null;
        List ids = this.getRequestIdByclient(token);
        if (ids != null) {
            reqs = new ArrayList<RequestMessage>(ids.size());
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                RequestID reqID = (RequestID)iter.next();
                Map map = this.requests;
                synchronized (map) {
                    RequestHolder holder = (RequestHolder)this.requests.get(reqID);
                    if (holder != null) {
                        reqs.add(holder.requestMsg);
                    }
                }
            }
        }
        return reqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getRequests() {
        HashMap<RequestMessage, Collection> reqs = new HashMap<RequestMessage, Collection>();
        ArrayList copies = null;
        Map map = this.requests;
        synchronized (map) {
            copies = new ArrayList(this.requests.values());
        }
        Iterator iter = copies.iterator();
        while (iter.hasNext()) {
            RequestHolder holder = (RequestHolder)iter.next();
            RequestMessage req = new RequestMessage(holder.originalCommand);
            Collection atomicReqs = this.loadRequestsForClient(holder, req);
            reqs.put(req, atomicReqs);
        }
        return reqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getRequestsByClient(ClientConnection token) {
        ArrayList atomicreqs = new ArrayList();
        List ids = this.getRequestIdByclient(token);
        if (ids != null) {
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                RequestID reqID = (RequestID)iter.next();
                Map map = this.requests;
                synchronized (map) {
                    RequestHolder holder = (RequestHolder)this.requests.get(reqID);
                    if (holder != null) {
                        RequestMessage req = new RequestMessage(holder.originalCommand);
                        Collection atomicReqs = this.loadRequestsForClient(holder, req);
                        atomicreqs.addAll(atomicReqs);
                    }
                }
            }
        }
        return atomicreqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getRequestMapByClient(ClientConnection token) {
        HashMap<RequestMessage, Collection> atomicreqs = new HashMap<RequestMessage, Collection>();
        List ids = this.getRequestIdByclient(token);
        if (ids != null) {
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                RequestID reqID = (RequestID)iter.next();
                Map map = this.requests;
                synchronized (map) {
                    RequestHolder holder = (RequestHolder)this.requests.get(reqID);
                    if (holder != null) {
                        RequestMessage req = new RequestMessage(holder.originalCommand);
                        Collection atomicReqs = this.loadRequestsForClient(holder, req);
                        atomicreqs.put(req, atomicReqs);
                    }
                }
            }
        }
        return atomicreqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getRequestIdByclient(ClientConnection token) {
        ArrayList ids;
        Map map = this.requestsByClients;
        synchronized (map) {
            Object byClient = this.requestsByClients.get(token);
            if (byClient == null) {
                ids = Collections.EMPTY_LIST;
            } else if (byClient instanceof RequestID) {
                ids = new ArrayList(1);
                ids.add(byClient);
            } else {
                ids = new ArrayList((List)byClient);
            }
        }
        return ids;
    }

    private Collection loadRequestsForClient(RequestHolder holder, RequestMessage req) {
        req.setRequestID(holder.requestMsg.getRequestID());
        req.setSubmittedTimestamp(holder.requestMsg.getSubmittedTimestamp());
        req.setProcessingTimestamp(holder.requestMsg.getProcessingTimestamp());
        ClientConnection clientConn = holder.requestMsg.getClientConnection();
        req.setClientConnection(clientConn);
        req.setUserParameters(clientConn);
        List conInfoList = this.getAllConnectorInfo(req.getRequestID());
        ArrayList<AtomicRequestMessage> atomicReqs = null;
        if (conInfoList != null && !conInfoList.isEmpty()) {
            atomicReqs = new ArrayList<AtomicRequestMessage>(conInfoList.size());
            Iterator i = conInfoList.iterator();
            while (i.hasNext()) {
                ConnectorRequestInfo conInfo = (ConnectorRequestInfo)i.next();
                ConnectorID connectorID = conInfo.getConnectorID();
                if (connectorID == null) continue;
                AtomicRequestMessage subRequest = conInfo.getAtomicRequest();
                atomicReqs.add(subRequest);
            }
        } else {
            atomicReqs = Collections.EMPTY_LIST;
        }
        return atomicReqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command getOriginalCommand(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return holder.originalCommand;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectorInfo(Object requestID, ConnectorRequestInfo connInfo) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                holder.connectorInfo.put(new Integer(connInfo.getAtomicRequest().getNodeID()), connInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcessing(Object requestID) {
        RequestHolder holder = null;
        Map map = this.requests;
        synchronized (map) {
            holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                holder.startProcessing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryProcessor getProcessor(Object requestID) {
        RequestHolder holder = null;
        Map map = this.requests;
        synchronized (map) {
            holder = (RequestHolder)this.requests.get(requestID);
            if (holder == null) {
                return null;
            }
            return holder.processor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markHasData(Object requestID, WorkItem workItem) throws QueueSuspendedException {
        RequestHolder holder = null;
        Map map = this.requests;
        synchronized (map) {
            holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                holder.requestWork(workItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markNeedsResults(Object requestID, WorkItem workItem, int batchFirst, int batchLast) throws QueueSuspendedException {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                if (holder.requestMsg.isSynchronousRequest()) {
                    holder.pollResults(workItem);
                } else {
                    holder.requestResults(workItem);
                }
                holder.range = new int[]{batchFirst, batchLast};
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markResultsSent(Object requestID) {
        RequestHolder holder = null;
        Map map = this.requests;
        synchronized (map) {
            holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                holder.sentResults();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsResults(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return holder.needsResults();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEndProcessing(Object requestID, WorkItem workItem) throws QueueSuspendedException, MetaMatrixComponentException {
        RequestHolder holder = null;
        Map map = this.requests;
        synchronized (map) {
            holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                holder.endProcessing(workItem);
                if (!holder.needsResults()) {
                    holder.range = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDoneProcessing(Object requestID, WorkItem workItem) throws QueueSuspendedException, MetaMatrixComponentException {
        RequestHolder holder = null;
        Map map = this.requests;
        synchronized (map) {
            holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                holder.doneProcessing(workItem);
                if (!holder.needsResults()) {
                    holder.range = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleSourceID getResultsID(Object requestID) {
        RequestHolder holder = null;
        Map map = this.requests;
        synchronized (map) {
            holder = (RequestHolder)this.requests.get(requestID);
        }
        if (holder != null) {
            return holder.resultsID;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllConnectorInfo(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return new ArrayList(holder.connectorInfo.values());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisRecord getAnalysisRecord(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return holder.analysisRecord;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCodeTableNodeID(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                --holder.nodeID;
                return holder.nodeID;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWarning(MetaMatrixException warning, Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                if (holder.warnings == null) {
                    holder.warnings = new ArrayList();
                }
                holder.warnings.add(warning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSchemas(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return holder.schemas;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intervals getIntervals(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null && holder.range != null) {
                return new Intervals(holder.range[0], holder.range[1]);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchemas(Object requestID, Collection schemas) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                holder.schemas = schemas;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAndClearWarnings(Object requestID) {
        ArrayList<PartialResultsException> copied = null;
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                Object object = this.warningsLock;
                synchronized (object) {
                    copied = holder.warnings;
                    if (holder.partialWarn != null) {
                        if (copied == null) {
                            copied = new ArrayList<PartialResultsException>();
                        }
                        if (!copied.contains(holder.partialWarn)) {
                            copied.add(holder.partialWarn);
                        }
                    }
                    holder.warnings = null;
                    holder.partialWarn = null;
                }
                return copied;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getBatchInterval(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return holder.range;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSourceFailureDetails(SourceFailureDetails details, Object requestID) {
        PartialResultsException warning = null;
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                warning = holder.partialWarn != null ? holder.partialWarn : new PartialResultsException();
                warning.addSourceFailure(details);
                holder.partialWarn = warning;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlanOnly(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return holder.planOnly;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorRequestInfo getConnectorInfo(Object requestID, int nodeID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return (ConnectorRequestInfo)holder.connectorInfo.get(new Integer(nodeID));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorRequestInfo removeConnectorInfo(Object requestID, int nodeID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return (ConnectorRequestInfo)holder.connectorInfo.remove(new Integer(nodeID));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextChunkPosition(Object requestID, ValueID valueID, long startPosition) throws MetaMatrixComponentException {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                long[] positionAndRow;
                if (holder.lobChunkPositions == null) {
                    holder.lobChunkPositions = new HashMap();
                }
                if ((positionAndRow = (long[])holder.lobChunkPositions.get(valueID)) == null) {
                    if (startPosition != 0L) {
                        throw new MetaMatrixComponentException(DQPPlugin.Util.getString("RequestManager.Invalid_starting_position", (Object)new Long(startPosition)));
                    }
                    positionAndRow = new long[]{startPosition, 1L};
                    holder.lobChunkPositions.put(valueID, positionAndRow);
                    return 1;
                }
                if (startPosition == 0L) {
                    positionAndRow[0] = startPosition;
                    positionAndRow[1] = 1L;
                    return 1;
                }
                if (positionAndRow[0] == startPosition) {
                    return (int)positionAndRow[1];
                }
                if (startPosition < positionAndRow[0]) {
                    throw new MetaMatrixComponentException(DQPPlugin.Util.getString("RequestManager.Invalid_starting_position", (Object)new Long(startPosition)));
                }
                positionAndRow[0] = startPosition;
                positionAndRow[1] = positionAndRow[1] + 1L;
                return (int)positionAndRow[1];
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLobLength(Object requestID, ValueID valueID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                Long size;
                if (holder.lobLength == null) {
                    holder.lobLength = new HashMap();
                }
                if ((size = (Long)holder.lobLength.get(valueID)) != null) {
                    return size;
                }
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLobLength(Object requestID, ValueID valueID, long length) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                holder.lobLength = new HashMap();
                holder.lobLength.put(valueID, new Long(length));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getProcessingException(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return holder.processingException;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessingException(Object requestID, Throwable exception) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                holder.processingException = exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRequestCancelled(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                holder.isCancelled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestCancelled(Object requestID) {
        Map map = this.requests;
        synchronized (map) {
            RequestHolder holder = (RequestHolder)this.requests.get(requestID);
            if (holder != null) {
                return holder.isCancelled;
            }
        }
        return true;
    }

    WorkQueue getWorkQueue() {
        return this.queue;
    }
}

