/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.RedefinableElement;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class RedefinableElementOperations
extends UML2Operations {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";

    private RedefinableElementOperations() {
    }

    public static boolean validateRedefinitionContextValid(RedefinableElement redefinableElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator redefinedElements = redefinableElement.getRedefinedElements().iterator();
        while (redefinedElements.hasNext()) {
            RedefinableElement redefinedElement = (RedefinableElement)redefinedElements.next();
            if (redefinableElement.isRedefinitionContextValid(redefinedElement)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 30, UML2Plugin.INSTANCE.getString("_UI_RedefinableElement_RedefinitionContextValid_diagnostic", RedefinableElementOperations.getMessageSubstitutions(context, redefinableElement, redefinedElement)), new Object[]{redefinableElement, redefinedElement}));
        }
        return result;
    }

    public static boolean validateRedefinitionConsistent(RedefinableElement redefinableElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator redefinedElements = redefinableElement.getRedefinedElements().iterator();
        while (redefinedElements.hasNext()) {
            RedefinableElement redefinedElement = (RedefinableElement)redefinedElements.next();
            if (redefinedElement.isConsistentWith(redefinableElement)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 31, UML2Plugin.INSTANCE.getString("_UI_RedefinableElement_RedefinitionConsistent_diagnostic", RedefinableElementOperations.getMessageSubstitutions(context, redefinableElement, redefinedElement)), new Object[]{redefinableElement, redefinedElement}));
        }
        return result;
    }

    public static boolean isConsistentWith(RedefinableElement redefinableElement, RedefinableElement redefinee) {
        return false;
    }

    public static boolean isRedefinitionContextValid(RedefinableElement redefinableElement, RedefinableElement redefinable) {
        EList redefinableRedefinitionContexts = redefinable.getRedefinitionContexts();
        Iterator redefinitionContexts = redefinableElement.getRedefinitionContexts().iterator();
        while (redefinitionContexts.hasNext()) {
            Set redefinitionContextAllParents = ((Classifier)redefinitionContexts.next()).allParents();
            Iterator i = redefinableRedefinitionContexts.iterator();
            while (i.hasNext()) {
                Classifier redefinableRedefinitionContext = (Classifier)i.next();
                if (!redefinitionContextAllParents.contains(redefinableRedefinitionContext)) continue;
                return true;
            }
        }
        return false;
    }
}

