/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.text;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.connector.text.StringToDateTranslator;
import com.metamatrix.connector.text.TextConnection;
import com.metamatrix.connector.text.TextPlugin;
import com.metamatrix.connector.text.TextUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.SynchQueryExecution;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICompoundCriteria;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.IIsNullCriteria;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.INotCriteria;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.Group;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TextSynchExecution
implements SynchQueryExecution {
    private IQuery cmd;
    private int maxBatchSize;
    private Connection txtConn;
    private Map metadataProps;
    private ConnectorLogger logger;
    private RuntimeMetadata rm;
    private Properties groupProps = null;
    private StringToDateTranslator stringToDateTranslator;
    private int readerQueueIndex = 0;
    private ArrayList readerQueue = new ArrayList();
    private BufferedReader currentreader = null;
    private int lineNum = 0;
    private List colWidths = new ArrayList();
    private int numModeledColumns = 0;
    private boolean useModeledColumnCntedit = false;
    private List headerRow = null;
    private boolean canceled;
    private int rowsProduced = 0;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Date;

    public TextSynchExecution(Connection txtConn, RuntimeMetadata metadata) {
        this.txtConn = txtConn;
        this.rm = metadata;
        this.logger = ((TextConnection)txtConn).logger;
        this.metadataProps = ((TextConnection)txtConn).metadataProps;
    }

    public void execute(IQuery query, int maxBatchSize) throws ConnectorException {
        this.cmd = query;
        this.maxBatchSize = maxBatchSize;
        Object translatedRequest = this.translateRequest((ICommand)this.cmd);
        Object response = this.submitRequest(translatedRequest);
        this.translateResults(response, (ICommand)this.cmd);
    }

    public Batch nextBatch() throws ConnectorException {
        BasicBatch fetchedBatch = new BasicBatch();
        if (!this.canceled) {
            IQuery query = this.cmd;
            ISelect select = query.getSelect();
            ICriteria criteria = query.getWhere();
            int startRow = 1;
            int endRow = 0;
            if (query.getLimit() != null) {
                startRow = query.getLimit().getRowOffset() + 1;
                endRow = query.getLimit().getRowLimit() + query.getLimit().getRowOffset();
            }
            String location = null;
            try {
                int[] cols = this.getSelectCols(select.getSelectSymbols());
                Class[] types = this.getSelectTypes(select.getSelectSymbols());
                location = this.groupProps.getProperty("LOCATION");
                String delimiter = this.groupProps.getProperty("DELIMITER");
                String qualifier = this.groupProps.getProperty("QUALIFIER");
                String topLines = this.groupProps.getProperty("SKIPHEADERLINES");
                boolean hasQualifier = false;
                if (qualifier != null && qualifier.length() > 0) {
                    hasQualifier = true;
                }
                int numTop = 0;
                if (topLines != null) {
                    numTop = Integer.parseInt(topLines);
                }
                int rowsAddedToBatch = 0;
                while (rowsAddedToBatch < this.maxBatchSize) {
                    BufferedReader br = this.getCurrentReader();
                    if (br == null) {
                        fetchedBatch.setLast();
                    } else {
                        String line = br.readLine();
                        if (line == null) {
                            this.advanceToNextReader();
                            this.lineNum = 0;
                            continue;
                        }
                        if (hasQualifier) {
                            while (StringUtil.occurrences((String)line, (String)qualifier) % 2 != 0) {
                                String nextLine = br.readLine();
                                if (nextLine != null) {
                                    line = line + StringUtil.LINE_SEPARATOR + nextLine;
                                    continue;
                                }
                                Object[] params = new Object[]{line};
                                String msg = TextPlugin.Util.getString("TextSynchExecution.Text_has_no_determined_ending_qualifier", params);
                                this.logger.logError(msg);
                                throw new ConnectorException(msg);
                            }
                        }
                        ++this.lineNum;
                        if (line.length() == 0 || numTop >= this.lineNum) continue;
                        List record = this.getRecord(line, delimiter, qualifier, this.colWidths);
                        if (criteria != null && !this.satisfiesCriteria(criteria, record) || ++this.rowsProduced < startRow) continue;
                        if (this.useModeledColumnCntedit && record.size() != this.numModeledColumns) {
                            Object[] params = new Object[]{new Integer(this.numModeledColumns), new Integer(record.size())};
                            String msg = TextPlugin.Util.getString("TextSynchExecution.Input_column_cnt_incorrect", params);
                            this.logger.logError(msg);
                            throw new ConnectorException(msg);
                        }
                        this.saveResult((Batch)fetchedBatch, record, cols, types);
                        ++rowsAddedToBatch;
                        if (this.rowsProduced != endRow) continue;
                        fetchedBatch.setLast();
                    }
                    break;
                }
            }
            catch (ConnectorException ce) {
                throw ce;
            }
            catch (Throwable e) {
                Object[] params = new Object[]{location, e.getMessage()};
                this.logger.logError(TextPlugin.Util.getString("TextSynchExecution.Error_reading_text_file", params), e);
                throw new ConnectorException(e, "Error while reading text file: " + location);
            }
        }
        return fetchedBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedReader getCurrentReader() throws ConnectorException {
        if (this.currentreader == null && this.readerQueueIndex < this.readerQueue.size()) {
            ArrayList arrayList = this.readerQueue;
            synchronized (arrayList) {
                this.currentreader = (BufferedReader)this.readerQueue.get(this.readerQueueIndex);
            }
            String line = null;
            String location = this.groupProps.getProperty("LOCATION");
            String delimiter = this.groupProps.getProperty("DELIMITER");
            String qualifier = this.groupProps.getProperty("QUALIFIER");
            String topLines = this.groupProps.getProperty("SKIPHEADERLINES");
            String headerLine = this.groupProps.getProperty("HEADERLINE");
            int numTop = 0;
            int headerRowNum = 0;
            if (topLines != null && topLines.length() > 0) {
                numTop = Integer.parseInt(topLines);
            }
            if (headerLine != null && headerLine.length() > 0) {
                headerRowNum = Integer.parseInt(headerLine);
            }
            if (numTop > 0) {
                if (headerRowNum > numTop) {
                    Object[] params = new Object[]{"HEADERLINE", new Integer(headerRowNum), new Integer(numTop)};
                    String msg = TextPlugin.Util.getString("TextSynchExecution.Property_contains_an_invalid_value_Using_value", params);
                    this.logger.logWarning(msg);
                    headerRowNum = numTop;
                }
                try {
                    boolean hasQualifier = false;
                    if (qualifier != null && qualifier.length() > 0) {
                        hasQualifier = true;
                    }
                    while (this.currentreader != null) {
                        line = this.currentreader.readLine();
                        if (line == null) {
                            this.advanceToNextReader();
                            this.lineNum = 0;
                            return this.getCurrentReader();
                        }
                        if (hasQualifier) {
                            while (StringUtil.occurrences((String)line, (String)qualifier) % 2 != 0) {
                                String nextLine = this.currentreader.readLine();
                                if (nextLine != null) {
                                    line = line + StringUtil.LINE_SEPARATOR + nextLine;
                                    continue;
                                }
                                Object[] params = new Object[]{line};
                                String msg = TextPlugin.Util.getString("TextSynchExecution.Text_has_no_determined_ending_qualifier", params);
                                this.logger.logError(msg);
                                throw new ConnectorException(msg);
                            }
                        }
                        ++this.lineNum;
                        if (line.length() == 0) continue;
                        if (headerRowNum > 0 && headerRowNum == this.lineNum || numTop == this.lineNum) {
                            this.headerRow = this.getRecord(line, delimiter, qualifier, this.colWidths);
                            break;
                        }
                        if (numTop < this.lineNum) continue;
                    }
                }
                catch (Throwable e) {
                    Object[] params = new Object[]{location, e.getMessage()};
                    this.logger.logError(TextPlugin.Util.getString("TextSynchExecution.Error_reading_text_file", params), e);
                    throw new ConnectorException(e, "Error while reading text file: " + location);
                }
            }
        }
        return this.currentreader;
    }

    private void advanceToNextReader() {
        this.currentreader = null;
        ++this.readerQueueIndex;
    }

    public void close() {
        if (this.readerQueue.size() > 0) {
            Iterator it = this.readerQueue.iterator();
            while (it.hasNext()) {
                BufferedReader br = (BufferedReader)it.next();
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.readerQueue.clear();
        this.canceled = true;
        this.logger.logInfo("TextSynchExecution is successfully closed.");
    }

    public void cancel() {
        if (this.readerQueue.size() > 0) {
            Iterator it = this.readerQueue.iterator();
            while (it.hasNext()) {
                BufferedReader br = (BufferedReader)it.next();
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.readerQueue.clear();
        this.canceled = true;
        this.logger.logInfo("TextSynchExecution is cancelled on command.");
    }

    protected Object translateRequest(ICommand request) throws ConnectorException {
        if (request == null) {
            throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Request_is_null"));
        }
        if (this.cmd == null) {
            Object[] params = new Object[]{this.cmd};
            throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Error_translating_request", params));
        }
        IQuery query = (IQuery)request;
        IFrom from = query.getFrom();
        IGroup group = (IGroup)from.getItems().get(0);
        try {
            int i;
            String groupName = group.getMetadataID().getFullName();
            Map metadataMap = this.metadataProps;
            this.groupProps = (Properties)metadataMap.get(groupName.toUpperCase());
            if (this.groupProps == null) {
                Object[] params = new Object[]{groupName};
                throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Error_obtain_properties_for_group", params));
            }
            try {
                this.createReaders(this.groupProps, groupName);
            }
            catch (IOException ex) {
                Object[] params = new Object[]{groupName, ex.getMessage()};
                throw new ConnectorException((Throwable)ex, TextPlugin.Util.getString("TextSynchExecution.Unable_get_Reader", params));
            }
            List elementIDs = group.getMetadataID().getChildIDs();
            this.numModeledColumns = elementIDs.size();
            int[] colWidthArray = new int[elementIDs.size()];
            for (i = 0; i < colWidthArray.length; ++i) {
                Element element = (Element)this.rm.getObject((MetadataID)elementIDs.get(i));
                colWidthArray[this.getColumn((Element)element)] = element.getLength();
            }
            for (i = 0; i < colWidthArray.length; ++i) {
                this.colWidths.add(new Integer(colWidthArray[i]));
            }
        }
        catch (ConnectorException e) {
            Object[] params = new Object[]{query, e.getMessage()};
            throw new ConnectorException((Throwable)e, TextPlugin.Util.getString("TextSynchExecution.Cannot_be_translated_by_the_TextTranslator.", params));
        }
        return request;
    }

    protected Object submitRequest(Object req) {
        Properties connprops = ((TextConnection)this.txtConn).connectorProps;
        this.metadataProps.put("CONNECTOR_PROPERTIES", connprops);
        String cnt_edit = (String)connprops.get("EnforceColumnCount");
        if (cnt_edit != null && cnt_edit.equalsIgnoreCase(Boolean.TRUE.toString())) {
            this.useModeledColumnCntedit = true;
        }
        return this.metadataProps;
    }

    protected void translateResults(Object response, ICommand cmd) throws ConnectorException, ConnectorException {
        if (!(response instanceof Map)) {
            throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Not_of_type_Map"));
        }
        IFrom from = ((IQuery)cmd).getFrom();
        List groups = from.getItems();
        IGroup symbol = (IGroup)groups.get(0);
        Group group = (Group)this.rm.getObject(symbol.getMetadataID());
        String groupName = group.getMetadataID().getFullName();
        Map metadataMap = (Map)response;
        Properties connProps = (Properties)metadataMap.get("CONNECTOR_PROPERTIES");
        if (connProps.get("DateResultFormats") != null) {
            this.stringToDateTranslator = new StringToDateTranslator(connProps, this.logger);
        }
        this.groupProps = (Properties)metadataMap.get(groupName.toUpperCase());
        if (this.groupProps == null) {
            Object[] params = new Object[]{groupName};
            throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Error_obtain_properties_for_group", params));
        }
        this.performQuery(this.groupProps, groupName);
    }

    private void performQuery(Properties props, String groupName) throws ConnectorException {
        try {
            this.createReaders(props, groupName);
        }
        catch (IOException ex) {
            Object[] params = new Object[]{groupName, ex.getMessage()};
            throw new ConnectorException((Throwable)ex, TextPlugin.Util.getString("TextSynchExecution.Unable_get_Reader", params));
        }
    }

    private void createReaders(Properties props, String groupName) throws IOException, ConnectorException {
        if (this.readerQueue != null && this.readerQueue.size() > 0) {
            return;
        }
        String fileName = props.getProperty("FILE");
        if (fileName != null) {
            File datafile = new File(fileName);
            File[] files = TextUtil.getFiles(fileName);
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    File f = files[i];
                    this.addReader(f.getName(), f);
                }
            } else {
                this.addReader(fileName, datafile);
            }
        } else {
            String urlName = props.getProperty("URL");
            if (urlName == null) {
                Object[] params = new Object[]{groupName};
                throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Unable_get_Reader_for_group", params));
            }
            URL url = new URL(urlName);
            URLConnection conn = url.openConnection();
            conn.connect();
            InputStreamReader inSR = new InputStreamReader(conn.getInputStream());
            this.addReader(fileName, inSR);
        }
    }

    private synchronized void addReader(String fileName, File datafile) throws IOException {
        FileInputStream fis = new FileInputStream(datafile);
        InputStreamReader inSR = new InputStreamReader(fis);
        BufferedReader r = new BufferedReader(inSR);
        this.logger.logInfo("Reading file: " + fileName);
        this.readerQueue.add(r);
    }

    private void addReader(String fileName, InputStreamReader inSr) throws IOException {
        BufferedReader r = new BufferedReader(inSr);
        this.logger.logInfo("Reading URL: " + fileName);
        this.readerQueue.add(r);
    }

    private int[] getSelectCols(List vars) throws ConnectorException {
        int[] cols = new int[vars.size()];
        for (int i = 0; i < vars.size(); ++i) {
            cols[i] = this.getColumn((ISelectSymbol)vars.get(i));
        }
        return cols;
    }

    private Class[] getSelectTypes(List vars) throws ConnectorException {
        Class[] types = new Class[vars.size()];
        for (int i = 0; i < vars.size(); ++i) {
            ISelectSymbol symbol = (ISelectSymbol)vars.get(i);
            try {
                Element element = this.getElementFromSymbol(symbol);
                types[i] = element.getJavaType();
                continue;
            }
            catch (ConnectorException e) {
                throw new ConnectorException((Throwable)e);
            }
        }
        return types;
    }

    private int getColumn(ISelectSymbol symbol) throws ConnectorException {
        return this.getColumn(this.getElementFromSymbol(symbol));
    }

    private Element getElementFromSymbol(ISelectSymbol symbol) throws ConnectorException {
        IElement expr = (IElement)symbol.getExpression();
        MetadataID elementID = expr.getMetadataID();
        return (Element)this.rm.getObject(elementID);
    }

    private int getColumn(Element elem) throws ConnectorException {
        String colStr = null;
        try {
            colStr = elem.getNameInSource();
        }
        catch (ConnectorException e) {
            throw new ConnectorException((Throwable)e);
        }
        try {
            return Integer.parseInt(colStr);
        }
        catch (NumberFormatException e) {
            if (colStr == null) {
                colStr = elem.getMetadataID().getName();
            }
            if (this.headerRow == null) {
                this.getCurrentReader();
            }
            if (this.headerRow != null) {
                for (int i = 0; i < this.headerRow.size(); ++i) {
                    if (colStr.compareToIgnoreCase((String)this.headerRow.get(i)) != 0) continue;
                    return i;
                }
                throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Column_not_found_in_header_row", new Object[]{colStr, elem.getMetadataID().getFullName()}));
            }
            throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Invalid_column_number", new Object[]{colStr, elem.getMetadataID().getFullName()}));
        }
    }

    private List getRecord(String line, String delimiter, String qualifier, List colWidths) throws Exception {
        if (delimiter != null) {
            return this.parseDelimitedLine(line, delimiter, qualifier);
        }
        return this.parseFixedWidthLine(line, colWidths);
    }

    private List parseDelimitedLine(String line, String delimiter, String qualifier) throws Exception {
        if (qualifier == null || qualifier.trim().length() == 0) {
            int newIndex;
            ArrayList strs = new ArrayList();
            int index = -1;
            while ((newIndex = line.indexOf(delimiter, index)) >= 0) {
                if (index >= 0) {
                    TextSynchExecution.addUnqualifiedColumnToList(strs, line.substring(index, newIndex));
                } else {
                    TextSynchExecution.addUnqualifiedColumnToList(strs, line.substring(0, newIndex));
                }
                index = newIndex + 1;
            }
            if (index >= 0) {
                TextSynchExecution.addUnqualifiedColumnToList(strs, line.substring(index));
            } else {
                TextSynchExecution.addUnqualifiedColumnToList(strs, line);
            }
            return strs;
        }
        char delimChar = delimiter.charAt(0);
        char qualChar = qualifier.charAt(0);
        char spaceChar = " ".charAt(0);
        ArrayList<String> columns = new ArrayList<String>();
        int charIndex = 0;
        int totalChars = line.length();
        while (charIndex < totalChars) {
            char c = line.charAt(charIndex);
            if (c == delimChar) {
                TextSynchExecution.addUnqualifiedColumnToList(columns, null);
                ++charIndex;
            } else if (c == qualChar) {
                int endQualIndex = charIndex;
                while (true) {
                    if ((endQualIndex = line.indexOf(qualChar, endQualIndex + 1)) < 0) {
                        Object[] params = new Object[]{"" + (columns.size() + 1), line};
                        throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Text_has_no_ending_qualifier", params));
                    }
                    if (line.length() <= endQualIndex + 1 || line.charAt(endQualIndex + 1) != qualChar) break;
                    ++endQualIndex;
                }
                columns.add(line.substring(charIndex + 1, endQualIndex));
                charIndex = endQualIndex + 1;
                if (charIndex < totalChars && line.charAt(charIndex) != delimChar) {
                    Object[] params = new Object[]{"" + (columns.size() + 1), line};
                    String msg = TextPlugin.Util.getString("TextSynchExecution.Text_file_must_have_delimiter", params);
                    this.logger.logError(msg);
                    throw new ConnectorException(msg);
                }
                ++charIndex;
            } else if (c == spaceChar) {
                ++charIndex;
            } else {
                int endColIndex = line.indexOf(delimChar, charIndex);
                if (endColIndex < 0) {
                    TextSynchExecution.addUnqualifiedColumnToList(columns, line.substring(charIndex));
                    break;
                }
                TextSynchExecution.addUnqualifiedColumnToList(columns, line.substring(charIndex, endColIndex));
                charIndex = endColIndex + 1;
            }
            if (charIndex != totalChars) continue;
            TextSynchExecution.addUnqualifiedColumnToList(columns, null);
        }
        return columns;
    }

    private static void addUnqualifiedColumnToList(List list, String col) {
        if (col == null || col.length() == 0) {
            list.add(null);
        } else {
            list.add(col);
        }
    }

    private List parseFixedWidthLine(String line, List colWidths) throws ConnectorException {
        int length = line.length();
        ArrayList<String> fields = new ArrayList<String>(colWidths.size());
        Iterator iter = colWidths.iterator();
        int current = 0;
        while (iter.hasNext()) {
            try {
                String colValue;
                int width = (Integer)iter.next();
                if (width <= 0) {
                    throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Column_length_must_be_positive"));
                }
                int end = current + width;
                if (end > length) {
                    end = length;
                }
                if ((colValue = line.substring(current, end).trim()).length() == 0) {
                    fields.add(null);
                } else {
                    fields.add(colValue);
                }
                current += width;
            }
            catch (Exception e) {
                fields.add(null);
            }
        }
        return fields;
    }

    private boolean satisfiesCriteria(ICriteria criteria, List record) throws ConnectorException {
        if (criteria instanceof ICompoundCriteria) {
            return this.satisfiesCriteria((ICompoundCriteria)criteria, record);
        }
        if (criteria instanceof ILikeCriteria) {
            return this.satisfiesCriteria((ILikeCriteria)criteria, record);
        }
        if (criteria instanceof IInCriteria) {
            return this.satisfiesCriteria((IInCriteria)criteria, record);
        }
        if (criteria instanceof ICompareCriteria) {
            return this.satisfiesCriteria((ICompareCriteria)criteria, record);
        }
        if (criteria instanceof IIsNullCriteria) {
            return this.satisfiesCriteria((IIsNullCriteria)criteria, record);
        }
        if (criteria instanceof INotCriteria) {
            return this.satisfiesCriteria((INotCriteria)criteria, record);
        }
        Object[] params = new Object[]{criteria.getClass()};
        throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Got_unknown_type_of_criteria", params));
    }

    private boolean satisfiesCriteria(ICompoundCriteria criteria, List record) throws ConnectorException {
        int type = criteria.getOperator();
        List crits = criteria.getCriteria();
        for (int i = 0; i < crits.size(); ++i) {
            ICriteria subCrit = (ICriteria)crits.get(i);
            boolean subVal = this.satisfiesCriteria(subCrit, record);
            if (!subVal && type == 0) {
                return false;
            }
            if (!subVal || type != 1) continue;
            return true;
        }
        return type == 0;
    }

    private boolean satisfiesCriteria(INotCriteria criteria, List record) throws ConnectorException {
        return !this.satisfiesCriteria(criteria.getCriteria(), record);
    }

    private boolean satisfiesCriteria(ICompareCriteria criteria, List record) throws ConnectorException {
        IExpression lExpression = criteria.getLeftExpression();
        IExpression rExpression = criteria.getRightExpression();
        if (!(lExpression instanceof IElement) && !(rExpression instanceof IElement)) {
            Object[] params = new Object[]{criteria};
            throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Functions_not_supported._14", params));
        }
        IElement symbol = null;
        boolean leftExpr = true;
        if (lExpression instanceof IElement) {
            symbol = (IElement)lExpression;
        } else {
            leftExpr = false;
            symbol = (IElement)rExpression;
        }
        MetadataID elementID = symbol.getMetadataID();
        Class dataValueType = null;
        Element elem = null;
        try {
            elem = (Element)this.rm.getObject(elementID);
            dataValueType = elem.getJavaType();
        }
        catch (ConnectorException e) {
            throw new ConnectorException((Throwable)e);
        }
        int col = this.getColumn(elem);
        String recordValue = (String)record.get(col);
        Object value = this.convertString(recordValue, dataValueType);
        IExpression literalExpr = null;
        literalExpr = leftExpr ? rExpression : lExpression;
        if (literalExpr instanceof ILiteral) {
            Object compareValue = ((ILiteral)literalExpr).getValue();
            if (value == null || compareValue == null) {
                return false;
            }
            if (!dataValueType.equals(compareValue.getClass())) {
                Object[] params = new Object[]{criteria};
                throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Values_of_different_types", params));
            }
            int comparison = 0;
            Comparable comparable = (Comparable)value;
            comparison = comparable.compareTo(compareValue);
            switch (criteria.getOperator()) {
                case 0: {
                    return comparison == 0;
                }
                case 1: {
                    return comparison != 0;
                }
                case 4: {
                    return comparison > 0;
                }
                case 5: {
                    return comparison >= 0;
                }
                case 2: {
                    return comparison < 0;
                }
                case 3: {
                    return comparison <= 0;
                }
            }
            Object[] params = new Object[]{"" + criteria.getOperator()};
            throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Unknown_compare_criteria_type", params));
        }
        Object[] params = new Object[]{criteria};
        throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Joins_and_Functions_not_supported._18", params));
    }

    private boolean satisfiesCriteria(ILikeCriteria criteria, List record) throws ConnectorException {
        IElement element = (IElement)criteria.getLeftExpression();
        MetadataID elementID = element.getMetadataID();
        Element elem = null;
        try {
            elem = (Element)this.rm.getObject(elementID);
        }
        catch (ConnectorException e) {
            throw new ConnectorException((Throwable)e);
        }
        int col = this.getColumn(elem);
        String recordValue = (String)record.get(col);
        IExpression rExpression = criteria.getRightExpression();
        if (rExpression instanceof ILiteral) {
            Object compareValue = ((ILiteral)rExpression).getValue();
            if (compareValue != null) {
                String compareValueString = compareValue.toString();
                if (recordValue == null) {
                    return false;
                }
                return this.isMatched(recordValue, compareValueString, "%");
            }
            return recordValue == null;
        }
        Object[] params = new Object[]{rExpression};
        throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.The_expression_cannot_be_used_as_criteria", params));
    }

    private boolean isMatched(String recordValue, String expression, String delimiter) {
        ArrayList<String> strArray = new ArrayList<String>();
        int index1 = -1;
        int delimiterNum = 0;
        while (index1 < expression.length()) {
            if (expression.indexOf(delimiter, index1 + 1) < 0) {
                if (index1 >= expression.length() - 1) break;
                strArray.add(expression.substring(index1 + 1, expression.length()));
                break;
            }
            ++delimiterNum;
            int index2 = expression.indexOf(delimiter, index1 + 1);
            if (index2 - index1 > 1) {
                strArray.add(expression.substring(index1 + 1, index2));
            }
            index1 = index2;
        }
        if (delimiterNum == 0) {
            return expression.equals(recordValue);
        }
        index1 = -1;
        for (int i = 0; i < strArray.size(); ++i) {
            index1 = recordValue.indexOf((String)strArray.get(i), index1 + 1);
            if (index1 < 0) {
                return false;
            }
            index1 = index1 + ((String)strArray.get(i)).length() - 1;
        }
        if (!expression.startsWith(delimiter) && !recordValue.startsWith((String)strArray.get(0))) {
            return false;
        }
        return expression.endsWith(delimiter) || recordValue.endsWith((String)strArray.get(strArray.size() - 1));
    }

    private boolean satisfiesCriteria(IInCriteria criteria, List record) throws ConnectorException {
        IExpression expression = criteria.getLeftExpression();
        if (!(expression instanceof IElement)) {
            Object[] params = new Object[]{criteria};
            throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Functions_in_criteria_not_supported._20", params));
        }
        MetadataID elementID = ((IElement)expression).getMetadataID();
        Class dataValueType = null;
        Element elem = null;
        try {
            elem = (Element)this.rm.getObject(elementID);
            dataValueType = elem.getJavaType();
        }
        catch (ConnectorException e) {
            throw new ConnectorException((Throwable)e);
        }
        int col = this.getColumn(elem);
        String recordValue = (String)record.get(col);
        if (recordValue == null) {
            return false;
        }
        Object value = this.convertString(recordValue, dataValueType);
        List expressions = criteria.getRightExpressions();
        Iterator iterator = expressions.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof ILiteral) {
                Object critValue = ((ILiteral)obj).getValue();
                if (!value.equals(critValue)) continue;
                return true;
            }
            Object[] params = new Object[]{criteria};
            throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Functions_in_set_criteria_not_supported._21", params));
        }
        return false;
    }

    private boolean satisfiesCriteria(IIsNullCriteria criteria, List record) throws ConnectorException {
        IElement symbol = (IElement)criteria.getExpression();
        MetadataID elementID = symbol.getMetadataID();
        Element elem = null;
        try {
            elem = (Element)this.rm.getObject(elementID);
        }
        catch (ConnectorException e) {
            throw new ConnectorException((Throwable)e);
        }
        int col = this.getColumn(elem);
        String recordValue = (String)record.get(col);
        return recordValue == null;
    }

    private void saveResult(Batch batch, List record, int[] columns, Class[] types) throws ConnectorException {
        ArrayList<Object> newRecord = new ArrayList<Object>(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            int column = columns[i];
            String value = (String)record.get(column);
            Class type = types[i];
            newRecord.add(this.convertString(value, type));
        }
        batch.addRow(newRecord);
    }

    private Object convertString(String value, Class type) throws ConnectorException {
        block7: {
            if (value == null) {
                return null;
            }
            if (type == (class$java$lang$String == null ? (class$java$lang$String = TextSynchExecution.class$("java.lang.String")) : class$java$lang$String)) {
                return value;
            }
            if (type == (class$java$sql$Date == null ? (class$java$sql$Date = TextSynchExecution.class$("java.sql.Date")) : class$java$sql$Date)) {
                try {
                    return DateFormat.getInstance().parse(value);
                }
                catch (ParseException e) {
                    if (this.stringToDateTranslator == null || !this.stringToDateTranslator.hasFormatters()) break block7;
                    try {
                        return this.stringToDateTranslator.translateStringToDate(value);
                    }
                    catch (ParseException ex) {
                        Object[] params = new Object[]{ex.getMessage()};
                        throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Unable_translate_String_to_Date", params));
                    }
                }
            }
        }
        return this.translateResultObject(value, type);
    }

    private Object translateResultObject(String value, Class dataType) throws ConnectorException {
        if (value == null) {
            return null;
        }
        Transform transform = DataTypeManager.getTransform(value.getClass(), (Class)dataType);
        if (transform == null) {
            Object[] params = new Object[]{dataType.getName()};
            throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Unable_get_Tranform", params));
        }
        Object transformedValue = null;
        try {
            transformedValue = transform.transform((Object)value);
        }
        catch (TransformationException e) {
            Object[] params = new Object[]{value, dataType.getName()};
            throw new ConnectorException(TextPlugin.Util.getString("TextSynchExecution.Unable_to_transform_value", params));
        }
        return transformedValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

