/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class RuleMergeCriteria
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, MetaMatrixComponentException {
        ArrayList criteriaChains = new ArrayList();
        this.findCriteriaChains(plan, criteriaChains);
        Iterator chainIter = criteriaChains.iterator();
        while (chainIter.hasNext()) {
            PlanNode critNode = (PlanNode)chainIter.next();
            this.mergeChain(critNode);
        }
        return plan;
    }

    void findCriteriaChains(PlanNode root, List foundNodes) throws QueryPlannerException, MetaMatrixComponentException {
        PlanNode recurseRoot = root;
        if (this.isCriteria(root)) {
            while (this.isCriteria(recurseRoot)) {
                recurseRoot = recurseRoot.getLastChild();
            }
            if (recurseRoot.getParent() != root) {
                foundNodes.add(root);
            }
        }
        if (recurseRoot.getChildCount() > 0) {
            List children = recurseRoot.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                this.findCriteriaChains(child, foundNodes);
            }
        }
    }

    boolean isCriteria(PlanNode critNode) {
        Boolean isHaving;
        return critNode.getType() == 13 && ((isHaving = (Boolean)critNode.getProperty(NodeConstants.Info.IS_HAVING)) == null || isHaving.equals(Boolean.FALSE));
    }

    void mergeChain(PlanNode chainRoot) {
        HashSet<Object> critParts = new HashSet<Object>();
        List subqueryPlans = null;
        List subqueryValueProviders = null;
        List correlatedReferences = null;
        PlanNode current = chainRoot;
        while (this.isCriteria(current)) {
            critParts.add(current.getProperty(NodeConstants.Info.SELECT_CRITERIA));
            subqueryPlans = RuleMergeCriteria.addProperties(subqueryPlans, (List)current.getProperty(NodeConstants.Info.SUBQUERY_PLANS));
            subqueryValueProviders = RuleMergeCriteria.addProperties(subqueryValueProviders, (List)current.getProperty(NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS));
            correlatedReferences = RuleMergeCriteria.addProperties(correlatedReferences, (List)current.getProperty(NodeConstants.Info.CORRELATED_REFERENCES));
            PlanNode last = current;
            current = current.getLastChild();
            if (last == chainRoot) continue;
            NodeEditor.removeChildNode(last.getParent(), last);
        }
        Criteria combinedCrit = null;
        if (critParts.size() == 1) {
            combinedCrit = (Criteria)critParts.iterator().next();
        } else {
            CompoundCriteria compCrit = new CompoundCriteria();
            compCrit.setOperator(0);
            Iterator critIter = critParts.iterator();
            while (critIter.hasNext()) {
                Criteria critPart = (Criteria)critIter.next();
                compCrit.addCriteria(critPart);
            }
            combinedCrit = compCrit;
        }
        chainRoot.setProperty(NodeConstants.Info.SELECT_CRITERIA, combinedCrit);
        if (subqueryPlans != null) {
            chainRoot.setProperty(NodeConstants.Info.SUBQUERY_PLANS, subqueryPlans);
        }
        if (subqueryValueProviders != null) {
            chainRoot.setProperty(NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS, subqueryValueProviders);
        }
        if (correlatedReferences != null) {
            chainRoot.setProperty(NodeConstants.Info.CORRELATED_REFERENCES, correlatedReferences);
        }
        chainRoot.getGroups().clear();
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)combinedCrit, (boolean)true);
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol element = (ElementSymbol)elementIter.next();
            chainRoot.addGroup(element.getGroupSymbol());
        }
    }

    private static List addProperties(List props, List addToProps) {
        if (addToProps != null) {
            if (props == null) {
                props = new ArrayList();
            }
            props.addAll(addToProps);
        }
        return props;
    }

    public String toString() {
        return "MergeCriteria";
    }
}

