/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.service;

import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.platform.server.ClientConnectionImpl;
import com.metamatrix.common.messaging.VMMessageBus;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.db.model.component.MetabaseRepositoryShredderComponent;
import com.metamatrix.metamodels.db.model.component.MetabaseRepositoryShredderConfigSource;
import com.metamatrix.metamodels.db.model.component.PropertyConfigSourceImpl;
import com.metamatrix.metamodels.db.model.pool.ConnectionPool;
import com.metamatrix.metamodels.db.model.pool.ConnectionPoolImpl;
import com.metamatrix.metamodels.db.platform.api.DBPlatformPlugin;
import com.metamatrix.metamodels.db.platform.api.IndexingServiceInterface;
import com.metamatrix.platform.resource.MessageReceiver;
import com.metamatrix.platform.service.controller.AbstractService;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class IndexingService
extends AbstractService
implements IndexingServiceInterface {
    private MetabaseRepositoryShredderComponent shredder;
    private Map sessionToClientConnection = Collections.synchronizedMap(new HashMap());

    public void initForTest(Properties props) throws Exception {
        this.initService(props);
    }

    protected void initService(Properties props) throws Exception {
        ArgCheck.isNotNull((Object)props);
        ConnectionPoolImpl pool = new ConnectionPoolImpl(props);
        PropertyConfigSourceImpl config = new PropertyConfigSourceImpl(props);
        this.shredder = new MetabaseRepositoryShredderComponent((MetabaseRepositoryShredderConfigSource)config, (ConnectionPool)pool, new VMMessageBus());
        this.shredder.initialize(props);
        this.shredder.start();
    }

    protected void closeService() throws Exception {
        this.shredder.stop();
    }

    protected void waitForServiceToClear() throws Exception {
    }

    protected void killService() {
        try {
            this.shredder.stop();
        }
        catch (ApplicationLifecycleException e) {
            Object[] params = new String[]{};
            DBPlatformPlugin.Util.log(4, (Throwable)e, DBPlatformPlugin.Util.getString("ModelShredderService.Failed_while_stopping_the_ModelShredderService._1", params));
        }
    }

    public void send(Message message, String messageKey, Object clientIdentifier) throws RemoteException {
        ClientConnection clientConn = (ClientConnection)this.sessionToClientConnection.get(clientIdentifier);
        this.shredder.receive(clientConn, message, messageKey);
    }

    public Message send(Message message, Object clientIdentifier) throws ApplicationException, RemoteException {
        ClientConnection clientConn = (ClientConnection)this.sessionToClientConnection.get(clientIdentifier);
        return this.shredder.receive(clientConn, message);
    }

    public void setMessageReceiver(MessageReceiver receiver, Properties props, Object clientIdentifier) throws RemoteException {
        ClientConnectionImpl clientConn = new ClientConnectionImpl(receiver, props);
        this.sessionToClientConnection.put(clientIdentifier, clientConn);
    }

    public void clientShutdown(Object clientIdentifier) throws RemoteException {
        ClientConnection clientConn = (ClientConnection)this.sessionToClientConnection.get(clientIdentifier);
        this.sessionToClientConnection.remove(clientIdentifier);
        this.shredder.connectionRemoved(clientConn);
    }
}

