/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.plantree;

import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlanNode {
    private int type;
    private PlanNode parent;
    private LinkedList children = new LinkedList();
    private Map nodeProperties;
    private Set groups = new HashSet();
    private static final String TAB = "  ";

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public PlanNode getParent() {
        return this.parent;
    }

    public void setParent(PlanNode parent) {
        this.parent = parent;
    }

    public List getChildren() {
        return this.children;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public PlanNode getFirstChild() {
        if (this.getChildren() != null && this.getChildCount() > 0) {
            return (PlanNode)this.children.getFirst();
        }
        return null;
    }

    public PlanNode getLastChild() {
        if (this.getChildren() != null && this.getChildCount() > 0) {
            return (PlanNode)this.children.getLast();
        }
        return null;
    }

    public void addFirstChild(PlanNode child) {
        this.children.addFirst(child);
    }

    public void addLastChild(PlanNode child) {
        this.children.addLast(child);
    }

    public void addChildren(List otherChildren) {
        this.children.addAll(otherChildren);
    }

    public boolean removeChild(PlanNode child) {
        return this.children.remove(child);
    }

    public Object getProperty(Object propertyID) {
        if (this.nodeProperties == null) {
            return null;
        }
        return this.nodeProperties.get(propertyID);
    }

    public void setProperty(Object propertyID, Object value) {
        if (this.nodeProperties == null) {
            this.nodeProperties = new HashMap();
        }
        this.nodeProperties.put(propertyID, value);
    }

    public void removeProperty(Object propertyID) {
        if (this.nodeProperties == null) {
            return;
        }
        this.nodeProperties.remove(propertyID);
    }

    public boolean hasProperty(Object propertyID) {
        return this.getProperty(propertyID) != null;
    }

    public boolean hasCollectionProperty(Object propertyID) {
        Collection value = (Collection)this.getProperty(propertyID);
        return value != null && !value.isEmpty();
    }

    public void addGroup(GroupSymbol groupID) {
        this.groups.add(groupID);
    }

    public void addGroups(Collection groups) {
        this.groups.addAll(groups);
    }

    public Set getGroups() {
        return this.groups;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        this.getRecursiveString(str, 0);
        return str.toString();
    }

    public String nodeToString() {
        StringBuffer str = new StringBuffer();
        this.getNodeString(str);
        return str.toString();
    }

    private void setTab(StringBuffer str, int tabStop) {
        for (int i = 0; i < tabStop; ++i) {
            str.append(TAB);
        }
    }

    void getRecursiveString(StringBuffer str, int tabLevel) {
        this.setTab(str, tabLevel);
        this.getNodeString(str);
        str.append(")\n");
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            PlanNode child = (PlanNode)iter.next();
            child.getRecursiveString(str, tabLevel + 1);
        }
    }

    void getNodeString(StringBuffer str) {
        str.append(NodeConstants.getNodeTypeString(this.type));
        str.append("(groups=");
        str.append(this.groups);
        if (this.nodeProperties != null) {
            str.append(", props=");
            str.append(this.nodeProperties);
        }
    }

    public boolean hasBooleanProperty(Object propertyKey) {
        return Boolean.TRUE.equals(this.getProperty(propertyKey));
    }
}

