/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime;

import com.metamatrix.common.cache.ObjectCache;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.TransactionMgr;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.NoOpMessageBus;
import com.metamatrix.common.messaging.VMMessageBus;
import com.metamatrix.common.vdb.api.VDBInfo;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.dqp.service.metadata.QueryMetadataCache;
import com.metamatrix.dqp.service.metadata.SingletonMetadataCacheHolder;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.VDBTreeUtility;
import com.metamatrix.metadata.runtime.api.MetadataSourceAPI;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseMetadata;
import com.metamatrix.metadata.runtime.event.RuntimeMetadataEvent;
import com.metamatrix.metadata.runtime.event.RuntimeMetadataListener;
import com.metamatrix.metadata.runtime.exception.InvalidStateException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseDoesNotExistException;
import com.metamatrix.metadata.runtime.exception.VirtualDatabaseException;
import com.metamatrix.metadata.runtime.model.BasicObjectCacheFactory;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseMetadata;
import com.metamatrix.metadata.runtime.model.MetadataCache;
import com.metamatrix.metadata.runtime.model.UpdateController;
import com.metamatrix.metadata.runtime.spi.MetaBaseConnector;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeImpl;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RuntimeMetadataCatalog {
    private static ObjectCache vdbModelsCache = null;
    private static UpdateController controller = null;
    private static boolean isInit = false;
    private static ObjectCache vdbMetadataCache = null;
    private static TransactionMgr transMgr = null;
    private static Properties allProps;
    private static MessageBus messageBus;
    private static Object initControl;
    private static boolean persist;
    private static MetadataCache systemModels;
    static /* synthetic */ Class class$com$metamatrix$metadata$runtime$event$RuntimeMetadataEvent;

    public static EventObjectListener registerRuntimeMetadataListener(RuntimeMetadataListener listener) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        try {
            VDBListener elistener = new VDBListener(listener);
            messageBus.addListener(class$com$metamatrix$metadata$runtime$event$RuntimeMetadataEvent == null ? (class$com$metamatrix$metadata$runtime$event$RuntimeMetadataEvent = RuntimeMetadataCatalog.class$("com.metamatrix.metadata.runtime.event.RuntimeMetadataEvent")) : class$com$metamatrix$metadata$runtime$event$RuntimeMetadataEvent, (EventObjectListener)elistener);
            return elistener;
        }
        catch (Exception e) {
            String msg = RuntimeMetadataPlugin.Util.getString("RuntimeMetadataCatalog.Error_adding_listener");
            RuntimeMetadataPlugin.Util.log(4, (Throwable)e, msg);
            throw new VirtualDatabaseException(msg);
        }
    }

    public static void removeRuntimeMetadataListener(EventObjectListener listener) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        try {
            messageBus.removeListener(class$com$metamatrix$metadata$runtime$event$RuntimeMetadataEvent == null ? (class$com$metamatrix$metadata$runtime$event$RuntimeMetadataEvent = RuntimeMetadataCatalog.class$("com.metamatrix.metadata.runtime.event.RuntimeMetadataEvent")) : class$com$metamatrix$metadata$runtime$event$RuntimeMetadataEvent, listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void buildVDBTree(String vdbName, String vdbVersion, PermissionDataNodeImpl rootNode, ObjectIDFactory idFactory) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        VirtualDatabaseID vdbID = null;
        vdbID = RuntimeMetadataCatalog.getVirtualDatabaseID(vdbName, vdbVersion);
        VirtualDatabaseMetadata vDBMetadata = RuntimeMetadataCatalog.getVirtualDatabaseMetadata(vdbID, true);
        VDBTreeUtility.buildDataNodeTree((PermissionDataNodeImpl)rootNode, (ObjectIDFactory)idFactory, (VirtualDatabaseMetadata)vDBMetadata);
    }

    public static VirtualDatabase createVirtualDatabase(VDBInfo vdbInfo, String userName, Object vdbIndexFile) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        VirtualDatabase vdb = RuntimeMetadataCatalog.getUpdateController().createVirtualDatabase(vdbInfo, userName, vdbIndexFile);
        RuntimeMetadataCatalog.fireEvent(vdb.getVirtualDatabaseID(), 5);
        return vdb;
    }

    public static VirtualDatabaseMetadata getVirtualDatabaseMetadata(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        return RuntimeMetadataCatalog.getVirtualDatabaseMetadata(vdbID, true);
    }

    private static VirtualDatabaseMetadata getVirtualDatabaseMetadata(VirtualDatabaseID vdbID, boolean includeMetadata) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        LogManager.logTrace((String)"RUNTIME_METADATA", (Object[])new Object[]{"Creating new BasicVirtualDatabaseMetadata instance for VDB ID \"", vdbID, ")", "\""});
        BasicVirtualDatabaseMetadata vDBMetadata = new BasicVirtualDatabaseMetadata(RuntimeMetadataCatalog.loadVDB(vdbID, includeMetadata), vdbID);
        return vDBMetadata;
    }

    /*
     * Unable to fully structure code
     */
    public static VirtualDatabaseID getActiveVirtualDatabaseID(String vdbName, String vdbVersion) throws VirtualDatabaseDoesNotExistException, VirtualDatabaseException {
        block11: {
            if (vdbName == null) {
                throw new IllegalArgumentException(RuntimeMetadataPlugin.Util.getString("ERR.008.001.0001"));
            }
            RuntimeMetadataCatalog.init();
            conn = null;
            vdbID = null;
            try {
                conn = RuntimeMetadataCatalog.getReadTransaction();
                vdbID = conn.getActiveVirtualDatabaseID(vdbName, vdbVersion);
                var6_4 = null;
                ** if (conn == null) goto lbl-1000
            }
            catch (Throwable var5_9) {
                var6_5 = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e2) {
                        I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
                    }
                }
                throw var5_9;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (ManagedConnectionException e) {
                    I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.001.0002", (Throwable)e, (Object[])new Object[]{vdbName});
                    throw new VirtualDatabaseException((Exception)e, "ERR.008.001.0002", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0002", (Object)vdbName));
                }
            }
        }
        if (vdbID == null) {
            throw new VirtualDatabaseDoesNotExistException("ERR.008.001.0003", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0003", (Object)vdbName, (Object)vdbVersion));
        }
        return vdbID;
    }

    /*
     * Unable to fully structure code
     */
    public static VirtualDatabaseID getVirtualDatabaseID(String vdbName, String vdbVersion) throws VirtualDatabaseDoesNotExistException, VirtualDatabaseException {
        block11: {
            if (vdbName == null) {
                throw new IllegalArgumentException(RuntimeMetadataPlugin.Util.getString("ERR.008.001.0001"));
            }
            RuntimeMetadataCatalog.init();
            conn = null;
            vdbID = null;
            try {
                conn = RuntimeMetadataCatalog.getReadTransaction();
                vdbID = conn.getVirtualDatabaseID(vdbName, vdbVersion);
                var6_4 = null;
                ** if (conn == null) goto lbl-1000
            }
            catch (Throwable var5_9) {
                var6_5 = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e2) {
                        I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
                    }
                }
                throw var5_9;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    conn.close();
                }
                catch (Exception e2) {
                    I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (ManagedConnectionException e) {
                    I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.001.0002", (Throwable)e, (Object[])new Object[]{vdbName});
                    throw new VirtualDatabaseException((Exception)e, "ERR.008.001.0002", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0002", (Object)vdbName));
                }
            }
        }
        if (vdbID == null) {
            throw new VirtualDatabaseDoesNotExistException("ERR.008.001.0003", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0003", (Object)vdbName, (Object)(vdbVersion == null ? "NoVersion" : vdbVersion)));
        }
        return vdbID;
    }

    public static void setVDBStatus(VirtualDatabaseID virtualDBID, short status, String userName) throws VirtualDatabaseException {
        if (!persist) {
            return;
        }
        try {
            RuntimeMetadataCatalog.init();
            RuntimeMetadataCatalog.getUpdateController().setVBDStatus(virtualDBID, status, userName);
            switch (status) {
                case 1: 
                case 2: {
                    RuntimeMetadataCatalog.removeFromMetadataCache(virtualDBID);
                    RuntimeMetadataCatalog.fireEvent(virtualDBID, 4);
                }
            }
        }
        catch (InvalidStateException ie) {
            throw new VirtualDatabaseException((Exception)((Object)ie), "ERR.008.001.0004", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0004", (Object)virtualDBID.getName()));
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getVirtualDatabases() throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        MetaBaseConnector conn = null;
        conn = RuntimeMetadataCatalog.getReadTransaction();
        Collection vdbs = conn.getVirtualDatabases();
        Object var4_2 = null;
        if (conn == null) return vdbs;
        try {
            conn.close();
            return vdbs;
        }
        catch (Exception e2) {
            I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
        }
        return vdbs;
        {
            catch (ManagedConnectionException e) {
                I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.001.0005", (Throwable)e);
                throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.001.0005", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0005"));
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (Exception e2) {
                I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
            }
            throw throwable;
        }
    }

    public static byte[] getVDBArchive(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        byte[] archive = null;
        VirtualDatabase vdb = RuntimeMetadataCatalog.getVirtualDatabase(vdbID);
        archive = RuntimeMetadataCatalog.getUpdateController().getVDBArchive(vdb.getFileName());
        return archive;
    }

    public static byte[] getSystemVDBArchive() throws VirtualDatabaseException {
        return RuntimeMetadataCatalog.getUpdateController().getVDBArchive("System.vdb");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VirtualDatabase getVirtualDatabase(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        MetaBaseConnector conn = null;
        conn = RuntimeMetadataCatalog.getReadTransaction();
        VirtualDatabase vdb = conn.getVirtualDatabase(vdbID);
        Object var5_3 = null;
        if (conn == null) return vdb;
        try {
            conn.close();
            return vdb;
        }
        catch (Exception e2) {
            I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
        }
        return vdb;
        {
            catch (ManagedConnectionException e) {
                I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.001.0006", (Throwable)e, (Object[])new Object[]{vdbID.getName()});
                throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.001.0006", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0006", (Object)vdbID.getName()));
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (Exception e2) {
                I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Collection getDeletedVirtualDatabaseIDs() throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        MetaBaseConnector conn = null;
        conn = RuntimeMetadataCatalog.getReadTransaction();
        Collection vdbs = conn.getDeletedVirtualDatabaseIDs();
        Object var4_2 = null;
        if (conn == null) return vdbs;
        try {
            conn.close();
            return vdbs;
        }
        catch (Exception e2) {
            I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
        }
        return vdbs;
        {
            catch (ManagedConnectionException e) {
                I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.001.0007", (Throwable)e);
                throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.001.0007", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0007"));
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (Exception e2) {
                I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
            }
            throw throwable;
        }
    }

    public static void deleteVirtualDatabase(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        if (persist) {
            RuntimeMetadataCatalog.getUpdateController().deleteVirtualDatabase(vdbID);
            RuntimeMetadataCatalog.fireEvent(vdbID, 2);
        }
        RuntimeMetadataCatalog.removeFromCache(vdbID);
    }

    public static void refreshProperties() throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
    }

    public static Collection getModels(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        Map modelMap = RuntimeMetadataCatalog.getModelMap(vdbID);
        ArrayList models = new ArrayList(modelMap.size());
        models.addAll(modelMap.values());
        return models;
    }

    public static List getMutiSourcedModels(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        ArrayList<String> models = null;
        Map modelMap = RuntimeMetadataCatalog.getModelMap(vdbID);
        if (modelMap != null && modelMap.size() > 0) {
            models = new ArrayList<String>(modelMap.size());
            Iterator it = modelMap.keySet().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                Model m = (Model)modelMap.get(o);
                if (!m.isMultiSourceBindingEnabled()) continue;
                models.add(m.getFullName());
            }
        }
        if (models == null) {
            return Collections.EMPTY_LIST;
        }
        return models;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map getModelMap(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        HashMap<String, Model> modelMap = null;
        MetaBaseConnector conn = null;
        Object v = vdbModelsCache.find((Object)vdbID);
        if (v != null) {
            LogManager.logTrace((String)"RUNTIME_METADATA", (String)("VDB " + vdbID + " is in cache"));
            vdbModelsCache.mark((Object)vdbID, v);
            return (HashMap<String, Model>)v;
        }
        LogManager.logTrace((String)"RUNTIME_METADATA", (String)("VDB " + vdbID + " is NOT in cache"));
        conn = RuntimeMetadataCatalog.getReadTransaction();
        Collection models = conn.getModels(vdbID);
        modelMap = new HashMap<String, Model>(models.size());
        Iterator it = models.iterator();
        while (it.hasNext()) {
            Model m = (Model)it.next();
            modelMap.put(m.getName(), m);
        }
        vdbModelsCache.mark((Object)vdbID, modelMap);
        Object var8_8 = null;
        if (conn == null) return modelMap;
        try {
            conn.close();
            return modelMap;
        }
        catch (Exception e2) {
            I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
        }
        return modelMap;
        {
            catch (ManagedConnectionException e) {
                I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.001.0009", (Throwable)e, (Object[])new Object[]{vdbID.getName()});
                throw new VirtualDatabaseException((Exception)((Object)e), "ERR.008.001.0009", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0009", (Object)vdbID.getName()));
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (Exception e2) {
                I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0001", (Throwable)e2);
            }
            throw throwable;
        }
    }

    public static boolean isVisible(String resourcePath, VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        VirtualDatabaseMetadata vdbm = RuntimeMetadataCatalog.getVirtualDatabaseMetadata(vdbID, false);
        return vdbm.isVisible(resourcePath);
    }

    public static Model getModel(String modelName, VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        Map modelMap = RuntimeMetadataCatalog.getModelMap(vdbID);
        if (modelMap.containsKey(modelName)) {
            Model m = (Model)modelMap.get(modelName);
            return m;
        }
        VirtualDatabaseMetadata vdbm = RuntimeMetadataCatalog.getVirtualDatabaseMetadata(vdbID, false);
        if (vdbm != null) {
            return vdbm.getModel(modelName);
        }
        return null;
    }

    public static void setConnectorBindingNames(VirtualDatabaseID vdbID, Map modelAndCBNames, String userName) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        Collection models = RuntimeMetadataCatalog.getModels(vdbID);
        HashMap cNamesByIDs = new HashMap();
        Iterator iter = modelAndCBNames.keySet().iterator();
        ModelID mID = null;
        try {
            while (iter.hasNext()) {
                String mName = (String)iter.next();
                if (modelAndCBNames.get(mName) == null) continue;
                Iterator mIter = models.iterator();
                while (mIter.hasNext() && !(mID = (ModelID)((Model)mIter.next()).getID()).getFullName().equalsIgnoreCase(mName)) {
                }
                if (mID == null) {
                    throw new VirtualDatabaseException("ERR.008.001.0010", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0010", (Object)mName, (Object)vdbID.getName()));
                }
                List bindings = (List)modelAndCBNames.get(mName);
                Iterator bit = bindings.iterator();
                while (bit.hasNext()) {
                    String bRouting = (String)bit.next();
                    if (CurrentConfiguration.getConfiguration().getConnectorBindingByRoutingID(bRouting) != null) continue;
                    throw new VirtualDatabaseException(RuntimeMetadataPlugin.Util.getString("RuntimeMetadataCatalog.No_connector_binding_found", new Object[]{mName, bRouting}));
                }
                cNamesByIDs.put(mID, modelAndCBNames.get(mName));
            }
        }
        catch (ConfigurationException ce) {
            throw new VirtualDatabaseException((Exception)((Object)ce));
        }
        RuntimeMetadataCatalog.getUpdateController().setConnectorBindingNames(vdbID, cNamesByIDs, userName);
        RuntimeMetadataCatalog.refreshCache(vdbID);
        RuntimeMetadataCatalog.fireEvent(vdbID, 1);
    }

    public static void updateVirtualDatabase(VirtualDatabase vdb, String userName) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        RuntimeMetadataCatalog.getUpdateController().updateVirtualDatabase(vdb, userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() throws VirtualDatabaseException {
        Object object = initControl;
        synchronized (object) {
            if (isInit) {
                return;
            }
            allProps = RuntimeMetadataCatalog.getProperties();
            I18nLogManager.logCritical((String)"RUNTIME_METADATA", (String)"MSG.008.000.0001");
            transMgr = RuntimeMetadataCatalog.getTransactionMgr(allProps);
            I18nLogManager.logCritical((String)"RUNTIME_METADATA", (String)"MSG.008.001.0001");
            messageBus = new VMMessageBus();
            try {
                VDBListener l = new VDBListener();
                messageBus.addListener(class$com$metamatrix$metadata$runtime$event$RuntimeMetadataEvent == null ? (class$com$metamatrix$metadata$runtime$event$RuntimeMetadataEvent = RuntimeMetadataCatalog.class$("com.metamatrix.metadata.runtime.event.RuntimeMetadataEvent")) : class$com$metamatrix$metadata$runtime$event$RuntimeMetadataEvent, (EventObjectListener)l);
            }
            catch (Exception e) {
                I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.001.0013");
                messageBus = new NoOpMessageBus();
            }
            I18nLogManager.logCritical((String)"RUNTIME_METADATA", (String)"MSG.008.001.0002");
            BasicObjectCacheFactory factory = new BasicObjectCacheFactory();
            vdbMetadataCache = factory.createObjectCache("vdbIDs", RuntimeMetadataCatalog.getCacheProperties(allProps));
            vdbModelsCache = factory.createObjectCache("vdbModels", RuntimeMetadataCatalog.getCacheProperties(allProps));
            controller = new UpdateController(transMgr, messageBus);
            RuntimeMetadataCatalog.loadSystemMetadataCache();
            I18nLogManager.logCritical((String)"RUNTIME_METADATA", (String)"MSG.008.001.0003");
            isInit = true;
        }
    }

    public static QueryMetadataInterface getQueryMetadata(VirtualDatabaseID vdbID) throws VirtualDatabaseException {
        RuntimeMetadataCatalog.init();
        QueryMetadataInterface qmi = RuntimeMetadataCatalog.getQueryMetadataCache().lookupMetadata(vdbID.getName(), vdbID.getVersion());
        if (qmi == null) {
            try {
                return RuntimeMetadataCatalog.getQueryMetadataCache().lookupMetadata(vdbID.getName(), vdbID.getVersion(), RuntimeMetadataCatalog.getVDBArchive(vdbID));
            }
            catch (Exception e) {
                throw new VirtualDatabaseException(e);
            }
        }
        return qmi;
    }

    public static QueryMetadataCache getQueryMetadataCache() throws VirtualDatabaseException {
        try {
            QueryMetadataCache sharedCache = null;
            sharedCache = SingletonMetadataCacheHolder.hasCache() ? SingletonMetadataCacheHolder.getMetadataCache() : SingletonMetadataCacheHolder.getMetadataCache((byte[])RuntimeMetadataCatalog.getSystemVDBArchive());
            return sharedCache;
        }
        catch (Exception e) {
            throw new VirtualDatabaseException(e);
        }
    }

    private static synchronized void refreshCache(VirtualDatabaseID vdbID) {
        try {
            RuntimeMetadataCatalog.removeFromCache(vdbID);
            RuntimeMetadataCatalog.getModels(vdbID);
            RuntimeMetadataCatalog.getQueryMetadata(vdbID);
        }
        catch (VirtualDatabaseException e) {
            I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.001.0009", (Throwable)e, (Object[])new Object[]{vdbID.getName()});
        }
    }

    private static synchronized void removeFromCache(VirtualDatabaseID vdbID) {
        LogManager.logTrace((String)"RUNTIME_METADATA", (String)("VDB " + vdbID + " is being removed from cache"));
        try {
            RuntimeMetadataCatalog.getQueryMetadataCache().removeFromCache(vdbID.getName(), vdbID.getVersion());
        }
        catch (Exception e) {
            I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"Error trying to get QueryMetadataCache", (Throwable)e);
        }
        RuntimeMetadataCatalog.removeFromMetadataCache(vdbID);
    }

    private static synchronized void removeFromMetadataCache(VirtualDatabaseID vdbID) {
        LogManager.logTrace((String)"RUNTIME_METADATA", (String)("VDB " + vdbID + " is being removed from cache"));
        vdbMetadataCache.remove((Object)vdbID);
        vdbModelsCache.remove((Object)vdbID);
        System.gc();
    }

    public static synchronized void clearCache() throws VirtualDatabaseException {
        LogManager.logTrace((String)"RUNTIME_METADATA", (String)"VDB cache is being cleared");
        RuntimeMetadataCatalog.init();
        vdbMetadataCache.clear();
        vdbModelsCache.clear();
        RuntimeMetadataCatalog.getQueryMetadataCache().clearCache();
        System.gc();
    }

    private static Properties getProperties() throws VirtualDatabaseException {
        Properties prop = new Properties();
        try {
            Properties resourceProps = CurrentConfiguration.getResourceProperties("RuntimeMetadata");
            Properties runtimeProps = CurrentConfiguration.getProperties();
            String value = runtimeProps.getProperty("metamatrix.metadata.runtime.persist");
            if (value != null) {
                persist = Boolean.valueOf(value);
            }
            prop.putAll((Map<?, ?>)runtimeProps);
            prop.putAll((Map<?, ?>)resourceProps);
        }
        catch (ConfigurationException ice) {
            I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0003", (Throwable)ice);
            throw new VirtualDatabaseException("ERR.008.000.0003", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0003"));
        }
        RuntimeMetadataCatalog.addProperty(prop, "metamatrix.metadata.runtime.connection.Factory", prop, "metamatrix.common.connection.transaction.factory");
        prop.put("metamatrix.metadata.runtime.cache.object.policyFactory", "com.metamatrix.common.cache.mru.MRUObjectCachePolicyFactory");
        prop.put("metamatrix.metadata.runtime.cache.object.recaptureMode", "SeparateThread");
        return prop;
    }

    private static TransactionMgr getTransactionMgr(Properties props) throws VirtualDatabaseException {
        TransactionMgr aTransMgr = null;
        try {
            aTransMgr = new TransactionMgr(props, "RuntimeMetadata");
        }
        catch (Throwable e) {
            I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.001.0017", (Throwable)e);
            throw new VirtualDatabaseException("ERR.008.001.0017", RuntimeMetadataPlugin.Util.getString("ERR.008.001.0017"));
        }
        return aTransMgr;
    }

    protected static void setTransactionManager(TransactionMgr transactionMgr) {
        transMgr = transactionMgr;
    }

    private static Properties getCacheProperties(Properties allProperties) {
        Properties properties = new Properties();
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.policyFactory", properties, "com.metamatrix.common.cache.ObjectCache.PolicyFactory");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.recaptureMode", properties, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureMode");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.maximumCapacity", properties, "com.metamatrix.common.cache.ObjectCache.MaximumCapacity");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.maximumCost", properties, "com.metamatrix.common.cache.ObjectCache.MaximumCost");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.maximumAge", properties, "com.metamatrix.common.cache.ObjectCache.MaximumAge");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.recaptureFraction", properties, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureFraction");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.recaptureInterval", properties, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureInterval");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.recaptureIntervalRate", properties, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalRate");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.recaptureIntervalCeiling", properties, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalCeiling");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.recaptureIntervalIncrement", properties, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalIncrement");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.recaptureIntervalDecrement", properties, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalDecrement");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.helper", properties, "com.metamatrix.common.cache.ObjectCache.CacheHelper");
        RuntimeMetadataCatalog.addProperty(allProperties, "metamatrix.metadata.runtime.cache.object.costCalculator", properties, "com.metamatrix.common.cache.ObjectCache.CostCalculatorClass");
        return properties;
    }

    private static UpdateController getUpdateController() {
        return controller;
    }

    private static void addProperty(Properties source, String sourceName, Properties props, String propName) {
        String value = source.getProperty(sourceName);
        if (value != null) {
            props.setProperty(propName, value);
        }
    }

    private static void fireEvent(VirtualDatabaseID vdbID, int type) {
        if (messageBus != null) {
            try {
                messageBus.processEvent((EventObject)new RuntimeMetadataEvent(new RuntimeMetadataSource(), vdbID, type));
            }
            catch (Exception e) {
                I18nLogManager.logError((String)"RUNTIME_METADATA", (String)"ERR.008.000.0002", (Throwable)e);
            }
        }
    }

    private static MetaBaseConnector getReadTransaction() throws ManagedConnectionException {
        return (MetaBaseConnector)transMgr.getReadTransaction();
    }

    private static MetadataSourceAPI loadVDB(VirtualDatabaseID vdbID, boolean includeMetadata) throws VirtualDatabaseException {
        MetadataCache mc = null;
        Object v = vdbMetadataCache.find((Object)vdbID);
        if (v != null) {
            vdbMetadataCache.mark((Object)vdbID, v);
            mc = (MetadataCache)v;
            if (includeMetadata && !mc.isModelDetailsLoaded()) {
                mc.loadModelDetails();
            }
        } else {
            VirtualDatabase vdb = RuntimeMetadataCatalog.getVirtualDatabase(vdbID);
            Collection models = RuntimeMetadataCatalog.getModels(vdbID);
            byte[] vdbcontents = RuntimeMetadataCatalog.getVDBArchive(vdbID);
            mc = new MetadataCache();
            mc.init(vdb, models, includeMetadata, vdbcontents, systemModels.getModelMap());
            vdbMetadataCache.mark((Object)vdbID, (Object)mc);
            LogManager.logTrace((String)"RUNTIME_METADATA", (String)("Creating MetadataCache for " + vdbID));
        }
        return mc;
    }

    private static void loadSystemMetadataCache() throws VirtualDatabaseException {
        byte[] systemvdb = RuntimeMetadataCatalog.getSystemVDBArchive();
        MetadataCache mc = new MetadataCache();
        mc.initSystemVDB("System.vdb", "1", systemvdb);
        systemModels = mc;
        LogManager.logTrace((String)"RUNTIME_METADATA", (String)"Creating MetadataCache for systemVDB");
    }

    private static void processEvent(RuntimeMetadataEvent event) {
        if (event.getSource() == null) {
            if (event.refreshModels()) {
                VirtualDatabaseID vdbID = event.getVirtualDatabaseID();
                RuntimeMetadataCatalog.refreshCache(vdbID);
            } else if (event.deleteVDB()) {
                RuntimeMetadataCatalog.removeFromCache(event.getVirtualDatabaseID());
            } else if (event.clearCacheForVDB()) {
                RuntimeMetadataCatalog.removeFromMetadataCache(event.getVirtualDatabaseID());
            }
        }
    }

    private RuntimeMetadataCatalog() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$000(RuntimeMetadataEvent x0) {
        RuntimeMetadataCatalog.processEvent(x0);
    }

    static {
        initControl = new Object();
        persist = true;
        systemModels = null;
    }

    private static class RuntimeMetadataSource
    implements Serializable {
        private RuntimeMetadataSource() {
        }
    }
}

