/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.symbol;

import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.AbstractCaseExpression;
import com.metamatrix.query.sql.symbol.Expression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CaseExpression
extends AbstractCaseExpression {
    private Expression expression = null;
    private List when = null;

    public CaseExpression(Expression expression, List when, List then) {
        this.setExpression(expression);
        this.setWhen(when, then);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0035"));
        }
        this.expression = expr;
    }

    public int getWhenCount() {
        return this.when == null ? 0 : this.when.size();
    }

    public List getWhen() {
        return this.when;
    }

    public Expression getWhenExpression(int index) {
        return (Expression)this.when.get(index);
    }

    public void setWhen(List when, List then) {
        if (when == null || then == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0036"));
        }
        if (when.size() != then.size() || when.size() < 1) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0036"));
        }
        for (int i = 0; i < when.size(); ++i) {
            if (!(when.get(i) instanceof Expression)) {
                throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0037"));
            }
            if (then.get(i) instanceof Expression) continue;
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0038"));
        }
        if (this.when != when) {
            this.when = Collections.unmodifiableList(when);
        }
        this.setThen(then);
    }

    public boolean isResolved() {
        if (!this.expression.isResolved()) {
            return false;
        }
        for (int i = 0; i < this.getWhenCount(); ++i) {
            if (this.when.get(i) != null && !((Expression)this.when.get(i)).isResolved()) {
                return false;
            }
            if (this.getThen().get(i) == null || ((Expression)this.getThen().get(i)).isResolved()) continue;
            return false;
        }
        if (this.getElseExpression() != null && !this.getElseExpression().isResolved()) {
            return false;
        }
        return this.getType() != null;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        Expression expr = (Expression)this.expression.clone();
        int whenCount = this.getWhenCount();
        ArrayList<Object> whenCopy = new ArrayList<Object>(whenCount);
        ArrayList<Object> thenCopy = new ArrayList<Object>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whenCopy.add(this.getWhenExpression(i).clone());
            thenCopy.add(this.getThenExpression(i).clone());
        }
        Expression elseExpr = this.getElseExpression();
        if (elseExpr != null) {
            elseExpr = (Expression)elseExpr.clone();
        }
        CaseExpression copy = new CaseExpression(expr, whenCopy, thenCopy);
        copy.setType(this.getType());
        copy.setElseExpression(elseExpr);
        return copy;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CaseExpression)) {
            return false;
        }
        CaseExpression other = (CaseExpression)obj;
        return this.getExpression().equals(other.getExpression()) && ((Object)this.when).equals(other.when);
    }
}

