/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.data.pool.CredentialMap;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMServerConnection;
import com.metamatrix.jdbc.transport.MultiTransportFactory;
import com.metamatrix.jdbc.util.MMJDBCURL;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MMDriver
implements BaseDriver {
    static final String JDBC = "jdbc:";
    static final String URL_PREFIX = "jdbc:metamatrix";
    static final int MAJOR_VERSION = 5;
    static final int MINOR_VERSION = 0;
    static final String DRIVER_NAME = "MetaMatrix JDBC Driver";
    static final String HOST_PORT_PATTERN = "[\\p{Alnum}\\.\\-]+:\\d+";
    static final String URL_PATTERN = "jdbc:metamatrix:(\\w+)@((mm[s]?://[\\p{Alnum}\\.\\-]+:\\d+(,[\\p{Alnum}\\.\\-]+:\\d+)*)[;]?){1}((.*)*)";
    static Pattern urlPattern;
    static MultiTransportFactory CONNECTION_FACTORY;
    private static MMDriver singleton;

    public static MMDriver getInstance() {
        return singleton;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        MMServerConnection myConnection = null;
        info = info == null ? new Properties() : PropertiesUtils.clone(info);
        if (this.acceptsURL(url)) {
            try {
                this.parseURL(url, info);
                myConnection = this.createMMConnection(url, info);
            }
            catch (MetaMatrixCoreException e) {
                DriverManager.println(e.getMessage());
                throw MMSQLException.create(e, e.getMessage());
            }
        } else {
            String msg = JDBCPlugin.Util.getString("MMDriver.urlFormat");
            throw new MMSQLException(msg);
        }
        String logMsg = JDBCPlugin.Util.getString("MMDriver.Connection_sucess");
        myConnection.getLogger().log(4, logMsg);
        return myConnection;
    }

    MMServerConnection createMMConnection(String url, Properties info) throws ConnectionException, CommunicationException {
        String transport = MMDriver.setupTransport(info);
        ServerConnection serverConn = CONNECTION_FACTORY.establishConnection(transport, info);
        MMServerConnection connection = MMServerConnection.newInstance(serverConn, info, url);
        return connection;
    }

    static String setupTransport(Properties info) {
        return "Socket";
    }

    void parseURL(String url, Properties info) throws SQLException {
        block12: {
            if (url == null) {
                String msg = JDBCPlugin.Util.getString("MMDriver.urlFormat");
                throw new MMSQLException(msg);
            }
            try {
                Object[] params;
                String value;
                MMJDBCURL jdbcURL = new MMJDBCURL(url);
                MMURL mmURL = new MMURL(jdbcURL.getConnectionURL());
                info.setProperty("VirtualDatabaseName", jdbcURL.getVDBName());
                info.setProperty("serverURL", mmURL.getAppServerURL());
                info.setProperty("host", mmURL.getHosts());
                info.setProperty("port", mmURL.getPorts());
                Properties optionalParams = jdbcURL.getProperties();
                MMJDBCURL.normalizeProperties(info);
                Enumeration<Object> keys = optionalParams.keys();
                while (keys.hasMoreElements()) {
                    String propName = (String)keys.nextElement();
                    if (info.containsKey(propName)) continue;
                    info.setProperty(propName, optionalParams.getProperty(propName));
                }
                if (optionalParams.containsKey("version") && !info.containsKey("VirtualDatabaseVersion")) {
                    info.setProperty("VirtualDatabaseVersion", optionalParams.getProperty("version"));
                }
                if (optionalParams.containsKey("logFile") && (value = optionalParams.getProperty("logFile")) != null) {
                    try {
                        File f = new File(value);
                        boolean exists = f.exists();
                        FileWriter fw = new FileWriter(f, true);
                        fw.close();
                        if (!exists) {
                            f.delete();
                        }
                    }
                    catch (IOException ioe) {
                        String msg = JDBCPlugin.Util.getString("MMDriver.Invalid_log_name", value);
                        throw MMSQLException.create(ioe, msg);
                    }
                }
                if (!optionalParams.containsKey("logLevel")) break block12;
                try {
                    int loglevel = Integer.parseInt(optionalParams.getProperty("logLevel"));
                    if (loglevel < 0 || loglevel > 3) {
                        params = new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3)};
                        String msg = JDBCPlugin.Util.getString("MMDriver.Log_level_invalid", params);
                        throw new MMSQLException(msg);
                    }
                }
                catch (NumberFormatException nfe) {
                    params = new Object[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3)};
                    String msg = JDBCPlugin.Util.getString("MMDriver.Log_level_invalid", params);
                    throw MMSQLException.create(nfe, msg);
                }
            }
            catch (IllegalArgumentException iae) {
                String msg = JDBCPlugin.Util.getString("MMDriver.urlFormat");
                throw new MMSQLException(msg);
            }
        }
        this.createCredentialToken(info);
    }

    void createCredentialToken(Properties info) throws MMSQLException {
        if (info.containsKey("credentials")) {
            if (info.containsKey("clientToken")) {
                throw new MMSQLException(JDBCPlugin.Util.getString("MMDriver.Invalid_use_of_credentials_and_token"));
            }
            try {
                int parenIndex;
                String credentials = info.getProperty("credentials");
                CredentialMap credentialMap = null;
                boolean defaultToLogon = false;
                if (credentials.startsWith("defaultToLogon")) {
                    defaultToLogon = true;
                }
                credentialMap = (parenIndex = credentials.indexOf("(")) >= 0 ? CredentialMap.parseCredentials(credentials.substring(parenIndex)) : new CredentialMap();
                if (defaultToLogon) {
                    credentialMap.setDefaultCredentialMode((short)1);
                    HashMap<String, String> defaultCredentials = new HashMap<String, String>();
                    defaultCredentials.put("user", info.getProperty("user"));
                    defaultCredentials.put("password", info.getProperty("password"));
                    credentialMap.setDefaultCredentials(defaultCredentials);
                } else {
                    credentialMap.setDefaultCredentialMode((short)0);
                }
                info.put("clientToken", credentialMap);
            }
            catch (Exception e) {
                throw MMSQLException.create(e);
            }
            info.remove("credentials");
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        Matcher m = urlPattern.matcher(url);
        return m.matches();
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        this.parseURL(url, info);
        LinkedList<DriverPropertyInfo> driverProps = new LinkedList<DriverPropertyInfo>();
        if (info.getProperty("VirtualDatabaseVersion") == null) {
            driverProps.add(new DriverPropertyInfo("VirtualDatabaseVersion", null));
        }
        if (info.getProperty("user") == null) {
            driverProps.add(new DriverPropertyInfo("user", null));
        }
        if (info.getProperty("password") == null) {
            driverProps.add(new DriverPropertyInfo("password", null));
        }
        if (info.getProperty("logFile") == null) {
            driverProps.add(new DriverPropertyInfo("logFile", null));
        }
        if (info.getProperty("logLevel") == null) {
            driverProps.add(new DriverPropertyInfo("logLevel", null));
        }
        if (info.getProperty("txnAutoWrap") == null) {
            driverProps.add(new DriverPropertyInfo("txnAutoWrap", null));
        }
        if (info.getProperty("partialResultsMode") == null) {
            driverProps.add(new DriverPropertyInfo("partialResultsMode", null));
        }
        if (info.getProperty("resultSetCacheMode") == null) {
            driverProps.add(new DriverPropertyInfo("resultSetCacheMode", null));
        }
        if (info.getProperty("clientToken") == null) {
            driverProps.add(new DriverPropertyInfo("clientToken", null));
        }
        if (info.getProperty("socketsPerVM") == null) {
            driverProps.add(new DriverPropertyInfo("socketsPerVM", null));
        }
        if (info.getProperty("stickyConnections") == null) {
            driverProps.add(new DriverPropertyInfo("stickyConnections", null));
        }
        if (info.getProperty("allowDoubleQuotedVariable") == null) {
            driverProps.add(new DriverPropertyInfo("allowDoubleQuotedVariable", null));
        }
        if (info.getProperty("sqlOptions") == null) {
            driverProps.add(new DriverPropertyInfo("sqlOptions", null));
        }
        DriverPropertyInfo[] propInfo = new DriverPropertyInfo[driverProps.size()];
        return driverProps.toArray(propInfo);
    }

    public int getMajorVersion() {
        return 5;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getDriverName() {
        return DRIVER_NAME;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        String logMsg;
        urlPattern = Pattern.compile(URL_PATTERN);
        CONNECTION_FACTORY = new MultiTransportFactory();
        singleton = new MMDriver();
        try {
            ApplicationInfo info = ApplicationInfo.getInstance();
            info.setMainComponent("metamatrix-jdbc.jar");
            info.markUnmodifiable();
        }
        catch (Exception e) {
            logMsg = JDBCPlugin.Util.getString("MMDriver.Err_init_appinfo", e.getMessage());
            DriverManager.println(logMsg);
        }
        try {
            DriverManager.registerDriver(singleton);
        }
        catch (SQLException e) {
            logMsg = JDBCPlugin.Util.getString("MMDriver.Err_registering", e.getMessage());
            DriverManager.println(logMsg);
        }
    }
}

