#!/bin/sh

# Copyright  2000-2006 MetaMatrix, Inc.  All rights reserved.

### ---------------------------------------------------------
### -- Setting up the Java environment --
###    -------------------------------
### This script expects the developer to have his or her
### Java environment set in order to run.
###
### Typical Java environment setup on a Linux machine is:
###
### export JAVA_HOME = <JAVA_HOME>
### for example,
### $ export JAVA_HOME=/home/usr/jre1.5.0_06
###
### export PATH=<JAVA_HOME>/bin:$PATH
### for example,
### $ export PATH=$JAVA_HOME/bin:$PATH
### 
### ---------------------------------------------------------

if [ -z "$JAVA_HOME" ] ; then
        echo "Please set the JAVA_HOME environment variable for this script.  See script comments for details.";
        exit 127;
fi

TOOLS_PATCH=
MMEMBEDDED_HOME=./embedded
CLASSPATH=${TOOLS_PATCH}:${MMEMBEDDED_HOME}/license:${MMEMBEDDED_HOME}/jdbc/embedded-jdbc.jar:${MMEMBEDDED_HOME}/jdbc/bcprov-jdk14-122.jar:${MMEMBEDDED_HOME}/lib/embedded.jar:${MMEMBEDDED_HOME}/lib:./tools/lib/tools.jar:./tools/lib:${MMEMBEDDED_HOME}/extensions/jdbcconn.jar;

java -classpath ${CLASSPATH} -Xms64m -Xmx256m -Dquery.home=${MMEMBEDDED_HOME} -Dmmshell.dir=. -Dmetamatrix.config.none -Dmmshell.lib=${MMEMBEDDED_HOME}/extensions com.metamatrix.dqp.tools.mmshell.MMShell "$@"
