/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.xml.vdb.VdbHeader;
import com.metamatrix.internal.core.xml.vdb.VdbModelInfo;
import com.metamatrix.internal.core.xml.xmi.ModelImportInfo;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.internal.core.xml.xmi.XMIHeaderReader;
import com.metamatrix.internal.core.xml.xsd.XsdHeader;
import com.metamatrix.internal.core.xml.xsd.XsdHeaderReader;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ResourceFilter;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class WorkspaceResourceFinderUtil {
    protected static final String URI_REFERENCE_DELIMITER = "#";
    protected static final IResource[] EMPTY_IRESOURCE_ARRAY = new IResource[0];
    protected static final IPath[] EMPTY_IPATH_ARRAY = new IPath[0];
    private static final ResourceFilter VDB_RESOURCE_FILTER = new VdbResourceFilter();
    private static final String SCHEME_PLATFORM = "platform:";
    private static final String SCHEME_FILE = "file:";
    private static final String PLATFORM_RESOURCE_SEGMENT = "/resource";
    private static final char DEVICE_IDENTIFIER = ':';
    private static final String AUTHORITY_SEPARATOR = "//";
    private static final char SEGMENT_SEPARATOR = '/';
    protected static final String XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX = ModelerCore.XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX;
    protected static final String XML_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX = "XMLSchema.xsd";
    protected static final String XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX = "MagicXMLSchema.xsd";
    protected static final String XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI_SUFFIX = "XMLSchema-instance.xsd";
    public static final String UML_PRIMITIVE_TYPES_MODEL_FILE_NAME = "primitiveTypes.xmi";
    protected static final String UML_PRIMITIVE_TYPES_INTERNAL_URI = "http://www.metamatrix.com/metamodels/UmlPrimitiveTypes-instance";
    protected static final String UML_METAMODEL_URI = "pathmap://UML2_METAMODELS/UML2.metamodel.uml2";
    public static final String RELATIONSHIP_PRIMITIVE_TYPES_MODEL_FILE_NAME = "builtInRelationshipTypes.xmi";
    protected static final String RELATIONSHIP_PRIMITIVE_TYPES_INTERNAL_URI = "http://www.metamatrix.com/relationships/BuiltInRelationshipTypes-instance";

    public static IResource[] findIResourceByName(String name) {
        if (name == null || name.length() == 0 || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return EMPTY_IRESOURCE_ARRAY;
        }
        FileResourceCollectorVisitor visitor = new FileResourceCollectorVisitor();
        if (WorkspaceResourceFinderUtil.getWorkspace() != null && WorkspaceResourceFinderUtil.getWorkspace().getRoot() != null) {
            IProject[] projects = WorkspaceResourceFinderUtil.getWorkspace().getRoot().getProjects();
            for (int i2 = 0; i2 < projects.length; ++i2) {
                try {
                    projects[i2].accept((IResourceVisitor)visitor);
                    continue;
                }
                catch (CoreException e2) {
                    // empty catch block
                }
            }
        }
        boolean removeExtension = name.indexOf(46) == -1;
        IFile[] fileResources = visitor.getFileResources();
        ObjectVector tmp = new ObjectVector();
        for (int i3 = 0; i3 < fileResources.length; ++i3) {
            IPath path;
            IFile fileResource = fileResources[i3];
            if (fileResource == null || (path = fileResource.getFullPath()).lastSegment().charAt(0) == '.') continue;
            if (removeExtension) {
                path = path.removeFileExtension();
            }
            if (!name.equalsIgnoreCase(path.lastSegment())) continue;
            tmp.add((Object)fileResource);
        }
        if (tmp.size() == 0) {
            return EMPTY_IRESOURCE_ARRAY;
        }
        Object[] result = new IResource[tmp.size()];
        tmp.copyInto(result);
        return result;
    }

    public static IResource findIResourceByUUID(String stringifiedUuid) {
        int i2;
        if (StringUtil.isEmpty((String)stringifiedUuid) || !stringifiedUuid.startsWith("mmuuid") || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return null;
        }
        FileResourceCollectorVisitor visitor = new FileResourceCollectorVisitor();
        if (WorkspaceResourceFinderUtil.getWorkspace() != null && WorkspaceResourceFinderUtil.getWorkspace().getRoot() != null) {
            IProject[] projects = WorkspaceResourceFinderUtil.getWorkspace().getRoot().getProjects();
            for (i2 = 0; i2 < projects.length; ++i2) {
                try {
                    projects[i2].accept((IResourceVisitor)visitor);
                    continue;
                }
                catch (CoreException e2) {
                    // empty catch block
                }
            }
        }
        IFile[] fileResources = visitor.getFileResources();
        for (i2 = 0; i2 < fileResources.length; ++i2) {
            XMIHeader header;
            IFile iResource = fileResources[i2];
            if (iResource == null || ModelUtil.isXsdFile((IResource)iResource) || (header = ModelUtil.getXmiHeader((IResource)iResource)) == null || !stringifiedUuid.equals(header.getUUID())) continue;
            return iResource;
        }
        return null;
    }

    public static IResource findIResourceByPath(IPath workspacePath) {
        int i2;
        if (workspacePath == null || workspacePath.isEmpty() || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return null;
        }
        FileResourceCollectorVisitor visitor = new FileResourceCollectorVisitor();
        if (WorkspaceResourceFinderUtil.getWorkspace() != null && WorkspaceResourceFinderUtil.getWorkspace().getRoot() != null) {
            IProject[] projects = WorkspaceResourceFinderUtil.getWorkspace().getRoot().getProjects();
            for (i2 = 0; i2 < projects.length; ++i2) {
                try {
                    projects[i2].accept((IResourceVisitor)visitor);
                    continue;
                }
                catch (CoreException e2) {
                    // empty catch block
                }
            }
        }
        IFile[] fileResources = visitor.getFileResources();
        for (i2 = 0; i2 < fileResources.length; ++i2) {
            IPath path;
            IFile fileResource = fileResources[i2];
            if (fileResource == null || (path = fileResource.getFullPath()).lastSegment().charAt(0) == '.' || !path.equals(workspacePath)) continue;
            return fileResource;
        }
        return null;
    }

    public static IPath[] getDependentResourcePaths(IResource iResource) {
        if (iResource == null || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return EMPTY_IPATH_ARRAY;
        }
        IResource[] dependentIResources = WorkspaceResourceFinderUtil.getDependentResources(iResource);
        if (dependentIResources == null || dependentIResources.length == 0) {
            return EMPTY_IPATH_ARRAY;
        }
        IPath[] result = new IPath[dependentIResources.length];
        for (int i2 = 0; i2 != dependentIResources.length; ++i2) {
            IResource dependentIResource = dependentIResources[i2];
            result[i2] = dependentIResource.getFullPath();
        }
        return result;
    }

    public static IResource[] getDependentResources(IResource iResource) {
        if (iResource == null || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return EMPTY_IRESOURCE_ARRAY;
        }
        File iResourceFile = iResource.getRawLocation().toFile();
        if (!iResourceFile.exists()) {
            return EMPTY_IRESOURCE_ARRAY;
        }
        ArrayList<IResource> result = new ArrayList<IResource>();
        try {
            XMIHeader header;
            if (ModelUtil.isXsdFile((IResource)iResource)) {
                XsdHeader header2 = XsdHeaderReader.readHeader((File)iResourceFile);
                if (header2 != null) {
                    String absolutePath;
                    IResource dependentIResource;
                    String location;
                    int i2;
                    String[] locations = header2.getImportSchemaLocations();
                    for (i2 = 0; i2 != locations.length; ++i2) {
                        location = locations[i2];
                        dependentIResource = WorkspaceResourceFinderUtil.findIResource(location);
                        if (dependentIResource == null) {
                            absolutePath = WorkspaceResourceFinderUtil.getAbsoluteLocation(iResourceFile, location);
                            dependentIResource = WorkspaceResourceFinderUtil.findIResource(absolutePath);
                        }
                        if (dependentIResource == null || result.contains(dependentIResource)) continue;
                        result.add(dependentIResource);
                    }
                    locations = header2.getIncludeSchemaLocations();
                    for (i2 = 0; i2 != locations.length; ++i2) {
                        location = locations[i2];
                        dependentIResource = WorkspaceResourceFinderUtil.findIResource(location);
                        if (dependentIResource == null) {
                            absolutePath = WorkspaceResourceFinderUtil.getAbsoluteLocation(iResourceFile, location);
                            dependentIResource = WorkspaceResourceFinderUtil.findIResource(absolutePath);
                        }
                        if (dependentIResource == null || result.contains(dependentIResource)) continue;
                        result.add(dependentIResource);
                    }
                }
            } else if (ModelUtil.isModelFile((IResource)iResource)) {
                XMIHeader header3 = XMIHeaderReader.readHeader((File)iResourceFile);
                if (header3 != null) {
                    ModelImportInfo[] infos = header3.getModelImportInfos();
                    for (int i3 = 0; i3 < infos.length; ++i3) {
                        IResource dependentIResource = null;
                        String location = infos[i3].getLocation();
                        String path = infos[i3].getPath();
                        if (!StringUtil.isEmpty((String)path)) {
                            dependentIResource = WorkspaceResourceFinderUtil.findIResource(path);
                        } else if (!StringUtil.isEmpty((String)location) && !WorkspaceResourceFinderUtil.isGlobalResource(location) && (dependentIResource = WorkspaceResourceFinderUtil.findIResource(location)) == null) {
                            String absolutePath = WorkspaceResourceFinderUtil.getAbsoluteLocation(iResourceFile, location);
                            dependentIResource = WorkspaceResourceFinderUtil.findIResource(absolutePath);
                        }
                        if (dependentIResource == null || result.contains(dependentIResource)) continue;
                        result.add(dependentIResource);
                    }
                }
            } else if (ModelUtil.isVdbArchiveFile((IResource)iResource) && (header = ModelUtil.getXmiHeaderForVdbArchive((File)iResourceFile)) != null) {
                ModelImportInfo[] infos = header.getModelImportInfos();
                for (int i4 = 0; i4 < infos.length; ++i4) {
                    IResource dependentIResource = null;
                    String location = infos[i4].getLocation();
                    String path = infos[i4].getPath();
                    if (!StringUtil.isEmpty((String)path)) {
                        dependentIResource = WorkspaceResourceFinderUtil.findIResource(path);
                    } else if (!StringUtil.isEmpty((String)location) && !WorkspaceResourceFinderUtil.isGlobalResource(location) && (dependentIResource = WorkspaceResourceFinderUtil.findIResource(location)) == null) {
                        String absolutePath = WorkspaceResourceFinderUtil.getAbsoluteLocation(iResourceFile, location);
                        dependentIResource = WorkspaceResourceFinderUtil.findIResource(absolutePath);
                    }
                    if (dependentIResource == null || result.contains(dependentIResource)) continue;
                    result.add(dependentIResource);
                }
            }
        }
        catch (Exception err) {
            Object[] params = new Object[]{iResource.getFullPath()};
            String msg = ModelerCore.Util.getString("WorkspaceResourceFinderUtil.Error_getting_model_imports_from_resource", params);
            ModelerCore.Util.log(4, (Throwable)err, msg);
        }
        return result.toArray(new IResource[result.size()]);
    }

    private static String getAbsoluteLocation(File base, String relativePath) {
        URI baseLocation = URI.createFileURI((String)base.getAbsolutePath());
        URI relLocation = URI.createURI((String)relativePath, (boolean)false);
        if (baseLocation.isHierarchical() && !baseLocation.isRelative() && relLocation.isRelative()) {
            relLocation = relLocation.resolve(baseLocation);
        }
        return URI.decode((String)relLocation.toString());
    }

    public static IResource findIResource(Resource resource) {
        try {
            if (resource != null && resource.getURI() != null && WorkspaceResourceFinderUtil.getWorkspace() != null) {
                return WorkspaceResourceFinderUtil.findIResource(resource.getURI());
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public static IResource findIResource(URI resourceUri) {
        try {
            if (resourceUri != null && WorkspaceResourceFinderUtil.getWorkspace() != null) {
                String uriString = WorkspaceResourceFinderUtil.normalizeUriToString(resourceUri);
                IFile[] fileResources = WorkspaceResourceFinderUtil.getAllProjectsFileResources();
                IFile fileResource = WorkspaceResourceFinderUtil.getResourceByLocation(fileResources, uriString);
                if (fileResource != null) {
                    return fileResource;
                }
            }
        }
        catch (IllegalStateException ise) {
            ModelerCore.Util.log((Throwable)ise);
        }
        return null;
    }

    public static IResource findIResource(String workspaceUri) {
        if (!WorkspaceResourceFinderUtil.isValidWorkspaceUri(workspaceUri)) {
            return null;
        }
        String normalizedUriString = WorkspaceResourceFinderUtil.normalizeUriString(workspaceUri);
        IFile[] fileResources = WorkspaceResourceFinderUtil.getAllProjectsFileResources();
        IFile fileResource = WorkspaceResourceFinderUtil.getResourceStartsWithHttp(fileResources, normalizedUriString);
        if (fileResource != null) {
            return fileResource;
        }
        fileResource = WorkspaceResourceFinderUtil.getResourceStartsWithPathSeparator(fileResources, normalizedUriString);
        if (fileResource != null) {
            return fileResource;
        }
        fileResource = WorkspaceResourceFinderUtil.getResourceByLocation(fileResources, normalizedUriString);
        if (fileResource != null) {
            return fileResource;
        }
        return null;
    }

    private static boolean isValidWorkspaceUri(String workspaceUri) {
        if (workspaceUri == null || workspaceUri.length() == 0 || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return false;
        }
        return !WorkspaceResourceFinderUtil.isGlobalResource(workspaceUri);
    }

    private static IFile[] getAllProjectsFileResources() {
        FileResourceCollectorVisitor visitor = new FileResourceCollectorVisitor();
        IWorkspace workSpace = WorkspaceResourceFinderUtil.getWorkspace();
        if (workSpace != null && workSpace.getRoot() != null) {
            IWorkspaceRoot wsRoot = workSpace.getRoot();
            IProject[] projects = wsRoot.getProjects();
            for (int i2 = 0; i2 < projects.length; ++i2) {
                try {
                    projects[i2].accept((IResourceVisitor)visitor);
                    continue;
                }
                catch (CoreException e2) {
                    ModelerCore.Util.log((Throwable)e2);
                }
            }
        }
        return visitor.getFileResources();
    }

    private static IFile getResourceStartsWithHttp(IFile[] fileResources, String workspaceUri) {
        IFile fileResource = null;
        if (workspaceUri.startsWith("http")) {
            for (int i2 = 0; i2 < fileResources.length; ++i2) {
                fileResource = fileResources[i2];
                String targetNamespace = WorkspaceResourceFinderUtil.getXsdTargetNamespace((IResource)fileResource);
                if (!workspaceUri.equals(targetNamespace)) continue;
                return fileResource;
            }
        }
        return null;
    }

    private static IFile getResourceStartsWithPathSeparator(IFile[] fileResources, String workspaceUri) {
        IFile fileResource = null;
        if (workspaceUri.charAt(0) == '/') {
            Path pathInWorkspace = new Path(workspaceUri);
            for (int i2 = 0; i2 < fileResources.length; ++i2) {
                fileResource = fileResources[i2];
                if (fileResource == null || !fileResource.getFullPath().equals(pathInWorkspace)) continue;
                return fileResource;
            }
        }
        return null;
    }

    private static IFile getResourceByLocation(IFile[] fileResources, String workspaceUri) {
        String resourceLocation;
        int i2;
        IFile fileResource = null;
        for (i2 = 0; i2 < fileResources.length; ++i2) {
            fileResource = fileResources[i2];
            resourceLocation = fileResource.getLocation().toOSString();
            if (workspaceUri.endsWith(resourceLocation)) {
                return fileResource;
            }
            resourceLocation = fileResource.getLocation().toString();
            if (!workspaceUri.endsWith(resourceLocation)) continue;
            return fileResource;
        }
        for (i2 = 0; i2 < fileResources.length; ++i2) {
            fileResource = fileResources[i2];
            resourceLocation = fileResource.getLocation().toOSString();
            if (resourceLocation.endsWith(workspaceUri)) {
                return fileResource;
            }
            resourceLocation = fileResource.getLocation().toString();
            if (!resourceLocation.endsWith(workspaceUri)) continue;
            return fileResource;
        }
        return null;
    }

    public static String getWorkspaceUri(IResource resource) {
        if (resource != null) {
            return resource.getFullPath().toString();
        }
        return null;
    }

    public static String getWorkspaceUri(Resource resource) {
        if (resource != null && resource.getURI() != null && WorkspaceResourceFinderUtil.getWorkspace() != null) {
            URI resourceUri = resource.getURI();
            String resourceUriString = resourceUri.toString();
            if (WorkspaceResourceFinderUtil.isGlobalResource(resourceUriString)) {
                return WorkspaceResourceFinderUtil.getGlobalResourceUri(resourceUriString);
            }
            resourceUriString = WorkspaceResourceFinderUtil.normalizeUriToString(resourceUri);
            if (WorkspaceResourceFinderUtil.isGlobalResource(resourceUriString)) {
                return WorkspaceResourceFinderUtil.getGlobalResourceUri(resourceUriString);
            }
            IResource iResource = WorkspaceResourceFinderUtil.findIResource(resource);
            if (iResource != null) {
                return iResource.getFullPath().toString();
            }
            String path = resourceUriString;
            try {
                IProject[] projects = WorkspaceResourceFinderUtil.getWorkspace().getRoot().getProjects();
                for (int i2 = 0; i2 < projects.length; ++i2) {
                    IProject project = projects[i2];
                    IPath iPath = project.getLocation().removeLastSegments(1);
                    String projectLocation = iPath.toString();
                    int beginIndex = path.indexOf(projectLocation);
                    if (beginIndex < 0) continue;
                    return path.substring(beginIndex += projectLocation.length());
                }
            }
            catch (Exception e2) {
                path = resourceUriString;
            }
            path = resourceUriString;
            String osPath = resourceUri.toFileString();
            if (osPath == null) {
                return null;
            }
            IPath wsPath = Platform.getLocation();
            String wsPathStr = wsPath.toOSString();
            if (osPath.startsWith(wsPathStr)) {
                path = osPath.substring(wsPathStr.length());
            }
            return path;
        }
        return null;
    }

    private static String normalizeUriToString(URI uri) {
        String uriString = new Path(URI.decode((String)uri.toString())).toString();
        return WorkspaceResourceFinderUtil.normalizeUriString(uriString);
    }

    private static String normalizeUriString(String uriString) {
        String normalizedUriString = WorkspaceResourceFinderUtil.removeSchemeAndAuthority(uriString);
        return normalizedUriString;
    }

    private static String removeSchemeAndAuthority(String uri) {
        String normalizedUri = uri;
        if (normalizedUri != null) {
            int beginIndex;
            if (normalizedUri.startsWith(SCHEME_FILE)) {
                normalizedUri = normalizedUri.substring(SCHEME_FILE.length());
            } else if (normalizedUri.startsWith(SCHEME_PLATFORM) && (normalizedUri = normalizedUri.substring(SCHEME_PLATFORM.length())).startsWith(PLATFORM_RESOURCE_SEGMENT)) {
                normalizedUri = normalizedUri.substring(PLATFORM_RESOURCE_SEGMENT.length());
            }
            if (normalizedUri.startsWith(AUTHORITY_SEPARATOR) && (beginIndex = (normalizedUri = normalizedUri.substring(AUTHORITY_SEPARATOR.length())).indexOf(47)) > -1) {
                normalizedUri = normalizedUri.substring(beginIndex);
            }
            if (normalizedUri.indexOf(58) > 0 && normalizedUri.charAt(0) == '/') {
                normalizedUri = normalizedUri.substring(1);
            }
        }
        return normalizedUri;
    }

    public static boolean isGlobalResource(String uri) {
        if (uri == null) {
            return false;
        }
        if (uri.startsWith("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance")) {
            return true;
        }
        if (uri.endsWith("builtInDataTypes.xsd")) {
            return true;
        }
        if (uri.startsWith(UML_PRIMITIVE_TYPES_INTERNAL_URI)) {
            return true;
        }
        if (uri.endsWith(UML_PRIMITIVE_TYPES_MODEL_FILE_NAME)) {
            return true;
        }
        if (uri.startsWith(UML_METAMODEL_URI)) {
            return true;
        }
        if (uri.endsWith(RELATIONSHIP_PRIMITIVE_TYPES_INTERNAL_URI)) {
            return true;
        }
        if (uri.endsWith(RELATIONSHIP_PRIMITIVE_TYPES_MODEL_FILE_NAME)) {
            return true;
        }
        if (uri.startsWith("http://www.w3.org/2001/XMLSchema-instance") || uri.startsWith("http://www.w3.org/2001/MagicXMLSchema") || uri.startsWith("http://www.w3.org/2001/XMLSchema") || uri.startsWith("http://www.w3.org/2001/xml")) {
            return true;
        }
        if (uri.startsWith(XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX)) {
            if (uri.indexOf(XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return true;
            }
            if (uri.indexOf(XML_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return true;
            }
            if (uri.indexOf(XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return true;
            }
        }
        try {
            Resource[] systemModels = ModelerCore.getSystemVdbResources();
            for (int i2 = 0; i2 != systemModels.length; ++i2) {
                String systemModelUri = URI.decode((String)systemModels[i2].getURI().toString());
                if (!uri.equalsIgnoreCase(systemModelUri)) continue;
                return true;
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (ModelerCore.getMetamodelRegistry().containsURI(uri)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (WorkspaceResourceFinderUtil.isLocalResource(uri)) {
            return false;
        }
        return false;
    }

    private static boolean isLocalResource(String uri) {
        boolean found = false;
        try {
            String uriName = URI.createURI((String)uri).lastSegment();
            Resource[] systemModels = ModelerCore.getModelContainer().getResourceFinder().findByName(uriName, false, false);
            for (int i2 = 0; i2 != systemModels.length; ++i2) {
                URI resUri = systemModels[i2].getURI();
                if (!resUri.lastSegment().equalsIgnoreCase(uriName)) continue;
                found = true;
            }
        }
        catch (Exception e2) {
            ModelerCore.Util.log((Throwable)e2);
        }
        return found;
    }

    public static String getGlobalResourceUri(String uri) {
        if (uri == null) {
            return null;
        }
        if (uri.startsWith("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance")) {
            return "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance";
        }
        if (uri.endsWith("builtInDataTypes.xsd")) {
            return "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance";
        }
        if (uri.startsWith(UML_PRIMITIVE_TYPES_INTERNAL_URI)) {
            return UML_PRIMITIVE_TYPES_INTERNAL_URI;
        }
        if (uri.endsWith(UML_PRIMITIVE_TYPES_MODEL_FILE_NAME)) {
            return UML_PRIMITIVE_TYPES_INTERNAL_URI;
        }
        if (uri.startsWith(UML_METAMODEL_URI)) {
            return UML_METAMODEL_URI;
        }
        if (uri.endsWith(RELATIONSHIP_PRIMITIVE_TYPES_INTERNAL_URI)) {
            return RELATIONSHIP_PRIMITIVE_TYPES_INTERNAL_URI;
        }
        if (uri.endsWith(RELATIONSHIP_PRIMITIVE_TYPES_MODEL_FILE_NAME)) {
            return RELATIONSHIP_PRIMITIVE_TYPES_INTERNAL_URI;
        }
        if (uri.startsWith("http://www.w3.org/2001/XMLSchema-instance")) {
            return "http://www.w3.org/2001/XMLSchema-instance";
        }
        if (uri.startsWith("http://www.w3.org/2001/XMLSchema")) {
            return "http://www.w3.org/2001/XMLSchema";
        }
        if (uri.startsWith("http://www.w3.org/2001/MagicXMLSchema")) {
            return "http://www.w3.org/2001/MagicXMLSchema";
        }
        if (uri.equals("http://www.w3.org/2001/xml")) {
            return "http://www.w3.org/2001/xml";
        }
        if (uri.startsWith(XML_SCHEMA_ECLIPSE_PLATFORM_URI_PREFIX)) {
            if (uri.indexOf(XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return "http://www.w3.org/2001/MagicXMLSchema";
            }
            if (uri.indexOf(XML_SCHEMA_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return "http://www.w3.org/2001/XMLSchema";
            }
            if (uri.indexOf(XML_SCHEMA_INSTANCE_ECLIPSE_PLATFORM_URI_SUFFIX) > 0) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
        }
        try {
            Resource[] systemModels = ModelerCore.getSystemVdbResources();
            for (int i2 = 0; i2 != systemModels.length; ++i2) {
                String systemModelUri = URI.decode((String)systemModels[i2].getURI().toString());
                if (!uri.equalsIgnoreCase(systemModelUri)) continue;
                return systemModelUri;
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (ModelerCore.getMetamodelRegistry().containsURI(uri)) {
                URI metamodelUri = ModelerCore.getMetamodelRegistry().getURI(uri);
                return ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(metamodelUri).getNamespaceURI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Collection getAllWorkspaceResources() {
        return WorkspaceResourceFinderUtil.getAllWorkspaceResources(null);
    }

    public static Collection getAllWorkspaceResources(ResourceFilter filter) {
        FileResourceCollectorVisitor visitor = new FileResourceCollectorVisitor(filter);
        IProject[] projects = ModelerCore.getWorkspace().getRoot().getProjects();
        for (int i2 = 0; i2 < projects.length; ++i2) {
            try {
                projects[i2].accept((IResourceVisitor)visitor);
                continue;
            }
            catch (CoreException e2) {
                // empty catch block
            }
        }
        Collection fileResources = visitor.getFileResourcesCollection();
        Iterator itor = fileResources.iterator();
        while (itor.hasNext()) {
            IFile fileResource = (IFile)itor.next();
            IPath path = fileResource.getFullPath();
            if (path.lastSegment().charAt(0) != '.') continue;
            itor.remove();
        }
        return fileResources;
    }

    public static IResource[] getVdbResourcesThatContain(IResource resource) {
        if (resource == null || !resource.exists() || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return EMPTY_IRESOURCE_ARRAY;
        }
        Collection vdbResources = WorkspaceResourceFinderUtil.getAllWorkspaceResources(VDB_RESOURCE_FILTER);
        Collection result = WorkspaceResourceFinderUtil.getVdbResourcesThatContain(resource, vdbResources);
        return result.toArray(new IResource[result.size()]);
    }

    public static IResource[] getVdbResourcesThatContain(Collection resources) {
        if (resources == null || resources.isEmpty() || WorkspaceResourceFinderUtil.getWorkspace() == null) {
            return EMPTY_IRESOURCE_ARRAY;
        }
        Collection vdbResources = WorkspaceResourceFinderUtil.getAllWorkspaceResources(VDB_RESOURCE_FILTER);
        HashSet result = new HashSet();
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            result.addAll(WorkspaceResourceFinderUtil.getVdbResourcesThatContain(resource, vdbResources));
        }
        return result.toArray(new IResource[result.size()]);
    }

    private static Collection getVdbResourcesThatContain(IResource resource, Collection workspaceResources) {
        ArrayList<IResource> result = Collections.EMPTY_LIST;
        if (resource == null || !resource.exists() || ModelUtil.isVdbArchiveFile((IResource)resource)) {
            return result;
        }
        if (workspaceResources == null || workspaceResources.isEmpty()) {
            return result;
        }
        String targetUuid = null;
        XMIHeader xmiHeader = ModelUtil.getXmiHeader((IResource)resource);
        if (xmiHeader != null) {
            targetUuid = xmiHeader.getUUID();
        }
        String targetPath = resource.getFullPath().makeAbsolute().toString();
        result = new ArrayList<IResource>();
        Iterator iter = workspaceResources.iterator();
        block0: while (iter.hasNext()) {
            VdbHeader vdbHeader;
            File vdbFile;
            IResource nextResource = (IResource)iter.next();
            if (!ModelUtil.isVdbArchiveFile((IResource)nextResource) || !(vdbFile = nextResource.getRawLocation().toFile()).exists() || (vdbHeader = ModelUtil.getVdbHeader((File)vdbFile)) == null) continue;
            VdbModelInfo[] infos = vdbHeader.getModelInfos();
            for (int i2 = 0; i2 != infos.length; ++i2) {
                if (targetUuid != null && targetUuid.equals(infos[i2].getUUID())) {
                    result.add(nextResource);
                    continue block0;
                }
                if (targetPath.equals(infos[i2].getPath())) {
                    result.add(nextResource);
                    continue block0;
                }
                if (!targetPath.equals(infos[i2].getLocation())) continue;
                result.add(nextResource);
                continue block0;
            }
        }
        return result;
    }

    public static Collection getResourcesThatUse(IResource resource) {
        return WorkspaceResourceFinderUtil.getResourcesThatUse(resource, null);
    }

    public static Collection getResourcesThatUse(IResource resource, ResourceFilter filter) {
        Collection allResources = WorkspaceResourceFinderUtil.getAllWorkspaceResources(filter);
        ArrayList<IResource> colDependentResources = new ArrayList<IResource>();
        IPath targetPath = resource.getFullPath();
        Iterator iter = allResources.iterator();
        block0: while (iter.hasNext()) {
            IResource nextResource = (IResource)iter.next();
            IPath[] paths = WorkspaceResourceFinderUtil.getDependentResourcePaths(nextResource);
            for (int i2 = 0; i2 < paths.length; ++i2) {
                if (!paths[i2].equals(targetPath)) continue;
                String modelPath = nextResource.getFullPath().toString();
                if (modelPath == null || WorkspaceResourceFinderUtil.isGlobalResource(modelPath)) continue block0;
                colDependentResources.add(nextResource);
                continue block0;
            }
        }
        return colDependentResources;
    }

    public static void getResourcesThatUseRecursive(IResource resource, ResourceFilter filter, Collection dependentResources) {
        Collection allResources = WorkspaceResourceFinderUtil.getAllWorkspaceResources(filter);
        IPath targetPath = resource.getFullPath();
        Iterator iter = allResources.iterator();
        block0: while (iter.hasNext()) {
            IResource nextResource = (IResource)iter.next();
            IPath[] paths = WorkspaceResourceFinderUtil.getDependentResourcePaths(nextResource);
            for (int i2 = 0; i2 < paths.length; ++i2) {
                if (!paths[i2].equals(targetPath)) continue;
                String modelPath = nextResource.getFullPath().toString();
                if (modelPath == null || WorkspaceResourceFinderUtil.isGlobalResource(modelPath) || dependentResources.contains(nextResource)) continue block0;
                dependentResources.add(nextResource);
                WorkspaceResourceFinderUtil.getResourcesThatUseRecursive(nextResource, filter, dependentResources);
                continue block0;
            }
        }
    }

    private static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private static String getXsdTargetNamespace(IResource iResource) {
        String location;
        File resourceFile;
        if (ModelUtil.isXsdFile((IResource)iResource) && (resourceFile = new File(location = iResource.getLocation().toOSString())).exists()) {
            try {
                XsdHeader header = XsdHeaderReader.readHeader((File)resourceFile);
                if (header != null) {
                    return header.getTargetNamespaceURI();
                }
            }
            catch (MetaMatrixCoreException e2) {
                ModelerCore.Util.log(4, (Throwable)e2, e2.getMessage());
            }
        }
        return null;
    }

    private static class VdbResourceFilter
    implements ResourceFilter {
        private VdbResourceFilter() {
        }

        public boolean accept(IResource res) {
            return ModelUtil.isVdbArchiveFile((IResource)res);
        }
    }

    public static class FileResourceCollectorVisitor
    implements IResourceVisitor {
        private List resources = new ArrayList();
        private ResourceFilter resFilt;

        public FileResourceCollectorVisitor() {
            this(ResourceFilter.ACCEPT_ALL);
        }

        public FileResourceCollectorVisitor(ResourceFilter rf) {
            this.resFilt = rf != null ? rf : ResourceFilter.ACCEPT_ALL;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.exists() && resource.getType() == 1 && this.resFilt.accept(resource)) {
                this.resources.add(resource);
            }
            return true;
        }

        public IFile[] getFileResources() {
            return this.resources.toArray(new IFile[this.resources.size()]);
        }

        public Collection getFileResourcesCollection() {
            return this.resources;
        }
    }
}

