/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.dqp.ui.config;

import com.metamatrix.core.event.IChangeListener;
import com.metamatrix.core.event.IChangeNotifier;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.dqp.execution.VdbExecutionValidator;
import com.metamatrix.modeler.dqp.internal.execution.WorkspaceProblemsExecutionValidatorImpl;
import com.metamatrix.modeler.dqp.ui.DqpUiConstants;
import com.metamatrix.modeler.internal.dqp.ui.actions.VdbExecutor;
import com.metamatrix.modeler.internal.dqp.ui.config.ConnectorBindingsPanel;
import com.metamatrix.modeler.internal.dqp.ui.views.ConfigurationManagerView;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.vdb.ui.editor.IVdbEditorPage;
import com.metamatrix.ui.internal.util.UiUtil;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.vdb.edit.VdbContextEditor;
import com.metamatrix.vdb.edit.VdbEditingContext;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.part.services.NullEditorInput;
import org.eclipse.ui.part.EditorPart;

public class ConnectorBindingsEditorPart
extends EditorPart
implements IChangeListener,
IVdbEditorPage,
DqpUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$internal$dqp$ui$config$ConnectorBindingsEditorPart == null ? (class$com$metamatrix$modeler$internal$dqp$ui$config$ConnectorBindingsEditorPart = ConnectorBindingsEditorPart.class$("com.metamatrix.modeler.internal.dqp.ui.config.ConnectorBindingsEditorPart")) : class$com$metamatrix$modeler$internal$dqp$ui$config$ConnectorBindingsEditorPart));
    private Button btnExecute;
    private Button btnAllowAllUpdates;
    private CLabel lblImage;
    private StyledText lblStatus;
    private Composite pnlMain;
    private ConnectorBindingsPanel pnlBindings;
    private IChangeListener changeListener;
    protected boolean dirty;
    private VdbExecutor executor;
    protected File vdbFile;
    protected VdbEditingContext vdbContext;
    protected VdbContextEditor vdbContextEditor;
    private boolean executionPropsChanged;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$dqp$ui$config$ConnectorBindingsEditorPart;
    static /* synthetic */ Class class$com$metamatrix$vdb$internal$edit$InternalVdbEditingContext;

    private static final String getString(String theKey) {
        return DqpUiConstants.UTIL.getStringOrKey(PREFIX + theKey);
    }

    private static final String getString(String id, Object obj) {
        return DqpUiConstants.UTIL.getString(PREFIX + id, obj);
    }

    public void createPartControl(Composite theParent) {
        this.pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        Display display = this.pnlMain.getDisplay();
        FormToolkit toolkit = null;
        toolkit = new FormToolkit(display);
        toolkit.setBackground(this.pnlMain.getBackground());
        Group group = WidgetFactory.createGroup((Composite)this.pnlMain, (String)ConnectorBindingsEditorPart.getString("statusGroup"), (int)768, (int)1, (int)3);
        this.btnExecute = WidgetFactory.createButton((Composite)group, (String)ConnectorBindingsEditorPart.getString("btnExecute"));
        this.btnExecute.setEnabled(false);
        this.btnExecute.setToolTipText(ConnectorBindingsEditorPart.getString("btnExecute.tip"));
        this.btnExecute.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.lblImage = WidgetFactory.createLabel((Composite)group);
        this.lblStatus = new StyledText((Composite)group, 74);
        this.lblStatus.setText(ConnectorBindingsEditorPart.getString("lblStatus"));
        this.lblStatus.setBackground(UiUtil.getSystemColor((int)22));
        this.lblStatus.setLayoutData((Object)new GridData(768));
        Hyperlink importLink = toolkit.createHyperlink((Composite)group, ConnectorBindingsEditorPart.getString("openConfigurationManager.linkText"), 64);
        GridData iLinkGD = new GridData();
        iLinkGD.horizontalSpan = 3;
        importLink.setLayoutData((Object)iLinkGD);
        Color bkgdColor = group.getBackground();
        importLink.setBackground(group.getBackground());
        importLink.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        group = WidgetFactory.createGroup((Composite)this.pnlMain, (String)ConnectorBindingsEditorPart.getString("executionOptionsGroup"), (int)768);
        this.btnAllowAllUpdates = WidgetFactory.createCheckBox((Composite)group, (String)ConnectorBindingsEditorPart.getString("btnAllowAllUpdates"), (boolean)false);
        this.btnAllowAllUpdates.setToolTipText(ConnectorBindingsEditorPart.getString("btnAllowAllUpdates.tip"));
        String txnAutoWrap = null;
        if (this.vdbContext != null) {
            txnAutoWrap = this.vdbContext.getExecutionProperties().getProperty("txnAutoWrap");
        } else if (this.vdbContextEditor != null) {
            txnAutoWrap = this.vdbContextEditor.getExecutionProperties().getProperty("txnAutoWrap");
        }
        if (txnAutoWrap != null) {
            this.btnAllowAllUpdates.setSelection(txnAutoWrap.equalsIgnoreCase("OFF"));
        }
        this.btnAllowAllUpdates.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        group = WidgetFactory.createGroup((Composite)this.pnlMain, (String)ConnectorBindingsEditorPart.getString("bindingsGroup"), (int)1808);
        if (this.vdbContext != null && !this.vdbContext.isReadOnly()) {
            StyledText txtInstructions = new StyledText((Composite)group, 74);
            txtInstructions.setText(ConnectorBindingsEditorPart.getString("editInstructionsMsg"));
            txtInstructions.setBackground(UiUtil.getSystemColor((int)22));
            txtInstructions.setLayoutData((Object)new GridData(768));
        } else if (this.vdbContextEditor != null && !this.vdbContextEditor.isReadOnly()) {
            StyledText txtInstructions = new StyledText((Composite)group, 74);
            txtInstructions.setText(ConnectorBindingsEditorPart.getString("editInstructionsMsg"));
            txtInstructions.setBackground(UiUtil.getSystemColor((int)22));
            txtInstructions.setLayoutData((Object)new GridData(768));
        }
        this.pnlBindings = null;
        if (this.vdbContext != null) {
            this.pnlBindings = new ConnectorBindingsPanel((Composite)group, this.vdbFile, this.vdbContext);
        } else if (this.vdbContextEditor != null) {
            this.pnlBindings = new ConnectorBindingsPanel((Composite)group, this.vdbFile, this.vdbContextEditor);
        }
        this.pnlBindings.addChangeListener((IChangeListener)this);
        this.dirty = this.isDirty();
        this.updateExecutionStatus();
    }

    public void doSave(IProgressMonitor theMonitor) {
        this.pnlBindings.save();
        this.executionPropsChanged = false;
        this.dirty = this.isDirty();
        this.updateExecutionStatus();
    }

    public void doSaveAs() {
    }

    private VdbExecutor getExecutor() {
        return this.executor;
    }

    public ISelectionListener getSelectionListener() {
        return null;
    }

    protected void handleExecuteSelected() {
        this.getSite().getShell().getDisplay().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleAllowAllUpdatesSelected() {
        boolean allAllUpdates = this.btnAllowAllUpdates.getSelection();
        if (allAllUpdates) {
            MessageDialog.openError(null, (String)ConnectorBindingsEditorPart.getString("allowAllUpdatesDialog.title"), (String)ConnectorBindingsEditorPart.getString("allowAllUpdatesDialog.msg"));
        }
        if (this.vdbContext != null) {
            this.vdbContext.setExecutionProperty("txnAutoWrap", allAllUpdates ? "OFF" : "OPTIMISTIC");
        } else if (this.vdbContextEditor != null) {
            this.vdbContextEditor.setExecutionProperty("txnAutoWrap", allAllUpdates ? "OFF" : "OPTIMISTIC");
        }
        this.executionPropsChanged = true;
        this.stateChanged(null);
    }

    public void init(IEditorSite theSite, IEditorInput theInput) throws PartInitException {
        super.setInput(theInput);
        if (!(theInput instanceof IFileEditorInput && ModelUtilities.isVdbFile((IResource)((IFileEditorInput)theInput).getFile()) && ((IFileEditorInput)theInput).getFile().exists())) {
            throw new PartInitException(ConnectorBindingsEditorPart.getString("errorInvalidInput"));
        }
        this.vdbFile = ((IFileEditorInput)theInput).getFile().getLocation().toFile();
        super.setSite((IWorkbenchPartSite)theSite);
    }

    public boolean isDirty() {
        return this.pnlBindings == null ? false : this.pnlBindings.hasVdbDefnChanges() || this.executionPropsChanged;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void preDispose() {
        this.executor.closeAllConnections();
        if (this.pnlBindings != null && !this.pnlBindings.isDisposed()) {
            this.pnlBindings.removeChangeListener((IChangeListener)this);
        }
        if (this.vdbContext != null) {
            this.vdbContext.removeChangeListener(this.changeListener);
        } else if (this.vdbContextEditor != null) {
            this.vdbContextEditor.removeChangeListener(this.changeListener);
        }
    }

    public void setDisplayName(String theName) {
        this.setPartName(theName);
    }

    public void setFocus() {
        this.pnlBindings.setFocus();
        this.updateExecutionStatus();
    }

    public void setVdbEditingContext(VdbEditingContext theEditingContext) {
        Assertion.isNotNull((Object)theEditingContext);
        Assertion.isInstanceOf((Object)theEditingContext, (Class)(class$com$metamatrix$vdb$internal$edit$InternalVdbEditingContext == null ? (class$com$metamatrix$vdb$internal$edit$InternalVdbEditingContext = ConnectorBindingsEditorPart.class$("com.metamatrix.vdb.internal.edit.InternalVdbEditingContext")) : class$com$metamatrix$vdb$internal$edit$InternalVdbEditingContext), (String)ConnectorBindingsEditorPart.getString("vdbStateError"));
        this.vdbContext = theEditingContext;
        this.vdbContextEditor = null;
        this.changeListener = new IChangeListener(){

            public void stateChanged(IChangeNotifier theSource) {
                ConnectorBindingsEditorPart.this.updateExecutionStatus();
            }
        };
        this.vdbContext.addChangeListener(this.changeListener);
        this.executor = new VdbExecutor(this.vdbContext, this.getValidator());
    }

    public void setVdbEditingContext(VdbContextEditor theEditingContext) {
        Assertion.isNotNull((Object)theEditingContext);
        this.vdbContext = null;
        this.vdbContextEditor = theEditingContext;
        this.changeListener = new IChangeListener(){

            public void stateChanged(IChangeNotifier theSource) {
                ConnectorBindingsEditorPart.this.updateExecutionStatus();
            }
        };
        this.vdbContextEditor.addChangeListener(this.changeListener);
        this.executor = new VdbExecutor(this.vdbContextEditor, this.getValidator());
    }

    public void stateChanged(IChangeNotifier theSource) {
        if (!this.dirty) {
            this.dirty = true;
            if (this.vdbContext != null) {
                this.vdbContext.setModified();
            } else if (this.vdbContextEditor != null) {
                this.vdbContextEditor.setSaveIsRequired();
            }
            this.firePropertyChange(257);
        }
        this.updateExecutionStatus();
    }

    protected void updateExecutionStatus() {
        if (!this.btnExecute.isDisposed()) {
            if (this.vdbContextEditor != null && !this.vdbContextEditor.isOpen()) {
                this.vdbContextEditor.removeChangeListener(this.changeListener);
            } else if (this.vdbContext != null && !this.vdbContext.isOpen()) {
                this.vdbContext.removeChangeListener(this.changeListener);
            }
            final IStatus status = this.executor.canExecute();
            this.btnExecute.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!ConnectorBindingsEditorPart.this.btnExecute.isDisposed()) {
                        ConnectorBindingsEditorPart.this.btnExecute.setEnabled(status.getSeverity() != 4);
                        ConnectorBindingsEditorPart.this.lblImage.setImage(UiUtil.getStatusImage((IStatus)status));
                        ConnectorBindingsEditorPart.this.lblImage.update();
                        String msg = null;
                        msg = status.getCode() == 92 ? ConnectorBindingsEditorPart.getString("noDefFileUserMsg") : (status.isOK() ? ConnectorBindingsEditorPart.getString("okStatusMsg") : status.getMessage());
                        ConnectorBindingsEditorPart.this.lblStatus.setText(msg);
                    }
                }
            });
        }
    }

    public void updateReadOnlyState(boolean theReadOnlyFlag) {
        if (this.pnlBindings != null) {
            this.pnlBindings.setReadonly(theReadOnlyFlag);
        }
    }

    private void openConfigurationManager() {
        IEditorPart part = ConfigurationManagerView.getEditorPart();
        if (part == null) {
            try {
                this.getEditorSite().getPage().openEditor((IEditorInput)new NullEditorInput(), "com.metamatrix.modeler.internal.dqp.ui.views.ConfigurationManagerEditor", true);
            }
            catch (PartInitException err) {
                MessageDialog.openError(null, (String)ConnectorBindingsEditorPart.getString("openConfigurationManager.error.title"), (String)ConnectorBindingsEditorPart.getString("openConfigurationManager.error.msg", "com.metamatrix.modeler.internal.dqp.ui.views.ConfigurationManagerEditor"));
            }
        } else {
            this.getEditorSite().getPage().activate((IWorkbenchPart)part);
        }
    }

    protected VdbExecutionValidator getValidator() {
        return new WorkspaceProblemsExecutionValidatorImpl();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$000(ConnectorBindingsEditorPart x0) {
        x0.openConfigurationManager();
    }

    static /* synthetic */ void access$100(ConnectorBindingsEditorPart x0) {
        x0.handleAllowAllUpdatesSelected();
    }

    static /* synthetic */ VdbExecutor access$200(ConnectorBindingsEditorPart x0) {
        return x0.getExecutor();
    }
}

