/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.validator;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BatchedUpdateCommand;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.DynamicCommand;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.navigator.DeepPreOrderNavigator;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.DeclareStatement;
import com.metamatrix.query.sql.proc.HasCriteria;
import com.metamatrix.query.sql.proc.IfStatement;
import com.metamatrix.query.sql.proc.LoopStatement;
import com.metamatrix.query.sql.proc.TranslateCriteria;
import com.metamatrix.query.sql.proc.WhileStatement;
import com.metamatrix.query.sql.symbol.AbstractCaseExpression;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.MultipleElementSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.symbol.Symbol;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.EvaluatableVisitor;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.PredicateCollectorVisitor;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import com.metamatrix.query.sql.visitor.VariableCollectorVisitor;
import com.metamatrix.query.validator.AbstractValidationVisitor;
import com.metamatrix.query.validator.AggregateValidationVisitor;
import com.metamatrix.query.validator.PredicateFormValidatorVisitor;
import com.metamatrix.query.validator.ValidatorReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValidationVisitor
extends AbstractValidationVisitor {
    private boolean isXML = false;
    private boolean isBatchedCommand = false;
    private boolean hasNoFrom = false;
    private CreateUpdateProcedureCommand updateProc;
    private Command transCommand;
    private Set assignedInputs = null;
    private Map inputs = null;
    private Query previousQuery = null;

    public void reset() {
        super.reset();
        this.transCommand = null;
        this.isXML = false;
        this.updateProc = null;
        this.hasNoFrom = false;
        this.isBatchedCommand = false;
        this.assignedInputs = null;
        this.inputs = null;
        this.previousQuery = null;
    }

    public void visit(BatchedUpdateCommand obj) {
        this.isBatchedCommand = true;
        List commands = obj.getUpdateCommands();
        Command command = null;
        int type = 0;
        for (int i = 0; i < commands.size(); ++i) {
            Into into;
            command = (Command)commands.get(i);
            type = command.getType();
            if (type != 2 && type != 3 && type != 4 && type != 1) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_batch_command"), (LanguageObject)command);
                continue;
            }
            if (type != 1 || (into = ((Query)command).getInto()) != null) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_batch_command"), (LanguageObject)command);
        }
    }

    public void visit(CompareCriteria obj) {
        this.validateProcInputElement(obj);
        if (this.isXML) {
            ArrayList rowLimitFunctions = new ArrayList();
            FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
            PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
            visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
            PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
            int functionCount = rowLimitFunctions.size();
            if (functionCount > 0) {
                Function rightExpr;
                Function leftExpr;
                Function function = null;
                Expression expr = null;
                if (obj.getLeftExpression() instanceof Function && ((leftExpr = (Function)obj.getLeftExpression()).getFunctionDescriptor().getName().equalsIgnoreCase("rowlimit") || leftExpr.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimitexception"))) {
                    function = leftExpr;
                    expr = obj.getRightExpression();
                }
                if (function == null && obj.getRightExpression() instanceof Function && ((rightExpr = (Function)obj.getRightExpression()).getFunctionDescriptor().getName().equalsIgnoreCase("rowlimit") || rightExpr.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimitexception"))) {
                    function = rightExpr;
                    expr = obj.getLeftExpression();
                }
                if (function == null) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.0"), (LanguageObject)obj);
                } else if (expr instanceof Constant) {
                    Constant constant = (Constant)expr;
                    if (constant.getValue() instanceof Integer) {
                        Integer integer = (Integer)constant.getValue();
                        if (integer < 0) {
                            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), (LanguageObject)obj);
                        }
                    } else {
                        this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), (LanguageObject)obj);
                    }
                } else {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.1"), (LanguageObject)obj);
                }
            }
        }
    }

    public void visit(Delete obj) {
        this.validateNoXMLUpdates((Command)obj);
        this.validateHasProjectedSymbols((Command)obj);
        this.validateGroupUpdatable((Command)obj);
        if (this.isBatchedCommand) {
            this.validateUpdatedGroupIsPhysical(obj.getGroup(), (Command)obj);
        }
    }

    public void visit(GroupBy obj) {
        List groupBySymbols = obj.getSymbols();
        if (groupBySymbols != null) {
            Iterator symbolIter = groupBySymbols.iterator();
            while (symbolIter.hasNext()) {
                ExpressionSymbol exprSymbol;
                Expression expr;
                SingleElementSymbol symbol = (SingleElementSymbol)symbolIter.next();
                if (!(symbol instanceof ExpressionSymbol) || (expr = (exprSymbol = (ExpressionSymbol)symbol).getExpression()) instanceof Function || expr instanceof AbstractCaseExpression) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.Expr_in_GROUP_BY_must_be_elem_func_case", (Object)expr), (LanguageObject)expr);
            }
        }
    }

    public void visit(Insert obj) {
        this.validateNoXMLUpdates((Command)obj);
        this.validateHasProjectedSymbols((Command)obj);
        this.validateGroupUpdatable((Command)obj);
        this.validateInsert(obj);
        if (this.isBatchedCommand) {
            this.validateUpdatedGroupIsPhysical(obj.getGroup(), (Command)obj);
        }
    }

    public void visit(JoinPredicate obj) {
        this.validateJoinPredicate(obj);
    }

    public void visit(Limit obj) {
        Expression limitExpr;
        Expression offsetExpr = obj.getOffset();
        if (offsetExpr instanceof Reference) {
            offsetExpr = ((Reference)offsetExpr).getExpression();
        }
        if (offsetExpr instanceof Constant) {
            Integer offset = (Integer)((Constant)offsetExpr).getValue();
            if (offset == null) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badoffset1"), (LanguageObject)obj);
            } else if (offset < 0) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badoffset2"), (LanguageObject)obj);
            }
        }
        if ((limitExpr = obj.getRowLimit()) != null) {
            if (limitExpr instanceof Reference) {
                limitExpr = ((Reference)limitExpr).getExpression();
            }
            if (limitExpr instanceof Constant) {
                Integer limit = (Integer)((Constant)limitExpr).getValue();
                if (limit == null) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badlimit1"), (LanguageObject)obj);
                } else if (limit < 0) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.badlimit2"), (LanguageObject)obj);
                }
            }
        }
    }

    public void visit(OrderBy obj) {
        this.validateNoSortOnObject(obj.getVariables());
    }

    public void checkInputAssignments() {
        if (this.inputs == null) {
            return;
        }
        Iterator i = this.inputs.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getValue() != null || this.assignedInputs.contains(entry.getKey())) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.missing_input_assignment", entry.getKey()), (LanguageObject)this.previousQuery);
        }
        this.inputs = null;
        this.previousQuery = null;
        this.assignedInputs = null;
    }

    public void visit(Query obj) {
        this.validateHasProjectedSymbols((Command)obj);
        if (this.isXMLCommand((Command)obj)) {
            if (obj.getInto() != null) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0069"), (LanguageObject)obj);
            }
            this.isXML = true;
            this.validateXMLQuery(obj);
        } else {
            this.validateAggregates(obj);
            if (obj.getSelect() != null && obj.getFrom() == null) {
                this.hasNoFrom = true;
                if (obj.getSubCommands() != null && obj.getSubCommands().size() > 0) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0067"), (LanguageObject)obj);
                }
            }
            if (this.isBatchedCommand) {
                if (obj.getInto() != null) {
                    this.validateUpdatedGroupIsPhysical(obj.getInto().getGroup(), (Command)obj);
                }
            } else if (obj.getSelect() != null && obj.getInto() != null && !obj.getInto().getGroup().isTempGroupSymbol()) {
                this.validateSelectInto(obj);
            }
            if (this.previousQuery != null) {
                this.checkInputAssignments();
            }
            this.previousQuery = obj;
            try {
                this.inputs = ResolverUtil.getInputMap((Query)obj, (QueryMetadataInterface)this.getMetadata(), (boolean)false);
                this.assignedInputs = new HashSet();
            }
            catch (MetaMatrixException e) {
                this.handleException(e, (LanguageObject)obj);
            }
        }
    }

    public void visit(Select obj) {
        this.validateSelectElements(obj);
        if (obj.isDistinct()) {
            this.validateNoSortOnObject(obj.getProjectedSymbols());
        }
    }

    public void visit(SubquerySetCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
        List projSymbols = obj.getCommand().getProjectedSymbols();
        if (projSymbols.size() != 1) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0011"), (LanguageObject)obj);
        }
    }

    public void visit(DependentSetCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
        this.validateCannotContainProcedureInputElement((Criteria)obj);
    }

    public void visit(ScalarSubquery obj) {
        List projSymbols = obj.getCommand().getProjectedSymbols();
        if (projSymbols.size() != 1) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0011"), (LanguageObject)obj);
        }
    }

    public void visit(SetQuery obj) {
        this.validateHasProjectedSymbols((Command)obj);
        this.validateSetQuery(obj);
    }

    public void visit(StoredProcedure obj) {
        Iterator params = obj.getInputParameters().iterator();
        while (params.hasNext()) {
            SPParameter param = (SPParameter)params.next();
            if (param.getExpression() == null) continue;
            try {
                this.validateInputExpression((LanguageObject)obj, param.getExpression());
            }
            catch (QueryMetadataException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
            }
            catch (MetaMatrixComponentException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
            }
        }
    }

    public void visit(Update obj) {
        this.validateNoXMLUpdates((Command)obj);
        this.validateHasProjectedSymbols((Command)obj);
        this.validateGroupUpdatable((Command)obj);
        this.validateUpdate(obj);
        if (this.isBatchedCommand) {
            this.validateUpdatedGroupIsPhysical(obj.getGroup(), (Command)obj);
        }
    }

    public void visit(Into obj) {
        Object groupID = obj.getGroup().getMetadataID();
        try {
            if (!obj.getGroup().isTempGroupSymbol() && this.getMetadata().isVirtualGroup(groupID)) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0070"), (LanguageObject)obj);
            } else {
                this.validateGroupSupportsUpdate(obj.getGroup());
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
    }

    public void visit(Function obj) {
        if (obj.getFunctionDescriptor().getName().equalsIgnoreCase("lookup")) {
            Expression[] args = obj.getArgs();
            String elementName = (String)((Constant)args[0]).getValue() + "." + (String)((Constant)args[2]).getValue();
            try {
                this.getMetadata().getElementID(elementName);
            }
            catch (QueryMetadataException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
            }
            catch (MetaMatrixComponentException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
            }
        } else if (obj.getFunctionDescriptor().getName().equalsIgnoreCase("context")) {
            if (!this.isXML) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.The_context_function_cannot_be_used_in_a_non-XML_command"), (LanguageObject)obj);
            }
        } else if (obj.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimit") || obj.getFunctionDescriptor().getName().equalsIgnoreCase("rowlimitexception")) {
            if (this.isXML) {
                if (!(obj.getArg(0) instanceof ElementSymbol)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.2"), (LanguageObject)obj);
                }
            } else {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.The_rowlimit_function_cannot_be_used_in_a_non-XML_command"), (LanguageObject)obj);
            }
        }
    }

    public void visit(AssignmentStatement obj) {
        ArrayList varsUsed = new ArrayList();
        ElementSymbol variable = obj.getVariable();
        String groupName = variable.getGroupSymbol().getCanonicalName();
        if (groupName.equals("INPUT") || groupName.equals("CHANGING")) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0012", new Object[]{"INPUT", "CHANGING"}), (LanguageObject)obj);
        }
        if (obj.hasCommand()) {
            this.transCommand = obj.getCommand();
            VariableCollectorVisitor.getVariables((LanguageObject)this.transCommand, varsUsed);
            List projSymbols = this.transCommand.getProjectedSymbols();
            if (projSymbols.size() != 1) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0013"), (LanguageObject)obj);
            } else {
                SingleElementSymbol value = (SingleElementSymbol)projSymbols.iterator().next();
                Class valueType = value.getType();
                Class varType = variable.getType();
                if (!varType.equals(valueType)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0014"), (LanguageObject)obj);
                }
            }
        } else if (obj.hasExpression()) {
            Expression expr = obj.getExpression();
            if (!CommandCollectorVisitor.getCommands((LanguageObject)obj.getExpression()).isEmpty()) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.assignment_subquery"), (LanguageObject)obj);
            }
            VariableCollectorVisitor.getVariables((LanguageObject)expr, varsUsed);
        }
    }

    public void visit(CommandStatement obj) {
        this.transCommand = obj.getCommand();
        VariableCollectorVisitor.getVariables((LanguageObject)this.transCommand, (boolean)true);
    }

    public void visit(CreateUpdateProcedureCommand obj) {
        if (!obj.isUpdateProcedure()) {
            if (obj.getSubCommands() == null || obj.getSubCommands().isEmpty()) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.Procedure_should_have_query"), (LanguageObject)obj);
            }
            this.validateCursorReference(obj);
            if (GroupCollectorVisitor.getGroups((LanguageObject)obj, (boolean)true).contains(obj.getVirtualGroup())) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.Procedure_has_group_self_reference"), (LanguageObject)obj);
            }
            return;
        }
        this.updateProc = obj;
        this.validateContainsRowsUpdatedVariable(obj);
        this.validateCursorNotSelected(obj);
    }

    private void validateCursorReference(CreateUpdateProcedureCommand obj) {
        final ArrayList loopStmts = new ArrayList();
        LanguageVisitor visitor = new LanguageVisitor(){

            public void visit(LoopStatement obj) {
                loopStmts.add(obj);
            }
        };
        PreOrderNavigator.doVisit((LanguageObject)obj.getBlock(), (LanguageVisitor)visitor);
        if (!loopStmts.isEmpty()) {
            Collection allElements = ElementCollectorVisitor.getElements((LanguageObject)obj, (boolean)false);
            Iterator iter = loopStmts.iterator();
            while (iter.hasNext()) {
                LoopStatement loopStmt = (LoopStatement)iter.next();
                String cursorName = loopStmt.getCursorName();
                Collection elementsInLoop = ElementCollectorVisitor.getElements((LanguageObject)loopStmt, (boolean)false);
                ArrayList elementsOutsideLoop = new ArrayList(allElements);
                elementsOutsideLoop.removeAll(elementsInLoop);
                Iterator iter2 = elementsOutsideLoop.iterator();
                while (iter2.hasNext()) {
                    ElementSymbol eSymbol = (ElementSymbol)iter2.next();
                    GroupSymbol gSymbol = eSymbol.getGroupSymbol();
                    if (gSymbol == null || !cursorName.equalsIgnoreCase(gSymbol.getName())) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0066"), (LanguageObject)eSymbol);
                }
            }
        }
    }

    public void visit(DeclareStatement obj) {
        ElementSymbol variable = obj.getVariable();
        String elementname = variable.getShortName().toUpperCase();
        if (elementname.equals("INPUT") || elementname.equals("CHANGING") || elementname.equals("ROWS_UPDATED")) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0017", new Object[]{"INPUT", "CHANGING", "ROWS_UPDATED"}), (LanguageObject)obj);
        }
        this.visit((AssignmentStatement)obj);
    }

    public void visit(IfStatement obj) {
        Criteria criteria = obj.getCondition();
        this.validatorCriteriaStatement((LanguageObject)obj, criteria);
    }

    public void visit(WhileStatement obj) {
        Criteria criteria = obj.getCondition();
        this.validatorCriteriaStatement((LanguageObject)obj, criteria);
    }

    private void validatorCriteriaStatement(LanguageObject obj, Criteria criteria) {
        Iterator criteriaIter = PredicateCollectorVisitor.getPredicates((LanguageObject)criteria).iterator();
        while (criteriaIter.hasNext()) {
            Criteria predicateCriteria = (Criteria)criteriaIter.next();
            Iterator elmntIter = ElementCollectorVisitor.getElements((LanguageObject)predicateCriteria, (boolean)true).iterator();
            if (predicateCriteria instanceof TranslateCriteria) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0019"), obj);
                continue;
            }
            if (predicateCriteria instanceof HasCriteria) continue;
            while (elmntIter.hasNext()) {
                ElementSymbol element = (ElementSymbol)elmntIter.next();
                if (element.isExternalReference()) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0020"), obj);
            }
        }
        if (!CommandCollectorVisitor.getCommands((LanguageObject)criteria).isEmpty()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.if_subquery"), obj);
        }
    }

    public void visit(TranslateCriteria obj) {
        if (obj.hasTranslations()) {
            List selectElmnts = null;
            if (obj.getSelector().hasElements()) {
                selectElmnts = obj.getSelector().getElements();
            }
            Iterator critIter = obj.getTranslations().iterator();
            while (critIter.hasNext()) {
                CompareCriteria transCrit = (CompareCriteria)critIter.next();
                Collection leftElmnts = ElementCollectorVisitor.getElements((LanguageObject)transCrit.getLeftExpression(), (boolean)true);
                ElementSymbol leftExpr = (ElementSymbol)leftElmnts.iterator().next();
                if (selectElmnts == null || selectElmnts.contains(leftExpr)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0021"), (LanguageObject)leftExpr);
            }
        }
        this.validateTranslateCriteria(obj);
    }

    public void visit(LoopStatement obj) {
        final ArrayList nestedLoopStmts = new ArrayList();
        LanguageVisitor visitor = new LanguageVisitor(){

            public void visit(LoopStatement obj) {
                nestedLoopStmts.add(obj);
            }
        };
        PreOrderNavigator.doVisit((LanguageObject)obj.getBlock(), (LanguageVisitor)visitor);
        if (nestedLoopStmts.size() > 0) {
            Iterator iter = nestedLoopStmts.iterator();
            while (iter.hasNext()) {
                LoopStatement childStmt = (LoopStatement)iter.next();
                if (!obj.getCursorName().equalsIgnoreCase(childStmt.getCursorName())) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0065"), (LanguageObject)childStmt);
            }
        }
    }

    public void visit(CompoundCriteria obj) {
        if (this.isXML) {
            ArrayList rowLimitFunctions = new ArrayList();
            FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
            PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
            visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
            PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
            int functionCount = rowLimitFunctions.size();
            if (functionCount > 0) {
                Iterator conjunctIter = Criteria.separateCriteriaByAnd((Criteria)obj).iterator();
                int i = 0;
                while (conjunctIter.hasNext() && i < functionCount) {
                    CompareCriteria crit;
                    Object conjunct = conjunctIter.next();
                    if (!(conjunct instanceof CompareCriteria) || !rowLimitFunctions.contains((crit = (CompareCriteria)conjunct).getLeftExpression()) && !rowLimitFunctions.contains(crit.getRightExpression())) continue;
                    ++i;
                }
                if (i < functionCount) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.3"), (LanguageObject)obj);
                }
            }
        }
        if (obj.getOperator() == 1 && this.containsProcedureInputElement((LanguageObject)obj)) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.proc_input_OR"), (LanguageObject)obj);
        }
    }

    protected void validateTranslateCriteria(TranslateCriteria obj) {
        if (this.transCommand == null) {
            return;
        }
        Map symbolMap = this.updateProc.getSymbolMap();
        if (symbolMap == null) {
            return;
        }
        Command userCommand = this.updateProc.getUserCommand();
        Criteria userCrit = null;
        int userCmdType = userCommand.getType();
        switch (userCmdType) {
            case 4: {
                userCrit = ((Delete)userCommand).getCriteria();
                break;
            }
            case 3: {
                userCrit = ((Update)userCommand).getCriteria();
                break;
            }
        }
        if (userCrit == null) {
            return;
        }
        Collection transleElmnts = ElementCollectorVisitor.getElements((LanguageObject)obj, (boolean)true);
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)this.transCommand, (boolean)true);
        int selectType = obj.getSelector().getSelectorType();
        Iterator critIter = PredicateCollectorVisitor.getPredicates((LanguageObject)userCrit).iterator();
        while (critIter.hasNext()) {
            CompareCriteria ccCrit;
            Criteria predCrit = (Criteria)critIter.next();
            if (selectType != 0 && (predCrit instanceof CompareCriteria ? selectType != (ccCrit = (CompareCriteria)predCrit).getOperator() : (predCrit instanceof MatchCriteria ? selectType != 7 : (predCrit instanceof IsNullCriteria ? selectType != 9 : (predCrit instanceof SetCriteria ? selectType != 8 : predCrit instanceof BetweenCriteria && selectType != 10))))) {
                return;
            }
            Iterator critEmlntIter = ElementCollectorVisitor.getElements((LanguageObject)predCrit, (boolean)true).iterator();
            while (critEmlntIter.hasNext()) {
                ElementSymbol criteriaElement = (ElementSymbol)critEmlntIter.next();
                if (!transleElmnts.contains(criteriaElement)) continue;
                Expression mappedExpr = (Expression)symbolMap.get(criteriaElement);
                if (mappedExpr instanceof AggregateSymbol) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0022", (Object)criteriaElement), (LanguageObject)criteriaElement);
                }
                Iterator mapElmntIter = ElementCollectorVisitor.getElements((LanguageObject)mappedExpr, (boolean)true).iterator();
                boolean groupMatch = false;
                while (mapElmntIter.hasNext()) {
                    ElementSymbol mapElement = (ElementSymbol)mapElmntIter.next();
                    GroupSymbol mapGrp = mapElement.getGroupSymbol();
                    if (!groups.contains(mapGrp)) continue;
                    groupMatch = true;
                }
                if (groupMatch) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0023", (Object)criteriaElement), (LanguageObject)criteriaElement);
            }
        }
    }

    protected void validateSelectElements(Select obj) {
        if (this.isXML) {
            return;
        }
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)obj, (boolean)true);
        if (this.hasNoFrom) {
            if (elements != null && elements.size() > 0) {
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    if (((ElementSymbol)iter.next()).isExternalReference()) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0068"), (LanguageObject)obj);
                }
            }
            this.hasNoFrom = false;
            return;
        }
        Collection cantSelect = this.validateElementsSupport(elements, 0);
        if (cantSelect != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0024", (Object)cantSelect), cantSelect);
        }
    }

    protected void validateHasProjectedSymbols(Command obj) {
        if (obj.getProjectedSymbols().size() == 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0025"), (LanguageObject)obj);
        }
    }

    protected void validateNoSortOnObject(List symbols) {
        Iterator iter = symbols.iterator();
        while (iter.hasNext()) {
            SingleElementSymbol symbol = (SingleElementSymbol)iter.next();
            if (!symbol.getType().equals(DataTypeManager.DefaultDataClasses.OBJECT)) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0026", (Object)symbol), (LanguageObject)symbol);
        }
    }

    protected void validateNoXMLUpdates(Command obj) {
        if (this.isXMLCommand(obj)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0029"), (LanguageObject)obj);
        }
    }

    protected void validateNoXMLProcedures(Command obj) {
        if (this.isXMLCommand(obj)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0030"), (LanguageObject)obj);
        }
    }

    private void validateXMLQuery(Query obj) {
        Collection invalidPredicates;
        if (obj.getGroupBy() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0031"), (LanguageObject)obj);
        }
        if (obj.getHaving() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0032"), (LanguageObject)obj);
        }
        if (!(invalidPredicates = PredicateFormValidatorVisitor.getInvalidPredicates((LanguageObject)obj.getCriteria())).isEmpty()) {
            this.handleValidationError(PredicateFormValidatorVisitor.getInvalidPredicateMessage((Collection)invalidPredicates), invalidPredicates);
        }
    }

    protected void validateGroupSupportsUpdate(GroupSymbol groupSymbol) throws QueryMetadataException, MetaMatrixComponentException {
        if (!this.getMetadata().groupSupports(groupSymbol.getMetadataID(), 0)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0033", (Object)SQLStringVisitor.getSQLString((LanguageObject)groupSymbol)), (LanguageObject)groupSymbol);
        }
    }

    protected void validateGroupUpdatable(Command obj) {
        try {
            Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)obj, (boolean)true);
            this.validateGroupSupportsUpdate((GroupSymbol)groups.iterator().next());
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
    }

    protected void validateSetQuery(SetQuery query) {
        if (this.isXMLCommand((Command)query)) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0034"), (LanguageObject)query);
        }
        List columns = null;
        List columnTypes = null;
        Iterator queryIter = query.getQueries().iterator();
        while (queryIter.hasNext()) {
            QueryCommand subQuery = (QueryCommand)queryIter.next();
            List projectedColumns = subQuery.getProjectedSymbols();
            List types = ValidationVisitor.getTypes(this.getMetadata(), projectedColumns);
            if (columnTypes == null) {
                columns = projectedColumns;
                columnTypes = types;
                continue;
            }
            if (columnTypes.size() != types.size()) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0035", (Object)SetQuery.getOperationString((int)query.getOperation())), (LanguageObject)subQuery);
                continue;
            }
            for (int i = 0; i < types.size(); ++i) {
                if (columnTypes.get(i).equals(types.get(i))) continue;
                ArrayList badCols = new ArrayList();
                badCols.add(columns.get(i));
                badCols.add(projectedColumns.get(i));
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0036", new Object[]{SetQuery.getOperationString((int)query.getOperation()), SQLStringVisitor.getSQLString((LanguageObject)((Symbol)columns.get(i))), DataTypeManager.getDataTypeName((Class)((Class)columnTypes.get(i))), SQLStringVisitor.getSQLString((LanguageObject)((Symbol)projectedColumns.get(i))), DataTypeManager.getDataTypeName((Class)((Class)types.get(i)))}), badCols);
            }
        }
    }

    private static List getTypes(QueryMetadataInterface metadata, List elements) {
        ArrayList<Class> types = new ArrayList<Class>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)elements.get(i);
            types.add(symbol.getType());
        }
        return types;
    }

    protected void validateJoinPredicate(JoinPredicate jp) {
        JoinType type = jp.getJoinType();
        List crits = jp.getJoinCriteria();
        if (type.equals((Object)JoinType.JOIN_CROSS)) {
            if (crits != null && crits.size() > 0) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0042", (Object)SQLStringVisitor.getSQLString((LanguageObject)jp)), (LanguageObject)jp);
            }
        } else {
            if (crits == null || crits.size() == 0) {
                Assertion.failed((String)"Criteria is empty on an outer join");
            }
            HashSet groups = new HashSet();
            GroupCollectorVisitor.getGroups((LanguageObject)jp.getLeftClause(), groups);
            GroupCollectorVisitor.getGroups((LanguageObject)jp.getRightClause(), groups);
            ArrayList symbols = new ArrayList();
            Iterator critIter = crits.iterator();
            while (critIter.hasNext()) {
                symbols.clear();
                Criteria joinCrit = (Criteria)critIter.next();
                this.validateCannotContainProcedureInputElement(joinCrit);
                ElementCollectorVisitor.getElements((LanguageObject)joinCrit, symbols);
                Iterator symbolIter = symbols.iterator();
                while (symbolIter.hasNext()) {
                    ElementSymbol es = (ElementSymbol)symbolIter.next();
                    if (groups.contains(es.getGroupSymbol())) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0045", (Object)SQLStringVisitor.getSQLString((LanguageObject)joinCrit)), (LanguageObject)joinCrit);
                }
            }
        }
    }

    private void validateAggregates(Query query) {
        Select select = query.getSelect();
        GroupBy groupBy = query.getGroupBy();
        Criteria having = query.getHaving();
        if (groupBy != null || having != null || AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)query, (boolean)false).size() > 0) {
            List groupSymbols = null;
            if (groupBy != null) {
                groupSymbols = groupBy.getSymbols();
            }
            AggregateValidationVisitor visitor = new AggregateValidationVisitor(groupSymbols);
            if (having != null) {
                AggregateValidationVisitor.validate((LanguageObject)having, (AggregateValidationVisitor)visitor);
            }
            List projectedSymbols = select.getProjectedSymbols();
            Iterator symbolIter = projectedSymbols.iterator();
            while (symbolIter.hasNext()) {
                SingleElementSymbol symbol = (SingleElementSymbol)symbolIter.next();
                if (symbol instanceof AliasSymbol) {
                    symbol = ((AliasSymbol)symbol).getSymbol();
                }
                if (symbol instanceof ExpressionSymbol && !(symbol instanceof AggregateSymbol)) {
                    if (groupSymbols != null && groupSymbols.contains(symbol)) continue;
                    AggregateValidationVisitor.validate((LanguageObject)((ExpressionSymbol)symbol).getExpression(), (AggregateValidationVisitor)visitor);
                    continue;
                }
                AggregateValidationVisitor.validate((LanguageObject)symbol, (AggregateValidationVisitor)visitor);
            }
            ValidatorReport report = visitor.getReport();
            Collection items = report.getItems();
            super.getReport().addItems(items);
        }
    }

    protected void validateInsert(Insert obj) {
        List vars = obj.getVariables();
        Iterator varIter = vars.iterator();
        List values = obj.getValues();
        Iterator valIter = values.iterator();
        GroupSymbol insertGroup = obj.getGroup();
        if (vars.size() != values.size()) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0051"), (LanguageObject)obj);
        }
        try {
            Iterator elementIter = vars.iterator();
            while (elementIter.hasNext()) {
                ElementSymbol insertElem = (ElementSymbol)elementIter.next();
                if (this.getMetadata().elementSupports(insertElem.getMetadataID(), 5)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0052", (Object)insertElem), (LanguageObject)insertElem);
            }
            List insertElmnts = ResolverUtil.resolveElementsInGroup((GroupSymbol)insertGroup, (QueryMetadataInterface)this.getMetadata());
            insertElmnts.removeAll(vars);
            Iterator ignoreIter = insertElmnts.iterator();
            while (ignoreIter.hasNext()) {
                ElementSymbol nextElmnt = (ElementSymbol)ignoreIter.next();
                if (this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 7) || this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 4) || this.getMetadata().elementSupports(nextElmnt.getMetadataID(), 8)) continue;
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0053", new Object[]{insertGroup, nextElmnt}), (LanguageObject)nextElmnt);
            }
            while (valIter.hasNext() && varIter.hasNext()) {
                Expression nextValue = (Expression)valIter.next();
                ElementSymbol nextVar = (ElementSymbol)varIter.next();
                if (nextVar.isExternalReference()) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0054", (Object)nextVar), (LanguageObject)nextVar);
                }
                Expression evaluatedValue = null;
                try {
                    IsNullCriteria dummyCrit = new IsNullCriteria(nextValue);
                    EvaluateExpressionVisitor.replaceExpressions((LanguageObject)dummyCrit, (boolean)false, (boolean)false, null);
                    evaluatedValue = dummyCrit.getExpression();
                }
                catch (ExpressionEvaluationException e) {
                    this.handleException((MetaMatrixException)((Object)e), (LanguageObject)nextValue);
                }
                if (evaluatedValue instanceof Constant) {
                    Object value = ((Constant)evaluatedValue).getValue();
                    if (value != null || this.getMetadata().elementSupports(nextVar.getMetadataID(), 4)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0055", (Object)SQLStringVisitor.getSQLString((LanguageObject)nextVar)), (LanguageObject)nextVar);
                    continue;
                }
                if (evaluatedValue instanceof Reference) {
                    if (evaluatedValue.getType() != null) continue;
                    ((Reference)evaluatedValue).setExpression((Expression)new Constant(null, nextVar.getType()));
                    continue;
                }
                Collection elements = ElementCollectorVisitor.getElements((LanguageObject)evaluatedValue, (boolean)false);
                if (elements.size() <= 0) continue;
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    ElementSymbol element = (ElementSymbol)iter.next();
                    if (element.isExternalReference()) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0056", (Object)SQLStringVisitor.getSQLString((LanguageObject)nextValue)), (LanguageObject)nextValue);
                }
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
        catch (QueryResolverException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)obj);
        }
    }

    protected void validateUpdate(Update update) {
        try {
            List changeList = update.getChangeList();
            HashSet<ElementSymbol> changeVars = new HashSet<ElementSymbol>(changeList.size());
            Iterator changeIter = changeList.iterator();
            while (changeIter.hasNext()) {
                Collection elements;
                ElementSymbol elementID;
                CompareCriteria cc = (CompareCriteria)changeIter.next();
                if (!(cc.getLeftExpression() instanceof ElementSymbol)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0057", (Object)SQLStringVisitor.getSQLString((LanguageObject)cc)), (LanguageObject)cc);
                }
                if ((elementID = (ElementSymbol)cc.getLeftExpression()).isExternalReference()) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0058", (Object)SQLStringVisitor.getSQLString((LanguageObject)elementID)), (LanguageObject)elementID);
                }
                if (!this.getMetadata().elementSupports(elementID.getMetadataID(), 5)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0059", (Object)elementID), (LanguageObject)elementID);
                }
                changeVars.add(elementID);
                Expression value = cc.getRightExpression();
                Expression evaluatedValue = null;
                try {
                    IsNullCriteria dummyCrit = new IsNullCriteria(value);
                    EvaluateExpressionVisitor.replaceExpressions((LanguageObject)dummyCrit, (boolean)false, (boolean)false, null);
                    evaluatedValue = dummyCrit.getExpression();
                }
                catch (ExpressionEvaluationException e) {
                    this.handleException((MetaMatrixException)((Object)e), (LanguageObject)value);
                }
                if (evaluatedValue instanceof Constant) {
                    Object newValue = ((Constant)evaluatedValue).getValue();
                    if (newValue != null || this.getMetadata().elementSupports(elementID.getMetadataID(), 4)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0060", (Object)SQLStringVisitor.getSQLString((LanguageObject)elementID)), (LanguageObject)elementID);
                    continue;
                }
                if (evaluatedValue instanceof Reference) {
                    if (evaluatedValue.getType() != null) continue;
                    ((Reference)evaluatedValue).setExpression((Expression)new Constant(null, cc.getLeftExpression().getType()));
                    continue;
                }
                GroupSymbol group = update.getGroup();
                if (!this.getMetadata().isVirtualGroup(group.getMetadataID()) || (elements = ElementCollectorVisitor.getElements((LanguageObject)evaluatedValue, (boolean)false)).size() <= 0) continue;
                Iterator iter = elements.iterator();
                while (iter.hasNext()) {
                    ElementSymbol element = (ElementSymbol)iter.next();
                    if (element.isExternalReference()) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0061", (Object)SQLStringVisitor.getSQLString((LanguageObject)value)), (LanguageObject)value);
                }
            }
            if (changeVars.size() < changeList.size()) {
                ArrayList dupList = new ArrayList();
                Iterator varIter = changeVars.iterator();
                while (varIter.hasNext()) {
                    Object id = varIter.next();
                    int counter = 0;
                    changeIter = changeList.iterator();
                    while (changeIter.hasNext()) {
                        if (!((CompareCriteria)changeIter.next()).getLeftExpression().equals(id)) continue;
                        ++counter;
                    }
                    if (counter <= true) continue;
                    dupList.add(id);
                }
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0062", dupList), dupList);
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)update);
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)update);
        }
    }

    protected void validateSelectInto(Query query) {
        List symbols = query.getSelect().getSymbols();
        GroupSymbol intoGroup = query.getInto().getGroup();
        List elementIDs = null;
        try {
            elementIDs = this.getMetadata().getElementIDsInGroupID(intoGroup.getMetadataID());
            int elementIDCount = elementIDs.size();
            for (int symbolNum = 0; symbolNum < symbols.size(); ++symbolNum) {
                String targetTypeName;
                String symbolTypeName;
                if (symbolNum >= elementIDCount) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.select_into_too_many_elements", elementIDCount), (LanguageObject)query);
                    break;
                }
                SelectSymbol symbol = (SelectSymbol)symbols.get(symbolNum);
                Object elementID = elementIDs.get(symbolNum);
                if (!this.getMetadata().elementSupports(elementID, 5)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.element_updates_not_allowed", (Object)this.getMetadata().getFullName(elementID)), (LanguageObject)intoGroup);
                }
                if (symbol instanceof MultipleElementSymbol) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.select_into_MultipleElementSymbol"), (LanguageObject)query);
                    continue;
                }
                Class symbolType = ((SingleElementSymbol)symbol).getType();
                if (symbolType == null || (symbolTypeName = DataTypeManager.getDataTypeName((Class)symbolType)).equals(targetTypeName = this.getMetadata().getElementType(elementID)) || DataTypeManager.isImplicitConversion((String)symbolTypeName, (String)targetTypeName)) continue;
                Object[] params = new Object[]{symbolTypeName, targetTypeName, new Integer(symbolNum + 1), query};
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.select_into_no_implicit_conversion", params), (LanguageObject)query);
            }
            if (symbols.size() < elementIDCount) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.select_into_too_few_elements", elementIDCount), (LanguageObject)query);
            }
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)query);
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)query);
        }
    }

    protected void validateUpdatedGroupIsPhysical(GroupSymbol group, Command command) {
        try {
            if (group.isTempGroupSymbol() || this.getMetadata().isVirtualGroup(group.getMetadataID())) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.batch_command_updated_invalid_group", (Object)group), (LanguageObject)command);
            }
        }
        catch (QueryMetadataException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)command);
        }
        catch (MetaMatrixComponentException e) {
            this.handleException((MetaMatrixException)((Object)e), (LanguageObject)command);
        }
    }

    protected void validateContainsRowsUpdatedVariable(CreateUpdateProcedureCommand obj) {
        final ArrayList assignVars = new ArrayList();
        LanguageVisitor visitor = new LanguageVisitor(){

            public void visit(AssignmentStatement obj) {
                assignVars.add(obj.getVariable());
            }
        };
        PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        boolean foundVar = false;
        Iterator varIter = assignVars.iterator();
        while (varIter.hasNext()) {
            ElementSymbol variable = (ElementSymbol)varIter.next();
            if (!variable.getShortName().equalsIgnoreCase("ROWS_UPDATED")) continue;
            foundVar = true;
            break;
        }
        if (!foundVar) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0016", (Object)"ROWS_UPDATED"), (LanguageObject)obj);
        }
    }

    protected void validateCursorNotSelected(CreateUpdateProcedureCommand obj) {
        final ArrayList cursors = new ArrayList();
        LanguageVisitor cursorVisitor = new LanguageVisitor(){

            public void visit(LoopStatement obj) {
                cursors.add(obj.getCursorName().toUpperCase());
            }

            public void visit(GroupSymbol obj) {
                if (obj.getMetadataID() instanceof TempMetadataID && !obj.isTempGroupSymbol() && cursors.contains(obj.getName().toUpperCase())) {
                    ValidationVisitor.this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_cursor_reference", (Object)obj), (LanguageObject)obj);
                }
            }
        };
        PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)cursorVisitor);
    }

    protected void validateProcInputElement(CompareCriteria obj) {
        Expression leftExpr = obj.getLeftExpression();
        Expression rightExpr = obj.getRightExpression();
        if (this.containsProcedureInputElement((LanguageObject)obj)) {
            try {
                if (!(leftExpr instanceof ElementSymbol)) {
                    Function function;
                    boolean implicit = false;
                    if (leftExpr instanceof Function && (function = (Function)leftExpr).isImplicit() && function.getArgs().length == 2 && function.getArg(0) instanceof ElementSymbol) {
                        this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_pi_syntax_with_convert", (Object)obj), (LanguageObject)obj);
                        implicit = true;
                    }
                    if (!implicit) {
                        this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_pi_syntax", (Object)obj), (LanguageObject)obj);
                    }
                } else if (this.inputs != null && !this.inputs.containsKey(leftExpr)) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_pi_syntax", (Object)obj), (LanguageObject)obj);
                } else if (obj.getOperator() != 1) {
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_pi_syntax", (Object)obj), (LanguageObject)obj);
                } else {
                    this.validateInputExpression((LanguageObject)obj, rightExpr);
                    this.checkForMultipleAssignments((LanguageObject)obj, (ElementSymbol)leftExpr);
                }
            }
            catch (QueryMetadataException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)leftExpr);
            }
            catch (MetaMatrixComponentException e) {
                this.handleException((MetaMatrixException)((Object)e), (LanguageObject)leftExpr);
            }
        }
    }

    private void checkForMultipleAssignments(LanguageObject obj, ElementSymbol leftExpr) {
        if (this.assignedInputs.contains(leftExpr)) {
            this.handleValidationError(QueryPlugin.Util.getString("Input_element_assigned_more_than_once_in_criteria", (Object)leftExpr), obj);
        } else {
            this.assignedInputs.add(leftExpr);
        }
    }

    private boolean validateInputExpression(LanguageObject obj, Expression expr) throws MetaMatrixComponentException, QueryMetadataException {
        EvaluatableVisitor visitor = new EvaluatableVisitor(false, false){

            public void visit(ElementSymbol obj) {
                try {
                    if (ValidationVisitor.this.getMetadata().elementSupports(obj.getMetadataID(), 0) || ValidationVisitor.this.inputs != null && ValidationVisitor.this.inputs.containsKey(obj)) {
                        super.visit(obj);
                    }
                }
                catch (MetaMatrixException e) {
                    this.evaluationPossible = false;
                    this.setAbort(true);
                }
            }
        };
        DeepPreOrderNavigator.doVisit((LanguageObject)expr, (LanguageVisitor)visitor);
        if (!visitor.isEvaluationPossible()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.proc_input_element", (Object)expr), obj);
        }
        return visitor.isEvaluationPossible();
    }

    private void validateRowLimitFunctionNotInInvalidCriteria(Criteria obj) {
        ArrayList rowLimitFunctions = new ArrayList();
        FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimit");
        PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        visitor = new FunctionCollectorVisitor(rowLimitFunctions, "rowlimitexception");
        PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        if (rowLimitFunctions.size() > 0) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.3"), (LanguageObject)obj);
        }
    }

    private void validateCannotContainProcedureInputElement(Criteria obj) {
        if (this.containsProcedureInputElement((LanguageObject)obj)) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.contains_pi", (Object)obj), (LanguageObject)obj);
        }
    }

    private boolean containsProcedureInputElement(LanguageObject obj) {
        if (this.inputs == null) {
            return false;
        }
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)obj, (boolean)false, (boolean)false);
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            ElementSymbol element = (ElementSymbol)i.next();
            if (!this.inputs.containsKey(element)) continue;
            return true;
        }
        return false;
    }

    public void visit(BetweenCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
        this.validateCannotContainProcedureInputElement((Criteria)obj);
    }

    public void visit(IsNullCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
        if (this.containsProcedureInputElement((LanguageObject)obj)) {
            if (obj.isNegated()) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.pi_isNotNull"), (LanguageObject)obj);
            } else if (!(obj.getExpression() instanceof ElementSymbol)) {
                this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.invalid_pi_syntax_isnull"), (LanguageObject)obj);
            } else {
                this.checkForMultipleAssignments((LanguageObject)obj, (ElementSymbol)obj.getExpression());
            }
        }
    }

    public void visit(MatchCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
        this.validateCannotContainProcedureInputElement((Criteria)obj);
    }

    public void visit(NotCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
        this.validateCannotContainProcedureInputElement((Criteria)obj);
    }

    public void visit(SetCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
        this.validateCannotContainProcedureInputElement((Criteria)obj);
    }

    public void visit(SubqueryCompareCriteria obj) {
        this.validateRowLimitFunctionNotInInvalidCriteria((Criteria)obj);
        this.validateCannotContainProcedureInputElement((Criteria)obj);
    }

    public void visit(Option obj) {
        List dep = obj.getDependentGroups();
        List notDep = obj.getNotDependentGroups();
        if (dep != null && !dep.isEmpty() && notDep != null && !notDep.isEmpty()) {
            String groupName = null;
            String notDepGroup = null;
            Iterator i = dep.iterator();
            while (i.hasNext()) {
                groupName = (String)i.next();
                Iterator j = notDep.iterator();
                while (j.hasNext()) {
                    notDepGroup = (String)j.next();
                    if (!notDepGroup.equalsIgnoreCase(groupName)) continue;
                    this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.group_in_both_dep", (Object)groupName), (LanguageObject)obj);
                    return;
                }
            }
        }
    }

    public void visit(DynamicCommand obj) {
        if (obj.getIntoGroup() != null && !obj.getIntoGroup().isTempGroupSymbol()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.temp_group_in_dynamic", (Object)obj));
        }
        if (!CommandCollectorVisitor.getCommands((LanguageObject)obj).isEmpty()) {
            this.handleValidationError(QueryPlugin.Util.getString("ValidationVisitor.assignment_subquery"), (LanguageObject)obj);
        }
    }
}

