/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.CommandPlanner;
import com.metamatrix.query.optimizer.CommandTreeNode;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.GenerateCanonical;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.PlanHints;
import com.metamatrix.query.optimizer.relational.PlanToProcessConverter;
import com.metamatrix.query.optimizer.relational.RelationalCommandConstants;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.CorrelatedReferenceCollectorVisitor;
import com.metamatrix.query.sql.visitor.CorrelatedVariableSubstitutionVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelationalPlanner
implements CommandPlanner {
    public void generateCanonical(CommandTreeNode node, QueryMetadataInterface metadata, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Command command = node.getCommand();
        try {
            CorrelatedVariableSubstitutionVisitor.substituteVariables((LanguageObject)node.getCommand(), (QueryMetadataInterface)metadata);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0070"));
        }
        PlanHints hints = (PlanHints)node.getProperty(RelationalCommandConstants.HINTS);
        PlanNode canonicalPlan = GenerateCanonical.generatePlan((Command)command, (PlanHints)hints, (QueryMetadataInterface)metadata);
        if (canonicalPlan == null) {
            return;
        }
        node.setCanonicalPlan((Object)canonicalPlan);
        if (command.getSubCommands() != null) {
            RelationalPlanner.saveNestedCommands(canonicalPlan, node.getCommand().getSubCommands(), metadata);
        }
        RelationalPlanner.removeSubqueryReferences(canonicalPlan);
        HashSet groupSymbols = new HashSet();
        RelationalPlanner.findGroupsFromSourceNodes(canonicalPlan, groupSymbols);
        RelationalPlanner.connectCorrelatedReferences(canonicalPlan, groupSymbols);
    }

    private static void saveNestedCommands(PlanNode canonicalPlan, List subCommands, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        int subCommandIndex = 0;
        List sourceNodes = NodeEditor.findAllNodes((PlanNode)canonicalPlan, (int)6);
        Iterator sourceIter = sourceNodes.iterator();
        while (sourceIter.hasNext() && subCommandIndex < subCommands.size()) {
            PlanNode parentProject;
            PlanNode sourceNode = (PlanNode)sourceIter.next();
            GroupSymbol sourceGroup = (GroupSymbol)sourceNode.getGroups().iterator().next();
            if (!metadata.isVirtualGroup(sourceGroup.getMetadataID())) continue;
            for (parentProject = sourceNode.getParent(); parentProject != null && parentProject.getType() != 3; parentProject = parentProject.getParent()) {
            }
            if (parentProject != null && parentProject.getProperty((Object)NodeConstants.Info.INTO_GROUP) != null || sourceGroup.isTempGroupSymbol()) continue;
            sourceNode.setProperty((Object)NodeConstants.Info.NESTED_COMMAND, subCommands.get(subCommandIndex));
            ++subCommandIndex;
        }
    }

    public ProcessorPlan optimize(CommandTreeNode node, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode plan = (PlanNode)node.getCanonicalPlan();
        Map planMap = RelationalPlanner.connectChildPlans(plan, node);
        Command command = node.getCommand();
        PlanHints hints = (PlanHints)node.getProperty(RelationalCommandConstants.HINTS);
        RelationalPlanner.checkForVirtualGroups(command, hints, metadata);
        if (hints.makeDepGroups != null) {
            RelationalPlanner.distributeDependentHints(hints.makeDepGroups, plan, metadata, NodeConstants.Info.MAKE_DEP);
        }
        if (hints.makeNotDepGroups != null) {
            RelationalPlanner.distributeDependentHints(hints.makeNotDepGroups, plan, metadata, NodeConstants.Info.MAKE_NOT_DEP);
        }
        if (!planMap.isEmpty()) {
            RelationalPlanner.connectSubqueryContainers(planMap, plan);
        }
        RuleStack rules = RelationalPlanner.buildRules(hints);
        plan = RelationalPlanner.executeRules(rules, plan, metadata, capFinder, analysisRecord, context);
        node.setCanonicalPlan((Object)plan);
        if (!planMap.isEmpty()) {
            RelationalPlanner.connectSubqueryContainers(planMap, plan);
        }
        ProcessorPlan result = PlanToProcessConverter.convert((PlanNode)plan, (QueryMetadataInterface)metadata, (IDGenerator)idGenerator, (AnalysisRecord)analysisRecord, (CapabilitiesFinder)capFinder);
        return result;
    }

    private static void findGroupsFromSourceNodes(PlanNode node, Set groupSymbols) {
        if (node.getType() == 6) {
            groupSymbols.addAll(node.getGroups());
        } else if (node.getChildCount() > 0) {
            List children = node.getChildren();
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                PlanNode childNode = (PlanNode)childIter.next();
                RelationalPlanner.findGroupsFromSourceNodes(childNode, groupSymbols);
            }
        }
    }

    private static void connectCorrelatedReferences(PlanNode node, Set groupSymbols) {
        if (node.getType() == 4 || node.getType() == 3) {
            ArrayList subqueryContainers = new ArrayList();
            if (node.getType() == 4) {
                Criteria criteria = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)criteria, subqueryContainers);
            } else {
                Collection projectCols = (Collection)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((Collection)projectCols, subqueryContainers);
            }
            if (subqueryContainers.size() > 0) {
                ArrayList correlatedReferences = new ArrayList();
                Iterator i = subqueryContainers.iterator();
                while (i.hasNext()) {
                    SubqueryContainer container = (SubqueryContainer)i.next();
                    Command subCommand = container.getCommand();
                    CorrelatedReferenceCollectorVisitor.collectReferences((LanguageObject)subCommand, (Collection)groupSymbols, correlatedReferences);
                }
                if (!correlatedReferences.isEmpty()) {
                    node.setProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES, correlatedReferences);
                }
            }
        }
        if (node.getChildCount() > 0) {
            List children = node.getChildren();
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                PlanNode childNode = (PlanNode)childIter.next();
                RelationalPlanner.connectCorrelatedReferences(childNode, groupSymbols);
            }
        }
    }

    private static void connectSubqueryContainers(Map planMap, PlanNode plan) {
        if (plan.getType() == 4 || plan.getType() == 3) {
            ArrayList subqueryContainers = new ArrayList();
            if (plan.getType() == 4) {
                Criteria criteria = (Criteria)plan.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)criteria, subqueryContainers);
            } else {
                Collection projectCols = (Collection)plan.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((Collection)projectCols, subqueryContainers);
            }
            if (subqueryContainers.size() > 0) {
                ArrayList plans = new ArrayList(subqueryContainers.size());
                Iterator i = subqueryContainers.iterator();
                while (i.hasNext()) {
                    SubqueryContainer container = (SubqueryContainer)i.next();
                    Command subCommand = container.getCommand();
                    Object processorPlan = planMap.get(subCommand);
                    plans.add(processorPlan);
                }
                plan.setProperty((Object)NodeConstants.Info.SUBQUERY_PLANS, plans);
                plan.setProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS, subqueryContainers);
            }
        }
        if (plan.getChildCount() > 0) {
            List children = plan.getChildren();
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                PlanNode childNode = (PlanNode)childIter.next();
                RelationalPlanner.connectSubqueryContainers(planMap, childNode);
            }
        }
    }

    private static Map connectChildPlans(PlanNode plan, CommandTreeNode commandNode) {
        List commandChildren = commandNode.getChildren();
        if (commandChildren.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        IdentityHashMap<Command, ProcessorPlan> planMap = new IdentityHashMap<Command, ProcessorPlan>();
        Iterator childIter = commandChildren.iterator();
        int i = 0;
        while (childIter.hasNext()) {
            CommandTreeNode child = (CommandTreeNode)childIter.next();
            planMap.put(child.getCommand(), child.getProcessorPlan());
            ++i;
        }
        RelationalPlanner.setProcessorPlans(plan, planMap);
        return planMap;
    }

    private static void setProcessorPlans(PlanNode plan, Map planMap) {
        Object nodeCommand;
        ProcessorPlan subPlan;
        if (plan.getType() == 6 && (subPlan = (ProcessorPlan)planMap.get(nodeCommand = plan.getProperty((Object)NodeConstants.Info.NESTED_COMMAND))) != null) {
            plan.setProperty((Object)NodeConstants.Info.PROCESSOR_PLAN, (Object)subPlan);
        }
        if (plan.getChildCount() > 0) {
            List children = plan.getChildren();
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                PlanNode childNode = (PlanNode)childIter.next();
                RelationalPlanner.setProcessorPlans(childNode, planMap);
            }
        }
    }

    private static void checkForVirtualGroups(Command command, PlanHints hints, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true);
        Iterator groupIter = groups.iterator();
        while (groupIter.hasNext()) {
            GroupSymbol group = (GroupSymbol)groupIter.next();
            if (!metadata.isVirtualGroup(group.getMetadataID())) continue;
            hints.hasVirtualGroups = true;
            break;
        }
    }

    private static void distributeDependentHints(Collection groups, PlanNode plan, QueryMetadataInterface metadata, Integer hintProperty) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        if (groups != null && groups.size() > 0) {
            List nodes = NodeEditor.findAllNodes((PlanNode)plan, (int)6);
            Iterator groupIter = groups.iterator();
            while (groupIter.hasNext()) {
                String groupName = (String)groupIter.next();
                boolean appliedHint = RelationalPlanner.applyHint(nodes, groupName, hintProperty);
                if (appliedHint) continue;
                Collection groupNames = metadata.getGroupsForPartialName(groupName);
                if (groupNames.size() == 1) {
                    groupName = (String)groupNames.iterator().next();
                    appliedHint = RelationalPlanner.applyHint(nodes, groupName, hintProperty);
                }
                if (appliedHint) continue;
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("ERR.015.004.0010", (Object)groupName));
            }
        }
    }

    private static boolean applyHint(List nodes, String groupName, Integer hintProperty) {
        boolean appliedHint = false;
        Iterator nodeIter = nodes.iterator();
        while (nodeIter.hasNext()) {
            PlanNode node = (PlanNode)nodeIter.next();
            GroupSymbol nodeGroup = (GroupSymbol)node.getGroups().iterator().next();
            if (!nodeGroup.getName().equalsIgnoreCase(groupName)) continue;
            node.setProperty((Object)hintProperty, (Object)Boolean.TRUE);
            appliedHint = true;
        }
        return appliedHint;
    }

    private static void removeSubqueryReferences(PlanNode plan) {
        List joinNodes = NodeEditor.findAllNodes((PlanNode)plan, (int)2);
        Iterator joinIter = joinNodes.iterator();
        while (joinIter.hasNext()) {
            PlanNode joinNode = (PlanNode)joinIter.next();
            From from = (From)joinNode.getProperty((Object)NodeConstants.Info.FROM_CLAUSE);
            joinNode.setProperty((Object)NodeConstants.Info.FROM_CLAUSE, (Object)RelationalPlanner.removeSubqueriesFromFrom(from));
        }
    }

    static From removeSubqueriesFromFrom(From from) {
        From fixedFrom = new From();
        List clauses = from.getClauses();
        Iterator iter = clauses.iterator();
        while (iter.hasNext()) {
            FromClause clause = (FromClause)iter.next();
            fixedFrom.addClause(RelationalPlanner.getReplacementClause(clause));
        }
        return fixedFrom;
    }

    static FromClause getReplacementClause(FromClause clause) {
        if (clause instanceof UnaryFromClause) {
            return clause;
        }
        if (clause instanceof JoinPredicate) {
            JoinPredicate jp = (JoinPredicate)clause;
            jp.setLeftClause(RelationalPlanner.getReplacementClause(jp.getLeftClause()));
            jp.setRightClause(RelationalPlanner.getReplacementClause(jp.getRightClause()));
            return jp;
        }
        UnaryFromClause fromClause = new UnaryFromClause(((SubqueryFromClause)clause).getGroupSymbol());
        fromClause.setOptional(clause.isOptional());
        return fromClause;
    }

    public static RuleStack buildRules(PlanHints hints) {
        RuleStack rules = new RuleStack();
        if (hints.needsWhereAllValidation) {
            rules.push(RuleConstants.VALIDATE_WHERE_ALL);
        }
        rules.push(RuleConstants.ACCESS_PATTERN_VALIDATION);
        if (hints.hasJoin) {
            rules.push(RuleConstants.MAKE_DEPENDENT);
        }
        if (hints.hasOptionalNodes) {
            rules.push(RuleConstants.REMOVE_OPTIONAL_JOINS);
        }
        rules.push(RuleConstants.COLLAPSE_SOURCE);
        rules.push(RuleConstants.ASSIGN_OUTPUT_ELEMENTS);
        if (hints.hasJoin) {
            rules.push(RuleConstants.CHOOSE_DEPENDENT);
            rules.push(RuleConstants.CHOOSE_MERGE_JOINS);
        }
        if (hints.hasAggregates) {
            rules.push(RuleConstants.PUSH_AGGREGATES);
        }
        if (hints.hasCriteria || hints.hasJoin) {
            rules.push(RuleConstants.RAISE_NULL);
            rules.push(RuleConstants.MERGE_CRITERIA);
        }
        if (hints.hasCriteria) {
            rules.push(RuleConstants.ATTACH_SUBQUERY_PLANS);
        }
        rules.push(RuleConstants.RAISE_ACCESS);
        if (hints.hasCriteria || hints.hasJoin) {
            rules.push(RuleConstants.CLEAN_CRITERIA);
        }
        if (hints.hasJoin) {
            rules.push(RuleConstants.COPY_CRITERIA);
            rules.push(RuleConstants.PUSH_NON_JOIN_CRITERIA);
            if (hints.hasCriteria) {
                rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
            }
            rules.push(RuleConstants.CHANGE_JOIN_TYPE);
            rules.push(RuleConstants.BREAK_MULTI_JOIN);
        }
        if (hints.hasVirtualGroups) {
            if (hints.hasCriteria) {
                rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
            }
            rules.push(RuleConstants.MERGE_VIRTUAL);
        }
        if (hints.hasCriteria) {
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
            rules.push(RuleConstants.BREAK_CRITERIA);
        }
        rules.push(RuleConstants.PLACE_ACCESS);
        if (hints.hasSort) {
            rules.push(RuleConstants.REMOVE_SORTS);
        }
        if (hints.isUpdate) {
            rules.push(RuleConstants.REMOVE_UPDATE_SOURCE);
        }
        return rules;
    }

    private static PlanNode executeRules(RuleStack rules, PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean debug = analysisRecord.recordDebug();
        while (!rules.isEmpty()) {
            if (debug) {
                analysisRecord.println("\n============================================================================");
            }
            OptimizerRule rule = rules.pop();
            if (debug) {
                analysisRecord.println("EXECUTING " + rule);
            }
            plan = rule.execute(plan, metadata, capFinder, rules, analysisRecord, context);
            if (!debug) continue;
            analysisRecord.println("\nAFTER: \n" + plan);
        }
        return plan;
    }
}

