/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.dynamic;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.multisource.PlanModifier;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.QueryOptimizer;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.parser.QueryParser;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.processor.dynamic.SQLSource;
import com.metamatrix.query.processor.dynamic.XMLSource;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.util.TypeRetrievalUtil;
import com.metamatrix.query.xquery.XQuerySQLEvaluator;
import java.util.List;
import javax.xml.transform.Source;

public class SqlEval
implements XQuerySQLEvaluator {
    private QueryMetadataInterface metadata;
    private CommandContext context;
    private CapabilitiesFinder finder;
    private IDGenerator idGenerator;
    private BufferManager bufferMgr;
    private ProcessorDataManager dataMgr;

    public SqlEval(QueryMetadataInterface metadata, CommandContext context, CapabilitiesFinder finder, IDGenerator idGenerator, BufferManager bufferMgr, ProcessorDataManager dataMgr) {
        this.metadata = metadata;
        this.context = context;
        this.finder = finder;
        this.idGenerator = idGenerator;
        this.bufferMgr = bufferMgr;
        this.dataMgr = dataMgr;
    }

    public Source executeSQL(String sql) throws QueryParserException, MetaMatrixProcessingException, MetaMatrixComponentException {
        QueryParser parser = new QueryParser();
        Command command = parser.parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)this.metadata);
        QueryRewriter.rewrite((Command)command, null, (QueryMetadataInterface)this.metadata, (CommandContext)this.context);
        ProcessorPlan plan = QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)this.metadata, (IDGenerator)this.idGenerator, (CapabilitiesFinder)this.finder, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord(), (CommandContext)this.context);
        PlanModifier multiSourcePlanModifier = (PlanModifier)this.context.getMultiSourcePlanModifier();
        if (multiSourcePlanModifier != null) {
            multiSourcePlanModifier.modifyPlan(plan, this.metadata);
        }
        List elements = plan.getOutputElements();
        CommandContext copy = (CommandContext)this.context.clone();
        copy.setTupleSourceID(this.bufferMgr.createTupleSource(elements, TypeRetrievalUtil.getTypeNames((List)elements), this.context.getConnectionID(), 1));
        QueryProcessor processor = new QueryProcessor(plan, copy, this.bufferMgr, this.dataMgr);
        try {
            processor.process();
        }
        catch (MetaMatrixComponentException e) {
            throw e;
        }
        catch (MetaMatrixProcessingException e) {
            throw e;
        }
        catch (MetaMatrixException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
        TupleSourceID tsID = processor.getResultsID();
        TupleSource src = this.bufferMgr.getTupleSource(tsID);
        String[] columns = this.elementNames(elements);
        Class[] types = this.elementTypes(elements);
        boolean xml = false;
        if (elements.size() > 0) {
            xml = ((SingleElementSymbol)elements.get(0)).getType().equals(DataTypeManager.DefaultDataClasses.XML);
        }
        if (xml) {
            return XMLSource.createSource((String[])columns, (Class[])types, (TupleSource)src, (QueryProcessor)processor);
        }
        return SQLSource.createSource((String[])columns, (Class[])types, (TupleSource)src);
    }

    String[] elementNames(List elements) {
        String[] columns = new String[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            SingleElementSymbol element = (SingleElementSymbol)elements.get(i);
            String name = element.getName();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(index + 1);
            }
            columns[i] = name;
        }
        return columns;
    }

    Class[] elementTypes(List elements) {
        Class[] types = new Class[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            SingleElementSymbol element = (SingleElementSymbol)elements.get(i);
            types[i] = element.getType();
        }
        return types;
    }
}

