/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.DependentJoinData;
import com.metamatrix.query.optimizer.relational.rules.RuleAssignOutputElements;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.DependentSetCriteriaCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.sql.visitor.RemoveGroupAliasMappingVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleCollapseSource
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List accessNodes = NodeEditor.findAllNodes((PlanNode)plan, (int)0);
        for (int i = 0; i < accessNodes.size(); ++i) {
            PlanNode accessNode = (PlanNode)accessNodes.get(i);
            ProcessorPlan nonRelationalPlan = RuleCollapseSource.getNestedPlan(accessNode);
            if (nonRelationalPlan != null) {
                accessNode.setProperty((Object)NodeConstants.Info.PROCESSOR_PLAN, (Object)nonRelationalPlan);
            } else {
                Command command = RuleCollapseSource.isNotQuery(accessNode);
                if (command == null) {
                    command = this.createQuery(metadata, capFinder, accessNode, accessNode);
                } else {
                    List columns = (List)accessNode.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
                    RuleAssignOutputElements.assignOutputElementsToCommand((PlanNode)accessNode, (List)columns, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder, (Command)command);
                }
                accessNode.setProperty((Object)NodeConstants.Info.ATOMIC_REQUEST, (Object)command);
                if (DependentSetCriteriaCollectorVisitor.getDependentSetCriteria((LanguageObject)command).size() > 0) {
                    accessNode.setProperty((Object)NodeConstants.Info.DEPENDENT_SET_CRITS, (Object)Boolean.TRUE);
                }
            }
            NodeEditor.cutLast((PlanNode)accessNode);
        }
        this.fixNoElements(plan, metadata, capFinder);
        return plan;
    }

    private QueryCommand createQuery(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode accessRoot, PlanNode node) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        boolean isSetQuery = false;
        for (PlanNode child = node; child != null && child.getType() != 6; child = child.getFirstChild()) {
            if (child.getType() != 8) continue;
            isSetQuery = true;
            break;
        }
        if (isSetQuery) {
            SetQuery unionCommand = new SetQuery();
            this.buildSetQuery(accessRoot, node, unionCommand, metadata, capFinder);
            return unionCommand;
        }
        Query query = new Query();
        query.setSelect(new Select());
        query.setFrom(new From());
        this.buildQuery(accessRoot, node, query, metadata, capFinder);
        if (query.getCriteria() instanceof CompoundCriteria) {
            query.setCriteria(QueryRewriter.optimizeCriteria((CompoundCriteria)((CompoundCriteria)query.getCriteria())));
        }
        this.removeAliases(accessRoot, (QueryCommand)query, metadata, capFinder);
        this.simplifyFromClause(query);
        List columns = (List)node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
        RuleAssignOutputElements.assignOutputElementsToCommand((PlanNode)node, (List)columns, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder, (Command)query);
        return query;
    }

    static ProcessorPlan getNestedPlan(PlanNode accessNode) {
        ProcessorPlan plan = null;
        PlanNode sourceNode = accessNode.getFirstChild();
        if (sourceNode.getType() != 6) {
            sourceNode = sourceNode.getFirstChild();
        }
        if (sourceNode.getType() == 6) {
            plan = (ProcessorPlan)sourceNode.getProperty((Object)NodeConstants.Info.PROCESSOR_PLAN);
        }
        return plan;
    }

    static Command isNotQuery(PlanNode node) {
        Command command;
        PlanNode sourceNode = node.getFirstChild();
        if (sourceNode.getType() != 6) {
            sourceNode = sourceNode.getFirstChild();
        }
        if (sourceNode.getType() == 6 && !((command = (Command)sourceNode.getProperty((Object)NodeConstants.Info.VIRTUAL_COMMAND)) instanceof QueryCommand)) {
            return command;
        }
        return null;
    }

    void buildQuery(PlanNode accessRoot, PlanNode node, Query query, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        switch (node.getType()) {
            case 2: {
                JoinType joinType = (JoinType)node.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
                ArrayList<Criteria> crits = (ArrayList<Criteria>)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
                if (crits == null || crits.isEmpty()) {
                    crits = new ArrayList<Criteria>();
                }
                PlanNode left = node.getFirstChild();
                PlanNode right = node.getLastChild();
                Criteria savedCriteria = null;
                this.buildQuery(accessRoot, left, query, metadata, capFinder);
                if (joinType == JoinType.JOIN_LEFT_OUTER) {
                    savedCriteria = query.getCriteria();
                    query.setCriteria(null);
                } else if (joinType == JoinType.JOIN_RIGHT_OUTER || joinType == JoinType.JOIN_CROSS) {
                    this.moveWhereClauseIntoOnClause(query, crits);
                }
                this.buildQuery(accessRoot, right, query, metadata, capFinder);
                if (joinType == JoinType.JOIN_LEFT_OUTER) {
                    this.moveWhereClauseIntoOnClause(query, crits);
                    query.setCriteria(savedCriteria);
                } else if (joinType == JoinType.JOIN_CROSS) {
                    this.moveWhereClauseIntoOnClause(query, crits);
                }
                From from = query.getFrom();
                List clauses = from.getClauses();
                int lastClause = clauses.size() - 1;
                FromClause clause1 = (FromClause)clauses.get(lastClause - 1);
                FromClause clause2 = (FromClause)clauses.get(lastClause);
                if (joinType != JoinType.JOIN_CROSS && crits.isEmpty()) {
                    crits.add(QueryRewriter.TRUE_CRITERIA);
                } else if (joinType == JoinType.JOIN_CROSS && !crits.isEmpty()) {
                    joinType = JoinType.JOIN_INNER;
                }
                JoinPredicate jp = new JoinPredicate(clause1, clause2, joinType, crits);
                clauses.remove(lastClause);
                clauses.set(lastClause - 1, jp);
                return;
            }
            case 6: {
                if (Boolean.TRUE.equals(node.getProperty((Object)NodeConstants.Info.INLINE_VIEW))) {
                    PlanNode child = NodeEditor.cutLast((PlanNode)node);
                    QueryCommand newQuery = this.createQuery(metadata, capFinder, accessRoot, child);
                    GroupSymbol symbol = (GroupSymbol)node.getGroups().iterator().next();
                    SubqueryFromClause sfc = new SubqueryFromClause(symbol.getName(), (Command)newQuery);
                    sfc.getGroupSymbol().setMetadataID(symbol.getMetadataID());
                    query.getFrom().addClause((FromClause)sfc);
                    return;
                }
                query.getFrom().addGroups((Collection)node.getGroups());
            }
        }
        Iterator childIter = node.getChildren().iterator();
        while (childIter.hasNext()) {
            PlanNode childNode = (PlanNode)childIter.next();
            this.buildQuery(accessRoot, childNode, query, metadata, capFinder);
        }
        switch (node.getType()) {
            case 4: {
                Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                Boolean isHaving = (Boolean)node.getProperty((Object)NodeConstants.Info.IS_HAVING);
                if (isHaving == null || isHaving.equals(Boolean.FALSE)) {
                    query.setCriteria(CompoundCriteria.combineCriteria((Criteria)query.getCriteria(), (Criteria)crit));
                    break;
                }
                query.setHaving(CompoundCriteria.combineCriteria((Criteria)query.getHaving(), (Criteria)crit));
                break;
            }
            case 5: {
                this.processOrderBy(node, (QueryCommand)query);
                break;
            }
            case 1: {
                query.getSelect().setDistinct(true);
                break;
            }
            case 7: {
                List groups = (List)node.getProperty((Object)NodeConstants.Info.GROUP_COLS);
                if (groups == null) break;
                query.setGroupBy(new GroupBy(groups));
                break;
            }
            case 11: {
                Expression limit = (Expression)node.getProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT);
                if (query.getLimit() != null) {
                    query.getLimit().setRowLimit(limit);
                    break;
                }
                query.setLimit(new Limit(null, limit));
                break;
            }
            case 10: {
                Expression offset = (Expression)node.getProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT);
                if (query.getLimit() != null) {
                    query.getLimit().setOffset(offset);
                    break;
                }
                query.setLimit(new Limit(offset, (Expression)new Constant((Object)new Integer(0), DataTypeManager.DefaultDataClasses.INTEGER)));
                break;
            }
        }
    }

    private void moveWhereClauseIntoOnClause(Query query, List joinCrits) {
        if (query.getCriteria() == null) {
            return;
        }
        LinkedHashSet combinedCrits = new LinkedHashSet();
        combinedCrits.addAll(joinCrits);
        this.buildCriteriaList(query.getCriteria(), combinedCrits);
        joinCrits.clear();
        joinCrits.addAll(combinedCrits);
        query.setCriteria(null);
    }

    private void buildCriteriaList(Criteria criteria, Collection combinedCrits) {
        if (criteria instanceof CompoundCriteria) {
            CompoundCriteria crit = (CompoundCriteria)criteria;
            if (crit.getOperator() == 0) {
                combinedCrits.addAll(crit.getCriteria());
            } else {
                combinedCrits.add(crit);
            }
        } else {
            combinedCrits.add(criteria);
        }
    }

    void buildSetQuery(PlanNode accessRoot, PlanNode node, SetQuery query, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        switch (node.getType()) {
            case 8: {
                this.collapseUnion(accessRoot, node, query, metadata, capFinder);
                return;
            }
        }
        Iterator childIter = node.getChildren().iterator();
        while (childIter.hasNext()) {
            PlanNode childNode = (PlanNode)childIter.next();
            this.buildSetQuery(accessRoot, childNode, query, metadata, capFinder);
        }
        if (node.getType() == 5) {
            this.processOrderBy(node, (QueryCommand)query);
        }
    }

    private void processOrderBy(PlanNode node, QueryCommand query) {
        List params = (List)node.getProperty((Object)NodeConstants.Info.SORT_ORDER);
        List types = (List)node.getProperty((Object)NodeConstants.Info.ORDER_TYPES);
        OrderBy orderBy = new OrderBy(params, types);
        query.setOrderBy(orderBy);
    }

    private void simplifyFromClause(Query query) {
        From from = query.getFrom();
        List clauses = from.getClauses();
        FromClause rootClause = (FromClause)clauses.get(0);
        if (rootClause instanceof UnaryFromClause) {
            return;
        }
        if (!this.hasOuterJoins(rootClause)) {
            from.setClauses(new ArrayList());
            this.shredJoinTree(rootClause, query);
        }
    }

    private void shredJoinTree(FromClause clause, Query query) {
        if (clause instanceof UnaryFromClause || clause instanceof SubqueryFromClause) {
            query.getFrom().addClause(clause);
        } else {
            JoinPredicate jp = (JoinPredicate)clause;
            Criteria crit = query.getCriteria();
            List crits = jp.getJoinCriteria();
            if (crits != null && crits.size() > 0) {
                Iterator critIter = crits.iterator();
                while (critIter.hasNext()) {
                    crit = CompoundCriteria.combineCriteria((Criteria)crit, (Criteria)((Criteria)critIter.next()));
                }
                query.setCriteria(crit);
            }
            this.shredJoinTree(jp.getLeftClause(), query);
            this.shredJoinTree(jp.getRightClause(), query);
        }
    }

    private boolean hasOuterJoins(FromClause clause) {
        if (clause instanceof UnaryFromClause || clause instanceof SubqueryFromClause) {
            return false;
        }
        JoinPredicate jp = (JoinPredicate)clause;
        if (jp.getJoinType().isOuter()) {
            return true;
        }
        boolean childHasOuter = this.hasOuterJoins(jp.getLeftClause());
        if (childHasOuter) {
            return true;
        }
        return this.hasOuterJoins(jp.getRightClause());
    }

    private void removeAliases(PlanNode accessNode, QueryCommand query, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = RuleRaiseAccess.getModelIDFromAccess((PlanNode)accessNode, (QueryMetadataInterface)metadata);
        if (modelID != null && CapabilitiesUtil.supportsGroupAliases((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
            return;
        }
        RemoveGroupAliasMappingVisitor.removeAliases((LanguageObject)query);
        DependentJoinData depJoin = (DependentJoinData)accessNode.getProperty((Object)NodeConstants.Info.DEPENDENT_JOIN_DATA);
        if (depJoin != null && this.isModelMatch(accessNode.getGroups(), depJoin.getDependentExpressions(), metadata)) {
            this.removeAliases(depJoin.getDependentExpressions());
        }
    }

    private boolean isModelMatch(Set groups, List expressions, QueryMetadataInterface metadata) {
        Iterator exprIter = expressions.iterator();
        while (exprIter.hasNext()) {
            Expression expr = (Expression)exprIter.next();
            Collection exprGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)expr);
            if (exprGroups.size() <= 0 || !groups.containsAll(exprGroups)) continue;
            return true;
        }
        return false;
    }

    private void removeAliases(List expressions) {
        IsNullCriteria holderCrit = new IsNullCriteria();
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expr = (Expression)expressions.get(i);
            holderCrit.setExpression(expr);
            RemoveGroupAliasMappingVisitor.removeAliases((LanguageObject)holderCrit);
            expressions.set(i, holderCrit.getExpression());
        }
    }

    private void collapseUnion(PlanNode accessRoot, PlanNode unionNode, SetQuery unionCommand, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        boolean unionAll = (Boolean)unionNode.getProperty((Object)NodeConstants.Info.USE_ALL);
        boolean first = true;
        Iterator projectNodeIter = unionNode.getChildren().iterator();
        while (projectNodeIter.hasNext()) {
            PlanNode projectNode = (PlanNode)projectNodeIter.next();
            QueryCommand command = this.createQuery(metadata, capFinder, accessRoot, projectNode);
            if (first) {
                if (command instanceof SetQuery && ((SetQuery)command).getOrderBy() == null) {
                    Iterator queries = ((SetQuery)command).getQueries().iterator();
                    while (queries.hasNext()) {
                        unionCommand.addQuery((QueryCommand)queries.next(), unionAll);
                    }
                } else {
                    unionCommand.addQuery(command, unionAll);
                }
                this.correctPushedAliasedLiterals(command, projectNode);
                first = false;
                continue;
            }
            unionCommand.addQuery(command, unionAll);
        }
    }

    private void correctPushedAliasedLiterals(QueryCommand command, PlanNode projectNode) {
        PlanNode parent;
        if (!(command instanceof Query)) {
            return;
        }
        if ((projectNode = RuleRaiseAccess.getLowerProject((PlanNode)projectNode)) == null) {
            return;
        }
        Query query = (Query)command;
        Select select = query.getSelect();
        List selectSymbols = select.getSymbols();
        for (parent = projectNode.getParent(); parent != null && parent.getType() != 6; parent = parent.getParent()) {
        }
        Map symbolMap = null;
        if (parent != null) {
            symbolMap = (Map)parent.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
        }
        List projectCols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
        Iterator iter = projectCols.iterator();
        int i = 0;
        while (iter.hasNext()) {
            SingleElementSymbol projSymbol = (SingleElementSymbol)iter.next();
            if (projSymbol instanceof AliasSymbol) {
                AliasSymbol alias = (AliasSymbol)projSymbol;
                projSymbol = alias.getSymbol();
                SingleElementSymbol selectSymbol = (SingleElementSymbol)selectSymbols.get(i);
                if (!(selectSymbol instanceof AliasSymbol)) {
                    AliasSymbol newAlias = new AliasSymbol(alias.getShortName(), selectSymbol);
                    selectSymbols.set(i, newAlias);
                    if (symbolMap != null) {
                        Iterator entries = symbolMap.entrySet().iterator();
                        while (entries.hasNext()) {
                            Map.Entry entry = entries.next();
                            if (!selectSymbol.equals(entry.getValue())) continue;
                            AliasSymbol newSymbolMapAlias = new AliasSymbol(alias.getShortName(), (SingleElementSymbol)entry.getValue());
                            entry.setValue(newSymbolMapAlias);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public String toString() {
        return "CollapseSource";
    }

    void fixNoElements(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        ArrayList<ElementSymbol> outputElements;
        List children = plan.getChildren();
        if (children != null && children.size() > 0) {
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                this.fixNoElements((PlanNode)childIter.next(), metadata, capFinder);
            }
        }
        if ((outputElements = (ArrayList<ElementSymbol>)plan.getProperty((Object)NodeConstants.Info.OUTPUT_COLS)) == null || outputElements.size() == 0) {
            if (plan.getType() == 0) {
                ElementSymbol element = this.findSelectableElement(plan.getGroups(), metadata);
                if (element != null) {
                    if (outputElements == null) {
                        outputElements = new ArrayList<ElementSymbol>();
                        plan.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, outputElements);
                    }
                    outputElements.add(element);
                    Command command = (Command)plan.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
                    if (command.getType() == 1) {
                        Select select = ((Query)command).getSelect();
                        select.addSymbol((SelectSymbol)element);
                        RuleAssignOutputElements.removeGroupAliases((PlanNode)plan, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder, (Select)select);
                    }
                }
            } else if (plan.getType() != 9) {
                List childElements;
                PlanNode lastChild = plan.getLastChild();
                if (lastChild == null) {
                    Assertion.isNotNull((Object)lastChild, (String)QueryExecPlugin.Util.getString("ERR.015.004.0059"));
                }
                if ((childElements = (List)lastChild.getProperty((Object)NodeConstants.Info.OUTPUT_COLS)) != null && childElements.size() > 0) {
                    if (outputElements == null) {
                        outputElements = new ArrayList();
                        plan.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, outputElements);
                    }
                    outputElements.add((ElementSymbol)childElements.get(0));
                }
            }
        }
    }

    ElementSymbol findSelectableElement(Collection groups, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        GroupSymbol group = null;
        ElementSymbol element = null;
        Iterator groupIter = groups.iterator();
        while (groupIter.hasNext() && group == null) {
            group = (GroupSymbol)groupIter.next();
            List elementIDs = metadata.getElementIDsInGroupID(group.getMetadataID());
            if (elementIDs.size() > 0) {
                Iterator elementIter = elementIDs.iterator();
                while (elementIter.hasNext() && element == null) {
                    Object elementID = elementIter.next();
                    String fullName = metadata.getFullName(elementID);
                    String shortName = metadata.getShortElementName(fullName);
                    String elementName = metadata.getFullElementName(group.getName(), shortName);
                    element = new ElementSymbol(elementName);
                    element.setGroupSymbol(group);
                    element.setMetadataID(elementID);
                    element.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(elementID)));
                    if (metadata.elementSupports(element.getMetadataID(), 0)) continue;
                    element = null;
                }
            }
            if (element != null) continue;
            group = null;
        }
        return element;
    }
}

