/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.connector.xml.base.XMLCapabilities;
import com.metamatrix.connector.xml.base.XMLConnector;
import com.metamatrix.connector.xml.base.XMLConnectorState;
import com.metamatrix.connector.xml.base.XMLExecution;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorMetadata;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.io.Serializable;

public class XMLConnection
implements Connection {
    private static XMLCapabilities caps = new XMLCapabilities();
    private XMLConnector m_parent;
    private ConnectorEnvironment connectorEnv;
    private String m_queryId;
    private String m_user;
    private Serializable m_executionPayload;
    private Serializable m_trustedPayload;

    public XMLConnection(XMLConnector parent, SecurityContext context, ConnectorEnvironment connectorEnv) {
        this.m_parent = parent;
        this.connectorEnv = connectorEnv;
        this.setQueryId(context.getRequestIdentifier());
        this.setUser(context.getUser());
        this.setTrustedPayload(context.getTrustedPayload());
        this.setExecutionPayload(context.getExecutionPayload());
    }

    public ConnectorCapabilities getCapabilities() {
        return caps;
    }

    public XMLConnectorState getState() {
        return this.m_parent.getState();
    }

    public Execution createExecution(int executionMode, ExecutionContext context, RuntimeMetadata metadata) throws ConnectorException {
        try {
            XMLExecution retVal = null;
            String errKey = null;
            switch (executionMode) {
                case 0: {
                    retVal = new XMLExecution(this, metadata, context, this.connectorEnv);
                    break;
                }
                case 1: {
                    errKey = Messages.getString("XMLConnection.update.not.supported");
                    break;
                }
                case 2: {
                    errKey = Messages.getString("XMLConnection.no.xml.procedures");
                    break;
                }
                default: {
                    errKey = Messages.getString("XMLConnection.invalid.execution.mode");
                }
            }
            if (errKey != null) {
                throw new ConnectorException(errKey);
            }
            return retVal;
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public ConnectorMetadata getMetadata() {
        return null;
    }

    public void release() {
    }

    public XMLConnector getConnector() {
        return this.m_parent;
    }

    protected void setQueryId(String queryId) {
        this.m_queryId = queryId;
    }

    public String getQueryId() {
        return this.m_queryId;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setExecutionPayload(Serializable ser) {
        this.m_executionPayload = ser;
    }

    public Serializable getExecutionPayload() {
        return this.m_executionPayload;
    }

    public void setTrustedPayload(Serializable ser) {
        this.m_trustedPayload = ser;
    }

    public Serializable getTrustedPayload() {
        return this.m_trustedPayload;
    }
}

