/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process.multisource;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.IntegerID;
import com.metamatrix.core.id.IntegerIDFactory;
import com.metamatrix.dqp.internal.process.multisource.MultiSourceElementReplacementVisitor;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.query.execution.multisource.PlanModifier;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.relational.AccessNode;
import com.metamatrix.query.processor.relational.NullNode;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.RelationalPlan;
import com.metamatrix.query.processor.relational.UnionAllNode;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.navigator.DeepPreOrderNavigator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MultiSourcePlanModifier
implements PlanModifier {
    private String vdbName;
    private String vdbVersion;
    private VDBService vdbService;
    private IDGenerator idGenerator;
    private Collection multiSourceModels;

    public void setIdGenerator(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setVdbName(String vdbName) {
        this.vdbName = vdbName;
    }

    public void setVdbService(VDBService vdbService) {
        this.vdbService = vdbService;
    }

    public void setVdbVersion(String vdbVersion) {
        this.vdbVersion = vdbVersion;
    }

    public void setMultiSourceModels(Collection multiSourceModels) {
        this.multiSourceModels = multiSourceModels;
    }

    public void modifyPlan(ProcessorPlan plan, QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        Collection subPlans;
        if (plan instanceof RelationalPlan) {
            RelationalPlan rplan = (RelationalPlan)plan;
            RelationalNode root = rplan.getRootNode();
            this.modifyPlan(root, metadata);
        }
        if ((subPlans = plan.getChildPlans()) != null && subPlans.size() > 0) {
            Iterator planIter = subPlans.iterator();
            while (planIter.hasNext()) {
                ProcessorPlan subPlan = (ProcessorPlan)planIter.next();
                this.modifyPlan(subPlan, metadata);
            }
        }
    }

    private int getID() {
        IntegerIDFactory intFactory = (IntegerIDFactory)this.idGenerator.getDefaultFactory();
        return ((IntegerID)intFactory.create()).getValue();
    }

    private void modifyPlan(RelationalNode node, QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        if (node instanceof AccessNode) {
            AccessNode accessNode = (AccessNode)node;
            String modelName = accessNode.getModelName();
            if (this.multiSourceModels.contains(modelName)) {
                List bindings = this.vdbService.getConnectorBindingNames(this.vdbName, this.vdbVersion, modelName);
                ArrayList<AccessNode> accessNodes = new ArrayList<AccessNode>(bindings.size());
                Iterator bindingIter = bindings.iterator();
                while (bindingIter.hasNext()) {
                    Query query;
                    Criteria crit;
                    String bindingUUID = (String)bindingIter.next();
                    String bindingName = this.vdbService.getConnectorName(bindingUUID);
                    AccessNode instanceNode = (AccessNode)accessNode.clone();
                    instanceNode.setID(this.getID());
                    instanceNode.setModelName(bindingUUID);
                    Command command = instanceNode.getCommand();
                    DeepPreOrderNavigator.doVisit((LanguageObject)command, (LanguageVisitor)new MultiSourceElementReplacementVisitor(bindingName));
                    try {
                        command = QueryRewriter.rewrite((Command)command, null, (QueryMetadataInterface)metadata, null);
                        instanceNode.setCommand(command);
                    }
                    catch (QueryValidatorException e) {
                        // empty catch block
                    }
                    if (command instanceof Query && (crit = (query = (Query)command).getCriteria()) == QueryRewriter.FALSE_CRITERIA) continue;
                    accessNodes.add(instanceNode);
                }
                switch (accessNodes.size()) {
                    case 0: {
                        NullNode nullNode = new NullNode(this.getID());
                        nullNode.setElements(accessNode.getElements());
                        nullNode.setTopElements(accessNode.getTopElements());
                        this.replaceChild((RelationalNode)accessNode, (RelationalNode)nullNode);
                        break;
                    }
                    case 1: {
                        AccessNode newNode = (AccessNode)accessNodes.get(0);
                        this.replaceChild((RelationalNode)accessNode, (RelationalNode)newNode);
                        break;
                    }
                    default: {
                        UnionAllNode unionNode = new UnionAllNode(this.getID());
                        unionNode.setElements(accessNode.getElements());
                        unionNode.setTopElements(accessNode.getTopElements());
                        Iterator accessIter = accessNodes.iterator();
                        while (accessIter.hasNext()) {
                            AccessNode newNode = (AccessNode)accessIter.next();
                            unionNode.addChild((RelationalNode)newNode);
                        }
                        this.replaceChild((RelationalNode)accessNode, (RelationalNode)unionNode);
                    }
                }
            }
        } else {
            RelationalNode[] children = node.getChildren();
            for (int i = 0; i < children.length && children[i] != null; ++i) {
                this.modifyPlan(children[i], metadata);
            }
        }
    }

    private void replaceChild(RelationalNode child, RelationalNode replacement) {
        RelationalNode parent = child.getParent();
        if (parent == null) {
            return;
        }
        RelationalNode[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != child) continue;
            children[i] = replacement;
            replacement.setParent(parent);
            return;
        }
    }
}

