/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process.multisource;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.IntegerID;
import com.metamatrix.core.id.IntegerIDFactory;
import com.metamatrix.dqp.internal.process.multisource.MultiSourceElementReplacementVisitor;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.query.e.e;
import com.metamatrix.query.e.l.a;
import com.metamatrix.query.e.l.am;
import com.metamatrix.query.e.l.aq;
import com.metamatrix.query.e.l.d;
import com.metamatrix.query.e.l.t;
import com.metamatrix.query.l.c;
import com.metamatrix.query.o.g.f;
import com.metamatrix.query.o.j.ag;
import com.metamatrix.query.o.j.ap;
import com.metamatrix.query.o.j.l;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MultiSourcePlanModifier
implements com.metamatrix.query.execution.b.a {
    private String vdbName;
    private String vdbVersion;
    private VDBService vdbService;
    private IDGenerator idGenerator;
    private Collection multiSourceModels;

    public void setIdGenerator(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setVdbName(String vdbName) {
        this.vdbName = vdbName;
    }

    public void setVdbService(VDBService vdbService) {
        this.vdbService = vdbService;
    }

    public void setVdbVersion(String vdbVersion) {
        this.vdbVersion = vdbVersion;
    }

    public void setMultiSourceModels(Collection multiSourceModels) {
        this.multiSourceModels = multiSourceModels;
    }

    public void modifyPlan(e plan, com.metamatrix.query.m.e metadata) throws MetaMatrixComponentException {
        Collection subPlans;
        if (plan instanceof aq) {
            aq rplan = (aq)plan;
            am root = rplan.gt();
            this.modifyPlan(root, metadata);
        }
        if ((subPlans = plan.f7()) != null && subPlans.size() > 0) {
            Iterator planIter = subPlans.iterator();
            while (planIter.hasNext()) {
                e subPlan = (e)planIter.next();
                this.modifyPlan(subPlan, metadata);
            }
        }
    }

    private int getID() {
        IntegerIDFactory intFactory = (IntegerIDFactory)this.idGenerator.getDefaultFactory();
        return ((IntegerID)intFactory.create()).getValue();
    }

    private void modifyPlan(am node, com.metamatrix.query.m.e metadata) throws MetaMatrixComponentException {
        if (node instanceof a) {
            a accessNode = (a)node;
            String modelName = accessNode.cp();
            if (this.multiSourceModels.contains(modelName)) {
                List bindings = this.vdbService.getConnectorBindingNames(this.vdbName, this.vdbVersion, modelName);
                ArrayList<a> accessNodes = new ArrayList<a>(bindings.size());
                Iterator bindingIter = bindings.iterator();
                while (bindingIter.hasNext()) {
                    ag query;
                    ap crit;
                    String bindingUUID = (String)bindingIter.next();
                    String bindingName = this.vdbService.getConnectorName(bindingUUID);
                    a instanceNode = (a)accessNode.clone();
                    instanceNode.ci(this.getID());
                    instanceNode.cn(bindingUUID);
                    l command = instanceNode.cm();
                    f.d5((com.metamatrix.query.o.d)command, (com.metamatrix.query.o.a)new MultiSourceElementReplacementVisitor(bindingName));
                    try {
                        command = c.as((l)command, null, (com.metamatrix.query.m.e)metadata, null);
                        instanceNode.cr(command);
                    }
                    catch (QueryValidatorException e2) {
                        // empty catch block
                    }
                    if (command instanceof ag && (crit = (query = (ag)command).jz()) == c.d) continue;
                    accessNodes.add(instanceNode);
                }
                switch (accessNodes.size()) {
                    case 0: {
                        d nullNode = new d(this.getID());
                        nullNode.ch(accessNode.cd());
                        nullNode.bc(accessNode.bb());
                        this.replaceChild((am)accessNode, (am)nullNode);
                        break;
                    }
                    case 1: {
                        a newNode = (a)accessNodes.get(0);
                        this.replaceChild((am)accessNode, (am)newNode);
                        break;
                    }
                    default: {
                        t unionNode = new t(this.getID());
                        unionNode.ch(accessNode.cd());
                        unionNode.bc(accessNode.bb());
                        Iterator accessIter = accessNodes.iterator();
                        while (accessIter.hasNext()) {
                            a newNode = (a)accessIter.next();
                            unionNode.bz((am)newNode);
                        }
                        this.replaceChild((am)accessNode, (am)unionNode);
                    }
                }
            }
        } else {
            am[] children = node.bk();
            for (int i2 = 0; i2 < children.length && children[i2] != null; ++i2) {
                this.modifyPlan(children[i2], metadata);
            }
        }
    }

    private void replaceChild(am child, am replacement) {
        am parent = child.cc();
        if (parent == null) {
            return;
        }
        am[] children = parent.bk();
        for (int i2 = 0; i2 < children.length; ++i2) {
            if (children[i2] != child) continue;
            children[i2] = replacement;
            replacement.b6(parent);
            return;
        }
    }
}

