/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.program;

import com.metamatrix.query.processor.Describable;
import com.metamatrix.query.processor.program.ProgramInstruction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Program
implements Cloneable,
Describable {
    private List programInstructions;
    private int counter = 0;

    public ProgramInstruction getCurrentInstruction() {
        return this.getInstructionAtIndex(this.counter);
    }

    public void incrementProgramCounter() {
        ++this.counter;
    }

    public void decrementProgramCounter() {
        --this.counter;
    }

    public void resetProgramCounter() {
        this.counter = 0;
    }

    int getProgramCounter() {
        return this.counter;
    }

    public ProgramInstruction getInstructionAt(int instructionIndex) {
        return this.getInstructionAtIndex(instructionIndex);
    }

    public void addInstruction(ProgramInstruction instruction) {
        if (instruction != null) {
            this.getProcessorInstructions().add(instruction);
        }
    }

    public void addInstructions(Program instructions) {
        if (instructions != null) {
            this.getProcessorInstructions().addAll(instructions.getProcessorInstructions());
        }
    }

    public String toString() {
        return "PROGRAM size " + this.getProcessorInstructions().size() + ", counter " + this.counter;
    }

    public Object clone() {
        Program program = new Program();
        program.counter = this.counter;
        if (this.getProcessorInstructions().size() > 0) {
            ArrayList<Object> clonedInstructions = new ArrayList<Object>(this.getProcessorInstructions().size());
            Iterator i = this.getProcessorInstructions().iterator();
            while (i.hasNext()) {
                clonedInstructions.add(((ProgramInstruction)i.next()).clone());
            }
            program.programInstructions = clonedInstructions;
        }
        return program;
    }

    public Map getDescriptionProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("type", "Program");
        if (this.getProcessorInstructions().size() > 0) {
            ArrayList<Map> children = new ArrayList<Map>();
            Iterator iter = this.getProcessorInstructions().iterator();
            while (iter.hasNext()) {
                ProgramInstruction inst = (ProgramInstruction)iter.next();
                Map childProps = inst.getDescriptionProperties();
                children.add(childProps);
            }
            props.put("children", children);
        }
        return props;
    }

    public Collection getChildPlans() {
        ArrayList plans = new ArrayList();
        for (int i = 0; i < this.getProcessorInstructions().size(); ++i) {
            ProgramInstruction inst = (ProgramInstruction)this.getProcessorInstructions().get(i);
            Collection instPlans = inst.getChildPlans();
            if (instPlans == null) continue;
            plans.addAll(instPlans);
        }
        return plans;
    }

    private ProgramInstruction getInstructionAtIndex(int instructionIndex) {
        if (this.getProcessorInstructions().size() > 0 && instructionIndex < this.getProcessorInstructions().size()) {
            return (ProgramInstruction)this.getProcessorInstructions().get(instructionIndex);
        }
        return null;
    }

    public List getProcessorInstructions() {
        if (this.programInstructions == null) {
            this.programInstructions = new ArrayList();
        }
        return this.programInstructions;
    }
}

