/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.util.CommandContext;
import java.util.Iterator;
import java.util.List;

public final class RuleRemoveSorts
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) {
        List nodes = NodeEditor.findAllNodes(plan, 17);
        if (nodes.size() == 0) {
            return plan;
        }
        Iterator nodeIter = nodes.iterator();
        while (nodeIter.hasNext()) {
            PlanNode node = (PlanNode)nodeIter.next();
            if (!this.shouldRemove(node)) continue;
            this.removeSort(node);
        }
        return plan;
    }

    boolean shouldRemove(PlanNode node) {
        PlanNode current = node.getParent();
        if (current == null) {
            return false;
        }
        while (current != null) {
            int type = current.getType();
            if (type == 41 || type == 37) {
                return false;
            }
            if (type != 11 && type != 13 && type != 3 && type != 19) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    void removeSort(PlanNode sortNode) {
        PlanNode parent = sortNode.getParent();
        NodeEditor.removeChildNode(parent, sortNode);
        List topCols = (List)sortNode.getProperty((Object)NodeConstants.Info.TOP_COLS);
        if (topCols != null) {
            parent.getFirstChild().setProperty((Object)NodeConstants.Info.TOP_COLS, (Object)topCols);
        }
    }

    public String toString() {
        return "RemoveSorts";
    }
}

