/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.AbstractSetCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CalculateCostUtil {
    private static final int DEPRECATED_UNKNOWN_CARDINALITY = -1;
    static final int UNKNOWN_COST = Integer.MAX_VALUE;
    public static final int STRONG_COST = 10;
    private static final int SET_CRITERIA_KEY_FILTER = 100;

    private CalculateCostUtil() {
    }

    static boolean isAccessNodeStrong(PlanNode accessNode, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        CalculateCostUtil.calculateCost(accessNode, metadata);
        Integer cost = (Integer)accessNode.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        return cost != null && cost < 10 && cost >= 0;
    }

    static void calculateCost(PlanNode accessNode, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        CalculateCostUtil.recursiveCalculateCost(accessNode, metadata);
    }

    private static void recursiveCalculateCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Iterator children = node.getChildren().iterator();
        while (children.hasNext()) {
            PlanNode child = (PlanNode)children.next();
            CalculateCostUtil.recursiveCalculateCost(child, metadata);
        }
        CalculateCostUtil.estimateCost(node, metadata);
    }

    private static void estimateCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        switch (node.getType()) {
            case 19: {
                CalculateCostUtil.estimateSourceNodeCost(node, metadata);
                break;
            }
            case 13: {
                CalculateCostUtil.estimateSelectNodeCost(node, metadata);
                break;
            }
            case 7: {
                CalculateCostUtil.estimateJoinNodeCost(node, metadata);
                break;
            }
            case 3: {
                PlanNode child = (PlanNode)node.getChildren().iterator().next();
                Integer childCost = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
                if (childCost == null) break;
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)childCost);
            }
        }
    }

    static void estimateJoinNodeCost(PlanNode node, QueryMetadataInterface metadata) {
        Iterator children = node.getChildren().iterator();
        PlanNode child1 = (PlanNode)children.next();
        Integer childCost1 = (Integer)child1.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        PlanNode child2 = (PlanNode)children.next();
        Integer childCost2 = (Integer)child2.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        if (childCost1 != null && childCost2 != null && childCost1 != -1 && childCost2 != -1) {
            JoinType joinType = (JoinType)node.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
            if (JoinType.JOIN_CROSS.equals((Object)joinType)) {
                int costProduct = CalculateCostUtil.safeMultiplyCost(childCost1, childCost2);
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(costProduct));
            } else if (JoinType.JOIN_INNER.equals((Object)joinType)) {
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(Math.max(childCost1, childCost2)));
            }
        } else {
            node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(-1));
        }
    }

    private static void estimateSelectNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Criteria selectCriteria;
        int newCost;
        PlanNode child = (PlanNode)node.getChildren().iterator().next();
        Integer childCostInteger = (Integer)child.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
        int childCost = Integer.MAX_VALUE;
        if (childCostInteger != null) {
            childCost = childCostInteger;
        }
        if ((newCost = CalculateCostUtil.estimateCostOfCriteria(childCost, selectCriteria = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA), metadata)) == Integer.MAX_VALUE) {
            if (childCostInteger != null) {
                node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)childCostInteger);
            }
        } else {
            node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(newCost));
        }
    }

    private static void estimateSourceNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        GroupSymbol group = (GroupSymbol)node.getGroups().iterator().next();
        int cardinality = metadata.getCardinality(group.getMetadataID());
        if (cardinality != 0 && cardinality != -1) {
            node.setProperty((Object)NodeConstants.Info.EST_CARDINALITY, (Object)new Integer(cardinality));
        }
    }

    static int estimateCostOfCriteria(int childCost, Criteria crit, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        CompoundCriteria compCrit;
        int cost = CalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, crit, metadata);
        if (cost > 10 && crit instanceof CompoundCriteria && (compCrit = (CompoundCriteria)crit).getOperator() == 0) {
            HashSet elements = new HashSet();
            Iterator iter = compCrit.getCriteria().iterator();
            while (iter.hasNext()) {
                Criteria aCrit = (Criteria)iter.next();
                CalculateCostUtil.collectElementsOfValidCriteria(aCrit, elements);
            }
            if (CalculateCostUtil.usesKey(elements, metadata)) {
                cost = 1;
            }
        }
        return cost;
    }

    private static void collectElementsOfValidCriteria(Criteria criteria, Collection elements) {
        IsNullCriteria isNullCriteria;
        if (criteria instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)criteria;
            if (compCrit.getOperator() == 0) {
                Iterator iter = compCrit.getCriteria().iterator();
                while (iter.hasNext()) {
                    CalculateCostUtil.collectElementsOfValidCriteria((Criteria)iter.next(), elements);
                }
            }
        } else if (criteria instanceof CompareCriteria) {
            CompareCriteria compCrit = (CompareCriteria)criteria;
            if (compCrit.getOperator() == 1) {
                ElementCollectorVisitor.getElements((LanguageObject)compCrit, (Collection)elements);
            }
        } else if (criteria instanceof MatchCriteria) {
            MatchCriteria matchCriteria = (MatchCriteria)criteria;
            if (!matchCriteria.isNegated()) {
                ElementCollectorVisitor.getElements((LanguageObject)matchCriteria, (Collection)elements);
            }
        } else if (criteria instanceof AbstractSetCriteria) {
            AbstractSetCriteria setCriteria = (AbstractSetCriteria)criteria;
            if (!setCriteria.isNegated()) {
                ElementCollectorVisitor.getElements((LanguageObject)setCriteria.getExpression(), (Collection)elements);
            }
        } else if (criteria instanceof IsNullCriteria && !(isNullCriteria = (IsNullCriteria)criteria).isNegated()) {
            ElementCollectorVisitor.getElements((LanguageObject)isNullCriteria.getExpression(), (Collection)elements);
        }
    }

    private static int recursiveEstimateCostOfCriteria(int childCost, Criteria crit, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        int cost = -1;
        if (crit instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)crit;
            Iterator iter = compCrit.getCriteria().iterator();
            while (iter.hasNext()) {
                int nextCost = CalculateCostUtil.estimateCostOfCriteria(childCost, (Criteria)iter.next(), metadata);
                if (cost == -1) {
                    cost = nextCost;
                    continue;
                }
                if (compCrit.getOperator() == 0) {
                    cost = Math.min(cost, nextCost);
                    continue;
                }
                cost = CalculateCostUtil.safeAddCost(cost, nextCost);
            }
        } else if (crit instanceof NotCriteria) {
            int nextCost;
            cost = childCost != Integer.MAX_VALUE ? ((nextCost = CalculateCostUtil.estimateCostOfCriteria(childCost, ((NotCriteria)crit).getCriteria(), metadata)) == Integer.MAX_VALUE ? Integer.MAX_VALUE : Math.max(childCost - nextCost, 1)) : Integer.MAX_VALUE;
        } else if (crit instanceof PredicateCriteria) {
            cost = CalculateCostUtil.estimateCostOfPredicate(childCost, (PredicateCriteria)crit, metadata);
        }
        return cost;
    }

    private static int estimateCostOfPredicate(int childCost, PredicateCriteria predicateCriteria, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        int cost = Integer.MAX_VALUE;
        boolean isNegatedPredicateCriteria = false;
        boolean usesKey = false;
        HashSet elements = new HashSet();
        if (predicateCriteria instanceof CompareCriteria) {
            CompareCriteria compCrit = (CompareCriteria)predicateCriteria;
            ElementCollectorVisitor.getElements((LanguageObject)compCrit, elements);
            usesKey = CalculateCostUtil.usesKey(elements, metadata);
            cost = usesKey ? (compCrit.getOperator() == 1 ? 1 : (compCrit.getOperator() == 2 ? childCost : (childCost == Integer.MAX_VALUE ? Integer.MAX_VALUE : childCost / 3))) : childCost;
        } else if (predicateCriteria instanceof MatchCriteria) {
            MatchCriteria matchCriteria = (MatchCriteria)predicateCriteria;
            ElementCollectorVisitor.getElements((LanguageObject)matchCriteria, elements);
            usesKey = CalculateCostUtil.usesKey(elements, metadata);
            cost = usesKey ? 1 : childCost;
            isNegatedPredicateCriteria = matchCriteria.isNegated();
        } else if (predicateCriteria instanceof AbstractSetCriteria) {
            AbstractSetCriteria setCriteria = (AbstractSetCriteria)predicateCriteria;
            ElementCollectorVisitor.getElements((LanguageObject)setCriteria.getExpression(), elements);
            usesKey = CalculateCostUtil.usesKey(elements, metadata);
            cost = usesKey ? (childCost == Integer.MAX_VALUE ? Integer.MAX_VALUE : childCost / 100) : childCost;
            isNegatedPredicateCriteria = setCriteria.isNegated();
        } else if (predicateCriteria instanceof IsNullCriteria) {
            IsNullCriteria isNullCriteria = (IsNullCriteria)predicateCriteria;
            ElementCollectorVisitor.getElements((LanguageObject)isNullCriteria.getExpression(), elements);
            usesKey = CalculateCostUtil.usesKey(elements, metadata);
            cost = usesKey ? 1 : childCost;
            isNegatedPredicateCriteria = isNullCriteria.isNegated();
        }
        if (isNegatedPredicateCriteria && usesKey) {
            int predicateCost = cost;
            cost = childCost != Integer.MAX_VALUE && predicateCost != Integer.MAX_VALUE ? Math.max(childCost - predicateCost, 1) : Integer.MAX_VALUE;
        }
        return cost;
    }

    private static boolean usesKey(Collection allElements, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        ArrayList<Object> elements;
        GroupSymbol group;
        if (allElements == null || allElements.size() == 0) {
            return false;
        }
        HashMap<GroupSymbol, ArrayList<Object>> groupMap = new HashMap<GroupSymbol, ArrayList<Object>>();
        Iterator elementIter = allElements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol element = (ElementSymbol)elementIter.next();
            group = element.getGroupSymbol();
            elements = (ArrayList<Object>)groupMap.get(group);
            if (elements == null) {
                elements = new ArrayList<Object>();
                groupMap.put(group, elements);
            }
            elements.add(element.getMetadataID());
        }
        Iterator groupIter = groupMap.keySet().iterator();
        while (groupIter.hasNext()) {
            group = (GroupSymbol)groupIter.next();
            elements = (List)groupMap.get(group);
            Collection keys = metadata.getUniqueKeysInGroup(group.getMetadataID());
            if (keys == null || keys.size() <= 0) continue;
            Iterator keyIter = keys.iterator();
            while (keyIter.hasNext()) {
                List keyElements = metadata.getElementIDsInKey(keyIter.next());
                if (!elements.containsAll(keyElements)) continue;
                return true;
            }
        }
        return false;
    }

    static int safeMultiplyCost(int cost1, int cost2) {
        Assertion.isNonNegative((int)cost1);
        Assertion.isNonNegative((int)cost2);
        if (cost1 == 0) {
            return 0;
        }
        if (cost1 == 1) {
            return cost2;
        }
        if (cost2 == 0) {
            return 0;
        }
        if (cost2 == 1) {
            return cost1;
        }
        int possibleCost = cost1 * cost2;
        if (possibleCost < cost1 || possibleCost < cost2) {
            return Integer.MAX_VALUE;
        }
        return possibleCost;
    }

    static int safeAddCost(int cost1, int cost2) {
        Assertion.isNonNegative((int)cost1);
        Assertion.isNonNegative((int)cost2);
        int possibleCost = cost1 + cost2;
        if (possibleCost < cost1 || possibleCost < cost2) {
            return Integer.MAX_VALUE;
        }
        return possibleCost;
    }
}

