/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.plantree;

import com.metamatrix.query.execution.QueryExecPlugin;

public final class NodeConstants {
    private NodeConstants() {
    }

    public static final String getNodeTypeString(int type) {
        switch (type) {
            case 3: {
                return "Access";
            }
            case 5: {
                return "DupRemoval";
            }
            case 7: {
                return "Join";
            }
            case 11: {
                return "Project";
            }
            case 13: {
                return "Select";
            }
            case 17: {
                return "Sort";
            }
            case 19: {
                return "Source";
            }
            case 23: {
                return "Group";
            }
            case 29: {
                return "SetOperation";
            }
            case 31: {
                return "Null";
            }
            case 37: {
                return "TupleOffset";
            }
            case 41: {
                return "TupleLimit";
            }
        }
        return "Unknown: " + type;
    }

    public static final int getNodeTypeInt(String type) {
        if (type.equals("Access")) {
            return 3;
        }
        if (type.equals("DupRemoval")) {
            return 5;
        }
        if (type.equals("Join")) {
            return 7;
        }
        if (type.equals("Project")) {
            return 11;
        }
        if (type.equals("Select")) {
            return 13;
        }
        if (type.equals("Sort")) {
            return 17;
        }
        if (type.equals("Source")) {
            return 19;
        }
        if (type.equals("Group")) {
            return 23;
        }
        if (type.equals("SetOperation")) {
            return 29;
        }
        if (type.equals("Null")) {
            return 31;
        }
        if (type.equals("TupleOffset")) {
            return 37;
        }
        if (type.equals("TupleLimit")) {
            return 41;
        }
        throw new IllegalArgumentException(QueryExecPlugin.Util.getString("ERR.015.004.0011", (Object)type));
    }

    public static final class Types {
        public static final int NO_TYPE = 2;
        public static final int ACCESS = 3;
        public static final int DUP_REMOVE = 5;
        public static final int JOIN = 7;
        public static final int PROJECT = 11;
        public static final int SELECT = 13;
        public static final int SORT = 17;
        public static final int SOURCE = 19;
        public static final int GROUP = 23;
        public static final int SET_OP = 29;
        public static final int NULL = 31;
        public static final int TUPLE_OFFSET = 37;
        public static final int TUPLE_LIMIT = 41;

        private Types() {
        }
    }
}

