/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.rewriter;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.FunctionExecutionException;
import com.metamatrix.api.exception.query.InvalidFunctionException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.eval.CriteriaEvaluator;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.function.FunctionMethods;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.resolver.util.ResolveCriteriaVisitor;
import com.metamatrix.query.rewriter.CaseSimplificationVisitor;
import com.metamatrix.query.rewriter.VariableSubstitutionVisitor;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.CriteriaSelector;
import com.metamatrix.query.sql.proc.HasCriteria;
import com.metamatrix.query.sql.proc.IfStatement;
import com.metamatrix.query.sql.proc.LoopStatement;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.proc.TranslateCriteria;
import com.metamatrix.query.sql.symbol.AbstractCaseExpression;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import com.metamatrix.query.sql.visitor.CriteriaTranslatorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.EvaluatableVisitor;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.PredicateCollectorVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class QueryRewriter {
    public static final Criteria TRUE_CRITERIA = new CompareCriteria((Expression)new Constant((Object)new Integer(1), DataTypeManager.DefaultDataClasses.INTEGER), 1, (Expression)new Constant((Object)new Integer(1), DataTypeManager.DefaultDataClasses.INTEGER));
    public static final Criteria FALSE_CRITERIA = new CompareCriteria((Expression)new Constant((Object)new Integer(1), DataTypeManager.DefaultDataClasses.INTEGER), 1, (Expression)new Constant((Object)new Integer(0), DataTypeManager.DefaultDataClasses.INTEGER));
    private static Integer INTEGER_ZERO = new Integer(0);
    private static Double DOUBLE_ZERO = new Double(0.0);
    private static Float FLOAT_ZERO = new Float(0.0f);
    private static Long LONG_ZERO = new Long(0L);
    private static BigInteger BIG_INTEGER_ZERO = new BigInteger("0");
    private static BigDecimal BIG_DECIMAL_ZERO = new BigDecimal("0");
    private static Short SHORT_ZERO = new Short(0);
    private static Byte BYTE_ZERO = new Byte(0);

    private QueryRewriter() {
    }

    public static Command rewrite(Command command, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        LinkedList<Object> commandQueue = new LinkedList<Object>();
        commandQueue.add(command);
        while (!commandQueue.isEmpty()) {
            Command workingCommand = (Command)commandQueue.removeLast();
            QueryRewriter.rewriteCommand(workingCommand, procCommand, metadata, context);
            if (workingCommand.getSubCommands() == null) continue;
            Iterator iter = workingCommand.getSubCommands().iterator();
            while (iter.hasNext()) {
                commandQueue.addFirst(iter.next());
            }
        }
        return command;
    }

    public static Command rewriteCommand(Command command, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        switch (command.getType()) {
            case 1: {
                if (command instanceof Query) {
                    QueryRewriter.rewriteQuery((Query)command, procCommand, metadata, context);
                    break;
                }
                QueryRewriter.rewriteSetQuery((SetQuery)command, procCommand, metadata, context);
                break;
            }
            case 6: {
                QueryRewriter.rewriteExec((StoredProcedure)command, procCommand, metadata, context);
                break;
            }
            case 2: {
                QueryRewriter.rewriteInsert((Insert)command, procCommand, context);
                break;
            }
            case 3: {
                QueryRewriter.rewriteUpdate((Update)command, procCommand, context);
                break;
            }
            case 4: {
                QueryRewriter.rewriteDelete((Delete)command, procCommand, context);
                break;
            }
            case 7: {
                QueryRewriter.rewriteUpdateProcedure((CreateUpdateProcedureCommand)command, metadata, context);
            }
        }
        if (command.hasSubCommands()) {
            Iterator cmdIter = command.getSubCommands().iterator();
            while (cmdIter.hasNext()) {
                Command subCommand = (Command)cmdIter.next();
                if (!(subCommand instanceof CreateUpdateProcedureCommand)) continue;
                QueryRewriter.rewriteUpdateProcedure((CreateUpdateProcedureCommand)subCommand, metadata, context);
            }
        }
        return command;
    }

    private static CreateUpdateProcedureCommand rewriteUpdateProcedure(CreateUpdateProcedureCommand procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        Command userCmd = procCommand.getUserCommand();
        if (metadata != null) {
            VariableSubstitutionVisitor.substituteVariables((LanguageObject)procCommand, (Command)userCmd, (QueryMetadataInterface)metadata);
        }
        Block block = QueryRewriter.rewriteBlock(procCommand.getBlock(), procCommand, context);
        procCommand.setBlock(block);
        if (procCommand.hasSubCommands()) {
            Iterator cmdIter = procCommand.getSubCommands().iterator();
            while (cmdIter.hasNext()) {
                Command subCommand = (Command)cmdIter.next();
                QueryRewriter.rewrite(subCommand, procCommand, metadata, context);
            }
        }
        return procCommand;
    }

    private static Block rewriteBlock(Block block, Command procCommand, CommandContext context) throws QueryValidatorException {
        List statements = block.getStatements();
        Iterator stmtIter = statements.iterator();
        ArrayList<Statement> newStmts = new ArrayList<Statement>(statements.size());
        while (stmtIter.hasNext()) {
            Statement stmnt = (Statement)stmtIter.next();
            Statement newStmt = QueryRewriter.rewriteStatement(stmnt, procCommand, context);
            if (newStmt == null) continue;
            newStmts.add(newStmt);
        }
        block.setStatements(newStmts);
        return block;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Statement rewriteStatement(Statement statement, Command procCommand, CommandContext context) throws QueryValidatorException {
        int stmtType = statement.getType();
        CreateUpdateProcedureCommand procedure = (CreateUpdateProcedureCommand)procCommand;
        switch (stmtType) {
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Criteria ifCrit = ifStmt.getCondition();
                Criteria evalCrit = QueryRewriter.rewriteCriteria(ifCrit, procCommand, context);
                evalCrit = QueryRewriter.evaluateCriteria(evalCrit);
                ifStmt.setCondition(evalCrit);
                if (evalCrit.equals(TRUE_CRITERIA)) {
                    Block ifblock = QueryRewriter.rewriteBlock(ifStmt.getIfBlock(), procCommand, context);
                    ifStmt.setIfBlock(ifblock);
                    if (!ifStmt.hasElseBlock()) return ifStmt;
                    List subCmds = CommandCollectorVisitor.getCommands((LanguageObject)ifStmt.getElseBlock());
                    procedure.removeSubCommands(subCmds);
                    ifStmt.setElseBlock(null);
                    return ifStmt;
                } else if (evalCrit.equals(FALSE_CRITERIA)) {
                    List subCmds = CommandCollectorVisitor.getCommands((LanguageObject)ifStmt.getIfBlock());
                    procedure.removeSubCommands(subCmds);
                    if (!ifStmt.hasElseBlock()) return null;
                    Block elseBlock = QueryRewriter.rewriteBlock(ifStmt.getElseBlock(), procCommand, context);
                    ifStmt.setIfBlock(elseBlock);
                    ifStmt.setElseBlock(null);
                    ifStmt.setCondition(TRUE_CRITERIA);
                    return ifStmt;
                } else {
                    Block ifblock = QueryRewriter.rewriteBlock(ifStmt.getIfBlock(), procCommand, context);
                    ifStmt.setIfBlock(ifblock);
                    if (!ifStmt.hasElseBlock()) return ifStmt;
                    Block elseBlock = QueryRewriter.rewriteBlock(ifStmt.getElseBlock(), procCommand, context);
                    ifStmt.setElseBlock(elseBlock);
                }
                return ifStmt;
            }
            case 4: 
            case 5: {
                AssignmentStatement assStmt = (AssignmentStatement)statement;
                if (assStmt.hasCommand()) {
                    if (procedure.hasSubCommand(assStmt.getCommand())) return assStmt;
                    return null;
                }
                Expression expr = assStmt.getExpression();
                expr = QueryRewriter.rewriteExpression(expr, procCommand, context);
                assStmt.setExpression(expr);
                return assStmt;
            }
            case 2: {
                CommandStatement cmdStmt = (CommandStatement)statement;
                if (procedure.hasSubCommand(cmdStmt.getCommand())) return statement;
                return null;
            }
            case 6: {
                LoopStatement loop = (LoopStatement)statement;
                QueryRewriter.rewriteBlock(loop.getBlock(), procCommand, context);
                return loop;
            }
        }
        return statement;
    }

    private static Criteria rewriteCriteria(HasCriteria hasCrit, Command procCommand, CommandContext context) {
        int selectorType;
        Criteria userCrit = null;
        Command userCommand = ((CreateUpdateProcedureCommand)procCommand).getUserCommand();
        int cmdType = userCommand.getType();
        switch (cmdType) {
            case 4: {
                userCrit = ((Delete)userCommand).getCriteria();
                break;
            }
            case 3: {
                userCrit = ((Update)userCommand).getCriteria();
                break;
            }
            default: {
                return FALSE_CRITERIA;
            }
        }
        if (userCrit == null) {
            return FALSE_CRITERIA;
        }
        CriteriaSelector selector = hasCrit.getSelector();
        List hasCritElmts = null;
        if (selector.hasElements()) {
            hasCritElmts = selector.getElements();
            Collection userElmnts = ElementCollectorVisitor.getElements((LanguageObject)userCrit, (boolean)true);
            if (!userElmnts.containsAll(hasCritElmts)) {
                return FALSE_CRITERIA;
            }
        }
        if ((selectorType = selector.getSelectorType()) == 0) {
            return TRUE_CRITERIA;
        }
        Iterator criteriaIter = PredicateCollectorVisitor.getPredicates((LanguageObject)userCrit).iterator();
        block10: while (criteriaIter.hasNext()) {
            CompareCriteria compCrit;
            Criteria predicateCriteria = (Criteria)criteriaIter.next();
            Collection predElmnts = ElementCollectorVisitor.getElements((LanguageObject)predicateCriteria, (boolean)true);
            if (selector.hasElements()) {
                Iterator hasIter = hasCritElmts.iterator();
                boolean containsElmnt = false;
                while (hasIter.hasNext()) {
                    ElementSymbol hasElmnt = (ElementSymbol)hasIter.next();
                    if (!predElmnts.contains(hasElmnt)) continue;
                    containsElmnt = true;
                }
                if (!containsElmnt) continue;
            }
            switch (selectorType) {
                case 8: {
                    if (!(predicateCriteria instanceof SetCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 7: {
                    if (!(predicateCriteria instanceof MatchCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 9: {
                    if (!(predicateCriteria instanceof IsNullCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
                case 10: {
                    if (!(predicateCriteria instanceof BetweenCriteria)) continue block10;
                    return TRUE_CRITERIA;
                }
            }
            if (!(predicateCriteria instanceof CompareCriteria) || (compCrit = (CompareCriteria)predicateCriteria).getOperator() != selectorType) continue;
            return TRUE_CRITERIA;
        }
        return FALSE_CRITERIA;
    }

    private static Criteria rewriteCriteria(TranslateCriteria transCrit, Command command, CommandContext context) throws QueryValidatorException {
        Criteria translatedCriteria = null;
        CreateUpdateProcedureCommand procCommand = (CreateUpdateProcedureCommand)command;
        Command userCmd = procCommand.getUserCommand();
        int cmdType = userCmd.getType();
        Criteria userCriteria = null;
        switch (cmdType) {
            case 4: {
                userCriteria = ((Delete)userCmd).getCriteria();
                break;
            }
            case 3: {
                userCriteria = ((Update)userCmd).getCriteria();
                break;
            }
            default: {
                return FALSE_CRITERIA;
            }
        }
        if (userCriteria == null) {
            return FALSE_CRITERIA;
        }
        CriteriaTranslatorVisitor translateVisitor = new CriteriaTranslatorVisitor(procCommand.getSymbolMap());
        CriteriaSelector selector = transCrit.getSelector();
        HasCriteria hasCrit = new HasCriteria(selector);
        Criteria result = QueryRewriter.rewriteCriteria(hasCrit, (Command)procCommand, context);
        if (result.equals(FALSE_CRITERIA)) {
            return FALSE_CRITERIA;
        }
        translateVisitor.setCriteriaSelector(selector);
        if (transCrit.hasTranslations()) {
            translateVisitor.setTranslations((Collection)transCrit.getTranslations());
        }
        Criteria userClone = (Criteria)userCriteria.clone();
        PreOrderNavigator.doVisit((LanguageObject)userClone, (LanguageVisitor)translateVisitor);
        translatedCriteria = translateVisitor.getTranslatedCriteria();
        translatedCriteria = QueryRewriter.rewriteCriteria(translatedCriteria, null, context);
        try {
            ResolveCriteriaVisitor.resolveCriteria((LanguageObject)translatedCriteria);
        }
        catch (Exception ex) {
            throw new QueryValidatorException((Throwable)ex, "ERR.015.009.0002", QueryExecPlugin.Util.getString("ERR.015.009.0002", (Object)translatedCriteria));
        }
        return translatedCriteria;
    }

    private static Query rewriteQuery(Query query, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        Criteria having;
        Select select = query.getSelect();
        List symbols = select.getSymbols();
        for (int i = 0; i < symbols.size(); ++i) {
            ExpressionSymbol es;
            Object symbol = symbols.get(i);
            boolean hasAlias = false;
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
                hasAlias = true;
            }
            if (!(symbol instanceof ExpressionSymbol) || (es = (ExpressionSymbol)symbol).getExpression() == null) continue;
            es.setExpression(QueryRewriter.rewriteExpression(es.getExpression(), procCommand, context));
            if (hasAlias || es.getExpression() instanceof Constant || !EvaluateExpressionVisitor.isRuntimeEvaluatable((LanguageObject)es.getExpression(), true)) continue;
            symbols.set(i, new AliasSymbol(es.getShortName(), (SingleElementSymbol)es));
        }
        From from = query.getFrom();
        if (from == null) {
            return query;
        }
        ArrayList<FromClause> clauses = new ArrayList<FromClause>(from.getClauses().size());
        Iterator clauseIter = from.getClauses().iterator();
        while (clauseIter.hasNext()) {
            clauses.add(QueryRewriter.rewriteFromClause((FromClause)clauseIter.next(), procCommand, metadata, context));
        }
        from.setClauses(clauses);
        Criteria crit = query.getCriteria();
        if (crit != null) {
            Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)query, (boolean)true);
            if (procCommand != null && procCommand.getType() == 7) {
                CreateUpdateProcedureCommand procedure = (CreateUpdateProcedureCommand)procCommand;
                procedure.setSubCommandGroups(groups);
            }
            crit = QueryRewriter.rewriteCriteria(crit, procCommand, context);
            query.setCriteria(crit);
            boolean isXmlQuery = query.getIsXML();
            if (!isXmlQuery && metadata != null) {
                crit = QueryRewriter.rewriteProcedureInputElements(metadata, crit);
                query.setCriteria(crit);
            }
            if (query.getCriteria() != null) {
                Criteria evalCrit = QueryRewriter.evaluateCriteria(query.getCriteria());
                if (evalCrit == TRUE_CRITERIA) {
                    query.setCriteria(null);
                } else if (evalCrit == FALSE_CRITERIA) {
                    query.setCriteria(FALSE_CRITERIA);
                }
            }
        }
        if ((having = query.getHaving()) != null) {
            query.setHaving(QueryRewriter.rewriteCriteria(having, procCommand, context));
        }
        if (query.getLimit() != null) {
            query.setLimit(QueryRewriter.rewriteLimitClause(query.getLimit()));
        }
        return query;
    }

    private static Criteria rewriteProcedureInputElements(QueryMetadataInterface metadata, Criteria crit) throws QueryValidatorException {
        if (crit instanceof CompareCriteria && QueryRewriter.hasProcudureInputElement((CompareCriteria)crit, metadata) || crit instanceof IsNullCriteria && QueryRewriter.hasProcudureInputElement((IsNullCriteria)crit, metadata)) {
            return null;
        }
        if (crit instanceof CompoundCriteria) {
            List crits = ((CompoundCriteria)crit).getCriteria();
            for (int i = 0; i < crits.size(); ++i) {
                Object criteria = crits.get(i);
                if (criteria instanceof CompareCriteria && QueryRewriter.hasProcudureInputElement((CompareCriteria)criteria, metadata) || criteria instanceof IsNullCriteria && QueryRewriter.hasProcudureInputElement((IsNullCriteria)criteria, metadata)) {
                    crits.remove(i);
                    --i;
                    continue;
                }
                if (!(criteria instanceof CompoundCriteria)) continue;
                Criteria newCriteria = QueryRewriter.rewriteProcedureInputElements(metadata, (Criteria)((CompoundCriteria)criteria));
                crits.remove(i);
                if (newCriteria != null) {
                    crits.add(i, newCriteria);
                    continue;
                }
                --i;
            }
            if (crits.isEmpty()) {
                return null;
            }
            if (crits.size() == 1) {
                return (Criteria)crits.get(0);
            }
        }
        return crit;
    }

    private static boolean hasProcudureInputElement(CompareCriteria criteria, QueryMetadataInterface metadata) throws QueryValidatorException {
        if (QueryRewriter.hasProcudureInputElement(criteria.getLeftExpression(), metadata)) {
            return true;
        }
        return QueryRewriter.hasProcudureInputElement(criteria.getRightExpression(), metadata);
    }

    private static boolean hasProcudureInputElement(IsNullCriteria criteria, QueryMetadataInterface metadata) throws QueryValidatorException {
        return QueryRewriter.hasProcudureInputElement(criteria.getExpression(), metadata);
    }

    private static boolean hasProcudureInputElement(Expression expr, QueryMetadataInterface metadata) throws QueryValidatorException {
        try {
            if (expr instanceof ElementSymbol && metadata.isProcedureInputElement(((ElementSymbol)expr).getMetadataID())) {
                return true;
            }
        }
        catch (QueryMetadataException e) {
            throw new QueryValidatorException(e.getMessage());
        }
        catch (MetaMatrixComponentException e) {
            throw new QueryValidatorException(e.getMessage());
        }
        return false;
    }

    private static SetQuery rewriteSetQuery(SetQuery setQuery, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        ArrayList<Command> newQueries = new ArrayList<Command>(setQuery.getQueries().size());
        Iterator queryIter = setQuery.getQueries().iterator();
        while (queryIter.hasNext()) {
            newQueries.add(QueryRewriter.rewrite((Command)((QueryCommand)queryIter.next()), procCommand, metadata, context));
        }
        ArrayList flags = new ArrayList(setQuery.getUseAllFlags());
        setQuery.removeAllQueries();
        setQuery.addQueries(newQueries, flags);
        return setQuery;
    }

    private static FromClause rewriteFromClause(FromClause clause, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        if (clause instanceof JoinPredicate) {
            return QueryRewriter.rewriteJoinPredicate((JoinPredicate)clause, procCommand, metadata, context);
        }
        if (clause instanceof SubqueryFromClause) {
            SubqueryFromClause sfc = (SubqueryFromClause)clause;
            Command rewrittenCommand = QueryRewriter.rewrite(sfc.getCommand(), procCommand, metadata, context);
            sfc.setCommand(rewrittenCommand);
            return sfc;
        }
        return clause;
    }

    private static JoinPredicate rewriteJoinPredicate(JoinPredicate predicate, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        List joinCrits = predicate.getJoinCriteria();
        if (joinCrits != null && joinCrits.size() > 0) {
            ArrayList<Criteria> newCrits = new ArrayList<Criteria>(joinCrits.size());
            Iterator critIter = joinCrits.iterator();
            while (critIter.hasNext()) {
                newCrits.add(QueryRewriter.rewriteCriteria((Criteria)critIter.next(), null, context));
            }
            predicate.setJoinCriteria(newCrits);
        }
        predicate.setLeftClause(QueryRewriter.rewriteFromClause(predicate.getLeftClause(), procCommand, metadata, context));
        predicate.setRightClause(QueryRewriter.rewriteFromClause(predicate.getRightClause(), procCommand, metadata, context));
        return predicate;
    }

    public static Criteria rewriteCriteria(Criteria criteria, Command procCommand, CommandContext context) throws QueryValidatorException {
        if (criteria instanceof CompoundCriteria) {
            return QueryRewriter.rewriteCriteria((CompoundCriteria)criteria, procCommand, context);
        }
        if (criteria instanceof NotCriteria) {
            return QueryRewriter.rewriteCriteria((NotCriteria)criteria, procCommand, context);
        }
        if (criteria instanceof CompareCriteria) {
            return QueryRewriter.rewriteCriteria((CompareCriteria)criteria, procCommand, context);
        }
        if (criteria instanceof SubqueryCompareCriteria) {
            return QueryRewriter.rewriteCriteria((SubqueryCompareCriteria)criteria, procCommand, context);
        }
        if (criteria instanceof MatchCriteria) {
            return QueryRewriter.rewriteCriteria((MatchCriteria)criteria, procCommand, context);
        }
        if (criteria instanceof SetCriteria) {
            return QueryRewriter.rewriteCriteria((SetCriteria)criteria, procCommand, context);
        }
        if (criteria instanceof IsNullCriteria) {
            return QueryRewriter.rewriteCriteria((IsNullCriteria)criteria, procCommand, context);
        }
        if (criteria instanceof BetweenCriteria) {
            return QueryRewriter.rewriteCriteria((BetweenCriteria)criteria, procCommand, context);
        }
        if (criteria instanceof HasCriteria) {
            return QueryRewriter.rewriteCriteria((HasCriteria)criteria, procCommand, context);
        }
        if (criteria instanceof TranslateCriteria) {
            return QueryRewriter.rewriteCriteria((TranslateCriteria)criteria, procCommand, context);
        }
        return criteria;
    }

    private static Criteria rewriteCriteria(CompoundCriteria criteria, Command procCommand, CommandContext context) throws QueryValidatorException {
        List crits = criteria.getCriteria();
        int operator = criteria.getOperator();
        ArrayList<Criteria> newCrits = new ArrayList<Criteria>(crits.size());
        Iterator critIter = crits.iterator();
        while (critIter.hasNext()) {
            Criteria converted = QueryRewriter.rewriteCriteria((Criteria)critIter.next(), procCommand, context);
            if ((converted = QueryRewriter.evaluateCriteria(converted)) == TRUE_CRITERIA) {
                if (operator != 1) continue;
                return converted;
            }
            if (converted == FALSE_CRITERIA) {
                if (operator != 0) continue;
                return converted;
            }
            newCrits.add(converted);
        }
        if (newCrits.size() == 0) {
            if (operator == 0) {
                return TRUE_CRITERIA;
            }
            return FALSE_CRITERIA;
        }
        if (newCrits.size() == 1) {
            return (Criteria)newCrits.get(0);
        }
        criteria.setCriteria(newCrits);
        return criteria;
    }

    private static Criteria evaluateCriteria(Criteria crit) throws QueryValidatorException {
        if (EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)crit, true)) {
            try {
                boolean eval = CriteriaEvaluator.evaluate((Criteria)crit, (Map)Collections.EMPTY_MAP, (List)Collections.EMPTY_LIST);
                if (eval) {
                    return TRUE_CRITERIA;
                }
                return FALSE_CRITERIA;
            }
            catch (CriteriaEvaluationException e) {
                throw new QueryValidatorException((Throwable)e, "ERR.015.009.0001", QueryExecPlugin.Util.getString("ERR.015.009.0001", (Object)crit));
            }
            catch (MetaMatrixComponentException e) {
                throw new QueryValidatorException((Throwable)e, "ERR.015.009.0001", QueryExecPlugin.Util.getString("ERR.015.009.0001", (Object)crit));
            }
        }
        return crit;
    }

    private static Criteria rewriteCriteria(NotCriteria criteria, Command procCommand, CommandContext context) throws QueryValidatorException {
        Criteria innerCrit = QueryRewriter.rewriteCriteria(criteria.getCriteria(), procCommand, context);
        if ((innerCrit = QueryRewriter.evaluateCriteria(innerCrit)) == TRUE_CRITERIA) {
            return FALSE_CRITERIA;
        }
        if (innerCrit == FALSE_CRITERIA) {
            return TRUE_CRITERIA;
        }
        criteria.setCriteria(innerCrit);
        return criteria;
    }

    private static Criteria rewriteCriteria(BetweenCriteria criteria, Command procCommand, CommandContext context) throws QueryValidatorException {
        CompareCriteria lowerCriteria = new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 3 : 6, criteria.getLowerExpression());
        CompareCriteria upperCriteria = new CompareCriteria(criteria.getExpression(), criteria.isNegated() ? 4 : 5, criteria.getUpperExpression());
        CompoundCriteria newCriteria = new CompoundCriteria(criteria.isNegated() ? 1 : 0, (Criteria)lowerCriteria, (Criteria)upperCriteria);
        return QueryRewriter.rewriteCriteria(newCriteria, procCommand, context);
    }

    private static Criteria rewriteCriteria(CompareCriteria criteria, Command procCommand, CommandContext context) throws QueryValidatorException {
        Criteria modCriteria;
        Expression leftExpr = QueryRewriter.rewriteExpression(criteria.getLeftExpression(), procCommand, context);
        Expression rightExpr = QueryRewriter.rewriteExpression(criteria.getRightExpression(), procCommand, context);
        if (rightExpr instanceof ElementSymbol && EvaluateExpressionVisitor.isRuntimeEvaluatable((LanguageObject)leftExpr, true)) {
            criteria.setLeftExpression(rightExpr);
            criteria.setRightExpression(leftExpr);
            switch (criteria.getOperator()) {
                case 3: {
                    criteria.setOperator(4);
                    break;
                }
                case 5: {
                    criteria.setOperator(6);
                    break;
                }
                case 4: {
                    criteria.setOperator(3);
                    break;
                }
                case 6: {
                    criteria.setOperator(5);
                }
            }
        } else {
            criteria.setLeftExpression(leftExpr);
            criteria.setRightExpression(rightExpr);
        }
        if (criteria.getLeftExpression() instanceof Function && EvaluateExpressionVisitor.isRuntimeEvaluatable((LanguageObject)criteria.getRightExpression(), true)) {
            criteria = QueryRewriter.simplifyWithInverse(criteria);
        }
        if ((modCriteria = QueryRewriter.simplifyTimestampMerge(criteria)) instanceof CompareCriteria) {
            modCriteria = QueryRewriter.simplifyTimestampMerge2((CompareCriteria)modCriteria);
        }
        return modCriteria;
    }

    private static Criteria rewriteCriteria(SubqueryCompareCriteria criteria, Command procCommand, CommandContext context) throws QueryValidatorException {
        Expression leftExpr = QueryRewriter.rewriteExpression(criteria.getLeftExpression(), procCommand, context);
        criteria.setLeftExpression(leftExpr);
        if (criteria.getPredicateQuantifier() == 3) {
            criteria.setPredicateQuantifier(2);
        }
        return criteria;
    }

    private static CompareCriteria simplifyWithInverse(CompareCriteria criteria) throws QueryValidatorException {
        Expression leftExpr = criteria.getLeftExpression();
        Function leftFunction = (Function)leftExpr;
        if (QueryRewriter.isSimpleMathematicalFunction(leftFunction)) {
            return QueryRewriter.simplifyMathematicalCriteria(criteria);
        }
        Expression[] args = leftFunction.getArgs();
        if (args != null && args.length > 0 && (criteria.getOperator() == 1 || criteria.getOperator() == 2)) {
            String funcName = leftFunction.getName().toLowerCase();
            if (criteria.getRightExpression() instanceof Constant && (funcName.equalsIgnoreCase("convert") || funcName.equalsIgnoreCase("cast"))) {
                return QueryRewriter.simplifyConvertFunction(criteria);
            }
            return QueryRewriter.simplifyParseFormatFunction(criteria);
        }
        return criteria;
    }

    private static boolean isSimpleMathematicalFunction(Function function) {
        Expression[] args;
        String funcName = function.getName();
        return !(!funcName.equals("+") && !funcName.equals("-") && !funcName.equals("*") && !funcName.equals("/") || !((args = function.getArgs())[0] instanceof Constant) && !(args[1] instanceof Constant));
    }

    private static CompareCriteria simplifyMathematicalCriteria(CompareCriteria criteria) throws QueryValidatorException {
        Object value;
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function function = (Function)leftExpr;
        String funcName = function.getName();
        Expression[] args = function.getArgs();
        Constant const1 = null;
        Expression expr = null;
        if (args[1] instanceof Constant) {
            const1 = (Constant)args[1];
            expr = args[0];
        } else if (funcName.equals("+") || funcName.equals("*")) {
            const1 = (Constant)args[0];
            expr = args[1];
        } else {
            return criteria;
        }
        int operator = criteria.getOperator();
        String oppFunc = null;
        switch (funcName.charAt(0)) {
            case '+': {
                oppFunc = "-";
                break;
            }
            case '-': {
                oppFunc = "+";
                break;
            }
            case '*': {
                oppFunc = "/";
                break;
            }
            case '/': {
                oppFunc = "*";
            }
        }
        Function combinedConst = null;
        FunctionLibrary funcLib = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findFunction(oppFunc, new Class[]{rightExpr.getType(), const1.getType()});
        if (descriptor == null) {
            return criteria;
        }
        if (rightExpr instanceof Constant) {
            Constant const2 = (Constant)rightExpr;
            try {
                Object result = funcLib.invokeFunction(descriptor, new Object[]{const2.getValue(), const1.getValue()});
                combinedConst = new Constant(result, descriptor.getReturnType());
            }
            catch (InvalidFunctionException e) {
                throw new QueryValidatorException((Throwable)e, "ERR.015.009.0003", QueryExecPlugin.Util.getString("ERR.015.009.0003", (Object)e.getMessage()));
            }
            catch (FunctionExecutionException e) {
                throw new QueryValidatorException((Throwable)e, "ERR.015.009.0003", QueryExecPlugin.Util.getString("ERR.015.009.0003", (Object)e.getMessage()));
            }
        } else {
            Function conversion = new Function(descriptor.getName(), new Expression[]{rightExpr, const1});
            conversion.setType(leftExpr.getType());
            conversion.setFunctionDescriptor(descriptor);
            combinedConst = conversion;
        }
        if (operator != 1 && operator != 2 && (oppFunc.equals("*") || oppFunc.equals("/")) && (value = const1.getValue()) != null) {
            Class type = const1.getType();
            Number comparisonObject = null;
            if (type.equals(DataTypeManager.DefaultDataClasses.INTEGER)) {
                comparisonObject = INTEGER_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.DOUBLE)) {
                comparisonObject = DOUBLE_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.FLOAT)) {
                comparisonObject = FLOAT_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.LONG)) {
                comparisonObject = LONG_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER)) {
                comparisonObject = BIG_INTEGER_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
                comparisonObject = BIG_DECIMAL_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.SHORT)) {
                comparisonObject = SHORT_ZERO;
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BYTE)) {
                comparisonObject = BYTE_ZERO;
            } else {
                return criteria;
            }
            if (comparisonObject.compareTo(value) > 0) {
                switch (operator) {
                    case 5: {
                        operator = 6;
                        break;
                    }
                    case 3: {
                        operator = 4;
                        break;
                    }
                    case 6: {
                        operator = 5;
                        break;
                    }
                    case 4: {
                        operator = 3;
                    }
                }
            }
        }
        criteria.setLeftExpression(expr);
        criteria.setRightExpression((Expression)combinedConst);
        criteria.setOperator(operator);
        if (expr instanceof Function) {
            return QueryRewriter.simplifyWithInverse(criteria);
        }
        return criteria;
    }

    private static CompareCriteria simplifyConvertFunction(CompareCriteria crit) throws QueryValidatorException {
        Function leftFunction = (Function)crit.getLeftExpression();
        Constant rightConstant = (Constant)crit.getRightExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        Expression targetType = leftFunction.getArgs()[1];
        if (!(targetType instanceof Constant)) {
            return crit;
        }
        String leftExprTypeName = DataTypeManager.getDataTypeName((Class)leftExpr.getType());
        if (leftExpr.getType() == DataTypeManager.DefaultDataClasses.NULL || rightConstant.getType() != DataTypeManager.DefaultDataClasses.STRING) {
            return crit;
        }
        FunctionLibrary funcLib = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findTypedConversionFunction(rightConstant.getType(), leftExpr.getType());
        if (descriptor == null) {
            return crit;
        }
        try {
            Object result = funcLib.invokeFunction(descriptor, new Object[]{rightConstant.getValue(), leftExprTypeName});
            crit.setRightExpression((Expression)new Constant(result, descriptor.getReturnType()));
            crit.setLeftExpression(leftExpr);
        }
        catch (InvalidFunctionException e) {
            String errorMsg = QueryPlugin.Util.getString("QueryRewriter.criteriaError", (Object)crit);
            throw new QueryValidatorException((Throwable)e, errorMsg);
        }
        catch (FunctionExecutionException e) {
            if (crit.getOperator() == 1) {
                return (CompareCriteria)FALSE_CRITERIA;
            }
            return (CompareCriteria)TRUE_CRITERIA;
        }
        if (leftExpr instanceof Function) {
            return QueryRewriter.simplifyWithInverse(crit);
        }
        return crit;
    }

    private static SetCriteria simplifyConvertFunction(SetCriteria crit) throws QueryValidatorException {
        Function leftFunction = (Function)crit.getExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        Expression targetType = leftFunction.getArgs()[1];
        String leftExprTypeName = DataTypeManager.getDataTypeName((Class)leftExpr.getType());
        Iterator i = crit.getValues().iterator();
        ArrayList<Constant> newValues = new ArrayList<Constant>(crit.getNumberOfValues());
        boolean success = true;
        try {
            while (i.hasNext()) {
                Object next = i.next();
                if (next instanceof Constant) {
                    Constant rightConstant = (Constant)next;
                    Class rightConstantType = rightConstant.getType();
                    if (targetType.getType().equals(rightConstantType) && targetType.getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
                        FunctionLibrary funcLib = FunctionLibraryManager.getFunctionLibrary();
                        FunctionDescriptor descriptor = funcLib.findTypedConversionFunction(rightConstantType, leftExpr.getType());
                        if (descriptor != null) {
                            Object result = funcLib.invokeFunction(descriptor, new Object[]{rightConstant.getValue(), leftExprTypeName});
                            newValues.add(new Constant(result, descriptor.getReturnType()));
                            continue;
                        }
                        success = false;
                    } else {
                        success = false;
                    }
                } else {
                    success = false;
                }
                break;
            }
        }
        catch (InvalidFunctionException e) {
            String errorMsg = QueryExecPlugin.Util.getString("QueryRewriter.criteriaError", (Object)crit);
            throw new QueryValidatorException((Throwable)e, errorMsg);
        }
        catch (FunctionExecutionException e) {
            return crit;
        }
        if (success) {
            crit.setExpression(leftExpr);
            crit.setValues(newValues);
        }
        return crit;
    }

    private static CompareCriteria simplifyParseFormatFunction(CompareCriteria crit) throws QueryValidatorException {
        String type;
        Function leftFunction = (Function)crit.getLeftExpression();
        String funcName = leftFunction.getName().toLowerCase();
        String inverseFunction = null;
        if (funcName.startsWith("parse")) {
            type = funcName.substring(5);
            inverseFunction = "format" + type;
        } else if (funcName.startsWith("format")) {
            type = funcName.substring(6);
            inverseFunction = "parse" + type;
        } else {
            return crit;
        }
        Expression rightExpr = crit.getRightExpression();
        Expression leftExpr = leftFunction.getArgs()[0];
        Expression formatExpr = leftFunction.getArgs()[1];
        if (!(formatExpr instanceof Constant)) {
            return crit;
        }
        FunctionLibrary funcLib = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor descriptor = funcLib.findFunction(inverseFunction, new Class[]{rightExpr.getType(), formatExpr.getType()});
        if (descriptor == null) {
            return crit;
        }
        try {
            if (rightExpr instanceof Constant) {
                Object result = funcLib.invokeFunction(descriptor, new Object[]{((Constant)rightExpr).getValue(), ((Constant)formatExpr).getValue()});
                crit.setRightExpression((Expression)new Constant(result, descriptor.getReturnType()));
                crit.setLeftExpression(leftExpr);
            } else {
                Function conversion = new Function(descriptor.getName(), new Expression[]{rightExpr, formatExpr});
                conversion.setType(leftExpr.getType());
                conversion.setFunctionDescriptor(descriptor);
                crit.setRightExpression((Expression)conversion);
                crit.setLeftExpression(leftExpr);
            }
        }
        catch (InvalidFunctionException e) {
            String errorMsg = QueryPlugin.Util.getString("QueryRewriter.criteriaError", (Object)crit);
            throw new QueryValidatorException((Throwable)e, errorMsg);
        }
        catch (FunctionExecutionException e) {
            String errorMsg = QueryPlugin.Util.getString("QueryRewriter.criteriaError", (Object)crit);
            throw new QueryValidatorException((Throwable)e, errorMsg);
        }
        if (leftExpr instanceof Function) {
            return QueryRewriter.simplifyWithInverse(crit);
        }
        return crit;
    }

    private static Criteria simplifyTimestampMerge2(CompareCriteria criteria) {
        if (criteria.getOperator() != 1) {
            return criteria;
        }
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function tsCreateFunction = null;
        Constant timestampConstant = null;
        if (leftExpr instanceof Function && rightExpr instanceof Constant) {
            tsCreateFunction = (Function)leftExpr;
            timestampConstant = (Constant)rightExpr;
        } else if (leftExpr instanceof Constant && rightExpr instanceof Function) {
            tsCreateFunction = (Function)rightExpr;
            timestampConstant = (Constant)leftExpr;
        } else {
            return criteria;
        }
        if (!timestampConstant.getType().equals(DataTypeManager.DefaultDataClasses.TIMESTAMP) || timestampConstant.getValue() == null) {
            return criteria;
        }
        if (!tsCreateFunction.getName().equalsIgnoreCase("timestampCreate")) {
            return criteria;
        }
        Timestamp ts = (Timestamp)timestampConstant.getValue();
        String tsStr = ts.toString();
        java.sql.Date date = java.sql.Date.valueOf(tsStr.substring(0, 10));
        Time time = Time.valueOf(tsStr.substring(11, 19));
        Expression[] args = tsCreateFunction.getArgs();
        CompareCriteria dateCrit = new CompareCriteria(args[0], 1, (Expression)new Constant((Object)date, DataTypeManager.DefaultDataClasses.DATE));
        CompareCriteria timeCrit = new CompareCriteria(args[1], 1, (Expression)new Constant((Object)time, DataTypeManager.DefaultDataClasses.TIME));
        CompoundCriteria compCrit = new CompoundCriteria(0, (Criteria)dateCrit, (Criteria)timeCrit);
        return compCrit;
    }

    private static Criteria simplifyTimestampMerge(CompareCriteria criteria) {
        if (criteria.getOperator() != 1) {
            return criteria;
        }
        Expression leftExpr = criteria.getLeftExpression();
        Expression rightExpr = criteria.getRightExpression();
        Function concatFunction = null;
        Constant timestampConstant = null;
        if (leftExpr instanceof Function && rightExpr instanceof Constant) {
            concatFunction = (Function)leftExpr;
            timestampConstant = (Constant)rightExpr;
        } else if (leftExpr instanceof Constant && rightExpr instanceof Function) {
            concatFunction = (Function)rightExpr;
            timestampConstant = (Constant)leftExpr;
        } else {
            return criteria;
        }
        if (!timestampConstant.getType().equals(DataTypeManager.DefaultDataClasses.STRING) || timestampConstant.getValue() == null) {
            return criteria;
        }
        if (!concatFunction.getName().equalsIgnoreCase("concat") && !concatFunction.getName().equals("||")) {
            return criteria;
        }
        Expression[] args = concatFunction.getArgs();
        if (!(args[0] instanceof Function) || !(args[1] instanceof Function)) {
            return criteria;
        }
        Function formatDateFunction = (Function)args[0];
        Function formatTimeFunction = (Function)args[1];
        if (!formatDateFunction.getName().equalsIgnoreCase("formatdate") || !formatTimeFunction.getName().equalsIgnoreCase("formattime")) {
            return criteria;
        }
        if (!(formatDateFunction.getArgs()[1] instanceof Constant) || !(formatTimeFunction.getArgs()[1] instanceof Constant)) {
            return criteria;
        }
        String dateFormat = (String)((Constant)formatDateFunction.getArgs()[1]).getValue();
        String timeFormat = (String)((Constant)formatTimeFunction.getArgs()[1]).getValue();
        if (dateFormat == null || timeFormat == null) {
            return criteria;
        }
        String timestampValue = (String)timestampConstant.getValue();
        if (timestampValue.length() != dateFormat.length() + timeFormat.length()) {
            return criteria;
        }
        try {
            SimpleDateFormat timestampFormatter = new SimpleDateFormat(dateFormat + timeFormat);
            Date parsedTimestamp = timestampFormatter.parse(timestampValue);
            GregorianCalendar tsCal = new GregorianCalendar();
            tsCal.setTime(parsedTimestamp);
            tsCal.set(11, 0);
            tsCal.set(12, 0);
            tsCal.set(13, 0);
            tsCal.set(14, 0);
            java.sql.Date date = new java.sql.Date(tsCal.getTime().getTime());
            Constant dateConstant = new Constant((Object)date);
            CompareCriteria dateCompare = new CompareCriteria(formatDateFunction.getArgs()[0], 1, (Expression)dateConstant);
            tsCal = new GregorianCalendar();
            tsCal.setTime(parsedTimestamp);
            tsCal.set(1, 1970);
            tsCal.set(2, 0);
            tsCal.set(5, 1);
            Time time = new Time(tsCal.getTime().getTime());
            Constant timeConstant = new Constant((Object)time);
            CompareCriteria timeCompare = new CompareCriteria(formatTimeFunction.getArgs()[0], 1, (Expression)timeConstant);
            CompoundCriteria compCrit = new CompoundCriteria(0, (Criteria)dateCompare, (Criteria)timeCompare);
            return compCrit;
        }
        catch (ParseException e) {
            return criteria;
        }
    }

    private static Criteria rewriteCriteria(MatchCriteria criteria, Command procCommand, CommandContext context) throws QueryValidatorException {
        Expression rightExpr;
        criteria.setLeftExpression(QueryRewriter.rewriteExpression(criteria.getLeftExpression(), procCommand, context));
        criteria.setRightExpression(QueryRewriter.rewriteExpression(criteria.getRightExpression(), procCommand, context));
        if (criteria.getEscapeChar() != '\u0000' && (rightExpr = criteria.getRightExpression()) instanceof Constant) {
            char escape;
            String value;
            Constant constant = (Constant)rightExpr;
            if (constant.isNull()) {
                criteria.setEscapeChar('\u0000');
            } else if (constant.getType().equals(DataTypeManager.DefaultDataClasses.STRING) && (value = (String)constant.getValue()).indexOf(escape = criteria.getEscapeChar()) < 0) {
                criteria.setEscapeChar('\u0000');
            }
        }
        return criteria;
    }

    private static Criteria rewriteCriteria(SetCriteria criteria, Command procCommand, CommandContext context) throws QueryValidatorException {
        String funcName;
        Function leftFunction;
        Expression[] args;
        criteria.setExpression(QueryRewriter.rewriteExpression(criteria.getExpression(), procCommand, context));
        List vals = criteria.getValues();
        ArrayList<Expression> newVals = new ArrayList<Expression>(vals.size());
        Iterator valIter = vals.iterator();
        while (valIter.hasNext()) {
            newVals.add(QueryRewriter.rewriteExpression((Expression)valIter.next(), procCommand, context));
        }
        criteria.setValues(newVals);
        if (criteria.getExpression() instanceof Function && (args = (leftFunction = (Function)criteria.getExpression()).getArgs()) != null && args.length > 0 && ((funcName = leftFunction.getName()).equalsIgnoreCase("convert") || funcName.equalsIgnoreCase("cast"))) {
            Iterator i = criteria.getValues().iterator();
            while (i.hasNext()) {
                if (i.next() instanceof Constant) continue;
                return criteria;
            }
            criteria = QueryRewriter.simplifyConvertFunction(criteria);
        }
        return criteria;
    }

    private static Criteria rewriteCriteria(IsNullCriteria criteria, Command procCommand, CommandContext context) throws QueryValidatorException {
        criteria.setExpression(QueryRewriter.rewriteExpression(criteria.getExpression(), procCommand, context));
        return criteria;
    }

    public static Expression rewriteExpression(Expression expression, CommandContext context) throws QueryValidatorException {
        return QueryRewriter.rewriteExpression(expression, null, context);
    }

    public static Expression rewriteExpression(Expression expression, Command procCommand, CommandContext context) throws QueryValidatorException {
        if (expression instanceof Function) {
            return QueryRewriter.rewriteFunction((Function)expression, procCommand, context);
        }
        if (expression instanceof CaseExpression) {
            return QueryRewriter.rewriteCaseExpression((CaseExpression)expression, procCommand, context);
        }
        if (expression instanceof SearchedCaseExpression) {
            return QueryRewriter.rewriteCaseExpression((SearchedCaseExpression)expression, procCommand, context);
        }
        return expression;
    }

    public static Expression rewriteFunction(Function function, CommandContext context) throws QueryValidatorException {
        return QueryRewriter.rewriteFunction(function, null, context);
    }

    public static Expression rewriteFunction(Function function, Command procCommand, CommandContext context) throws QueryValidatorException {
        int i;
        Expression[] args = function.getArgs();
        Expression[] newArgs = new Expression[args.length];
        for (i = 0; i < args.length; ++i) {
            newArgs[i] = QueryRewriter.rewriteExpression(args[i], procCommand, context);
        }
        function.setArgs(newArgs);
        if ((function.getName().equalsIgnoreCase("convert") || function.getName().equalsIgnoreCase("cast")) && newArgs[1] instanceof Constant) {
            Class srcType = newArgs[0].getType();
            String tgtTypeName = (String)((Constant)newArgs[1]).getValue();
            Class tgtType = DataTypeManager.getDataTypeClass((String)tgtTypeName);
            if (srcType != null && tgtType != null && srcType.equals(tgtType)) {
                return newArgs[0];
            }
        }
        if (function.getName().equalsIgnoreCase("decodestring") || function.getName().equalsIgnoreCase("decodeinteger")) {
            return QueryRewriter.convertDecodeFunction(function);
        }
        if (EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)function, true)) {
            try {
                Object result = null;
                result = context == null ? ExpressionEvaluator.evaluate((Expression)function, null, null) : ExpressionEvaluator.evaluate((Expression)function, null, null, null, context);
                Constant constant = new Constant(result, function.getType());
                return constant;
            }
            catch (ExpressionEvaluationException e) {
                String funcName = function.getName();
                if (funcName.equalsIgnoreCase("convert") || funcName.equalsIgnoreCase("cast")) {
                    Expression expr = newArgs[0];
                    String sourceType = DataTypeManager.getDataTypeName((Class)newArgs[0].getType());
                    String targetType = (String)((Constant)newArgs[1]).getValue();
                    throw new QueryValidatorException((Throwable)e, "ERR.015.009.0004", QueryExecPlugin.Util.getString("ERR.015.009.0004", new Object[]{funcName, expr, sourceType, targetType}));
                }
                throw new QueryValidatorException((Throwable)e, e.getMessage());
            }
            catch (MetaMatrixComponentException e) {
                throw new QueryValidatorException((Throwable)e, "ERR.015.009.0005", QueryExecPlugin.Util.getString("ERR.015.009.0005", (Object)function));
            }
        }
        if (EvaluatableVisitor.isDelayedEvaluationFunction(function) && ReferenceCollectorVisitor.getReferences((LanguageObject)function).isEmpty()) {
            for (i = 0; i < newArgs.length; ++i) {
                if (EvaluateExpressionVisitor.isRuntimeEvaluatable((LanguageObject)newArgs[i], true)) continue;
                return function;
            }
            Reference reference = new Reference(0, (Expression)function);
            return reference;
        }
        return function;
    }

    private static Expression convertDecodeFunction(Function function) {
        Expression[] exprs = function.getArgs();
        String decodeString = (String)((Constant)exprs[1]).getValue();
        String decodeDelimiter = ",";
        if (exprs.length == 3) {
            decodeDelimiter = (String)((Constant)exprs[2]).getValue();
        }
        ArrayList<Constant> newWhens = new ArrayList<Constant>();
        ArrayList<Constant> newThens = new ArrayList<Constant>();
        Constant elseConst = null;
        StringTokenizer tokenizer = new StringTokenizer(decodeString, decodeDelimiter);
        while (tokenizer.hasMoreTokens()) {
            String compareString = FunctionMethods.convertString(tokenizer.nextToken().trim());
            if (tokenizer.hasMoreTokens()) {
                String resultString = FunctionMethods.convertString(tokenizer.nextToken().trim());
                newWhens.add(new Constant((Object)compareString));
                newThens.add(new Constant((Object)resultString));
                continue;
            }
            elseConst = new Constant((Object)compareString);
        }
        CaseExpression newCaseExpr = new CaseExpression(exprs[0], newWhens, newThens);
        if (elseConst != null) {
            newCaseExpr.setElseExpression((Expression)elseConst);
        } else {
            newCaseExpr.setElseExpression(exprs[0]);
        }
        newCaseExpr.setType(function.getType());
        return newCaseExpr;
    }

    private static Expression rewriteCaseExpression(CaseExpression expr, Command procCommand, CommandContext context) throws QueryValidatorException {
        Expression rewrittenExpr = QueryRewriter.rewriteExpression(expr.getExpression(), procCommand, context);
        expr.setExpression(rewrittenExpr);
        int whenCount = expr.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        boolean tryToSimplify = CaseSimplificationVisitor.canSimplify((LanguageObject)rewrittenExpr);
        for (int i = 0; i < whenCount; ++i) {
            Expression rewrittenWhen = QueryRewriter.rewriteExpression(expr.getWhenExpression(i), procCommand, context);
            if (tryToSimplify && CaseSimplificationVisitor.canSimplify((LanguageObject)rewrittenWhen)) {
                CompareCriteria crit = new CompareCriteria(rewrittenExpr, 1, rewrittenWhen);
                try {
                    boolean eval = CriteriaEvaluator.evaluate((Criteria)crit, null, null);
                    if (!eval) continue;
                    return QueryRewriter.rewriteExpression(expr.getThenExpression(i), procCommand, context);
                }
                catch (Exception e) {
                    tryToSimplify = false;
                }
            } else {
                tryToSimplify = false;
            }
            whens.add(rewrittenWhen);
            thens.add(QueryRewriter.rewriteExpression(expr.getThenExpression(i), procCommand, context));
        }
        return QueryRewriter.simplifyCaseExpression((AbstractCaseExpression)expr, procCommand, context, whenCount, whens, thens);
    }

    private static Expression simplifyCaseExpression(AbstractCaseExpression expr, Command procCommand, CommandContext context, int whenCount, ArrayList whens, ArrayList thens) throws QueryValidatorException {
        expr.setElseExpression(QueryRewriter.rewriteExpression(expr.getElseExpression(), procCommand, context));
        Expression elseExpr = expr.getElseExpression();
        if (whens.size() == 0) {
            if (elseExpr == null) {
                return new Constant(null, expr.getType());
            }
            return elseExpr;
        }
        expr.setWhen(whens, thens);
        if (elseExpr != null) {
            boolean bAllMatch = true;
            for (int i = 0; i < whenCount; ++i) {
                if (thens.get(i).equals(elseExpr)) continue;
                bAllMatch = false;
                break;
            }
            if (bAllMatch) {
                return elseExpr;
            }
        }
        return expr;
    }

    private static Expression rewriteCaseExpression(SearchedCaseExpression expr, Command procCommand, CommandContext context) throws QueryValidatorException {
        int whenCount = expr.getWhenCount();
        ArrayList<Criteria> whens = new ArrayList<Criteria>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        boolean tryToSimplify = true;
        for (int i = 0; i < whenCount; ++i) {
            Criteria rewrittenWhen = QueryRewriter.rewriteCriteria(expr.getWhenCriteria(i), procCommand, context);
            if (tryToSimplify && CaseSimplificationVisitor.canSimplify((LanguageObject)rewrittenWhen)) {
                try {
                    boolean eval = CriteriaEvaluator.evaluate((Criteria)rewrittenWhen, null, null);
                    if (!eval) continue;
                    return QueryRewriter.rewriteExpression(expr.getThenExpression(i), procCommand, context);
                }
                catch (Exception e) {
                    tryToSimplify = false;
                }
            } else {
                tryToSimplify = false;
            }
            whens.add(rewrittenWhen);
            thens.add(QueryRewriter.rewriteExpression(expr.getThenExpression(i), procCommand, context));
        }
        return QueryRewriter.simplifyCaseExpression((AbstractCaseExpression)expr, procCommand, context, whenCount, whens, thens);
    }

    private static Command rewriteExec(StoredProcedure storedProcedure, Command procCommand, QueryMetadataInterface metadata, CommandContext context) throws QueryValidatorException {
        storedProcedure.setDisplayNamedParameters(false);
        try {
            EvaluateExpressionVisitor.replaceExpressions((LanguageObject)storedProcedure, false, false, context);
        }
        catch (Exception e) {
            throw new QueryValidatorException((Throwable)e, e.getMessage());
        }
        List subCommands = storedProcedure.getSubCommands();
        if (subCommands.size() > 0) {
            Command subCommand = (Command)storedProcedure.getSubCommands().get(0);
            Command rewrittenCommand = QueryRewriter.rewrite(subCommand, null, metadata, context);
            subCommands.set(0, rewrittenCommand);
        }
        return storedProcedure;
    }

    private static Insert rewriteInsert(Insert insert, Command procCommand, CommandContext context) throws QueryValidatorException {
        List expressions = insert.getValues();
        ArrayList<Expression> evalExpressions = new ArrayList<Expression>(expressions.size());
        Iterator expIter = expressions.iterator();
        while (expIter.hasNext()) {
            Expression exp = (Expression)expIter.next();
            evalExpressions.add(QueryRewriter.rewriteExpression(exp, procCommand, context));
        }
        insert.setValues(evalExpressions);
        return insert;
    }

    private static Update rewriteUpdate(Update update, Command procCommand, CommandContext context) throws QueryValidatorException {
        Criteria crit;
        List changeList = update.getChangeList();
        Iterator changeIter = changeList.iterator();
        while (changeIter.hasNext()) {
            crit = (CompareCriteria)changeIter.next();
            crit.setRightExpression(QueryRewriter.rewriteExpression(crit.getRightExpression(), procCommand, context));
        }
        crit = update.getCriteria();
        if (crit != null) {
            if (procCommand != null && procCommand.getType() == 7) {
                CreateUpdateProcedureCommand procedure = (CreateUpdateProcedureCommand)procCommand;
                ArrayList<GroupSymbol> groups = new ArrayList<GroupSymbol>(1);
                groups.add(update.getGroup());
                procedure.setSubCommandGroups(groups);
            }
            update.setCriteria(QueryRewriter.rewriteCriteria(crit, procCommand, context));
        }
        return update;
    }

    private static Delete rewriteDelete(Delete delete, Command procCommand, CommandContext context) throws QueryValidatorException {
        Criteria crit = delete.getCriteria();
        if (crit != null) {
            if (procCommand != null && procCommand.getType() == 7) {
                CreateUpdateProcedureCommand procedure = (CreateUpdateProcedureCommand)procCommand;
                ArrayList<GroupSymbol> groups = new ArrayList<GroupSymbol>(1);
                groups.add(delete.getGroup());
                procedure.setSubCommandGroups(groups);
            }
            delete.setCriteria(QueryRewriter.rewriteCriteria(crit, procCommand, context));
        }
        return delete;
    }

    private static Limit rewriteLimitClause(Limit limit) {
        if (limit.getRowLimit() instanceof Constant && ((Constant)limit.getRowLimit()).getValue().equals(new Integer(0)) && (limit.getOffset() == null || limit.getOffset() instanceof Constant && ((Constant)limit.getOffset()).getValue().equals(new Integer(0)))) {
            return null;
        }
        return limit;
    }
}

