/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.eval.CriteriaEvaluator;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RuleCleanCriteria
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, MetaMatrixComponentException {
        ArrayList phantomNodes = new ArrayList();
        this.findPhantomCriteria(plan, phantomNodes);
        if (phantomNodes.size() > 0) {
            Iterator phantomIter = phantomNodes.iterator();
            while (phantomIter.hasNext()) {
                PlanNode phantomNode = (PlanNode)phantomIter.next();
                NodeEditor.removeChildNode(phantomNode.getParent(), phantomNode);
            }
        }
        ArrayList noElementCriteria = new ArrayList();
        this.findNoElementCriteria(plan, noElementCriteria);
        this.handleNoElementCriteria(noElementCriteria);
        ArrayList criteriaChains = new ArrayList();
        this.findCriteriaChains(plan, criteriaChains);
        if (criteriaChains.size() > 0) {
            Iterator chainIter = criteriaChains.iterator();
            while (chainIter.hasNext()) {
                PlanNode critNode = (PlanNode)chainIter.next();
                this.mergeChain(critNode);
            }
        }
        return plan;
    }

    void findPhantomCriteria(PlanNode root, List foundNodes) throws QueryPlannerException, MetaMatrixComponentException {
        Boolean isPhantom;
        if (root.getType() == 13 && (isPhantom = (Boolean)root.getProperty((Object)NodeConstants.Info.IS_PHANTOM)) != null && isPhantom.equals(Boolean.TRUE)) {
            foundNodes.add(root);
        }
        if (root.getChildCount() > 0) {
            List children = root.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                this.findPhantomCriteria(child, foundNodes);
            }
        }
    }

    void findNoElementCriteria(PlanNode root, List foundNodes) throws QueryPlannerException, MetaMatrixComponentException {
        Collection criteria;
        Criteria crit;
        List references;
        if (root.getGroups().size() == 0 && this.isCriteria(root) && (references = ReferenceCollectorVisitor.getReferences((LanguageObject)(crit = (Criteria)root.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA)))).size() == 0 && (criteria = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)crit)).size() == 0) {
            Iterator functions = FunctionCollectorVisitor.getFunctions((LanguageObject)crit, (boolean)true).iterator();
            boolean hasFunctionThatCantBeEvaluated = false;
            while (functions.hasNext()) {
                Function function = (Function)functions.next();
                if (function.getFunctionDescriptor().getPushdown() != 2 && !function.getName().equalsIgnoreCase("lookup") && !function.getName().equalsIgnoreCase("commandpayload")) continue;
                hasFunctionThatCantBeEvaluated = true;
                break;
            }
            if (!hasFunctionThatCantBeEvaluated) {
                foundNodes.add(root);
            }
        }
        if (root.getChildCount() > 0) {
            List children = root.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                this.findNoElementCriteria(child, foundNodes);
            }
        }
    }

    void handleNoElementCriteria(List critNodes) throws MetaMatrixComponentException {
        Iterator critIter = critNodes.iterator();
        while (critIter.hasNext()) {
            Criteria crit = null;
            try {
                PlanNode critNode = (PlanNode)critIter.next();
                crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                try {
                    boolean eval = CriteriaEvaluator.evaluate((Criteria)crit, (Map)Collections.EMPTY_MAP, (List)Collections.EMPTY_LIST);
                    if (eval) {
                        NodeEditor.removeChildNode(critNode.getParent(), critNode);
                        continue;
                    }
                    PlanNode parent = critNode.getParent();
                    NodeEditor.cutLast(parent);
                    PlanNode nullNode = NodeFactory.getNewNode((int)31);
                    NodeEditor.attachLast(parent, nullNode);
                }
                catch (BlockedException e) {}
            }
            catch (CriteriaEvaluationException e) {
                throw new MetaMatrixComponentException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0017", (Object)crit));
            }
        }
    }

    void findCriteriaChains(PlanNode root, List foundNodes) throws QueryPlannerException, MetaMatrixComponentException {
        PlanNode recurseRoot = root;
        if (this.isCriteria(root)) {
            while (this.isCriteria(recurseRoot)) {
                recurseRoot = recurseRoot.getLastChild();
            }
            if (recurseRoot.getParent() != root) {
                foundNodes.add(root);
            }
        }
        if (recurseRoot.getChildCount() > 0) {
            List children = recurseRoot.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                this.findCriteriaChains(child, foundNodes);
            }
        }
    }

    boolean isCriteria(PlanNode critNode) {
        Boolean isHaving;
        return critNode.getType() == 13 && ((isHaving = (Boolean)critNode.getProperty((Object)NodeConstants.Info.IS_HAVING)) == null || isHaving.equals(Boolean.FALSE));
    }

    void mergeChain(PlanNode chainRoot) {
        HashSet<Object> critParts = new HashSet<Object>();
        List subqueryPlans = null;
        List subqueryValueProviders = null;
        List correlatedReferences = null;
        PlanNode current = chainRoot;
        while (this.isCriteria(current)) {
            critParts.add(current.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA));
            subqueryPlans = RuleCleanCriteria.addProperties(subqueryPlans, (List)current.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS));
            subqueryValueProviders = RuleCleanCriteria.addProperties(subqueryValueProviders, (List)current.getProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS));
            correlatedReferences = RuleCleanCriteria.addProperties(correlatedReferences, (List)current.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES));
            PlanNode last = current;
            current = current.getLastChild();
            if (last == chainRoot) continue;
            NodeEditor.removeChildNode(last.getParent(), last);
        }
        Criteria combinedCrit = null;
        if (critParts.size() == 1) {
            combinedCrit = (Criteria)critParts.iterator().next();
        } else {
            CompoundCriteria compCrit = new CompoundCriteria();
            compCrit.setOperator(0);
            Iterator critIter = critParts.iterator();
            while (critIter.hasNext()) {
                Criteria critPart = (Criteria)critIter.next();
                compCrit.addCriteria(critPart);
            }
            combinedCrit = compCrit;
        }
        chainRoot.setProperty((Object)NodeConstants.Info.SELECT_CRITERIA, (Object)combinedCrit);
        if (subqueryPlans != null) {
            chainRoot.setProperty((Object)NodeConstants.Info.SUBQUERY_PLANS, (Object)subqueryPlans);
        }
        if (subqueryValueProviders != null) {
            chainRoot.setProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS, (Object)subqueryValueProviders);
        }
        if (correlatedReferences != null) {
            chainRoot.setProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES, correlatedReferences);
        }
        chainRoot.getGroups().clear();
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)combinedCrit, (boolean)true);
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol element = (ElementSymbol)elementIter.next();
            chainRoot.addGroup(element.getGroupSymbol());
        }
    }

    private static List addProperties(List props, List addToProps) {
        if (addToProps != null) {
            if (props == null) {
                props = new ArrayList();
            }
            props.addAll(addToProps);
        }
        return props;
    }

    public String toString() {
        return "CleanCriteria";
    }
}

