/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.util.CommandContext;
import java.util.Iterator;
import java.util.List;

public class RuleChangeJoinType
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List joins = NodeEditor.findAllNodes(plan, 7);
        Iterator i = joins.iterator();
        while (i.hasNext()) {
            PlanNode joinNode = (PlanNode)i.next();
            JoinType jt = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
            if (jt != JoinType.JOIN_RIGHT_OUTER) continue;
            RuleChangeJoinType.swapJoinChildren(joinNode);
        }
        return plan;
    }

    static void swapJoinChildren(PlanNode joinNode) {
        PlanNode leftChild = joinNode.getFirstChild();
        joinNode.removeChild(leftChild);
        joinNode.addLastChild(leftChild);
        List leftExpressions = (List)joinNode.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS);
        List rightExpressions = (List)joinNode.getProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS);
        joinNode.setProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS, (Object)rightExpressions);
        joinNode.setProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS, (Object)leftExpressions);
        JoinType jt = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
        if (jt == JoinType.JOIN_LEFT_OUTER) {
            jt = JoinType.JOIN_RIGHT_OUTER;
        } else if (jt == JoinType.JOIN_RIGHT_OUTER) {
            jt = JoinType.JOIN_LEFT_OUTER;
        }
        joinNode.setProperty((Object)NodeConstants.Info.JOIN_TYPE, (Object)jt);
    }

    public String toString() {
        return "ChangeJoinTypes";
    }
}

