/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public final class RuleAccessPatternValidation
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException {
        Stack<Object> nodes = new Stack<Object>();
        nodes.push(plan);
        while (!nodes.isEmpty()) {
            PlanNode node = (PlanNode)nodes.pop();
            if (node.getType() == 3) {
                boolean isInsert = false;
                boolean isDelete = false;
                Delete del = null;
                if (node.hasProperty((Object)NodeConstants.Info.ATOMIC_REQUEST)) {
                    Object req = node.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
                    if (req instanceof Insert) {
                        isInsert = true;
                    } else if (req instanceof Delete) {
                        isDelete = true;
                        del = (Delete)req;
                    }
                }
                if (!isInsert && node.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
                    if (isDelete) {
                        Criteria crit = del.getCriteria();
                        Collection elementsInCrit = this.getCritElementIDs(crit);
                        Collection accessPatterns = (Collection)node.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
                        Iterator apElements = accessPatterns.iterator();
                        boolean done = false;
                        while (!done && apElements.hasNext()) {
                            Collection elements = (Collection)apElements.next();
                            if (!elementsInCrit.containsAll(elements)) continue;
                            done = true;
                            node.setProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED, (Object)elements);
                        }
                    }
                    if (!node.hasProperty((Object)NodeConstants.Info.ACCESS_PATTERN_USED)) {
                        Set groups = node.getGroups();
                        Object accessPatterns = node.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
                        throw new QueryPlannerException(QueryExecPlugin.Util.getString("ERR.015.004.0012", new Object[]{groups, accessPatterns}));
                    }
                }
            }
            Iterator children = node.getChildren().iterator();
            while (children.hasNext()) {
                nodes.push(children.next());
            }
        }
        return plan;
    }

    Collection getCritElementIDs(Criteria crit) {
        boolean REMOVE_DUPLICATES = true;
        Collection critElements = ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true);
        ArrayList<Object> critElementIDs = new ArrayList<Object>(critElements.size());
        Iterator elemIter = critElements.iterator();
        while (elemIter.hasNext()) {
            ElementSymbol element = (ElementSymbol)elemIter.next();
            critElementIDs.add(element.getMetadataID());
        }
        return critElementIDs;
    }

    public String toString() {
        return "AccessPatternValidation";
    }
}

