/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class RulePlaceAccess
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, MetaMatrixComponentException {
        ArrayList nodes = new ArrayList();
        this.collectLeafNodes(plan, nodes);
        boolean foundAccessPatterns = false;
        Iterator nodeIter = nodes.iterator();
        while (nodeIter.hasNext()) {
            Object req;
            Object hint;
            PlanNode node = (PlanNode)nodeIter.next();
            if (node.getType() != 19) continue;
            PlanNode accessNode = NodeFactory.getNewNode((int)3);
            accessNode.addGroups((Collection)node.getGroups());
            Object accessModelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
            if (accessModelID != null) {
                accessNode.setProperty((Object)NodeConstants.Info.MODEL_ID, accessModelID);
            }
            if ((hint = node.getProperty((Object)NodeConstants.Info.MAKE_DEP)) != null) {
                accessNode.setProperty((Object)NodeConstants.Info.MAKE_DEP, hint);
            }
            if ((hint = node.getProperty((Object)NodeConstants.Info.MAKE_NOT_DEP)) != null) {
                accessNode.setProperty((Object)NodeConstants.Info.MAKE_NOT_DEP, hint);
            }
            boolean isInsert = false;
            if (node.hasProperty((Object)NodeConstants.Info.ATOMIC_REQUEST) && (req = node.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST)) instanceof Insert) {
                isInsert = true;
            }
            if (!isInsert && RulePlaceAccess.addAccessPatternsProperty(accessNode, metadata)) {
                foundAccessPatterns = true;
            }
            NodeEditor.insertNode(node.getParent(), node, accessNode);
        }
        if (!foundAccessPatterns) {
            rules.remove(RuleConstants.ACCESS_PATTERN_VALIDATION);
        }
        return plan;
    }

    void collectLeafNodes(PlanNode node, Collection leafNodes) {
        if (node.getChildCount() == 0) {
            leafNodes.add(node);
        } else {
            Iterator iter = node.getChildren().iterator();
            while (iter.hasNext()) {
                this.collectLeafNodes((PlanNode)iter.next(), leafNodes);
            }
        }
    }

    public String toString() {
        return "PlaceAccess";
    }

    static boolean addAccessPatternsProperty(PlanNode accessNode, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        ArrayList patternElements;
        if (!accessNode.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS) && (patternElements = ResolverUtil.getAccessPatternElementsInGroups((QueryMetadataInterface)metadata, (Collection)accessNode.getGroups(), (boolean)false)) != null) {
            if (patternElements.size() > 1) {
                ArrayList accessPatternList = new ArrayList(patternElements);
                Collections.sort(accessPatternList, new /* Unavailable Anonymous Inner Class!! */);
                patternElements = accessPatternList;
            }
            accessNode.setProperty((Object)NodeConstants.Info.ACCESS_PATTERNS, (Object)patternElements);
            return true;
        }
        return false;
    }
}

